"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetMemcachedDefaults = exports.GetDefaultCachePort = void 0;
/*
 *  The functions found here in the core library are for internal use and can be changed
 *  or removed outside of a major release. We recommend against calling them directly from client code.
 */
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 */
function GetDefaultCachePort() {
    // Best practice not to use default port 11211
    return 11222;
}
exports.GetDefaultCachePort = GetDefaultCachePort;
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 */
function GetMemcachedDefaults(id, port) {
    return {
        clusterName: `${id}-cdk-cluster`,
        cacheNodeType: "cache.t3.medium",
        engine: "memcached",
        numCacheNodes: 2,
        port,
        azMode: 'cross-az'
    };
}
exports.GetMemcachedDefaults = GetMemcachedDefaults;
//# sourceMappingURL=data:application/json;base64,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