"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultCfnDomainProps = void 0;
const iam = require("aws-cdk-lib/aws-iam");
const cdk = require("aws-cdk-lib");
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 */
function DefaultCfnDomainProps(domainName, cognitoKibanaConfigureRole, props) {
    const roleARNs = [];
    roleARNs.push(new iam.ArnPrincipal(props.cognitoAuthorizedRoleARN));
    if (props.serviceRoleARN) {
        roleARNs.push(new iam.ArnPrincipal(props.serviceRoleARN));
    }
    return {
        domainName,
        elasticsearchVersion: '6.3',
        encryptionAtRestOptions: {
            enabled: true
        },
        nodeToNodeEncryptionOptions: {
            enabled: true
        },
        snapshotOptions: {
            automatedSnapshotStartHour: 1
        },
        ebsOptions: {
            ebsEnabled: true,
            volumeSize: 10
        },
        cognitoOptions: {
            enabled: true,
            identityPoolId: props.identitypool.ref,
            userPoolId: props.userpool.userPoolId,
            roleArn: cognitoKibanaConfigureRole.roleArn
        },
        accessPolicies: new iam.PolicyDocument({
            statements: [
                new iam.PolicyStatement({
                    principals: roleARNs,
                    actions: [
                        'es:ESHttp*'
                    ],
                    resources: [
                        `arn:aws:es:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:domain/${domainName}/*`
                    ]
                })
            ]
        })
    };
}
exports.DefaultCfnDomainProps = DefaultCfnDomainProps;
//# sourceMappingURL=data:application/json;base64,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