"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildEventBus = void 0;
const events = require("aws-cdk-lib/aws-events");
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 */
function buildEventBus(scope, props) {
    // Check whether existing EventBus is provided
    if (props.existingEventBusInterface) {
        return props.existingEventBusInterface;
    }
    else if (props.eventBusProps) {
        // eventBusProps is provided, create a new EventBus
        const _eventBusName = props.eventBusProps.eventBusName || 'CustomEventBus';
        return new events.EventBus(scope, _eventBusName, props.eventBusProps);
    }
    return;
}
exports.buildEventBus = buildEventBus;
//# sourceMappingURL=data:application/json;base64,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