"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultContainerDefinitionProps = exports.DefaultApplicationTargetGroupProps = exports.DefaultFargateTaskDefinitionProps = exports.DefaultFargateServiceProps = exports.DefaultClusterProps = void 0;
const ecs = require("aws-cdk-lib/aws-ecs");
const elb = require("aws-cdk-lib/aws-elasticloadbalancingv2");
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 */
function DefaultClusterProps() {
    return {};
}
exports.DefaultClusterProps = DefaultClusterProps;
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 */
function DefaultFargateServiceProps() {
    return {
        assignPublicIp: false,
        desiredCount: 2,
        maxHealthyPercent: 150,
        minHealthyPercent: 75,
        platformVersion: ecs.FargatePlatformVersion.LATEST,
    };
}
exports.DefaultFargateServiceProps = DefaultFargateServiceProps;
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 */
function DefaultFargateTaskDefinitionProps() {
    return {
        cpu: 256,
        memoryLimitMiB: 512,
    };
}
exports.DefaultFargateTaskDefinitionProps = DefaultFargateTaskDefinitionProps;
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 */
function DefaultApplicationTargetGroupProps(vpc) {
    return {
        port: 8080,
        protocol: elb.ApplicationProtocol.HTTP,
        protocolVersion: elb.ApplicationProtocolVersion.HTTP1,
        targetType: elb.TargetType.IP,
        vpc,
        healthCheck: { path: '/' }
    };
}
exports.DefaultApplicationTargetGroupProps = DefaultApplicationTargetGroupProps;
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 */
function DefaultContainerDefinitionProps() {
    return {
        memoryReservationMiB: 512,
        portMappings: [{ containerPort: 8080 }],
    };
}
exports.DefaultContainerDefinitionProps = DefaultContainerDefinitionProps;
//# sourceMappingURL=data:application/json;base64,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