/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import { Construct } from "constructs";
import * as ec2 from "aws-cdk-lib/aws-ec2";
import * as ecs from "aws-cdk-lib/aws-ecs";
export interface CreateFargateServiceResponse {
    readonly service: ecs.FargateService;
    readonly containerDefinition: ecs.ContainerDefinition;
}
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 */
export declare function CreateFargateService(scope: Construct, id: string, constructVpc: ec2.IVpc, clientClusterProps?: ecs.ClusterProps, ecrRepositoryArn?: string, ecrImageVersion?: string, clientFargateTaskDefinitionProps?: ecs.FargateTaskDefinitionProps | any, clientContainerDefinitionProps?: ecs.ContainerDefinitionProps | any, clientFargateServiceProps?: ecs.FargateServiceProps | any): CreateFargateServiceResponse;
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 */
export declare function CheckFargateProps(props: any): void;
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 */
export declare function getServiceVpcSecurityGroupIds(service: ecs.FargateService): string[];
