/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import { CfnDatabase, CfnDatabaseProps } from "aws-cdk-lib/aws-glue";
import { Construct } from "constructs";
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 *
 * Create an AWS Glue database with the properties provided
 *
 * @param scope
 * @param databaseProps
 */
export declare function DefaultGlueDatabase(scope: Construct, databaseProps: CfnDatabaseProps): CfnDatabase;
