"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultGlueJobProps = void 0;
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 */
function DefaultGlueJobProps(jobRole, userProvidedGlueJobProps, glueSecurityConfigName, defaultArguments, etlCodeAsset) {
    const glueVersion = userProvidedGlueJobProps.glueVersion;
    // setting default to 2 to reduce cost
    const maxCapacity = glueVersion === "1.0" && !(userProvidedGlueJobProps.workerType
        || userProvidedGlueJobProps.numberOfWorkers) ? 2 : undefined;
    if (etlCodeAsset) {
        userProvidedGlueJobProps.command.scriptLocation = etlCodeAsset.s3ObjectUrl;
    }
    const defaultGlueJobProps = {
        command: userProvidedGlueJobProps.command,
        role: jobRole.roleArn,
        securityConfiguration: glueSecurityConfigName,
        defaultArguments,
        maxCapacity,
        numberOfWorkers: (!glueVersion || glueVersion === "2.0") ? 2 : undefined,
        workerType: (!glueVersion || glueVersion === "2.0") ? 'G.1X' : undefined,
        // glue version though optional is required for streaming etl jobs otherwise it throws an error that 'command not found'
        glueVersion: glueVersion ? glueVersion : '2.0'
    };
    return defaultGlueJobProps;
}
exports.DefaultGlueJobProps = DefaultGlueJobProps;
//# sourceMappingURL=data:application/json;base64,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