"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultGlueTableProps = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 */
function DefaultGlueTableProps(database, fieldSchema, sourceType, parameters) {
    let _tableProps;
    if (sourceType === 'kinesis') {
        const kinesisStreamName = parameters.STREAM_NAME;
        const _paths = fieldSchema.map((item) => {
            return item.name;
        }).join(',');
        _tableProps = {
            catalogId: database.catalogId,
            databaseName: database.ref,
            tableInput: {
                storageDescriptor: {
                    columns: fieldSchema,
                    location: kinesisStreamName,
                    inputFormat: "org.apache.hadoop.mapred.TextInputFormat",
                    outputFormat: "org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat",
                    compressed: false,
                    numberOfBuckets: -1,
                    serdeInfo: {
                        serializationLibrary: "org.openx.data.jsonserde.JsonSerDe",
                        parameters: {
                            paths: _paths
                        }
                    },
                    parameters: {
                        endpointUrl: `https://kinesis.${aws_cdk_lib_1.Aws.REGION}.amazonaws.com`,
                        streamName: kinesisStreamName,
                        typeOfData: sourceType
                    }
                },
                tableType: 'EXTERNAL_TABLE',
                parameters: {
                    classification: 'json'
                }
            }
        };
        return _tableProps;
    }
    else {
        throw Error('Source Type not Supported. Valid Source Type not provided');
    }
}
exports.DefaultGlueTableProps = DefaultGlueTableProps;
//# sourceMappingURL=data:application/json;base64,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