"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultCfnTopicRuleProps = void 0;
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 */
function DefaultCfnTopicRuleProps(_actions, _sql = '') {
    const _topicRulePayload = {
        ruleDisabled: false,
        actions: _actions,
        sql: _sql
    };
    const defaultCfnTopicRuleProps = {
        topicRulePayload: _topicRulePayload
    };
    return defaultCfnTopicRuleProps;
}
exports.DefaultCfnTopicRuleProps = DefaultCfnTopicRuleProps;
//# sourceMappingURL=data:application/json;base64,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