"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildKinesisAnalyticsApp = void 0;
/*
 *  The functions found here in the core library are for internal use and can be changed
 *  or removed outside of a major release. We recommend against calling them directly from client code.
 */
// Imports
const kinesisAnalytics = require("aws-cdk-lib/aws-kinesisanalytics");
const iam = require("aws-cdk-lib/aws-iam");
const defaults = require("./kinesis-analytics-defaults");
const utils_1 = require("./utils");
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 */
function buildKinesisAnalyticsApp(scope, props) {
    // Setup the IAM role for Kinesis Analytics
    const analyticsRole = new iam.Role(scope, 'KinesisAnalyticsRole', {
        assumedBy: new iam.ServicePrincipal('kinesisanalytics.amazonaws.com'),
    });
    // Setup the IAM policy for Kinesis Analytics
    const analyticsPolicy = new iam.Policy(scope, 'KinesisAnalyticsPolicy', {
        statements: [
            new iam.PolicyStatement({
                actions: [
                    'firehose:DescribeDeliveryStream',
                    'firehose:Get*'
                ],
                resources: [props.kinesisFirehose.attrArn]
            })
        ]
    });
    // Attach policy to role
    analyticsPolicy.attachToRole(analyticsRole);
    // Setup the Kinesis application properties
    const kinesisAnalyticsProps = utils_1.overrideProps(defaults.DefaultCfnApplicationProps, props.kinesisAnalyticsProps);
    kinesisAnalyticsProps.inputs[0].kinesisFirehoseInput = {
        resourceArn: props.kinesisFirehose.attrArn,
        roleArn: analyticsRole.roleArn
    };
    // Setup the Kinesis application and add dependencies
    const kinesisAnalyticsApp = new kinesisAnalytics.CfnApplication(scope, 'KinesisAnalytics', kinesisAnalyticsProps);
    kinesisAnalyticsApp.addDependency(analyticsPolicy.node.findChild('Resource'));
    // Create the application and return
    return kinesisAnalyticsApp;
}
exports.buildKinesisAnalyticsApp = buildKinesisAnalyticsApp;
//# sourceMappingURL=data:application/json;base64,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