"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultCfnDeliveryStreamProps = void 0;
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 */
function DefaultCfnDeliveryStreamProps(_bucketArn, _roleArn, _logGroupName, _logStreamName, _kms, deliveryStreamName) {
    return {
        deliveryStreamName,
        extendedS3DestinationConfiguration: {
            bucketArn: _bucketArn,
            bufferingHints: {
                intervalInSeconds: 300,
                sizeInMBs: 5
            },
            compressionFormat: 'GZIP',
            roleArn: _roleArn,
            cloudWatchLoggingOptions: {
                enabled: true,
                logGroupName: _logGroupName,
                logStreamName: _logStreamName
            },
            encryptionConfiguration: {
                kmsEncryptionConfig: {
                    awskmsKeyArn: _kms.keyArn
                }
            }
        },
    };
}
exports.DefaultCfnDeliveryStreamProps = DefaultCfnDeliveryStreamProps;
//# sourceMappingURL=data:application/json;base64,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