"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.KinesisEventSourceProps = exports.S3EventSourceProps = exports.DynamoEventSourceProps = void 0;
const lambda = require("aws-cdk-lib/aws-lambda");
const utils_1 = require("./utils");
const aws_lambda_event_sources_1 = require("aws-cdk-lib/aws-lambda-event-sources");
const s3 = require("aws-cdk-lib/aws-s3");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const sqs_helper_1 = require("./sqs-helper");
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 */
function DynamoEventSourceProps(scope, _dynamoEventSourceProps) {
    const baseProps = {
        startingPosition: lambda.StartingPosition.TRIM_HORIZON,
        bisectBatchOnError: true,
        maxRecordAge: aws_cdk_lib_1.Duration.hours(24),
        retryAttempts: 500
    };
    let extraProps = {};
    if (_dynamoEventSourceProps === undefined || _dynamoEventSourceProps?.deploySqsDlqQueue === undefined
        || _dynamoEventSourceProps.deploySqsDlqQueue) {
        const buildQueueResponse = sqs_helper_1.buildQueue(scope, 'SqsDlqQueue', {
            queueProps: _dynamoEventSourceProps?.sqsDlqQueueProps
        });
        extraProps = {
            onFailure: new aws_lambda_event_sources_1.SqsDlq(buildQueueResponse.queue),
        };
    }
    const defaultDynamoEventSourceProps = Object.assign(baseProps, extraProps);
    return utils_1.consolidateProps(defaultDynamoEventSourceProps, _dynamoEventSourceProps?.eventSourceProps);
}
exports.DynamoEventSourceProps = DynamoEventSourceProps;
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 */
function S3EventSourceProps(_s3EventSourceProps) {
    const defaultS3EventSourceProps = {
        events: [s3.EventType.OBJECT_CREATED]
    };
    return utils_1.consolidateProps(defaultS3EventSourceProps, _s3EventSourceProps);
}
exports.S3EventSourceProps = S3EventSourceProps;
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 */
function KinesisEventSourceProps(scope, _kinesisEventSourceProps) {
    const baseProps = {
        startingPosition: lambda.StartingPosition.TRIM_HORIZON,
        bisectBatchOnError: true,
        maxRecordAge: aws_cdk_lib_1.Duration.hours(24),
        retryAttempts: 500
    };
    let extraProps = {};
    if (_kinesisEventSourceProps === undefined || _kinesisEventSourceProps?.deploySqsDlqQueue === undefined
        || _kinesisEventSourceProps.deploySqsDlqQueue) {
        const buildQueueResponse = sqs_helper_1.buildQueue(scope, 'SqsDlqQueue', {
            queueProps: _kinesisEventSourceProps?.sqsDlqQueueProps
        });
        extraProps = {
            onFailure: new aws_lambda_event_sources_1.SqsDlq(buildQueueResponse.queue),
        };
    }
    const defaultKinesisEventSourceProps = Object.assign(baseProps, extraProps);
    return utils_1.consolidateProps(defaultKinesisEventSourceProps, _kinesisEventSourceProps?.eventSourceProps);
}
exports.KinesisEventSourceProps = KinesisEventSourceProps;
//# sourceMappingURL=data:application/json;base64,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