"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.MediaStoreContainerProps = void 0;
/*
 *  The functions found here in the core library are for internal use and can be changed
 *  or removed outside of a major release. We recommend against calling them directly from client code.
 */
const cdk = require("aws-cdk-lib");
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 */
function MediaStoreContainerProps() {
    return {
        containerName: cdk.Aws.STACK_NAME,
        accessLoggingEnabled: true,
        corsPolicy: [{
                allowedHeaders: ['*'],
                allowedMethods: ['GET'],
                allowedOrigins: ['*'],
                exposeHeaders: ['*'],
                maxAgeSeconds: 3000
            }],
        policy: JSON.stringify({
            Version: '2012-10-17',
            Statement: [{
                    Sid: 'MediaStoreDefaultPolicy',
                    Effect: 'Allow',
                    Principal: '*',
                    Action: [
                        'mediastore:GetObject',
                        'mediastore:DescribeObject'
                    ],
                    Resource: `arn:${cdk.Aws.PARTITION}:mediastore:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:container/${cdk.Aws.STACK_NAME}/*`,
                    Condition: {
                        Bool: {
                            'aws:SecureTransport': 'true'
                        }
                    }
                }]
        }),
        lifecyclePolicy: JSON.stringify({
            rules: [{
                    definition: {
                        path: [
                            { wildcard: '*' }
                        ],
                        days_since_create: [
                            { numeric: ['>', 30] }
                        ]
                    },
                    action: 'EXPIRE'
                }]
        }),
        metricPolicy: {
            containerLevelMetrics: 'ENABLED'
        }
    };
}
exports.MediaStoreContainerProps = MediaStoreContainerProps;
//# sourceMappingURL=data:application/json;base64,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