"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.MediaStoreContainer = void 0;
/*
 *  The functions found here in the core library are for internal use and can be changed
 *  or removed outside of a major release. We recommend against calling them directly from client code.
 */
const cdk = require("aws-cdk-lib");
const mediastore = require("aws-cdk-lib/aws-mediastore");
const mediastore_defaults_1 = require("./mediastore-defaults");
const utils_1 = require("./utils");
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 */
function MediaStoreContainer(scope, mediaStoreContainerProps) {
    const defaultprops = mediastore_defaults_1.MediaStoreContainerProps();
    let mediaStoreProps;
    mediaStoreProps = utils_1.consolidateProps(defaultprops, mediaStoreContainerProps);
    // Create the MediaStore Container
    const mediaStoreContainer = new mediastore.CfnContainer(scope, 'MediaStoreContainer', mediaStoreProps);
    // Add deletion policy to retain because it will fail to delete if the container is not empty.
    mediaStoreContainer.cfnOptions.deletionPolicy = cdk.CfnDeletionPolicy.RETAIN;
    return mediaStoreContainer;
}
exports.MediaStoreContainer = MediaStoreContainer;
//# sourceMappingURL=data:application/json;base64,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