"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.defaultS3NotificationEventTypes = exports.DefaultLoggingBucketProps = exports.DefaultS3Props = void 0;
/*
 *  The functions found here in the core library are for internal use and can be changed
 *  or removed outside of a major release. We recommend against calling them directly from client code.
 */
const s3 = require("aws-cdk-lib/aws-s3");
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 */
function DefaultS3Props(loggingBucket, lifecycleRules) {
    return {
        encryption: s3.BucketEncryption.S3_MANAGED,
        versioned: true,
        blockPublicAccess: s3.BlockPublicAccess.BLOCK_ALL,
        removalPolicy: aws_cdk_lib_1.RemovalPolicy.RETAIN,
        enforceSSL: true,
        ...((lifecycleRules !== undefined) && { lifecycleRules }),
        ...((loggingBucket !== undefined) && { serverAccessLogsBucket: loggingBucket })
    };
}
exports.DefaultS3Props = DefaultS3Props;
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 */
function DefaultLoggingBucketProps() {
    return {
        encryption: s3.BucketEncryption.S3_MANAGED,
        versioned: true,
        blockPublicAccess: s3.BlockPublicAccess.BLOCK_ALL,
        removalPolicy: aws_cdk_lib_1.RemovalPolicy.RETAIN,
        enforceSSL: true,
    };
}
exports.DefaultLoggingBucketProps = DefaultLoggingBucketProps;
// Default event types to trigger S3 notifications
exports.defaultS3NotificationEventTypes = [s3.EventType.OBJECT_CREATED];
//# sourceMappingURL=data:application/json;base64,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