"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultSagemakerEndpointProps = exports.DefaultSagemakerEndpointConfigProps = exports.DefaultSagemakerModelProps = exports.DefaultSagemakerNotebookProps = void 0;
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 */
function DefaultSagemakerNotebookProps(roleArn, kmsKeyId, subnetId, securityGroupIds) {
    return {
        instanceType: 'ml.t2.medium',
        roleArn,
        kmsKeyId,
        ...(subnetId && { subnetId, directInternetAccess: 'Disabled' }),
        ...(securityGroupIds && { securityGroupIds }),
    };
}
exports.DefaultSagemakerNotebookProps = DefaultSagemakerNotebookProps;
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 */
function DefaultSagemakerModelProps(executionRoleArn, primaryContainer, vpcConfig) {
    return {
        executionRoleArn,
        primaryContainer,
        ...(vpcConfig && { vpcConfig }),
    };
}
exports.DefaultSagemakerModelProps = DefaultSagemakerModelProps;
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 */
function DefaultSagemakerEndpointConfigProps(modelName, kmsKeyId) {
    return {
        productionVariants: [
            {
                modelName,
                initialInstanceCount: 1,
                initialVariantWeight: 1.0,
                instanceType: 'ml.m4.xlarge',
                variantName: 'AllTraffic',
            },
        ],
        ...(kmsKeyId && { kmsKeyId }),
    };
}
exports.DefaultSagemakerEndpointConfigProps = DefaultSagemakerEndpointConfigProps;
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 */
function DefaultSagemakerEndpointProps(endpointConfigName) {
    return {
        endpointConfigName,
    };
}
exports.DefaultSagemakerEndpointProps = DefaultSagemakerEndpointProps;
//# sourceMappingURL=data:application/json;base64,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