"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildSecretsManagerSecret = void 0;
/*
 *  The functions found here in the core library are for internal use and can be changed
 *  or removed outside of a major release. We recommend against calling them directly from client code.
 */
const aws_secretsmanager_1 = require("aws-cdk-lib/aws-secretsmanager");
const secretsmanager_defaults_1 = require("./secretsmanager-defaults");
const utils_1 = require("./utils");
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 *
 * Method to build the default AWS Secrets Manager Secret
 *
 * @param scope
 * @param id
 * @param secretProps
 */
function buildSecretsManagerSecret(scope, id, secretProps) {
    let secret;
    secret = new aws_secretsmanager_1.Secret(scope, id, utils_1.consolidateProps(secretsmanager_defaults_1.DefaultSecretProps, secretProps));
    // suppress warning on build
    utils_1.addCfnSuppressRules(secret, [
        {
            id: 'W77',
            reason: `We allow the use of the AWS account default key aws/secretsmanager for secret encryption.`
        }
    ]);
    return secret;
}
exports.buildSecretsManagerSecret = buildSecretsManagerSecret;
//# sourceMappingURL=data:application/json;base64,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