/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import * as ec2 from "aws-cdk-lib/aws-ec2";
import { Construct } from "constructs";
export interface SecurityGroupRuleDefinition {
    readonly peer: ec2.IPeer;
    readonly connection: ec2.Port;
    readonly description?: string;
    readonly remoteRule?: boolean;
}
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 */
export declare function buildSecurityGroup(scope: Construct, name: string, props: ec2.SecurityGroupProps, ingressRules: SecurityGroupRuleDefinition[], egressRules: SecurityGroupRuleDefinition[]): ec2.SecurityGroup;
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 */
export declare function CreateSelfReferencingSecurityGroup(scope: Construct, id: string, vpc: ec2.IVpc, cachePort: any): ec2.SecurityGroup;
