"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateSelfReferencingSecurityGroup = exports.buildSecurityGroup = void 0;
/*
 *  The functions found here in the core library are for internal use and can be changed
 *  or removed outside of a major release. We recommend against calling them directly from client code.
 */
// import { countResources } from "@aws-cdk/assert";
const ec2 = require("aws-cdk-lib/aws-ec2");
const utils_1 = require("./utils");
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 */
function buildSecurityGroup(scope, name, props, ingressRules, egressRules) {
    const newSecurityGroup = new ec2.SecurityGroup(scope, `${name}-security-group`, props);
    ingressRules.forEach(rule => {
        newSecurityGroup.addIngressRule(rule.peer, rule.connection, rule.description, rule.remoteRule);
    });
    egressRules.forEach(rule => {
        newSecurityGroup.addEgressRule(rule.peer, rule.connection, rule.description, rule.remoteRule);
    });
    utils_1.addCfnSuppressRules(newSecurityGroup, [
        {
            id: "W5",
            reason: "Egress of 0.0.0.0/0 is default and generally considered OK",
        },
        {
            id: "W40",
            reason: "Egress IPProtocol of -1 is default and generally considered OK",
        },
    ]);
    return newSecurityGroup;
}
exports.buildSecurityGroup = buildSecurityGroup;
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 */
function CreateSelfReferencingSecurityGroup(scope, id, vpc, cachePort) {
    const newCacheSG = new ec2.SecurityGroup(scope, `${id}-cachesg`, {
        vpc,
        allowAllOutbound: true,
    });
    const selfReferenceRule = new ec2.CfnSecurityGroupIngress(scope, `${id}-ingress`, {
        groupId: newCacheSG.securityGroupId,
        sourceSecurityGroupId: newCacheSG.securityGroupId,
        ipProtocol: "TCP",
        fromPort: cachePort,
        toPort: cachePort,
        description: 'Self referencing rule to control access to Elasticache memcached cluster',
    });
    selfReferenceRule.node.addDependency(newCacheSG);
    utils_1.addCfnSuppressRules(newCacheSG, [
        {
            id: "W5",
            reason: "Egress of 0.0.0.0/0 is default and generally considered OK",
        },
        {
            id: "W40",
            reason: "Egress IPProtocol of -1 is default and generally considered OK",
        },
    ]);
    return newCacheSG;
}
exports.CreateSelfReferencingSecurityGroup = CreateSelfReferencingSecurityGroup;
//# sourceMappingURL=data:application/json;base64,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