"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultWafwebaclProps = exports.wrapManagedRuleSet = exports.DefaultWafRules = void 0;
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 */
function DefaultWafRules() {
    return [
        wrapManagedRuleSet("AWSManagedRulesBotControlRuleSet", "AWS", 0),
        wrapManagedRuleSet("AWSManagedRulesKnownBadInputsRuleSet", "AWS", 1),
        wrapManagedRuleSet("AWSManagedRulesCommonRuleSet", "AWS", 2),
        wrapManagedRuleSet("AWSManagedRulesAnonymousIpList", "AWS", 3),
        wrapManagedRuleSet("AWSManagedRulesAmazonIpReputationList", "AWS", 4),
        wrapManagedRuleSet("AWSManagedRulesAdminProtectionRuleSet", "AWS", 5),
        wrapManagedRuleSet("AWSManagedRulesSQLiRuleSet", "AWS", 6)
    ];
}
exports.DefaultWafRules = DefaultWafRules;
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 */
function wrapManagedRuleSet(managedGroupName, vendorName, priority) {
    return {
        name: `${vendorName}-${managedGroupName}`,
        priority,
        overrideAction: { none: {} },
        statement: {
            managedRuleGroupStatement: {
                name: managedGroupName,
                vendorName,
            }
        },
        visibilityConfig: {
            cloudWatchMetricsEnabled: true,
            metricName: managedGroupName,
            sampledRequestsEnabled: true
        }
    };
}
exports.wrapManagedRuleSet = wrapManagedRuleSet;
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 */
function DefaultWafwebaclProps(webaclScope) {
    return {
        defaultAction: {
            allow: {}
        },
        scope: webaclScope,
        visibilityConfig: {
            cloudWatchMetricsEnabled: true,
            metricName: 'webACL',
            sampledRequestsEnabled: true
        },
        rules: DefaultWafRules()
    };
}
exports.DefaultWafwebaclProps = DefaultWafwebaclProps;
//# sourceMappingURL=data:application/json;base64,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