"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildWebacl = void 0;
const waf = require("aws-cdk-lib/aws-wafv2");
const waf_defaults_1 = require("./waf-defaults");
const utils_1 = require("./utils");
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 */
function buildWebacl(scope, webaclScope, props) {
    let webAcl;
    if (props.existingWebaclObj && !props.webaclProps) { // Existing WAF web ACL
        webAcl = props.existingWebaclObj;
    }
    else { // Create a new WAF web ACL
        let finalWebaclProps;
        finalWebaclProps = utils_1.consolidateProps(waf_defaults_1.DefaultWafwebaclProps(webaclScope), props.webaclProps);
        webAcl = new waf.CfnWebACL(scope, `${scope.node.id}-WebACL`, finalWebaclProps);
    }
    return webAcl;
}
exports.buildWebacl = buildWebacl;
//# sourceMappingURL=data:application/json;base64,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