"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
require("@aws-cdk/assert/jest");
const elasticache_defaults_1 = require("../lib/elasticache-defaults");
test("Test GetDefaultCachePort()", () => {
    const defaultPort = elasticache_defaults_1.GetDefaultCachePort();
    expect(defaultPort).toEqual(11222);
});
test("Test GetMemcachedDefaults()", () => {
    const testPort = 22222;
    const testId = 'test';
    const props = elasticache_defaults_1.GetMemcachedDefaults(testId, testPort);
    expect(props.port).toEqual(testPort);
    expect(props.clusterName).toEqual(`${testId}-cdk-cluster`);
    expect(props.engine).toEqual("memcached");
    expect(props.cacheNodeType).toEqual("cache.t3.medium");
    expect(props.numCacheNodes).toEqual(2);
    expect(props.azMode).toEqual('cross-az');
});
//# sourceMappingURL=data:application/json;base64,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