"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const aws_cdk_lib_1 = require("aws-cdk-lib");
const events = require("aws-cdk-lib/aws-events");
const defaults = require("../index");
require("@aws-cdk/assert/jest");
const aws_events_1 = require("aws-cdk-lib/aws-events");
const aws_cdk_lib_2 = require("aws-cdk-lib");
const utils_1 = require("../lib/utils");
test('test EventsRuleProps override ruleName and description', () => {
    const stack = new aws_cdk_lib_1.Stack();
    const lambdaFunc = {
        bind: () => ({
            id: '',
            arn: 'ARN'
        })
    };
    const defaultEventsRuleProps = defaults.DefaultEventsRuleProps([lambdaFunc]);
    const eventsRuleProps = utils_1.overrideProps(defaultEventsRuleProps, {
        ruleName: 'test',
        description: 'hello world',
        schedule: aws_events_1.Schedule.rate(aws_cdk_lib_2.Duration.minutes(5))
    });
    new events.Rule(stack, 'Events', eventsRuleProps);
    expect(stack).toHaveResource('AWS::Events::Rule', {
        Description: "hello world",
        Name: "test",
        ScheduleExpression: "rate(5 minutes)",
        State: "ENABLED",
        Targets: [
            {
                Arn: "ARN",
                Id: "Target0"
            }
        ]
    });
});
test('test EventsRuleProps add more event targets', () => {
    const stack = new aws_cdk_lib_1.Stack();
    const lambdaFunc1 = {
        bind: () => ({
            id: '',
            arn: 'ARN1'
        })
    };
    const defaultEventsRuleProps = defaults.DefaultEventsRuleProps([lambdaFunc1]);
    const lambdaFunc2 = {
        bind: () => ({
            id: '',
            arn: 'ARN2'
        })
    };
    const eventsRuleProps = utils_1.overrideProps(defaultEventsRuleProps, {
        targets: [lambdaFunc2],
        schedule: aws_events_1.Schedule.rate(aws_cdk_lib_2.Duration.minutes(5))
    }, true);
    new events.Rule(stack, 'Events', eventsRuleProps);
    expect(stack).toHaveResource('AWS::Events::Rule', {
        ScheduleExpression: "rate(5 minutes)",
        State: "ENABLED",
        Targets: [
            {
                Arn: "ARN1",
                Id: "Target0"
            },
            {
                Arn: "ARN2",
                Id: "Target1"
            }
        ]
    });
});
//# sourceMappingURL=data:application/json;base64,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