"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const aws_cdk_lib_1 = require("aws-cdk-lib");
const iot = require("aws-cdk-lib/aws-iot");
const defaults = require("../index");
const utils_1 = require("../lib/utils");
require("@aws-cdk/assert/jest");
test('test TopicRuleProps override sql and description', () => {
    const stack = new aws_cdk_lib_1.Stack();
    const action1 = {
        lambda: {
            functionArn: 'xyz'
        }
    };
    const defaultProps = defaults.DefaultCfnTopicRuleProps([action1]);
    const inProps = {
        topicRulePayload: {
            ruleDisabled: true,
            description: "Processing of vehicle messages",
            sql: "SELECT * FROM 'connectedcar/#'",
            actions: []
        }
    };
    const outProps = utils_1.overrideProps(defaultProps, inProps, true);
    new iot.CfnTopicRule(stack, 'IotTopic', outProps);
    expect(stack).toHaveResource('AWS::IoT::TopicRule', {
        TopicRulePayload: {
            Actions: [
                {
                    Lambda: {
                        FunctionArn: "xyz"
                    }
                }
            ],
            Description: "Processing of vehicle messages",
            RuleDisabled: true,
            Sql: "SELECT * FROM 'connectedcar/#'"
        }
    });
});
test('test TopicRuleProps override actions', () => {
    const stack = new aws_cdk_lib_1.Stack();
    const defaultProps = defaults.DefaultCfnTopicRuleProps([], '');
    const action = {
        lambda: {
            functionArn: 'abc'
        }
    };
    const inProps = {
        topicRulePayload: {
            ruleDisabled: true,
            sql: '',
            actions: [action]
        }
    };
    const outProps = utils_1.overrideProps(defaultProps, inProps);
    new iot.CfnTopicRule(stack, 'IotTopic', outProps);
    expect(stack).toHaveResource('AWS::IoT::TopicRule', {
        TopicRulePayload: {
            Actions: [
                {
                    Lambda: {
                        FunctionArn: "abc"
                    }
                }
            ],
            RuleDisabled: true,
            Sql: ""
        }
    });
});
//# sourceMappingURL=data:application/json;base64,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