"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
require("@aws-cdk/assert/jest");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const mediastore_helper_1 = require("../lib/mediastore-helper");
test('MediaStore container override params', () => {
    const stack = new aws_cdk_lib_1.Stack();
    const mediaStoreContainerProps = {
        containerName: 'TestContainer',
        policy: '{}',
        lifecyclePolicy: '{}',
        metricPolicy: {
            containerLevelMetrics: 'DISABLED'
        }
    };
    mediastore_helper_1.MediaStoreContainer(stack, mediaStoreContainerProps);
    expect(stack).toHaveResourceLike('AWS::MediaStore::Container', {
        AccessLoggingEnabled: true,
        CorsPolicy: [
            {
                AllowedHeaders: ['*'],
                AllowedMethods: ['GET'],
                AllowedOrigins: ['*'],
                ExposeHeaders: ['*'],
                MaxAgeSeconds: 3000
            }
        ],
        MetricPolicy: {
            ContainerLevelMetrics: 'DISABLED'
        },
        Policy: '{}',
        LifecyclePolicy: '{}',
        ContainerName: 'TestContainer'
    });
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibWVkaWFzdG9yZS1oZWxwZXIudGVzdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIm1lZGlhc3RvcmUtaGVscGVyLnRlc3QudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBOzs7Ozs7Ozs7OztHQVdHOztBQUVILGdDQUE4QjtBQUM5Qiw2Q0FBb0M7QUFFcEMsZ0VBQStEO0FBRS9ELElBQUksQ0FBQyxzQ0FBc0MsRUFBRSxHQUFHLEVBQUU7SUFDaEQsTUFBTSxLQUFLLEdBQUcsSUFBSSxtQkFBSyxFQUFFLENBQUM7SUFDMUIsTUFBTSx3QkFBd0IsR0FBaUM7UUFDN0QsYUFBYSxFQUFFLGVBQWU7UUFDOUIsTUFBTSxFQUFFLElBQUk7UUFDWixlQUFlLEVBQUUsSUFBSTtRQUNyQixZQUFZLEVBQUU7WUFDWixxQkFBcUIsRUFBRSxVQUFVO1NBQ2xDO0tBQ0YsQ0FBQztJQUVGLHVDQUFtQixDQUFDLEtBQUssRUFBRSx3QkFBd0IsQ0FBQyxDQUFDO0lBQ3JELE1BQU0sQ0FBQyxLQUFLLENBQUMsQ0FBQyxrQkFBa0IsQ0FBQyw0QkFBNEIsRUFBRTtRQUM3RCxvQkFBb0IsRUFBRSxJQUFJO1FBQzFCLFVBQVUsRUFBRTtZQUNWO2dCQUNFLGNBQWMsRUFBRSxDQUFFLEdBQUcsQ0FBRTtnQkFDdkIsY0FBYyxFQUFFLENBQUUsS0FBSyxDQUFFO2dCQUN6QixjQUFjLEVBQUUsQ0FBRSxHQUFHLENBQUU7Z0JBQ3ZCLGFBQWEsRUFBRSxDQUFFLEdBQUcsQ0FBRTtnQkFDdEIsYUFBYSxFQUFFLElBQUk7YUFDcEI7U0FDRjtRQUNELFlBQVksRUFBRTtZQUNaLHFCQUFxQixFQUFFLFVBQVU7U0FDbEM7UUFDRCxNQUFNLEVBQUUsSUFBSTtRQUNaLGVBQWUsRUFBRSxJQUFJO1FBQ3JCLGFBQWEsRUFBRSxlQUFlO0tBQy9CLENBQUMsQ0FBQztBQUNMLENBQUMsQ0FBQyxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiAgQ29weXJpZ2h0IEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4gKlxuICogIExpY2Vuc2VkIHVuZGVyIHRoZSBBcGFjaGUgTGljZW5zZSwgVmVyc2lvbiAyLjAgKHRoZSBcIkxpY2Vuc2VcIikuIFlvdSBtYXkgbm90IHVzZSB0aGlzIGZpbGUgZXhjZXB0IGluIGNvbXBsaWFuY2VcbiAqICB3aXRoIHRoZSBMaWNlbnNlLiBBIGNvcHkgb2YgdGhlIExpY2Vuc2UgaXMgbG9jYXRlZCBhdFxuICpcbiAqICAgICAgaHR0cDovL3d3dy5hcGFjaGUub3JnL2xpY2Vuc2VzL0xJQ0VOU0UtMi4wXG4gKlxuICogIG9yIGluIHRoZSAnbGljZW5zZScgZmlsZSBhY2NvbXBhbnlpbmcgdGhpcyBmaWxlLiBUaGlzIGZpbGUgaXMgZGlzdHJpYnV0ZWQgb24gYW4gJ0FTIElTJyBCQVNJUywgV0lUSE9VVCBXQVJSQU5USUVTXG4gKiAgT1IgQ09ORElUSU9OUyBPRiBBTlkgS0lORCwgZXhwcmVzcyBvciBpbXBsaWVkLiBTZWUgdGhlIExpY2Vuc2UgZm9yIHRoZSBzcGVjaWZpYyBsYW5ndWFnZSBnb3Zlcm5pbmcgcGVybWlzc2lvbnNcbiAqICBhbmQgbGltaXRhdGlvbnMgdW5kZXIgdGhlIExpY2Vuc2UuXG4gKi9cblxuaW1wb3J0ICdAYXdzLWNkay9hc3NlcnQvamVzdCc7XG5pbXBvcnQgeyBTdGFjayB9IGZyb20gJ2F3cy1jZGstbGliJztcbmltcG9ydCAqIGFzIG1lZGlhc3RvcmUgZnJvbSAnYXdzLWNkay1saWIvYXdzLW1lZGlhc3RvcmUnO1xuaW1wb3J0IHsgTWVkaWFTdG9yZUNvbnRhaW5lciB9IGZyb20gJy4uL2xpYi9tZWRpYXN0b3JlLWhlbHBlcic7XG5cbnRlc3QoJ01lZGlhU3RvcmUgY29udGFpbmVyIG92ZXJyaWRlIHBhcmFtcycsICgpID0+IHtcbiAgY29uc3Qgc3RhY2sgPSBuZXcgU3RhY2soKTtcbiAgY29uc3QgbWVkaWFTdG9yZUNvbnRhaW5lclByb3BzOiBtZWRpYXN0b3JlLkNmbkNvbnRhaW5lclByb3BzID0ge1xuICAgIGNvbnRhaW5lck5hbWU6ICdUZXN0Q29udGFpbmVyJyxcbiAgICBwb2xpY3k6ICd7fScsXG4gICAgbGlmZWN5Y2xlUG9saWN5OiAne30nLFxuICAgIG1ldHJpY1BvbGljeToge1xuICAgICAgY29udGFpbmVyTGV2ZWxNZXRyaWNzOiAnRElTQUJMRUQnXG4gICAgfVxuICB9O1xuXG4gIE1lZGlhU3RvcmVDb250YWluZXIoc3RhY2ssIG1lZGlhU3RvcmVDb250YWluZXJQcm9wcyk7XG4gIGV4cGVjdChzdGFjaykudG9IYXZlUmVzb3VyY2VMaWtlKCdBV1M6Ok1lZGlhU3RvcmU6OkNvbnRhaW5lcicsIHtcbiAgICBBY2Nlc3NMb2dnaW5nRW5hYmxlZDogdHJ1ZSxcbiAgICBDb3JzUG9saWN5OiBbXG4gICAgICB7XG4gICAgICAgIEFsbG93ZWRIZWFkZXJzOiBbICcqJyBdLFxuICAgICAgICBBbGxvd2VkTWV0aG9kczogWyAnR0VUJyBdLFxuICAgICAgICBBbGxvd2VkT3JpZ2luczogWyAnKicgXSxcbiAgICAgICAgRXhwb3NlSGVhZGVyczogWyAnKicgXSxcbiAgICAgICAgTWF4QWdlU2Vjb25kczogMzAwMFxuICAgICAgfVxuICAgIF0sXG4gICAgTWV0cmljUG9saWN5OiB7XG4gICAgICBDb250YWluZXJMZXZlbE1ldHJpY3M6ICdESVNBQkxFRCdcbiAgICB9LFxuICAgIFBvbGljeTogJ3t9JyxcbiAgICBMaWZlY3ljbGVQb2xpY3k6ICd7fScsXG4gICAgQ29udGFpbmVyTmFtZTogJ1Rlc3RDb250YWluZXInXG4gIH0pO1xufSk7Il19