/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import { Construct } from 'constructs';
import { Bucket, BucketProps } from "aws-cdk-lib/aws-s3";
import { Stack } from "aws-cdk-lib";
import * as cache from 'aws-cdk-lib/aws-elasticache';
import * as ec2 from 'aws-cdk-lib/aws-ec2';
import * as acm from 'aws-cdk-lib/aws-certificatemanager';
export declare const fakeEcrRepoArn = "arn:aws:ecr:us-east-1:123456789012:repository/fake-repo";
export declare function CreateScrapBucket(scope: Construct, props?: BucketProps | any): Bucket;
/**
 * @summary Creates a stack name for Integration tests
 * @param {string} filename - the filename of the integ test
 * @returns {string} - a string with current filename after removing anything before the prefix '.' and suffix '.js'
 * e.g. 'integ.apigateway-dynamodb-CRUD.js' will return 'apigateway-dynamodb-CRUD'
 */
export declare function generateIntegStackName(filename: string): string;
export declare function getTestVpc(stack: Stack, publicFacing?: boolean, userVpcProps?: ec2.VpcProps): ec2.IVpc;
export declare function getFakeCertificate(scope: Construct, id: string): acm.ICertificate;
export declare function suppressAutoDeleteHandlerWarnings(stack: Stack): void;
export declare function CreateTestCache(scope: Construct, id: string, vpc: ec2.IVpc, port?: number): cache.CfnCacheCluster;
/**
 * Asserts that a KMS key with a specific description exists on a resource
 *
 * @param stack The CloudFormation Stack that contains the to validate.
 * @param parentResourceType The type of CloudFormation Resource that should have the key set on it, e.g., `AWS::SNS::Topic`, etc...
 * @param description The value of the Description property on the KMS Key
 */
export declare function expectKmsKeyAttachedToCorrectResource(stack: Stack, parentResourceType: string, keyDescription: string): void;
