from mcclient import QueryClient

from tests.utils import BaseTestConn, TooManyPackets


class QueryTestConn(BaseTestConn):
    max_packets = 2

    def __init__(self):
        super().__init__()


    def sendto(self, data, *args):
        if self.packets == 0:
            self.packets += 1
            assert len(data) == 7
            assert data[:3] == b"\xFE\xFD\x09"

            session_id = data[:3]
            handshake_res = b"\x09" + session_id + b"\x39\x35\x31\x33\x33\x30\x37\x00"
            self.respond(handshake_res)

        elif self.packets == 1:
            self.packets += 1
            assert len(data) == 11 or len(data) == 15 # check the packet length (11: basic stat, 15: full stat)
            assert data[:3] == b"\xFE\xFD\x00"
            # implement checks for the rest of the packet (session id, challenge token)

            if len(data) == 15:
                stat_res = b"""\x00\x09\x09\x0B\x03\x73\x70\x6C\x69\x74\x6E\x75\x6D\x00\x80\x00\x68\x6F\x73\x74\x6E\x61\x6D\x65\x00\x4C\x50\x6D\x69\x74\x4B\x65\x76\x20\x43\x6F\x6D\x6D\x75\x6E\x69\x74\x79\x20\x53\x65\x72\x76\x65\x72\x21\x20\x42\x4C\x42\x20\x47\x4C\x4F\x21\x20\x20\x28\x5E\x5F\x5E\x29\x2F\x00\x67\x61\x6D\x65\x74\x79\x70\x65\x00\x53\x4D\x50\x00\x67\x61\x6D\x65\x5F\x69\x64\x00\x4D\x49\x4E\x45\x43\x52\x41\x46\x54\x00\x76\x65\x72\x73\x69\x6F\x6E\x00\x31\x2E\x31\x39\x2E\x32\x00\x70\x6C\x75\x67\x69\x6E\x73\x00\x50\x61\x70\x65\x72\x20\x6F\x6E\x20\x31\x2E\x31\x39\x2E\x32\x2D\x52\x30\x2E\x31\x2D\x53\x4E\x41\x50\x53\x48\x4F\x54\x3A\x20\x4C\x75\x63\x6B\x50\x65\x72\x6D\x73\x20\x35\x2E\x34\x2E\x34\x30\x3B\x20\x4F\x70\x65\x6E\x49\x6E\x76\x20\x34\x2E\x32\x2E\x31\x3B\x20\x4C\x70\x6D\x69\x74\x6B\x65\x76\x20\x31\x2E\x31\x39\x3B\x20\x49\x6E\x73\x61\x6E\x65\x41\x6E\x6E\x6F\x75\x6E\x63\x65\x72\x20\x31\x2E\x32\x2E\x32\x3B\x20\x56\x61\x75\x6C\x74\x20\x31\x2E\x37\x2E\x33\x2D\x62\x31\x33\x31\x3B\x20\x64\x79\x6E\x6D\x61\x70\x20\x33\x2E\x34\x2D\x38\x32\x38\x3B\x20\x57\x6F\x72\x6C\x64\x45\x64\x69\x74\x20\x37\x2E\x32\x2E\x31\x32\x2B\x36\x32\x34\x30\x2D\x38\x37\x66\x34\x61\x65\x31\x3B\x20\x45\x73\x73\x65\x6E\x74\x69\x61\x6C\x73\x20\x32\x2E\x32\x30\x2E\x30\x2D\x64\x65\x76\x2B\x31\x36\x2D\x32\x32\x61\x30\x64\x35\x33\x3B\x20\x45\x73\x73\x65\x6E\x74\x69\x61\x6C\x73\x43\x68\x61\x74\x20\x32\x2E\x32\x30\x2E\x30\x2D\x64\x65\x76\x2B\x31\x36\x2D\x32\x32\x61\x30\x64\x35\x33\x3B\x20\x45\x73\x73\x65\x6E\x74\x69\x61\x6C\x73\x53\x70\x61\x77\x6E\x20\x32\x2E\x32\x30\x2E\x30\x2D\x64\x65\x76\x2B\x31\x36\x2D\x32\x32\x61\x30\x64\x35\x33\x3B\x20\x57\x6F\x72\x6C\x64\x47\x75\x61\x72\x64\x20\x37\x2E\x30\x2E\x38\x2D\x62\x65\x74\x61\x2D\x30\x31\x2B\x63\x62\x62\x32\x62\x61\x37\x3B\x20\x43\x6F\x72\x65\x50\x72\x6F\x74\x65\x63\x74\x20\x32\x31\x2E\x32\x3B\x20\x41\x72\x6D\x6F\x72\x53\x74\x61\x6E\x64\x54\x6F\x6F\x6C\x73\x20\x34\x2E\x34\x2E\x34\x3B\x20\x6D\x63\x4D\x4D\x4F\x20\x32\x2E\x31\x2E\x32\x31\x37\x3B\x20\x47\x72\x69\x65\x66\x50\x72\x65\x76\x65\x6E\x74\x69\x6F\x6E\x20\x31\x36\x2E\x31\x38\x3B\x20\x44\x69\x73\x63\x6F\x72\x64\x53\x52\x56\x20\x31\x2E\x32\x36\x2E\x30\x3B\x20\x47\x53\x69\x74\x20\x31\x2E\x33\x2E\x33\x00\x6D\x61\x70\x00\x77\x6F\x72\x6C\x64\x00\x6E\x75\x6D\x70\x6C\x61\x79\x65\x72\x73\x00\x34\x00\x6D\x61\x78\x70\x6C\x61\x79\x65\x72\x73\x00\x32\x35\x00\x68\x6F\x73\x74\x70\x6F\x72\x74\x00\x32\x35\x35\x36\x35\x00\x68\x6F\x73\x74\x69\x70\x00\x39\x34\x2E\x32\x35\x30\x2E\x32\x31\x30\x2E\x35\x32\x00\x00\x01\x70\x6C\x61\x79\x65\x72\x5F\x00\x00\x54\x6F\x64\x6F\x72\x72\x00\x48\x65\x6E\x6B\x65\x72\x31\x00\x68\x6F\x62\x62\x79\x6C\x6F\x73\x65\x72\x5F\x00\x44\x61\x73\x41\x74\x6F\x6D\x32\x32\x00\x00"""
                # test response, should be constructed manually in the future
                self.respond(stat_res)

            elif len(data) == 11:
                raise NotImplementedError("Basic stat is not implemented yet.")

        elif self.packets >= self.max_packets:
            TooManyPackets(self.max_packets)



def test_query_request():
    test_conn = QueryTestConn()
    query_client = QueryClient("example.com")
    query_client.sock = test_conn # implant test socket
    query_client.get_status()
    # Todo: add checks for response


if __name__ == "__main__":
    test_query_request()