# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['graph_attention_student',
 'graph_attention_student.examples',
 'graph_attention_student.experiments']

package_data = \
{'': ['*'], 'graph_attention_student': ['templates/*']}

install_requires = \
['cairosvg>=2.5.2',
 'click>=7.1.2',
 'imageio>=2.19.0',
 'jinja2>=3.0.3',
 'kgcnn>=2.2.1',
 'matplotlib>=3.5.3',
 'nltk>=3.7',
 'numpy>=1.23.2',
 'orjson>=3.8.0',
 'poetry-bumpversion>=0.3.0',
 'pycomex>=0.8.4',
 'rdkit>=2022.9.1',
 'tensorflow>=2.8.0',
 'visual_graph_datasets>=0.7.2']

entry_points = \
{'console_scripts': ['graph_attention_student = '
                     'graph_attention_student.cli:cli']}

setup_kwargs = {
    'name': 'graph-attention-student',
    'version': '0.6.0',
    'description': 'MEGAN: Multi Explanation Graph Attention Network',
    'long_description': '|made-with-python| |made-with-kgcnn| |python-version| |os-linux|\n\n.. |os-linux| image:: https://img.shields.io/badge/os-linux-orange.svg\n   :target: https://www.python.org/\n\n.. |python-version| image:: https://img.shields.io/badge/Python-3.8.0-green.svg\n   :target: https://www.python.org/\n\n.. |made-with-kgcnn| image:: https://img.shields.io/badge/Made%20with-KGCNN-blue.svg\n   :target: https://github.com/aimat-lab/gcnn_keras\n\n.. |made-with-python| image:: https://img.shields.io/badge/Made%20with-Python-1f425f.svg\n   :target: https://www.python.org/\n\n.. image:: architecture.png\n    :width: 800\n    :alt: Architecture Overview\n\n================================================\nMEGAN: Multi Explanation Graph Attention Student\n================================================\n\nExplainable artificial intelligence (XAI) methods are expected to improve trust during human-AI interactions,\nprovide tools for model analysis and extend human understanding of complex problems. Attention-based models\nare an important subclass of XAI methods, partly due to their full differentiability and the potential to\nimprove explanations by means of explanation-supervised training. We propose the novel multi-explanation\ngraph attention network (MEGAN). Our graph regression and classification model features multiple explanation\nchannels, which can be chosen independently of the task specifications. We first validate our model on a\nsynthetic graph regression dataset, where our model produces single-channel explanations with quality\nsimilar to GNNExplainer. Furthermore, we demonstrate the advantages of multi-channel explanations on one\nsynthetic and two real-world datasets: The prediction of water solubility of molecular graphs and\nsentiment classification of movie reviews. We find that our model produces explanations consistent\nwith human intuition, opening the way to learning from our model in less well-understood tasks.\n\nInstallation\n============\n\nMain Installation\n-----------------\n\nClone the repository from github:\n\n.. code-block:: shell\n\n    git clone https://github.com/awa59kst120df/graph_attention_student.git\n\nThen in the main folder run a ``pip install``:\n\n.. code-block:: shell\n\n    cd graph_attention_student\n    pip3 install -e .\n\nAfterwards, you can check the install by invoking the CLI:\n\n.. code-block:: shell\n\n    python3 -m graph_attention_student.cli --version\n    python3 -m graph_attention_student.cli --help\n\nUsage\n=====\n\nComputational Experiments\n-------------------------\n\nIt is possible to list, show and execute all the computational experiments using a command line interface\nCLI.\n\n    *NOTE* Most of the experiments have a long runtime, ranging from ~2hrs to ~2days.\n    Furthermore, all of the experiments which do model training are currently configured to run on a GPU\n    and might crash if the GPU can either not be detected or does not have enough VRAM. This setting can\n    be changed in the corresponding experiment scripts\n\nAll the available experiments can be listed like this:\n\n.. code-block:: shell\n\n    python3 -m graph_attention_student.cli list\n\nThe details for a specific experiment can be viewed like this:\n\n.. code-block:: shell\n\n    python3 -m graph_attention_student.cli info [experiment_name]\n\nA new run of an experiment can be started like this. However, be aware that this might take some time.\n\n.. code-block::\n\n    python3 -m graph_attention_student.cli run [experiment_name]\n\nEach experiment will create a new archive folder, which will contain all the artifacts (such as visual\nexamples and the raw data) created during the runtime. The location of this archive folder can be found\nfrom the output generated by the experiment execution.\n\nArchived Experiments\n--------------------\n\nTo view the detailed data which was used in the making of the paper, go to\n``graph_attention_student/experiments``. The subfolders in that folder contain the archived experiments.\nThese contain extensive examples for each repetition of the various experiments as well as all of the raw\ndata collected during the execution of the experiments.\n\nMEGAN in code\n-------------\n\nThe MEGAN model is implemented as the ``MultiAttentionStudent`` class, which implements ``keras.Model``.\nThe implementation is based on the `kgcnn`_ library for graph convolutional networks for keras. For further\ninformation on loading graph structured data with `kgcnn`_ visit:\nhttps://github.com/aimat-lab/gcnn_keras\n\nThis is a simple example of how to use the model in the regression case:\n\n.. code-block:: python\n\n    import tensorflow as tf\n    import tensorflow.keras as ks\n    from graph_attention_student.training import NoLoss\n    from graph_attention_student.models import Megan\n\n    model = Megan(\n        # These lists define the number of layers and the number of hidden units in each layer for the\n        # various parts of the architecture\n        units=[9, 9, 9],  # The main convolutional layers\n        importance_units=[],  # The MLP that creates the node importances\n        final_units=[5, 1],  # The final MLP for graph embeddings\n        # Example for a regression problem. We need the prior knowledge about what range the values of the\n        # dataset will be expected to fall into...\n        regression_limits=(-3, +3),\n        # ... as well as a reference value.\n        regression_reference=0,\n        # This controls the weight of the explanation-only train step (gamma)\n        importance_factor=1.0,\n        importance_multiplier=5,\n        # This is the weight of the sparsity regularization\n        sparsity_factor=0.1,\n    )\n\n    # The model output is actually a three tuple: (prediction, node_importances, edge_importances).\n    # This allows the importances to be trained in a supervised fashion. If we don\'t want that,\n    # we can simply supply the NoLoss function instead.\n    model.compile(\n        loss=[ks.losses.MeanSquaredError(), NoLoss(), NoLoss()],\n        loss_weights=[1, 1, 1],\n        optimizer=ks.optimizers.Adam(0.001)\n    )\n\n    # model.fit() ...\n\n\n.. _kgcnn: https://github.com/aimat-lab/gcnn_keras\n.. _examples/solubility_regression.py: https://github.com/aimat-lab/graph_attention_student/tree/master/graph_attention_student/examples/solubility_regression.py\n.. _`GATv2`: https://github.com/tech-srl/how_attentive_are_gats\n\n---\n\nExamples\n========\n\nThe following examples show some of the *cherry picked* examples that show the explanatory capabilities of\nthe model.\n\nRB-Motifs Dataset\n-----------------\n\nThis is a synthetic dataset, which basically consists of randomly generated graphs with nodes of different\ncolors. Some of the graphs contain special sub-graph motifs, which are either blue-heavy or red-heavy\nstructures. The blue-heavy sub-graphs contribute a certain negative value to the overall value of the graph,\nwhile red-heavy structures contain a certain positive value.\n\nThis way, every graph has a certain value associated with it, which is between -3 and 3. The network was\ntrained to predict this value for each graph.\n\n.. image:: rb_motifs_example.png\n    :width: 800\n    :alt: Rb-Motifs Example\n\nThe examples shows from left to right: (1) The ground truth explanations, (2) a baseline MEGAN model trained\nonly on the prediction task, (3) explanation-supervised MEGAN model and (4) GNNExplainer explanations for a\nbasic GCN network. While the baseline MEGAN and GNNExplainer focus only on one of the ground truth motifs,\nthe explanation-supervised MEGAN model correctly finds both.\n\nWater Solubility Dataset\n------------------------\n\nThis is the `AqSolDB`_ dataset, which consists of ~10000 molecules and measured values for the solubility in\nwater (logS value).\n\nThe network was trained to predict the solubility value for each molecule.\n\n.. image:: solubility_example.png\n    :width: 800\n    :alt: Solubility Example.png\n\n.. _`AqSolDB`: https://www.nature.com/articles/s41597-019-0151-1\n\nMovie Reviews\n-------------\n\nOriginally the *MovieReviews* dataset is a natural language processing dataset from the `ERASER`_ benchmark.\nThe task is to classify the sentiment of ~2000 movie reviews collected from the IMDB database into the\nclasses "positive" and "negative". This dataset was converted into a graph dataset by considering all words\nas nodes of a graph and then connecting adjacent words by undirected edges with a sliding window of size 2.\nWords were converted into numeric feature vectors by using a pre-trained `GLOVE`_ model.\n\nExample for a positive review:\n\n.. image:: movie_reviews_pos.png\n    :width: 800\n    :alt: Positive Movie Review\n\nExample for a negative review:\n\n.. image:: movie_reviews_neg.png\n    :width: 800\n    :alt: Negative Movie Review\n\nExamples show the explanation channel for the "negative" class left and the "positive" class right.\nSentences with negative / positive adjectives are appropriately attributed to the corresponding channels.\n\n.. _`ERASER`: https://www.eraserbenchmark.com/\n.. _`GLOVE`: https://nlp.stanford.edu/projects/glove/\n\n',
    'author': 'xxx',
    'author_email': 'jonseb1998@gmail.com',
    'maintainer': 'xxx',
    'maintainer_email': 'jonseb1998@gmail.com',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8.0,<3.11',
}


setup(**setup_kwargs)
