# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['TlsCertificateArgs', 'TlsCertificate']

@pulumi.input_type
class TlsCertificateArgs:
    def __init__(__self__, *,
                 certificate_body: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a TlsCertificate resource.
        :param pulumi.Input[str] certificate_body: PEM-formatted certificate, optionally including any intermediary certificates.
        :param pulumi.Input[str] name: Human-readable name used to identify the certificate. Defaults to the certificate's Common Name or first Subject Alternative Name entry.
        """
        pulumi.set(__self__, "certificate_body", certificate_body)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="certificateBody")
    def certificate_body(self) -> pulumi.Input[str]:
        """
        PEM-formatted certificate, optionally including any intermediary certificates.
        """
        return pulumi.get(self, "certificate_body")

    @certificate_body.setter
    def certificate_body(self, value: pulumi.Input[str]):
        pulumi.set(self, "certificate_body", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Human-readable name used to identify the certificate. Defaults to the certificate's Common Name or first Subject Alternative Name entry.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _TlsCertificateState:
    def __init__(__self__, *,
                 certificate_body: Optional[pulumi.Input[str]] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 issued_to: Optional[pulumi.Input[str]] = None,
                 issuer: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 replace: Optional[pulumi.Input[bool]] = None,
                 serial_number: Optional[pulumi.Input[str]] = None,
                 signature_algorithm: Optional[pulumi.Input[str]] = None,
                 updated_at: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering TlsCertificate resources.
        :param pulumi.Input[str] certificate_body: PEM-formatted certificate, optionally including any intermediary certificates.
        :param pulumi.Input[str] created_at: Timestamp (GMT) when the certificate was created.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] domains: All the domains (including wildcard domains) that are listed in the certificate's Subject Alternative Names (SAN) list.
        :param pulumi.Input[str] issued_to: The hostname for which a certificate was issued.
        :param pulumi.Input[str] issuer: The certificate authority that issued the certificate.
        :param pulumi.Input[str] name: Human-readable name used to identify the certificate. Defaults to the certificate's Common Name or first Subject Alternative Name entry.
        :param pulumi.Input[bool] replace: A recommendation from Fastly indicating the key associated with this certificate is in need of rotation.
        :param pulumi.Input[str] serial_number: A value assigned by the issuer that is unique to a certificate.
        :param pulumi.Input[str] signature_algorithm: The algorithm used to sign the certificate.
        :param pulumi.Input[str] updated_at: Timestamp (GMT) when the certificate was last updated.
        """
        if certificate_body is not None:
            pulumi.set(__self__, "certificate_body", certificate_body)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if domains is not None:
            pulumi.set(__self__, "domains", domains)
        if issued_to is not None:
            pulumi.set(__self__, "issued_to", issued_to)
        if issuer is not None:
            pulumi.set(__self__, "issuer", issuer)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if replace is not None:
            pulumi.set(__self__, "replace", replace)
        if serial_number is not None:
            pulumi.set(__self__, "serial_number", serial_number)
        if signature_algorithm is not None:
            pulumi.set(__self__, "signature_algorithm", signature_algorithm)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter(name="certificateBody")
    def certificate_body(self) -> Optional[pulumi.Input[str]]:
        """
        PEM-formatted certificate, optionally including any intermediary certificates.
        """
        return pulumi.get(self, "certificate_body")

    @certificate_body.setter
    def certificate_body(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_body", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp (GMT) when the certificate was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        All the domains (including wildcard domains) that are listed in the certificate's Subject Alternative Names (SAN) list.
        """
        return pulumi.get(self, "domains")

    @domains.setter
    def domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "domains", value)

    @property
    @pulumi.getter(name="issuedTo")
    def issued_to(self) -> Optional[pulumi.Input[str]]:
        """
        The hostname for which a certificate was issued.
        """
        return pulumi.get(self, "issued_to")

    @issued_to.setter
    def issued_to(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "issued_to", value)

    @property
    @pulumi.getter
    def issuer(self) -> Optional[pulumi.Input[str]]:
        """
        The certificate authority that issued the certificate.
        """
        return pulumi.get(self, "issuer")

    @issuer.setter
    def issuer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "issuer", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Human-readable name used to identify the certificate. Defaults to the certificate's Common Name or first Subject Alternative Name entry.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def replace(self) -> Optional[pulumi.Input[bool]]:
        """
        A recommendation from Fastly indicating the key associated with this certificate is in need of rotation.
        """
        return pulumi.get(self, "replace")

    @replace.setter
    def replace(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "replace", value)

    @property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> Optional[pulumi.Input[str]]:
        """
        A value assigned by the issuer that is unique to a certificate.
        """
        return pulumi.get(self, "serial_number")

    @serial_number.setter
    def serial_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "serial_number", value)

    @property
    @pulumi.getter(name="signatureAlgorithm")
    def signature_algorithm(self) -> Optional[pulumi.Input[str]]:
        """
        The algorithm used to sign the certificate.
        """
        return pulumi.get(self, "signature_algorithm")

    @signature_algorithm.setter
    def signature_algorithm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "signature_algorithm", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp (GMT) when the certificate was last updated.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "updated_at", value)


class TlsCertificate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_body: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Uploads a custom TLS certificate to Fastly to be used to terminate TLS traffic.

        > Each TLS certificate **must** have its corresponding private key uploaded _prior_ to uploading the certificate.

        ## Example Usage

        Basic usage:

        ```python
        import pulumi
        import pulumi_fastly as fastly
        import pulumi_tls as tls

        key_private_key = tls.PrivateKey("keyPrivateKey", algorithm="RSA")
        cert = tls.SelfSignedCert("cert",
            key_algorithm=key_private_key.algorithm,
            private_key_pem=key_private_key.private_key_pem,
            subjects=[tls.SelfSignedCertSubjectArgs(
                common_name="example.com",
            )],
            is_ca_certificate=True,
            validity_period_hours=360,
            allowed_uses=[
                "cert_signing",
                "server_auth",
            ],
            dns_names=["example.com"])
        key_tls_private_key = fastly.TlsPrivateKey("keyTlsPrivateKey", key_pem=key_private_key.private_key_pem)
        example = fastly.TlsCertificate("example", certificate_body=cert.cert_pem,
        opts=pulumi.ResourceOptions(depends_on=[key_tls_private_key]))
        # The private key has to be present before the certificate can be uploaded
        ```

        > **Warning:** Updating the `TlsPrivateKey`/`TlsCertificate` resources should be done in multiple plan/apply steps to avoid potential downtime. The new certificate and associated private key must first be created so they exist alongside the currently active resources. Once the new resources have been created, then the `TlsActivation` can be updated to point to the new certificate. Finally, the original key/certificate resources can be deleted.

        ## Import

        A certificate can be imported using its Fastly certificate ID, e.g.

        ```sh
         $ pulumi import fastly:index/tlsCertificate:TlsCertificate demo xxxxxxxxxxx
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] certificate_body: PEM-formatted certificate, optionally including any intermediary certificates.
        :param pulumi.Input[str] name: Human-readable name used to identify the certificate. Defaults to the certificate's Common Name or first Subject Alternative Name entry.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TlsCertificateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Uploads a custom TLS certificate to Fastly to be used to terminate TLS traffic.

        > Each TLS certificate **must** have its corresponding private key uploaded _prior_ to uploading the certificate.

        ## Example Usage

        Basic usage:

        ```python
        import pulumi
        import pulumi_fastly as fastly
        import pulumi_tls as tls

        key_private_key = tls.PrivateKey("keyPrivateKey", algorithm="RSA")
        cert = tls.SelfSignedCert("cert",
            key_algorithm=key_private_key.algorithm,
            private_key_pem=key_private_key.private_key_pem,
            subjects=[tls.SelfSignedCertSubjectArgs(
                common_name="example.com",
            )],
            is_ca_certificate=True,
            validity_period_hours=360,
            allowed_uses=[
                "cert_signing",
                "server_auth",
            ],
            dns_names=["example.com"])
        key_tls_private_key = fastly.TlsPrivateKey("keyTlsPrivateKey", key_pem=key_private_key.private_key_pem)
        example = fastly.TlsCertificate("example", certificate_body=cert.cert_pem,
        opts=pulumi.ResourceOptions(depends_on=[key_tls_private_key]))
        # The private key has to be present before the certificate can be uploaded
        ```

        > **Warning:** Updating the `TlsPrivateKey`/`TlsCertificate` resources should be done in multiple plan/apply steps to avoid potential downtime. The new certificate and associated private key must first be created so they exist alongside the currently active resources. Once the new resources have been created, then the `TlsActivation` can be updated to point to the new certificate. Finally, the original key/certificate resources can be deleted.

        ## Import

        A certificate can be imported using its Fastly certificate ID, e.g.

        ```sh
         $ pulumi import fastly:index/tlsCertificate:TlsCertificate demo xxxxxxxxxxx
        ```

        :param str resource_name: The name of the resource.
        :param TlsCertificateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TlsCertificateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_body: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TlsCertificateArgs.__new__(TlsCertificateArgs)

            if certificate_body is None and not opts.urn:
                raise TypeError("Missing required property 'certificate_body'")
            __props__.__dict__["certificate_body"] = certificate_body
            __props__.__dict__["name"] = name
            __props__.__dict__["created_at"] = None
            __props__.__dict__["domains"] = None
            __props__.__dict__["issued_to"] = None
            __props__.__dict__["issuer"] = None
            __props__.__dict__["replace"] = None
            __props__.__dict__["serial_number"] = None
            __props__.__dict__["signature_algorithm"] = None
            __props__.__dict__["updated_at"] = None
        super(TlsCertificate, __self__).__init__(
            'fastly:index/tlsCertificate:TlsCertificate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            certificate_body: Optional[pulumi.Input[str]] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            issued_to: Optional[pulumi.Input[str]] = None,
            issuer: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            replace: Optional[pulumi.Input[bool]] = None,
            serial_number: Optional[pulumi.Input[str]] = None,
            signature_algorithm: Optional[pulumi.Input[str]] = None,
            updated_at: Optional[pulumi.Input[str]] = None) -> 'TlsCertificate':
        """
        Get an existing TlsCertificate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] certificate_body: PEM-formatted certificate, optionally including any intermediary certificates.
        :param pulumi.Input[str] created_at: Timestamp (GMT) when the certificate was created.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] domains: All the domains (including wildcard domains) that are listed in the certificate's Subject Alternative Names (SAN) list.
        :param pulumi.Input[str] issued_to: The hostname for which a certificate was issued.
        :param pulumi.Input[str] issuer: The certificate authority that issued the certificate.
        :param pulumi.Input[str] name: Human-readable name used to identify the certificate. Defaults to the certificate's Common Name or first Subject Alternative Name entry.
        :param pulumi.Input[bool] replace: A recommendation from Fastly indicating the key associated with this certificate is in need of rotation.
        :param pulumi.Input[str] serial_number: A value assigned by the issuer that is unique to a certificate.
        :param pulumi.Input[str] signature_algorithm: The algorithm used to sign the certificate.
        :param pulumi.Input[str] updated_at: Timestamp (GMT) when the certificate was last updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TlsCertificateState.__new__(_TlsCertificateState)

        __props__.__dict__["certificate_body"] = certificate_body
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["domains"] = domains
        __props__.__dict__["issued_to"] = issued_to
        __props__.__dict__["issuer"] = issuer
        __props__.__dict__["name"] = name
        __props__.__dict__["replace"] = replace
        __props__.__dict__["serial_number"] = serial_number
        __props__.__dict__["signature_algorithm"] = signature_algorithm
        __props__.__dict__["updated_at"] = updated_at
        return TlsCertificate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="certificateBody")
    def certificate_body(self) -> pulumi.Output[str]:
        """
        PEM-formatted certificate, optionally including any intermediary certificates.
        """
        return pulumi.get(self, "certificate_body")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        Timestamp (GMT) when the certificate was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def domains(self) -> pulumi.Output[Sequence[str]]:
        """
        All the domains (including wildcard domains) that are listed in the certificate's Subject Alternative Names (SAN) list.
        """
        return pulumi.get(self, "domains")

    @property
    @pulumi.getter(name="issuedTo")
    def issued_to(self) -> pulumi.Output[str]:
        """
        The hostname for which a certificate was issued.
        """
        return pulumi.get(self, "issued_to")

    @property
    @pulumi.getter
    def issuer(self) -> pulumi.Output[str]:
        """
        The certificate authority that issued the certificate.
        """
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Human-readable name used to identify the certificate. Defaults to the certificate's Common Name or first Subject Alternative Name entry.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def replace(self) -> pulumi.Output[bool]:
        """
        A recommendation from Fastly indicating the key associated with this certificate is in need of rotation.
        """
        return pulumi.get(self, "replace")

    @property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> pulumi.Output[str]:
        """
        A value assigned by the issuer that is unique to a certificate.
        """
        return pulumi.get(self, "serial_number")

    @property
    @pulumi.getter(name="signatureAlgorithm")
    def signature_algorithm(self) -> pulumi.Output[str]:
        """
        The algorithm used to sign the certificate.
        """
        return pulumi.get(self, "signature_algorithm")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[str]:
        """
        Timestamp (GMT) when the certificate was last updated.
        """
        return pulumi.get(self, "updated_at")

