from time import sleep
import board
import busio
from adafruit_as7341 import AS7341

import neopixel


pixel_pin = board.GP28
num_pixels = 1

pixel = neopixel.NeoPixel(pixel_pin, num_pixels, brightness=0.05, auto_write=False)

i2c = busio.I2C(sda=board.GP26, scl=board.GP27)  # see Maker Pi Pico Base pinout

# i2c = board.I2C()  # uses board.SCL and board.SDA
sensor = AS7341(i2c)


def bar_graph(read_value):
    scaled = int(read_value / 1000)
    return "[%5d] " % read_value + (scaled * "*")


pixel.brightness = 0.05

pixel.fill((255, 0, 0))
pixel.show()

for _ in range(1):

    print("F1 - 415nm/Violet  %s" % bar_graph(sensor.channel_415nm))
    print("F2 - 445nm//Indigo %s" % bar_graph(sensor.channel_445nm))
    print("F3 - 480nm//Blue   %s" % bar_graph(sensor.channel_480nm))
    print("F4 - 515nm//Cyan   %s" % bar_graph(sensor.channel_515nm))
    print("F5 - 555nm/Green   %s" % bar_graph(sensor.channel_555nm))
    print("F6 - 590nm/Yellow  %s" % bar_graph(sensor.channel_590nm))
    print("F7 - 630nm/Orange  %s" % bar_graph(sensor.channel_630nm))
    print("F8 - 680nm/Red     %s" % bar_graph(sensor.channel_680nm))
    print("Clear              %s" % bar_graph(sensor.channel_clear))
    print("Near-IR (NIR)      %s" % bar_graph(sensor.channel_nir))
    print("\n------------------------------------------------")
    sleep(0.1)

pixel.deinit()

# %% web server
# SPDX-FileCopyrightText: 2022 Dan Halbert for Adafruit Industries
#
# SPDX-License-Identifier: Unlicense

from secrets import secrets  # pylint: disable=no-name-in-module

import socketpool
import wifi

from adafruit_httpserver import HTTPServer, HTTPResponse

ssid = secrets["ssid"]
print("Connecting to", ssid)
wifi.radio.connect(ssid, secrets["password"])
print("Connected to", ssid)
print(f"Listening on http://{wifi.radio.ipv4_address}:80")

pool = socket.SocketPool(wifi.radio)
server = HTTPServer(pool)


@server.route("/")
def base(request):  # pylint: disable=unused-argument
    """Default reponse is /index.html"""
    return HTTPResponse(filename="/index.html")


# Never returns
server.serve_forever(str(wifi.radio.ipv4_address))

# %% web server

# import time
# import network
# import socket
# from machine import Pin

# led = Pin(15, Pin.OUT)

# ssid = 'YOUR NETWORK NAME'
# password = 'YOUR NETWORK PASSWORD'

# wlan = network.WLAN(network.STA_IF)
# wlan.active(True)
# wlan.connect(ssid, password)

# html = """<!DOCTYPE html>
# <html>
#     <head> <title>Pico W</title> </head>
#     <body> <h1>Pico W</h1>
#         <p>%s</p>
#     </body>
# </html>
# """

# max_wait = 10
# while max_wait > 0:
#     if wlan.status() < 0 or wlan.status() >= 3:
#         break
#     max_wait -= 1
#     print('waiting for connection...')
#     time.sleep(1)

# if wlan.status() != 3:
#     raise RuntimeError('network connection failed')
# else:
#     print('connected')
#     status = wlan.ifconfig()
#     print( 'ip = ' + status[0] )

# addr = socket.getaddrinfo('0.0.0.0', 80)[0][-1]

# s = socket.socket()
# s.bind(addr)
# s.listen(1)

# print('listening on', addr)

# # Listen for connections
# while True:
#     try:
#         cl, addr = s.accept()
#         print('client connected from', addr)
#         request = cl.recv(1024)
#         print(request)

#         request = str(request)
#         led_on = request.find('/light/on')
#         led_off = request.find('/light/off')
#         print( 'led on = ' + str(led_on))
#         print( 'led off = ' + str(led_off))

#         if led_on == 6:
#             print("led on")
#             led.value(1)
#             stateis = "LED is ON"

#         if led_off == 6:
#             print("led off")
#             led.value(0)
#             stateis = "LED is OFF"

#         response = html % stateis

#         cl.send('HTTP/1.0 200 OK\r\nContent-type: text/html\r\n\r\n')
#         cl.send(response)
#         cl.close()

#     except OSError as e:
#         cl.close()
#         print('connection closed')
