# Audio Transcriber

Проект для автоматической транскрибации аудиофайлов в текст на платформе 1С.

## Возможности

1. Конвертация аудио форматов (MP3, WAV, OGG, M4A, AVI, MOV)
2. Автоматическая транскрибация речи в текст
3. Поддержка длинных аудиофайлов
4. Экспорт результатов в текстовый формат

## Предварительные требования

### Системные зависимости
- **FFmpeg** - для обработки аудио
  ```powershell
  winget install ffmpeg
  ```
  или скачайте с [официального сайта](https://ffmpeg.org/)

### Python зависимости
Установите из файла requirements.txt:
```bash
pip install -r requirements.txt
```

## Быстрый старт

1. **Установите зависимости** (см. выше)
2. **Запустите приложение**:
   ```bash
   python main.py
   ```

## Использование

### Через интерфейс 1С
1. Откройте выгрузку базы "Транскрибатор"
2. Запустите обработку "Решение"
3. Выберите аудиофайл
5. Дождитесь завершения обработки

### Через API
```python
POST /api/v1/create_task
{
    "file_path": "/path/to/audio.mp3"
}

GET /api/v1/status/{task_id}
```

## Настройка

### Поддерживаемые форматы
- Аудио: MP3, WAV, OGG, M4A
- Видео: AVI, MOV, MP4 (извлекается аудиодорожка)

## Решение проблем

### Ошибка "FFmpeg not found"
```bash
# Проверьте установку
ffmpeg -version

# Если не установлен - см. раздел "Предварительные требования"
```

### Ошибка "No module named..."
```bash
# Переустановите зависимости
pip install -r requirements.txt
```

### Долгая обработка
- Используйте меньший размер модели (tiny, base)
- Убедитесь, что есть доступ к GPU

## Статусы задач

- `PENDING` - задача в очереди
- `IN_PROGRESS` - идет обработка
- `COMPLETED` - транскрибация завершена
- `FAILED` - ошибка обработки

## Разработка

### Установка для разработки
```bash
git clone https://github.com/your-username/audio-transcriber.git
cd audio-transcriber
pip install -r requirements.txt
```

## Лицензия

MIT License - см. файл [LICENSE](LICENSE)


