"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LifecycleLabel = exports.renderAmazonLinuxUserData = void 0;
const core_1 = require("@aws-cdk/core");
// tslint:disable-next-line:max-line-length
function renderAmazonLinuxUserData(scope, clusterName, spotFleet, options = {}) {
    const stack = core_1.Stack.of(scope);
    // determine logical id of ASG so we can signal cloudformation
    // const cfn = spotFleet.node.defaultChild as autoscaling.CfnAutoScalingGroup;
    // const asgLogicalId = cfn.logicalId;
    const spotFleetLogicalId = spotFleet.node.id;
    const extraArgs = new Array();
    extraArgs.push(`--use-max-pods ${options.useMaxPods === undefined ? true : options.useMaxPods}`);
    if (options.awsApiRetryAttempts) {
        extraArgs.push(`--aws-api-retry-attempts ${options.awsApiRetryAttempts}`);
    }
    if (options.enableDockerBridge) {
        extraArgs.push('--enable-docker-bridge');
    }
    if (options.dockerConfigJson) {
        extraArgs.push(`--docker-config-json '${options.dockerConfigJson}'`);
    }
    if (options.additionalArgs) {
        extraArgs.push(options.additionalArgs);
    }
    const commandLineSuffix = extraArgs.join(' ');
    const kubeletExtraArgsSuffix = options.kubeletExtraArgs || '';
    // determine lifecycle label based on whether the ASG has a spot price.
    // const lifecycleLabel = autoScalingGroup.spotPrice ? LifecycleLabel.SPOT : LifecycleLabel.ON_DEMAND;
    const lifecycleLabel = LifecycleLabel.SPOT;
    // const withTaints = autoScalingGroup.spotPrice ? '--register-with-taints=spotInstance=true:PreferNoSchedule' : '';
    const withTaints = '--register-with-taints=spotInstance=true:PreferNoSchedule';
    const kubeletExtraArgs = `--node-labels lifecycle=${lifecycleLabel} ${withTaints} ${kubeletExtraArgsSuffix}`.trim();
    return [
        'set -o xtrace',
        `/etc/eks/bootstrap.sh ${clusterName} --kubelet-extra-args "${kubeletExtraArgs}" ${commandLineSuffix}`.trim(),
        `/opt/aws/bin/cfn-signal --exit-code $? --stack ${stack.stackName} --resource ${spotFleetLogicalId} --region ${stack.region}`,
    ];
}
exports.renderAmazonLinuxUserData = renderAmazonLinuxUserData;
/**
 * The lifecycle label for node selector
 */
var LifecycleLabel;
(function (LifecycleLabel) {
    /**
     * on-demand instances
     */
    LifecycleLabel["ON_DEMAND"] = "OnDemand";
    /**
     * spot instances
     */
    LifecycleLabel["SPOT"] = "Ec2Spot";
})(LifecycleLabel = exports.LifecycleLabel || (exports.LifecycleLabel = {}));
//# sourceMappingURL=data:application/json;base64,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