"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Database = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_glue_1 = require("aws-cdk-lib/aws-glue");
/**
 * A Glue database.
 */
class Database extends aws_cdk_lib_1.Resource {
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.databaseName,
        });
        jsiiDeprecationWarnings._aws_cdk_aws_glue_alpha_DatabaseProps(props);
        let databaseInput = {
            name: props.databaseName,
        };
        if (props.locationUri !== undefined) {
            validateLocationUri(props.locationUri);
            this.locationUri = props.locationUri;
            databaseInput = {
                locationUri: this.locationUri,
                ...databaseInput,
            };
        }
        this.catalogId = aws_cdk_lib_1.Stack.of(this).account;
        const resource = new aws_glue_1.CfnDatabase(this, 'Resource', {
            catalogId: this.catalogId,
            databaseInput,
        });
        // see https://docs.aws.amazon.com/glue/latest/dg/glue-specifying-resource-arns.html#data-catalog-resource-arns
        this.databaseName = this.getResourceNameAttribute(resource.ref);
        this.databaseArn = this.stack.formatArn({
            service: 'glue',
            resource: 'database',
            resourceName: this.databaseName,
        });
        // catalogId is implicitly the accountId, which is why we don't pass the catalogId here
        this.catalogArn = aws_cdk_lib_1.Stack.of(this).formatArn({
            service: 'glue',
            resource: 'catalog',
        });
    }
    static fromDatabaseArn(scope, id, databaseArn) {
        const stack = aws_cdk_lib_1.Stack.of(scope);
        class Import extends aws_cdk_lib_1.Resource {
            constructor() {
                super(...arguments);
                this.databaseArn = databaseArn;
                this.databaseName = stack.splitArn(databaseArn, aws_cdk_lib_1.ArnFormat.SLASH_RESOURCE_NAME).resourceName;
                this.catalogArn = stack.formatArn({ service: 'glue', resource: 'catalog' });
                this.catalogId = stack.account;
            }
        }
        return new Import(scope, id);
    }
}
exports.Database = Database;
_a = JSII_RTTI_SYMBOL_1;
Database[_a] = { fqn: "@aws-cdk/aws-glue-alpha.Database", version: "2.19.0-alpha.0" };
function validateLocationUri(locationUri) {
    if (locationUri.length < 1 || locationUri.length > 1024) {
        throw new Error(`locationUri length must be (inclusively) between 1 and 1024, but was ${locationUri.length}`);
    }
}
//# sourceMappingURL=data:application/json;base64,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