[![Build Status](https://dev.azure.com/asottile/asottile/_apis/build/status/asottile.covdefaults?branchName=main)](https://dev.azure.com/asottile/asottile/_build/latest?definitionId=62&branchName=main)
[![Azure DevOps coverage](https://img.shields.io/azure-devops/coverage/asottile/asottile/62/main.svg)](https://dev.azure.com/asottile/asottile/_build/latest?definitionId=62&branchName=main)
[![pre-commit.ci status](https://results.pre-commit.ci/badge/github/asottile/covdefaults/main.svg)](https://results.pre-commit.ci/latest/github/asottile/covdefaults/main)

covdefaults
===========

A coverage plugin to provide sensible default settings

## installation

```bash
pip install covdefaults
```

## usage

to enable the plugin, add `covdefaults` to your coverage plugins

in `.coveragerc`:

```ini
[run]
plugins = covdefaults
```

in `setup.cfg` / `tox.ini`:

```ini
[coverage:run]
plugins = covdefaults
```

in `pyproject.toml`:

```ini
[tool.coverage.run]
plugins = ["covdefaults"]
```

## default settings

### `[coverage:run]`

```ini
branch = True
source = .
omit =
    */__main__.py
    */setup.py
```

### `[coverage:report]`

```ini
show_missing = True
skip_covered = True
fail_under = 100
exclude_lines =
    # a more strict default pragma
    \# pragma: no cover\b

    # allow defensive code
    ^\s*raise AssertionError\b
    ^\s*raise NotImplementedError\b
    ^\s*return NotImplemented\b
    ^\s*raise$

    # typing-related code
    ^\s*if (False|TYPE_CHECKING):
    : \.\.\.(\s*#.*)?$
    ^ +\.\.\.$
    -> ['"]?NoReturn['"]?:

    # non-runnable code
    if __name__ == ['"]__main__['"]:$

    # additional platform related pragmas (see below)
    # additional version related pragmas (see below)
partial_branches =
    # a more strict default pragma
    \# pragma: no cover\b

    # out platform pragmas
    \# pragma: (nt|posix|cygwin|darwin|linux|msys|win32|cpython|pypy) (no )?cover\b

    # our version pragmas
    \# pragma: (>=?|<=?|==|!=)\d+\.\d+ cover\b
```

### platform specific `# pragma: no cover`

several `# pragma: no cover` tags will be added automatically based on the
platform and implementation.

these will be in the form of:

```python
# pragma: TAG no cover
```

or

```python
# pragma: TAG cover
```

these tags will be generated by the following values:

- `os.name`
    - `nt` (windows)
    - `posix` (linux, macOs, cygwin, etc.)
- `sys.platform`
    - `cygwin`
    - `darwin` (macOs)
    - `linux`
    - `msys`
    - `win32`
- `sys.implementation.name`
    - `cpython`
    - `pypy`

for every tag which does not match, you can use negation.  here's an example:

```python
if sys.platform == 'win32':  # pragma: win32 cover
    bin_dir = 'Scripts'
else:  # pragma: win32 no cover
    bin_dir = 'bin'
```

note here that `# pragma: win32 cover` will become a "no cover" for everything
which is not `win32` -- whereas the `# pragma: win32 no cover` will be a
"no cover" only on `win32`.

### version specific `# pragma: no cover`

several `# pragma: no cover` tags will be added automatically based on the
platform and implementation.

these will be in the form of:

```python
# pragma: >=#.# cover
```

where the comparison operator is one of `>`, `>=`, `<`, `<=`, `==`, `!=`

for example:

```python
if sys.version_info >= (3, 9):  # pragma: >=3.9 cover
    print('3.9+')
else:  # pragma: <3.9 cover
    print('old')
```

### overriding options

several of the options can be overridden / extended in your coverage
configuration.  the examples below assume `.coveragerc` however any of the
files `coverage` supports work as well.

#### `run:omit`

```ini
[run]
omit =
    pre_commit/resources/*
```

this will result in the `pre_commit/resources/*` being `omit`ted in addition
to the defaults provided by `covdefaults`.

```ini
[covdefaults]
subtract_omit = */__main__.py
```

this will result in `*/__main__.py` not being `omit`ted (`*/__main__.py` is
among the defaults provided by `covdefaults`).

#### `run:source`

```ini
[run]
source = $PWD
```

covdefaults will not override this value to `.` if it is set manually.

#### `report:exclude_lines`

```ini
[report]
exclude_lines =
    ^if MYPY:$
```

this will result in lines matching `^if MYPY:$` to additionally be excluded
from coverage in addition to the defaults provided by `covdefaults`.

#### `report:fail_under`

```ini
[report]
fail_under = 90
```

`covdefaults` will not change the value if you provide one for `fail_under`
