import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
/**
 * (experimental) Statement provider for service [frauddetector](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonfrauddetector.html).
 *
 * @experimental
 */
export declare class Frauddetector extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [frauddetector](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonfrauddetector.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to create a batch of variables.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_BatchCreateVariable
     *
     * @experimental
     */
    toBatchCreateVariable(): this;
    /**
     * (experimental) Grants permission to get a batch of variables.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_BatchGetVariable
     *
     * @experimental
     */
    toBatchGetVariable(): this;
    /**
     * (experimental) Grants permission to cancel the specified batch prediction job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_CancelBatchPredictionJob
     *
     * @experimental
     */
    toCancelBatchPredictionJob(): this;
    /**
     * (experimental) Grants permission to create a batch prediction job.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_CreateBatchPredictionJob
     *
     * @experimental
     */
    toCreateBatchPredictionJob(): this;
    /**
     * (experimental) Grants permission to create a detector version. The detector version starts in a DRAFT status.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_CreateDetectorVersion
     *
     * @experimental
     */
    toCreateDetectorVersion(): this;
    /**
     * (experimental) Grants permission to create a model using the specified model type.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_CreateModel
     *
     * @experimental
     */
    toCreateModel(): this;
    /**
     * (experimental) Grants permission to create a version of the model using the specified model type and model id.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_CreateModelVersion
     *
     * @experimental
     */
    toCreateModelVersion(): this;
    /**
     * (experimental) Grants permission to create a rule for use with the specified detector.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_CreateRule.html
     *
     * @experimental
     */
    toCreateRule(): this;
    /**
     * (experimental) Grants permission to create a variable.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_CreateVariable.html
     *
     * @experimental
     */
    toCreateVariable(): this;
    /**
     * (experimental) Grants permission to delete a batch prediction job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_DeleteBatchPredictionJob
     *
     * @experimental
     */
    toDeleteBatchPredictionJob(): this;
    /**
     * (experimental) Grants permission to delete the detector.
     *
     * Before deleting a detector, you must first delete all detector versions and rule versions associated with the detector
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_DeleteDetector
     *
     * @experimental
     */
    toDeleteDetector(): this;
    /**
     * (experimental) Grants permission to delete the detector version. You cannot delete detector versions that are in ACTIVE status.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_DeleteDetectorVersion
     *
     * @experimental
     */
    toDeleteDetectorVersion(): this;
    /**
     * (experimental) Grants permission to delete an entity type.
     *
     * You cannot delete an entity type that is included in an event type
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_DeleteEntityType
     *
     * @experimental
     */
    toDeleteEntityType(): this;
    /**
     * (experimental) Grants permission to deletes the specified event.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_DeleteEvent
     *
     * @experimental
     */
    toDeleteEvent(): this;
    /**
     * (experimental) Grants permission to delete an event type.
     *
     * You cannot delete an event type that is used in a detector or a model
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_DeleteEventType
     *
     * @experimental
     */
    toDeleteEventType(): this;
    /**
     * (experimental) Grants permission to remove a SageMaker model from Amazon Fraud Detector.
     *
     * You can remove an Amazon SageMaker model if it is not associated with a detector version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_DeleteExternalModel
     *
     * @experimental
     */
    toDeleteExternalModel(): this;
    /**
     * (experimental) Grants permission to delete a label.
     *
     * You cannot delete labels that are included in an event type in Amazon Fraud Detector. You cannot delete a label assigned to an event ID. You must first delete the relevant event ID
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_DeleteLabel
     *
     * @experimental
     */
    toDeleteLabel(): this;
    /**
     * (experimental) Grants permission to delete a model.
     *
     * You can delete models and model versions in Amazon Fraud Detector, provided that they are not associated with a detector version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_DeleteModel
     *
     * @experimental
     */
    toDeleteModel(): this;
    /**
     * (experimental) Grants permission to delete a model version.
     *
     * You can delete models and model versions in Amazon Fraud Detector, provided that they are not associated with a detector version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_DeleteModelVersion
     *
     * @experimental
     */
    toDeleteModelVersion(): this;
    /**
     * (experimental) Grants permission to delete an outcome. You cannot delete an outcome that is used in a rule version.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_DeleteOutcome
     *
     * @experimental
     */
    toDeleteOutcome(): this;
    /**
     * (experimental) Grants permission to delete the rule.
     *
     * You cannot delete a rule if it is used by an ACTIVE or INACTIVE detector version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_DeleteRule
     *
     * @experimental
     */
    toDeleteRule(): this;
    /**
     * (experimental) Grants permission to delete a variable.
     *
     * You cannot delete variables that are included in an event type in Amazon Fraud Detector
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_DeleteVariable
     *
     * @experimental
     */
    toDeleteVariable(): this;
    /**
     * (experimental) Grants permission to get all versions for a specified detector.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_DescribeDetector
     *
     * @experimental
     */
    toDescribeDetector(): this;
    /**
     * (experimental) Grants permission to get all of the model versions for the specified model type or for the specified model type and model ID.
     *
     * You can also get details for a single, specified model version
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_DescribeModelVersions
     *
     * @experimental
     */
    toDescribeModelVersions(): this;
    /**
     * (experimental) Grants permission to get all batch prediction jobs or a specific job if you specify a job ID.
     *
     * This is a paginated API. If you provide a null maxResults, this action retrieves a maximum of 50 records per page. If you provide a maxResults, the value must be between 1 and 50. To get the next page results, provide the pagination token from the GetBatchPredictionJobsResponse as part of your request. A null pagination token fetches the records from the beginning
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_GetBatchPredictionJobs
     *
     * @experimental
     */
    toGetBatchPredictionJobs(): this;
    /**
     * (experimental) Grants permission to get a particular detector version.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_GetDetectorVersion
     *
     * @experimental
     */
    toGetDetectorVersion(): this;
    /**
     * (experimental) Grants permission to get all detectors or a single detector if a detectorId is specified.
     *
     * This is a paginated API. If you provide a null maxResults, this action retrieves a maximum of 10 records per page. If you provide a maxResults, the value must be between 5 and 10. To get the next page results, provide the pagination token from the GetDetectorsResponse as part of your request. A null pagination token fetches the records from the beginning
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_GetDetectors
     *
     * @experimental
     */
    toGetDetectors(): this;
    /**
     * (experimental) Grants permission to get all entity types or a specific entity type if a name is specified.
     *
     * This is a paginated API. If you provide a null maxResults, this action retrieves a maximum of 10 records per page. If you provide a maxResults, the value must be between 5 and 10. To get the next page results, provide the pagination token from the GetEntityTypesResponse as part of your request. A null pagination token fetches the records from the beginning
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_GetEntityTypes
     *
     * @experimental
     */
    toGetEntityTypes(): this;
    /**
     * (experimental) Grants permission to evaluate an event against a detector version.
     *
     * If a version ID is not provided, the detector’s (ACTIVE) version is used
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_GetEventPrediction
     *
     * @experimental
     */
    toGetEventPrediction(): this;
    /**
     * (experimental) Grants permission to get all event types or a specific event type if name is provided.
     *
     * This is a paginated API. If you provide a null maxResults, this action retrieves a maximum of 10 records per page. If you provide a maxResults, the value must be between 5 and 10. To get the next page results, provide the pagination token from the GetEventTypesResponse as part of your request. A null pagination token fetches the records from the beginning
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_GetEventTypes
     *
     * @experimental
     */
    toGetEventTypes(): this;
    /**
     * (experimental) Grants permission to get the details for one or more Amazon SageMaker models that have been imported into the service.
     *
     * This is a paginated API. If you provide a null maxResults, this actions retrieves a maximum of 10 records per page. If you provide a maxResults, the value must be between 5 and 10. To get the next page results, provide the pagination token from the GetExternalModelsResult as part of your request. A null pagination token fetches the records from the beginning
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_GetExternalModels
     *
     * @experimental
     */
    toGetExternalModels(): this;
    /**
     * (experimental) Grants permission to get the encryption key if a Key Management Service (KMS) customer master key (CMK) has been specified to be used to encrypt content in Amazon Fraud Detector.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_GetKMSEncryptionKey
     *
     * @experimental
     */
    toGetKMSEncryptionKey(): this;
    /**
     * (experimental) Grants permission to get all labels or a specific label if name is provided.
     *
     * This is a paginated API. If you provide a null maxResults, this action retrieves a maximum of 50 records per page. If you provide a maxResults, the value must be between 10 and 50. To get the next page results, provide the pagination token from the GetGetLabelsResponse as part of your request. A null pagination token fetches the records from the beginning
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_GetLabels
     *
     * @experimental
     */
    toGetLabels(): this;
    /**
     * (experimental) Grants permission to get the details of the specified model version.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_GetModelVersion
     *
     * @experimental
     */
    toGetModelVersion(): this;
    /**
     * (experimental) Grants permission to get one or more models.
     *
     * Gets all models for the AWS account if no model type and no model id provided. Gets all models for the AWS account and model type, if the model type is specified but model id is not provided. Gets a specific model if (model type, model id) tuple is specified
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_GetModels
     *
     * @experimental
     */
    toGetModels(): this;
    /**
     * (experimental) Grants permission to get one or more outcomes.
     *
     * This is a paginated API. If you provide a null maxResults, this actions retrieves a maximum of 100 records per page. If you provide a maxResults, the value must be between 50 and 100. To get the next page results, provide the pagination token from the GetOutcomesResult as part of your request. A null pagination token fetches the records from the beginning
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_GetOutcomes
     *
     * @experimental
     */
    toGetOutcomes(): this;
    /**
     * (experimental) Grants permission to get all rules for a detector (paginated) if ruleId and ruleVersion are not specified.
     *
     * Gets all rules for the detector and the ruleId if present (paginated). Gets a specific rule if both the ruleId and the ruleVersion are specified
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_GetRules.html
     *
     * @experimental
     */
    toGetRules(): this;
    /**
     * (experimental) Grants permission to get all of the variables or the specific variable.
     *
     * This is a paginated API. Providing null maxSizePerPage results in retrieving maximum of 100 records per page. If you provide maxSizePerPage the value must be between 50 and 100. To get the next page result, a provide a pagination token from GetVariablesResult as part of your request. Null pagination token fetches the records from the beginning
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_GetVariables
     *
     * @experimental
     */
    toGetVariables(): this;
    /**
     * (experimental) Grants permission to list all tags associated with the resource.
     *
     * This is a paginated API. To get the next page results, provide the pagination token from the response as part of your request. A null pagination token fetches the records from the beginning
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to create or update a detector.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_PutDetector.html
     *
     * @experimental
     */
    toPutDetector(): this;
    /**
     * (experimental) Grants permission to create or update an entity type.
     *
     * An entity represents who is performing the event. As part of a fraud prediction, you pass the entity ID to indicate the specific entity who performed the event. An entity type classifies the entity. Example classifications include customer, merchant, or account
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_PutEntityType.html
     *
     * @experimental
     */
    toPutEntityType(): this;
    /**
     * (experimental) Grants permission to create or update an event type.
     *
     * An event is a business activity that is evaluated for fraud risk. With Amazon Fraud Detector, you generate fraud predictions for events. An event type defines the structure for an event sent to Amazon Fraud Detector. This includes the variables sent as part of the event, the entity performing the event (such as a customer), and the labels that classify the event. Example event types include online payment transactions, account registrations, and authentications
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_PutEventType.html
     *
     * @experimental
     */
    toPutEventType(): this;
    /**
     * (experimental) Grants permission to create or update an Amazon SageMaker model endpoint.
     *
     * You can also use this action to update the configuration of the model endpoint, including the IAM role and/or the mapped variables
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_PutExternalModel.html
     *
     * @experimental
     */
    toPutExternalModel(): this;
    /**
     * (experimental) Grants permission to specify the Key Management Service (KMS) customer master key (CMK) to be used to encrypt content in Amazon Fraud Detector.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_PutKMSEncryptionKey.html
     *
     * @experimental
     */
    toPutKMSEncryptionKey(): this;
    /**
     * (experimental) Grants permission to create or update label.
     *
     * A label classifies an event as fraudulent or legitimate. Labels are associated with event types and used to train supervised machine learning models in Amazon Fraud Detector
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_PutLabel.html
     *
     * @experimental
     */
    toPutLabel(): this;
    /**
     * (experimental) Grants permission to create or update an outcome.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_PutOutcome.html
     *
     * @experimental
     */
    toPutOutcome(): this;
    /**
     * (experimental) Grants permission to assign tags to a resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to remove tags from a resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to update a detector version.
     *
     * The detector version attributes that you can update include models, external model endpoints, rules, rule execution mode, and description. You can only update a DRAFT detector version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_UpdateDetectorVersion
     *
     * @experimental
     */
    toUpdateDetectorVersion(): this;
    /**
     * (experimental) Grants permission to update the detector version's description.
     *
     * You can update the metadata for any detector version (DRAFT, ACTIVE, or INACTIVE)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_UpdateDetectorVersionMetadata
     *
     * @experimental
     */
    toUpdateDetectorVersionMetadata(): this;
    /**
     * (experimental) Grants permission to update the detector version’s status.
     *
     * You can perform the following promotions or demotions using UpdateDetectorVersionStatus: DRAFT to ACTIVE, ACTIVE to INACTIVE, and INACTIVE to ACTIVE
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_UpdateDetectorVersionStatus
     *
     * @experimental
     */
    toUpdateDetectorVersionStatus(): this;
    /**
     * (experimental) Grants permission to update a model. You can update the description attribute using this action.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_UpdateModel
     *
     * @experimental
     */
    toUpdateModel(): this;
    /**
     * (experimental) Grants permission to update a model version.
     *
     * Updating a model version retrains an existing model version using updated training data and produces a new minor version of the model. You can update the training data set location and data access role attributes using this action. This action creates and trains a new minor version of the model, for example version 1.01, 1.02, 1.03
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_UpdateModelVersion
     *
     * @experimental
     */
    toUpdateModelVersion(): this;
    /**
     * (experimental) Grants permission to update the status of a model version.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_UpdateModelVersionStatus
     *
     * @experimental
     */
    toUpdateModelVersionStatus(): this;
    /**
     * (experimental) Grants permission to update a rule's metadata. The description attribute can be updated.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_UpdateRuleMetadata.html
     *
     * @experimental
     */
    toUpdateRuleMetadata(): this;
    /**
     * (experimental) Grants permission to update a rule version resulting in a new rule version.
     *
     * Updates a rule version resulting in a new rule version (version 1, 2, 3 ...)
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_UpdateRuleVersion.html
     *
     * @experimental
     */
    toUpdateRuleVersion(): this;
    /**
     * (experimental) Grants permission to update a variable.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/frauddetector/latest/api/API_UpdateVariable.html
     *
     * @experimental
     */
    toUpdateVariable(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type batch-prediction to the statement.
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonfrauddetector.html#amazonfrauddetector-resources-for-iam-policies
     *
     * @param resourcePath - Identifier for the resourcePath.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onBatchPrediction(resourcePath: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type detector to the statement.
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonfrauddetector.html#amazonfrauddetector-resources-for-iam-policies
     *
     * @param resourcePath - Identifier for the resourcePath.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onDetector(resourcePath: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type detector-version to the statement.
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonfrauddetector.html#amazonfrauddetector-resources-for-iam-policies
     *
     * @param resourcePath - Identifier for the resourcePath.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onDetectorVersion(resourcePath: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type entity-type to the statement.
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonfrauddetector.html#amazonfrauddetector-resources-for-iam-policies
     *
     * @param resourcePath - Identifier for the resourcePath.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onEntityType(resourcePath: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type external-model to the statement.
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonfrauddetector.html#amazonfrauddetector-resources-for-iam-policies
     *
     * @param resourcePath - Identifier for the resourcePath.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onExternalModel(resourcePath: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type event-type to the statement.
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonfrauddetector.html#amazonfrauddetector-resources-for-iam-policies
     *
     * @param resourcePath - Identifier for the resourcePath.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onEventType(resourcePath: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type label to the statement.
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonfrauddetector.html#amazonfrauddetector-resources-for-iam-policies
     *
     * @param resourcePath - Identifier for the resourcePath.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onLabel(resourcePath: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type model to the statement.
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonfrauddetector.html#amazonfrauddetector-resources-for-iam-policies
     *
     * @param resourcePath - Identifier for the resourcePath.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onModel(resourcePath: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type model-version to the statement.
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonfrauddetector.html#amazonfrauddetector-resources-for-iam-policies
     *
     * @param resourcePath - Identifier for the resourcePath.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onModelVersion(resourcePath: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type outcome to the statement.
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonfrauddetector.html#amazonfrauddetector-resources-for-iam-policies
     *
     * @param resourcePath - Identifier for the resourcePath.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onOutcome(resourcePath: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type rule to the statement.
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonfrauddetector.html#amazonfrauddetector-resources-for-iam-policies
     *
     * @param resourcePath - Identifier for the resourcePath.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onRule(resourcePath: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type variable to the statement.
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonfrauddetector.html#amazonfrauddetector-resources-for-iam-policies
     *
     * @param resourcePath - Identifier for the resourcePath.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onVariable(resourcePath: string, account?: string, region?: string, partition?: string): this;
}
