import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement, Operator } from "../shared";
/**
 * (experimental) Statement provider for service [serverlessrepo](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsserverlessapplicationrepository.html).
 *
 * @experimental
 */
export declare class Serverlessrepo extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [serverlessrepo](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsserverlessapplicationrepository.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Creates an application, optionally including an AWS SAM file to create the first application version in the same call.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toCreateApplication(): this;
    /**
     * (experimental) Creates an application version.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toCreateApplicationVersion(): this;
    /**
     * (experimental) Creates an AWS CloudFormation ChangeSet for the given application.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifApplicationType()
     *
     * @experimental
     */
    toCreateCloudFormationChangeSet(): this;
    /**
     * (experimental) Creates an AWS CloudFormation template.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifApplicationType()
     *
     * @experimental
     */
    toCreateCloudFormationTemplate(): this;
    /**
     * (experimental) Deletes the specified application.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toDeleteApplication(): this;
    /**
     * (experimental) Gets the specified application.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifApplicationType()
     *
     * @experimental
     */
    toGetApplication(): this;
    /**
     * (experimental) Gets the policy for the specified application.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toGetApplicationPolicy(): this;
    /**
     * (experimental) Gets the specified AWS CloudFormation template.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toGetCloudFormationTemplate(): this;
    /**
     * (experimental) Retrieves the list of applications nested in the containing application.
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifApplicationType()
     *
     * @experimental
     */
    toListApplicationDependencies(): this;
    /**
     * (experimental) Lists versions for the specified application owned by the requester.
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifApplicationType()
     *
     * @experimental
     */
    toListApplicationVersions(): this;
    /**
     * (experimental) Lists applications owned by the requester.
     *
     * Access Level: List
     *
     * @experimental
     */
    toListApplications(): this;
    /**
     * (experimental) Puts the policy for the specified application.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toPutApplicationPolicy(): this;
    /**
     * (experimental) Gets all applications authorized for this user.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifApplicationType()
     *
     * @experimental
     */
    toSearchApplications(): this;
    /**
     * (experimental) Unshares the specified application.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toUnshareApplication(): this;
    /**
     * (experimental) Updates meta-data of the application.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toUpdateApplication(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type applications to the statement.
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onApplications(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Application type.
     *
     * Applies to actions:
     * - .toCreateCloudFormationChangeSet()
     * - .toCreateCloudFormationTemplate()
     * - .toGetApplication()
     * - .toListApplicationDependencies()
     * - .toListApplicationVersions()
     * - .toSearchApplications()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifApplicationType(value: string | string[], operator?: Operator | string): this;
}
