import csv
from collections import defaultdict
from typing import Dict, Set, TextIO


def flat_to_annotations(file: TextIO) -> Dict[str, Set[str]]:
    """
    Convert a two column file to an annotation dictionary
    :param file: text I/O stream such as returned by open()
    :return: annotations: Dict[str, Set[str]]
    """
    annotations = defaultdict(set)
    reader = csv.reader(file, delimiter='\t', quotechar='\"')
    for row in reader:
        if row[0].startswith('#'):
            continue
        (individual, cls) = row[0:2]
        annotations[individual].add(cls)

    return annotations
