import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [docdb-elastic](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazondocumentdbelasticclusters.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class DocdbElastic extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [docdb-elastic](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazondocumentdbelasticclusters.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to create a new Amazon DocDB-Elastic cluster
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - ec2:CreateVpcEndpoint
     * - ec2:DeleteVpcEndpoints
     * - ec2:DescribeAvailabilityZones
     * - ec2:DescribeSecurityGroups
     * - ec2:DescribeSubnets
     * - ec2:DescribeVpcAttribute
     * - ec2:DescribeVpcEndpoints
     * - ec2:DescribeVpcs
     * - ec2:ModifyVpcEndpoint
     * - iam:CreateServiceLinkedRole
     * - kms:CreateGrant
     * - kms:Decrypt
     * - kms:DescribeKey
     * - kms:GenerateDataKey
     * - secretsmanager:DescribeSecret
     * - secretsmanager:GetResourcePolicy
     * - secretsmanager:GetSecretValue
     * - secretsmanager:ListSecretVersionIds
     * - secretsmanager:ListSecrets
     *
     * https://docs.aws.amazon.com/documentdb/latest/developerguide/API_elastic_CreateCluster.html
     */
    toCreateCluster(): this;
    /**
     * Grants permission to create a new Amazon DocDB-Elastic cluster snapshot
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifAwsResourceTag()
     *
     * Dependent actions:
     * - ec2:CreateVpcEndpoint
     * - ec2:DeleteVpcEndpoints
     * - ec2:DescribeAvailabilityZones
     * - ec2:DescribeSecurityGroups
     * - ec2:DescribeSubnets
     * - ec2:DescribeVpcAttribute
     * - ec2:DescribeVpcEndpoints
     * - ec2:DescribeVpcs
     * - ec2:ModifyVpcEndpoint
     * - iam:CreateServiceLinkedRole
     * - kms:CreateGrant
     * - kms:Decrypt
     * - kms:DescribeKey
     * - kms:GenerateDataKey
     * - secretsmanager:DescribeSecret
     * - secretsmanager:GetResourcePolicy
     * - secretsmanager:GetSecretValue
     * - secretsmanager:ListSecretVersionIds
     * - secretsmanager:ListSecrets
     *
     * https://docs.aws.amazon.com/documentdb/latest/developerguide/API_elastic_CreateClusterSnapshot.html
     */
    toCreateClusterSnapshot(): this;
    /**
     * Grants permission to delete a cluster
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * Dependent actions:
     * - ec2:DeleteVpcEndpoints
     * - ec2:DescribeAvailabilityZones
     * - ec2:DescribeSecurityGroups
     * - ec2:DescribeSubnets
     * - ec2:DescribeVpcAttribute
     * - ec2:DescribeVpcEndpoints
     * - ec2:DescribeVpcs
     * - ec2:ModifyVpcEndpoint
     *
     * https://docs.aws.amazon.com/documentdb/latest/developerguide/API_elastic_DeleteCluster.html
     */
    toDeleteCluster(): this;
    /**
     * Grants permission to delete a cluster snapshot
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * Dependent actions:
     * - ec2:DeleteVpcEndpoints
     * - ec2:DescribeAvailabilityZones
     * - ec2:DescribeSecurityGroups
     * - ec2:DescribeSubnets
     * - ec2:DescribeVpcAttribute
     * - ec2:DescribeVpcEndpoints
     * - ec2:DescribeVpcs
     * - ec2:ModifyVpcEndpoint
     *
     * https://docs.aws.amazon.com/documentdb/latest/developerguide/API_elastic_DeleteClusterSnapshot.html
     */
    toDeleteClusterSnapshot(): this;
    /**
     * Grants permission to view details about a cluster
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/documentdb/latest/developerguide/API_elastic_GetCluster.html
     */
    toGetCluster(): this;
    /**
     * Grants permission to view details about a cluster snapshot
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/documentdb/latest/developerguide/API_elastic_GetClusterSnapshot.html
     */
    toGetClusterSnapshot(): this;
    /**
     * Grants permission to list the cluster snapshots in your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/documentdb/latest/developerguide/API_elastic_ListClusterSnapshots.html
     */
    toListClusterSnapshots(): this;
    /**
     * Grants permission to list the clusters in your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/documentdb/latest/developerguide/API_elastic_ListClusters.html
     */
    toListClusters(): this;
    /**
     * Grants permission to lists tag for an DocumentDB Elastic resource
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/documentdb/latest/developerguide/API_elastic_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to restore cluster from a Amazon DocDB-Elastic cluster snapshot
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifAwsResourceTag()
     *
     * Dependent actions:
     * - ec2:CreateVpcEndpoint
     * - ec2:DeleteVpcEndpoints
     * - ec2:DescribeAvailabilityZones
     * - ec2:DescribeSecurityGroups
     * - ec2:DescribeSubnets
     * - ec2:DescribeVpcAttribute
     * - ec2:DescribeVpcEndpoints
     * - ec2:DescribeVpcs
     * - ec2:ModifyVpcEndpoint
     * - iam:CreateServiceLinkedRole
     * - kms:CreateGrant
     * - kms:Decrypt
     * - kms:DescribeKey
     * - kms:GenerateDataKey
     * - secretsmanager:DescribeSecret
     * - secretsmanager:GetResourcePolicy
     * - secretsmanager:GetSecretValue
     * - secretsmanager:ListSecretVersionIds
     * - secretsmanager:ListSecrets
     *
     * https://docs.aws.amazon.com/documentdb/latest/developerguide/API_elastic_RestoreClusterFromSnapshot.html
     */
    toRestoreClusterFromSnapshot(): this;
    /**
     * Grants permission to tag an DocumentDB Elastic resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/documentdb/latest/developerguide/API_elastic_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to untag a DocumentDB Elastic resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/documentdb/latest/developerguide/API_elastic_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to modify a cluster
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * Dependent actions:
     * - ec2:CreateVpcEndpoint
     * - ec2:DeleteVpcEndpoints
     * - ec2:DescribeAvailabilityZones
     * - ec2:DescribeSecurityGroups
     * - ec2:DescribeSubnets
     * - ec2:DescribeVpcAttribute
     * - ec2:DescribeVpcEndpoints
     * - ec2:DescribeVpcs
     * - ec2:ModifyVpcEndpoint
     * - kms:CreateGrant
     * - kms:Decrypt
     * - kms:DescribeKey
     * - kms:GenerateDataKey
     * - secretsmanager:DescribeSecret
     * - secretsmanager:GetResourcePolicy
     * - secretsmanager:GetSecretValue
     * - secretsmanager:ListSecretVersionIds
     * - secretsmanager:ListSecrets
     *
     * https://docs.aws.amazon.com/documentdb/latest/developerguide/API_elastic_UpdateCluster.html
     */
    toUpdateCluster(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type cluster to the statement
     *
     * https://docs.aws.amazon.com/documentdb/latest/developerguide/elastic-managing.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onCluster(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type cluster-snapshot to the statement
     *
     * https://docs.aws.amazon.com/documentdb/latest/developerguide/elastic-managing.html#elastic-manage-snapshots
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onClusterSnapshot(resourceId: string, account?: string, region?: string, partition?: string): this;
}
