"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Glue = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [glue](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsglue.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Glue extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [glue](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsglue.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'glue';
        this.accessLevelList = {
            Write: [
                'BatchCreatePartition',
                'BatchDeleteConnection',
                'BatchDeletePartition',
                'BatchDeleteTable',
                'BatchDeleteTableVersion',
                'BatchStopJobRun',
                'BatchUpdatePartition',
                'CancelDataQualityRuleRecommendationRun',
                'CancelDataQualityRulesetEvaluationRun',
                'CancelMLTaskRun',
                'CancelStatement',
                'CreateBlueprint',
                'CreateClassifier',
                'CreateConnection',
                'CreateCrawler',
                'CreateCustomEntityType',
                'CreateDataQualityRuleset',
                'CreateDatabase',
                'CreateDevEndpoint',
                'CreateJob',
                'CreateMLTransform',
                'CreatePartition',
                'CreatePartitionIndex',
                'CreateRegistry',
                'CreateSchema',
                'CreateScript',
                'CreateSecurityConfiguration',
                'CreateSession',
                'CreateTable',
                'CreateTrigger',
                'CreateUserDefinedFunction',
                'CreateWorkflow',
                'DeleteBlueprint',
                'DeleteClassifier',
                'DeleteColumnStatisticsForPartition',
                'DeleteColumnStatisticsForTable',
                'DeleteConnection',
                'DeleteCrawler',
                'DeleteCustomEntityType',
                'DeleteDataQualityRuleset',
                'DeleteDatabase',
                'DeleteDevEndpoint',
                'DeleteJob',
                'DeleteMLTransform',
                'DeletePartition',
                'DeletePartitionIndex',
                'DeleteRegistry',
                'DeleteSchema',
                'DeleteSchemaVersions',
                'DeleteSecurityConfiguration',
                'DeleteSession',
                'DeleteTable',
                'DeleteTableVersion',
                'DeleteTrigger',
                'DeleteUserDefinedFunction',
                'DeleteWorkflow',
                'ImportCatalogToGlue',
                'NotifyEvent',
                'PublishDataQuality',
                'PutDataCatalogEncryptionSettings',
                'PutSchemaVersionMetadata',
                'PutWorkflowRunProperties',
                'RegisterSchemaVersion',
                'RemoveSchemaVersionMetadata',
                'ResetJobBookmark',
                'ResumeWorkflowRun',
                'RunStatement',
                'StartBlueprintRun',
                'StartCrawler',
                'StartCrawlerSchedule',
                'StartDataQualityRuleRecommendationRun',
                'StartDataQualityRulesetEvaluationRun',
                'StartExportLabelsTaskRun',
                'StartImportLabelsTaskRun',
                'StartJobRun',
                'StartMLEvaluationTaskRun',
                'StartMLLabelingSetGenerationTaskRun',
                'StartTrigger',
                'StartWorkflowRun',
                'StopCrawler',
                'StopCrawlerSchedule',
                'StopSession',
                'StopTrigger',
                'StopWorkflowRun',
                'UpdateBlueprint',
                'UpdateClassifier',
                'UpdateColumnStatisticsForPartition',
                'UpdateColumnStatisticsForTable',
                'UpdateConnection',
                'UpdateCrawler',
                'UpdateCrawlerSchedule',
                'UpdateDataQualityRuleset',
                'UpdateDatabase',
                'UpdateDevEndpoint',
                'UpdateJob',
                'UpdateJobFromSourceControl',
                'UpdateMLTransform',
                'UpdatePartition',
                'UpdateRegistry',
                'UpdateSchema',
                'UpdateSourceControlFromJob',
                'UpdateTable',
                'UpdateTrigger',
                'UpdateUserDefinedFunction',
                'UpdateWorkflow',
                'UseMLTransforms'
            ],
            Read: [
                'BatchGetBlueprints',
                'BatchGetCrawlers',
                'BatchGetCustomEntityTypes',
                'BatchGetDevEndpoints',
                'BatchGetJobs',
                'BatchGetPartition',
                'BatchGetTriggers',
                'BatchGetWorkflows',
                'CheckSchemaVersionValidity',
                'GetBlueprint',
                'GetBlueprintRun',
                'GetBlueprintRuns',
                'GetCatalogImportStatus',
                'GetClassifier',
                'GetClassifiers',
                'GetColumnStatisticsForPartition',
                'GetColumnStatisticsForTable',
                'GetConnection',
                'GetConnections',
                'GetCrawler',
                'GetCrawlerMetrics',
                'GetCrawlers',
                'GetCustomEntityType',
                'GetDataCatalogEncryptionSettings',
                'GetDataQualityResult',
                'GetDataQualityRuleRecommendationRun',
                'GetDataQualityRuleset',
                'GetDataQualityRulesetEvaluationRun',
                'GetDatabase',
                'GetDatabases',
                'GetDataflowGraph',
                'GetDevEndpoint',
                'GetDevEndpoints',
                'GetJob',
                'GetJobBookmark',
                'GetJobRun',
                'GetJobRuns',
                'GetJobs',
                'GetMLTaskRun',
                'GetMLTransform',
                'GetMapping',
                'GetPartition',
                'GetPartitionIndexes',
                'GetPartitions',
                'GetPlan',
                'GetRegistry',
                'GetResourcePolicies',
                'GetResourcePolicy',
                'GetSchema',
                'GetSchemaByDefinition',
                'GetSchemaVersion',
                'GetSchemaVersionsDiff',
                'GetSecurityConfiguration',
                'GetSecurityConfigurations',
                'GetSession',
                'GetStatement',
                'GetTable',
                'GetTableVersion',
                'GetTableVersions',
                'GetTables',
                'GetTags',
                'GetTrigger',
                'GetTriggers',
                'GetUserDefinedFunction',
                'GetUserDefinedFunctions',
                'GetWorkflow',
                'GetWorkflowRun',
                'GetWorkflowRunProperties',
                'GetWorkflowRuns',
                'SearchTables'
            ],
            'Permissions management': [
                'DeleteResourcePolicy',
                'DeregisterDataPreview',
                'GetNotebookInstanceStatus',
                'GlueNotebookAuthorize',
                'GlueNotebookRefreshCredentials',
                'PutResourcePolicy',
                'StartNotebook',
                'TerminateNotebook',
                'UseGlueStudio'
            ],
            List: [
                'GetMLTaskRuns',
                'GetMLTransforms',
                'ListBlueprints',
                'ListCrawlers',
                'ListCrawls',
                'ListCustomEntityTypes',
                'ListDataQualityResults',
                'ListDataQualityRuleRecommendationRuns',
                'ListDataQualityRulesetEvaluationRuns',
                'ListDataQualityRulesets',
                'ListDevEndpoints',
                'ListJobs',
                'ListMLTransforms',
                'ListRegistries',
                'ListSchemaVersions',
                'ListSchemas',
                'ListSessions',
                'ListStatements',
                'ListTriggers',
                'ListWorkflows',
                'QuerySchemaVersionMetadata'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Grants permission to create one or more partitions
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-partitions.html#aws-glue-api-catalog-partitions-BatchCreatePartition
     */
    toBatchCreatePartition() {
        return this.to('BatchCreatePartition');
    }
    /**
     * Grants permission to delete one or more connections
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-connections.html#aws-glue-api-catalog-connections-BatchDeleteConnection
     */
    toBatchDeleteConnection() {
        return this.to('BatchDeleteConnection');
    }
    /**
     * Grants permission to delete one or more partitions
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-partitions.html#aws-glue-api-catalog-partitions-BatchDeletePartition
     */
    toBatchDeletePartition() {
        return this.to('BatchDeletePartition');
    }
    /**
     * Grants permission to delete one or more tables
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-BatchDeleteTable
     */
    toBatchDeleteTable() {
        return this.to('BatchDeleteTable');
    }
    /**
     * Grants permission to delete one or more versions of a table
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-DeleteTableVersion
     */
    toBatchDeleteTableVersion() {
        return this.to('BatchDeleteTableVersion');
    }
    /**
     * Grants permission to retrieve one or more blueprints
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-workflow.html#aws-glue-api-workflow-BatchGetBlueprints
     */
    toBatchGetBlueprints() {
        return this.to('BatchGetBlueprints');
    }
    /**
     * Grants permission to retrieve one or more crawlers
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-crawling.html#aws-glue-api-crawler-crawling-BatchGetCrawlers
     */
    toBatchGetCrawlers() {
        return this.to('BatchGetCrawlers');
    }
    /**
     * Grants permission to retrieve one or more Custom Entity Types
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-sensitive-data-api.html#aws-glue-api-sensitive-data-api-BatchGetCustomEntityTypes
     */
    toBatchGetCustomEntityTypes() {
        return this.to('BatchGetCustomEntityTypes');
    }
    /**
     * Grants permission to retrieve one or more development endpoints
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-dev-endpoint.html#aws-glue-api-dev-endpoint-BatchGetDevEndpoints
     */
    toBatchGetDevEndpoints() {
        return this.to('BatchGetDevEndpoints');
    }
    /**
     * Grants permission to retrieve one or more jobs
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-job.html#aws-glue-api-jobs-job-BatchGetJobs
     */
    toBatchGetJobs() {
        return this.to('BatchGetJobs');
    }
    /**
     * Grants permission to retrieve one or more partitions
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-partitions.html#aws-glue-api-catalog-partitions-BatchGetPartition
     */
    toBatchGetPartition() {
        return this.to('BatchGetPartition');
    }
    /**
     * Grants permission to retrieve one or more triggers
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-trigger.html#aws-glue-api-jobs-trigger-BatchGetTriggers
     */
    toBatchGetTriggers() {
        return this.to('BatchGetTriggers');
    }
    /**
     * Grants permission to retrieve one or more workflows
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-workflow.html#aws-glue-api-workflow-BatchGetWorkflows
     */
    toBatchGetWorkflows() {
        return this.to('BatchGetWorkflows');
    }
    /**
     * Grants permission to stop one or more job runs for a job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-runs.html#aws-glue-api-jobs-runs-BatchStopStartJobRun
     */
    toBatchStopJobRun() {
        return this.to('BatchStopJobRun');
    }
    /**
     * Grants permission to update one or more partitions
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-partitions.html#aws-glue-api-catalog-partitions-BatchUpdatePartition
     */
    toBatchUpdatePartition() {
        return this.to('BatchUpdatePartition');
    }
    /**
     * Grants permission to stop a running Data Quality rule recommendation run
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-data-quality-api.html#aws-glue-api-data-quality-api-CancelDataQualityRuleRecommendationRun
     */
    toCancelDataQualityRuleRecommendationRun() {
        return this.to('CancelDataQualityRuleRecommendationRun');
    }
    /**
     * Grants permission to stop a running Data Quality ruleset evaluation run
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-data-quality-api.html#aws-glue-api-data-quality-api-CancelDataQualityRulesetEvaluationRun
     */
    toCancelDataQualityRulesetEvaluationRun() {
        return this.to('CancelDataQualityRulesetEvaluationRun');
    }
    /**
     * Grants permission to stop a running ML Task Run
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-machine-learning-api.html#aws-glue-api-machine-learning-api-CancelMLTaskRun
     */
    toCancelMLTaskRun() {
        return this.to('CancelMLTaskRun');
    }
    /**
     * Grants permission to cancel a statement in an interactive session
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-interactive-sessions.html#aws-glue-interactive-sessions-CancelStatement
     */
    toCancelStatement() {
        return this.to('CancelStatement');
    }
    /**
     * Grants permission to retrieve a check the validity of schema version
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-schema-registry-api.html#aws-glue-api-schema-registry-api-CheckSchemaVersionValidity
     */
    toCheckSchemaVersionValidity() {
        return this.to('CheckSchemaVersionValidity');
    }
    /**
     * Grants permission to create a blueprint
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-workflow.html#aws-glue-api-workflow-CreateBlueprint
     */
    toCreateBlueprint() {
        return this.to('CreateBlueprint');
    }
    /**
     * Grants permission to create a classifier
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-classifiers.html#aws-glue-api-crawler-classifiers-CreateClassifier
     */
    toCreateClassifier() {
        return this.to('CreateClassifier');
    }
    /**
     * Grants permission to create a connection
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-connections.html#aws-glue-api-catalog-connections-CreateConnection
     */
    toCreateConnection() {
        return this.to('CreateConnection');
    }
    /**
     * Grants permission to create a crawler
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-crawling.html#aws-glue-api-crawler-crawling-CreateCrawler
     */
    toCreateCrawler() {
        return this.to('CreateCrawler');
    }
    /**
     * Grants permission to create a Custom Entity Type
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-sensitive-data-api.html#aws-glue-api-sensitive-data-api-CreateCustomEntityType
     */
    toCreateCustomEntityType() {
        return this.to('CreateCustomEntityType');
    }
    /**
     * Grants permission to create a Data Quality ruleset
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-data-quality-api.html#aws-glue-api-data-quality-api-CreateDataQualityRuleset
     */
    toCreateDataQualityRuleset() {
        return this.to('CreateDataQualityRuleset');
    }
    /**
     * Grants permission to create a database
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-databases.html#aws-glue-api-catalog-databases-CreateDatabase
     */
    toCreateDatabase() {
        return this.to('CreateDatabase');
    }
    /**
     * Grants permission to create a development endpoint
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-dev-endpoint.html#aws-glue-api-dev-endpoint-CreateDevEndpoint
     */
    toCreateDevEndpoint() {
        return this.to('CreateDevEndpoint');
    }
    /**
     * Grants permission to create a job
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifVpcIds()
     * - .ifSubnetIds()
     * - .ifSecurityGroupIds()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-job.html#aws-glue-api-jobs-job-CreateJob
     */
    toCreateJob() {
        return this.to('CreateJob');
    }
    /**
     * Grants permission to create an ML Transform
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-machine-learning-api.html#aws-glue-api-machine-learning-api-CreateMLTransform
     */
    toCreateMLTransform() {
        return this.to('CreateMLTransform');
    }
    /**
     * Grants permission to create a partition
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-partitions.html#aws-glue-api-catalog-partitions-CreatePartition
     */
    toCreatePartition() {
        return this.to('CreatePartition');
    }
    /**
     * Grants permission to create a specified partition index in an existing table
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-CreatePartitionIndex
     */
    toCreatePartitionIndex() {
        return this.to('CreatePartitionIndex');
    }
    /**
     * Grants permission to create a new schema registry
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-schema-registry-api.html#aws-glue-api-schema-registry-api-CreateRegistry
     */
    toCreateRegistry() {
        return this.to('CreateRegistry');
    }
    /**
     * Grants permission to create a new schema container
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-schema-registry-api.html#aws-glue-api-schema-registry-api-CreateSchema
     */
    toCreateSchema() {
        return this.to('CreateSchema');
    }
    /**
     * Grants permission to create a script
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-etl-script-generation.html#aws-glue-api-etl-script-generation-CreateScript
     */
    toCreateScript() {
        return this.to('CreateScript');
    }
    /**
     * Grants permission to create a security configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-security.html#aws-glue-api-jobs-security-CreateSecurityConfiguration
     */
    toCreateSecurityConfiguration() {
        return this.to('CreateSecurityConfiguration');
    }
    /**
     * Grants permission to create an interactive session
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-interactive-sessions.html#aws-glue-api-interactive-sessions-CreateSession
     */
    toCreateSession() {
        return this.to('CreateSession');
    }
    /**
     * Grants permission to create a table
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-CreateTable
     */
    toCreateTable() {
        return this.to('CreateTable');
    }
    /**
     * Grants permission to create a trigger
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-trigger.html#aws-glue-api-jobs-trigger-CreateTrigger
     */
    toCreateTrigger() {
        return this.to('CreateTrigger');
    }
    /**
     * Grants permission to create a function definition
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-functions.html#aws-glue-api-catalog-functions-CreateUserDefinedFunction
     */
    toCreateUserDefinedFunction() {
        return this.to('CreateUserDefinedFunction');
    }
    /**
     * Grants permission to create a workflow
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-workflow.html#aws-glue-api-workflow-CreateWorkflow
     */
    toCreateWorkflow() {
        return this.to('CreateWorkflow');
    }
    /**
     * Grants permission to delete a blueprint
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-workflow.html#aws-glue-api-workflow-DeleteBlueprint
     */
    toDeleteBlueprint() {
        return this.to('DeleteBlueprint');
    }
    /**
     * Grants permission to delete a classifier
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-classifiers.html#aws-glue-api-crawler-classifiers-DeleteClassifier
     */
    toDeleteClassifier() {
        return this.to('DeleteClassifier');
    }
    /**
     * Grants permission to delete the partition column statistics of a column
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-partitions.html#aws-glue-api-catalog-partitions-DeleteColumnStatisticsForPartition
     */
    toDeleteColumnStatisticsForPartition() {
        return this.to('DeleteColumnStatisticsForPartition');
    }
    /**
     * Grants permission to delete the table statistics of columns
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-DeleteColumnStatisticsForTable
     */
    toDeleteColumnStatisticsForTable() {
        return this.to('DeleteColumnStatisticsForTable');
    }
    /**
     * Grants permission to delete a connection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-connections.html#aws-glue-api-catalog-connections-DeleteConnection
     */
    toDeleteConnection() {
        return this.to('DeleteConnection');
    }
    /**
     * Grants permission to delete a crawler
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-crawling.html#aws-glue-api-crawler-crawling-DeleteCrawler
     */
    toDeleteCrawler() {
        return this.to('DeleteCrawler');
    }
    /**
     * Grants permission to delete a Custom Entity Type
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-sensitive-data-api.html#aws-glue-api-sensitive-data-api-DeleteCustomEntityType
     */
    toDeleteCustomEntityType() {
        return this.to('DeleteCustomEntityType');
    }
    /**
     * Grants permission to delete a Data Quality ruleset
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-data-quality-api.html#aws-glue-api-data-quality-api-DeleteDataQualityRuleset
     */
    toDeleteDataQualityRuleset() {
        return this.to('DeleteDataQualityRuleset');
    }
    /**
     * Grants permission to delete a database
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-databases.html#aws-glue-api-catalog-databases-DeleteDatabase
     */
    toDeleteDatabase() {
        return this.to('DeleteDatabase');
    }
    /**
     * Grants permission to delete a development endpoint
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-dev-endpoint.html#aws-glue-api-dev-endpoint-DeleteDevEndpoint
     */
    toDeleteDevEndpoint() {
        return this.to('DeleteDevEndpoint');
    }
    /**
     * Grants permission to delete a job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-job.html#aws-glue-api-jobs-job-DeleteJob
     */
    toDeleteJob() {
        return this.to('DeleteJob');
    }
    /**
     * Grants permission to delete an ML Transform
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-machine-learning-api.html#aws-glue-api-machine-learning-api-DeleteMLTransform
     */
    toDeleteMLTransform() {
        return this.to('DeleteMLTransform');
    }
    /**
     * Grants permission to delete a partition
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-partitions.html#aws-glue-api-catalog-partitions-DeletePartition
     */
    toDeletePartition() {
        return this.to('DeletePartition');
    }
    /**
     * Grants permission to delete a specified partition index from an existing table
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-DeletePartitionIndex
     */
    toDeletePartitionIndex() {
        return this.to('DeletePartitionIndex');
    }
    /**
     * Grants permission to delete a schema registry
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-schema-registry-api.html#aws-glue-api-schema-registry-api-DeleteRegistry
     */
    toDeleteRegistry() {
        return this.to('DeleteRegistry');
    }
    /**
     * Grants permission to delete a resource policy
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-security.html#aws-glue-api-jobs-security-DeleteResourcePolicy
     */
    toDeleteResourcePolicy() {
        return this.to('DeleteResourcePolicy');
    }
    /**
     * Grants permission to delete a schema container
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-schema-registry-api.html#aws-glue-api-schema-registry-api-DeleteSchema
     */
    toDeleteSchema() {
        return this.to('DeleteSchema');
    }
    /**
     * Grants permission to delete a range of schema versions
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-schema-registry-api.html#aws-glue-api-schema-registry-api-DeleteSchemaVersions
     */
    toDeleteSchemaVersions() {
        return this.to('DeleteSchemaVersions');
    }
    /**
     * Grants permission to delete a security configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-security.html#aws-glue-api-jobs-security-DeleteSecurityConfiguration
     */
    toDeleteSecurityConfiguration() {
        return this.to('DeleteSecurityConfiguration');
    }
    /**
     * Grants permission to delete an interactive session after stopping the session if not already stopped
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-interactive-sessions.html#aws-glue-interactive-sessions-DeleteSession
     */
    toDeleteSession() {
        return this.to('DeleteSession');
    }
    /**
     * Grants permission to delete a table
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-DeleteTable
     */
    toDeleteTable() {
        return this.to('DeleteTable');
    }
    /**
     * Grants permission to delete a version of a table
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-DeleteTableVersion
     */
    toDeleteTableVersion() {
        return this.to('DeleteTableVersion');
    }
    /**
     * Grants permission to delete a trigger
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-trigger.html#aws-glue-api-jobs-trigger-DeleteTrigger
     */
    toDeleteTrigger() {
        return this.to('DeleteTrigger');
    }
    /**
     * Grants permission to delete a function definition
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-functions.html#aws-glue-api-catalog-functions-DeleteUserDefinedFunction
     */
    toDeleteUserDefinedFunction() {
        return this.to('DeleteUserDefinedFunction');
    }
    /**
     * Grants permission to delete a workflow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-workflow.html#aws-glue-api-workflow-DeleteWorkflow
     */
    toDeleteWorkflow() {
        return this.to('DeleteWorkflow');
    }
    /**
     * Grants permission to terminate Glue Studio Notebook session
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/glue/latest/ug/notebook-getting-started.html#create-notebook-permissions-operations
     */
    toDeregisterDataPreview() {
        return this.to('DeregisterDataPreview');
    }
    /**
     * Grants permission to retrieve a blueprint
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-workflow.html#aws-glue-api-workflow-GetBlueprint
     */
    toGetBlueprint() {
        return this.to('GetBlueprint');
    }
    /**
     * Grants permission to retrieve a blueprint run
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-workflow.html#aws-glue-api-workflow-GetBlueprintRun
     */
    toGetBlueprintRun() {
        return this.to('GetBlueprintRun');
    }
    /**
     * Grants permission to retrieve all runs of a blueprint
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-workflow.html#aws-glue-api-workflow-GetBlueprintRuns
     */
    toGetBlueprintRuns() {
        return this.to('GetBlueprintRuns');
    }
    /**
     * Grants permission to retrieve the catalog import status
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-migration.html#aws-glue-api-catalog-migration-GetCatalogImportStatus
     */
    toGetCatalogImportStatus() {
        return this.to('GetCatalogImportStatus');
    }
    /**
     * Grants permission to retrieve a classifier
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-classifiers.html#aws-glue-api-crawler-classifiers-GetClassifier
     */
    toGetClassifier() {
        return this.to('GetClassifier');
    }
    /**
     * Grants permission to list all classifiers
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-classifiers.html#aws-glue-api-crawler-classifiers-GetClassifiers
     */
    toGetClassifiers() {
        return this.to('GetClassifiers');
    }
    /**
     * Grants permission to retrieve partition statistics of columns
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-partitions.html#aws-glue-api-catalog-partitions-GetColumnStatisticsForPartition
     */
    toGetColumnStatisticsForPartition() {
        return this.to('GetColumnStatisticsForPartition');
    }
    /**
     * Grants permission to retrieve table statistics of columns
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-GetColumnStatisticsForTable
     */
    toGetColumnStatisticsForTable() {
        return this.to('GetColumnStatisticsForTable');
    }
    /**
     * Grants permission to retrieve a connection
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-connections.html#aws-glue-api-catalog-connections-GetConnection
     */
    toGetConnection() {
        return this.to('GetConnection');
    }
    /**
     * Grants permission to retrieve a list of connections
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-connections.html#aws-glue-api-catalog-connections-GetConnections
     */
    toGetConnections() {
        return this.to('GetConnections');
    }
    /**
     * Grants permission to retrieve a crawler
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-crawling.html#aws-glue-api-crawler-crawling-GetCrawler
     */
    toGetCrawler() {
        return this.to('GetCrawler');
    }
    /**
     * Grants permission to retrieve metrics about crawlers
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-crawling.html#aws-glue-api-crawler-crawling-GetCrawlerMetrics
     */
    toGetCrawlerMetrics() {
        return this.to('GetCrawlerMetrics');
    }
    /**
     * Grants permission to retrieve all crawlers
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-crawling.html#aws-glue-api-crawler-crawling-GetCrawlers
     */
    toGetCrawlers() {
        return this.to('GetCrawlers');
    }
    /**
     * Grants permission to read a Custom Entity Type
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-sensitive-data-api.html#aws-glue-api-sensitive-data-api-GetCustomEntityType
     */
    toGetCustomEntityType() {
        return this.to('GetCustomEntityType');
    }
    /**
     * Grants permission to retrieve catalog encryption settings
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-security.html#aws-glue-api-jobs-security-GetDataCatalogEncryptionSettings
     */
    toGetDataCatalogEncryptionSettings() {
        return this.to('GetDataCatalogEncryptionSettings');
    }
    /**
     * Grants permission to retrieve a Data Quality result
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-data-quality-api.html#aws-glue-api-data-quality-api-GetDataQualityResult
     */
    toGetDataQualityResult() {
        return this.to('GetDataQualityResult');
    }
    /**
     * Grants permission to retrieve a Data Quality rule recommendation run
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-data-quality-api.html#aws-glue-api-data-quality-api-GetDataQualityRuleRecommendationRun
     */
    toGetDataQualityRuleRecommendationRun() {
        return this.to('GetDataQualityRuleRecommendationRun');
    }
    /**
     * Grants permission to retrieve a Data Quality ruleset
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-data-quality-api.html#aws-glue-api-data-quality-api-GetDataQualityRuleset
     */
    toGetDataQualityRuleset() {
        return this.to('GetDataQualityRuleset');
    }
    /**
     * Grants permission to retrieve a Data Quality rule recommendation run
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-data-quality-api.html#aws-glue-api-data-quality-api-GetDataQualityRulesetEvaluationRun
     */
    toGetDataQualityRulesetEvaluationRun() {
        return this.to('GetDataQualityRulesetEvaluationRun');
    }
    /**
     * Grants permission to retrieve a database
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-databases.html#aws-glue-api-catalog-databases-GetDatabase
     */
    toGetDatabase() {
        return this.to('GetDatabase');
    }
    /**
     * Grants permission to retrieve all databases
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-databases.html#aws-glue-api-catalog-databases-GetDatabases
     */
    toGetDatabases() {
        return this.to('GetDatabases');
    }
    /**
     * Grants permission to transform a script into a directed acyclic graph (DAG)
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-etl-script-generation.html#aws-glue-api-etl-script-generation-GetDataflowGraph
     */
    toGetDataflowGraph() {
        return this.to('GetDataflowGraph');
    }
    /**
     * Grants permission to retrieve a development endpoint
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-dev-endpoint.html#aws-glue-api-dev-endpoint-GetDevEndpoint
     */
    toGetDevEndpoint() {
        return this.to('GetDevEndpoint');
    }
    /**
     * Grants permission to retrieve all development endpoints
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-dev-endpoint.html#aws-glue-api-dev-endpoint-GetDevEndpoints
     */
    toGetDevEndpoints() {
        return this.to('GetDevEndpoints');
    }
    /**
     * Grants permission to retrieve a job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-job.html#aws-glue-api-jobs-job-GetJob
     */
    toGetJob() {
        return this.to('GetJob');
    }
    /**
     * Grants permission to retrieve a job bookmark
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-runs.html#aws-glue-api-jobs-job-GetJobBookmark
     */
    toGetJobBookmark() {
        return this.to('GetJobBookmark');
    }
    /**
     * Grants permission to retrieve a job run
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-runs.html#aws-glue-api-jobs-runs-GetJobRun
     */
    toGetJobRun() {
        return this.to('GetJobRun');
    }
    /**
     * Grants permission to retrieve all job runs of a job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-runs.html#aws-glue-api-jobs-runs-GetJobRuns
     */
    toGetJobRuns() {
        return this.to('GetJobRuns');
    }
    /**
     * Grants permission to retrieve all current jobs
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-job.html#aws-glue-api-jobs-job-GetJobs
     */
    toGetJobs() {
        return this.to('GetJobs');
    }
    /**
     * Grants permission to retrieve an ML Task Run
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-machine-learning-api.html#aws-glue-api-machine-learning-api-GetMLTaskRun
     */
    toGetMLTaskRun() {
        return this.to('GetMLTaskRun');
    }
    /**
     * Grants permission to retrieve all ML Task Runs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-machine-learning-api.html#aws-glue-api-machine-learning-api-GetMLTaskRuns
     */
    toGetMLTaskRuns() {
        return this.to('GetMLTaskRuns');
    }
    /**
     * Grants permission to retrieve an ML Transform
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-machine-learning-api.html#aws-glue-api-machine-learning-api-GetMLTransform
     */
    toGetMLTransform() {
        return this.to('GetMLTransform');
    }
    /**
     * Grants permission to retrieve all ML Transforms
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-machine-learning-api.html#aws-glue-api-machine-learning-api-GetMLTransforms
     */
    toGetMLTransforms() {
        return this.to('GetMLTransforms');
    }
    /**
     * Grants permission to create a mapping
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-etl-script-generation.html#aws-glue-api-etl-script-generation-GetMapping
     */
    toGetMapping() {
        return this.to('GetMapping');
    }
    /**
     * Grants permission to retrieve Glue Studio Notebooks session status
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/glue/latest/ug/notebook-getting-started.html#create-notebook-permissions-operations
     */
    toGetNotebookInstanceStatus() {
        return this.to('GetNotebookInstanceStatus');
    }
    /**
     * Grants permission to retrieve a partition
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-partitions.html#aws-glue-api-catalog-partitions-GetPartition
     */
    toGetPartition() {
        return this.to('GetPartition');
    }
    /**
     * Grants permission to retrieve partition indexes for a table
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-GetPartitionIndexes
     */
    toGetPartitionIndexes() {
        return this.to('GetPartitionIndexes');
    }
    /**
     * Grants permission to retrieve the partitions of a table
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-partitions.html#aws-glue-api-catalog-partitions-GetPartitions
     */
    toGetPartitions() {
        return this.to('GetPartitions');
    }
    /**
     * Grants permission to retrieve a mapping for a script
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-etl-script-generation.html#aws-glue-api-etl-script-generation-GetPlan
     */
    toGetPlan() {
        return this.to('GetPlan');
    }
    /**
     * Grants permission to retrieve a schema registry
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-schema-registry-api.html#aws-glue-api-schema-registry-api-GetRegistry
     */
    toGetRegistry() {
        return this.to('GetRegistry');
    }
    /**
     * Grants permission to retrieve resource policies
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-security.html#aws-glue-api-jobs-security-GetResourcePolicies
     */
    toGetResourcePolicies() {
        return this.to('GetResourcePolicies');
    }
    /**
     * Grants permission to retrieve a resource policy
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-security.html#aws-glue-api-jobs-security-GetResourcePolicy
     */
    toGetResourcePolicy() {
        return this.to('GetResourcePolicy');
    }
    /**
     * Grants permission to retrieve a schema container
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-schema-registry-api.html#aws-glue-api-schema-registry-api-GetSchema
     */
    toGetSchema() {
        return this.to('GetSchema');
    }
    /**
     * Grants permission to retrieve a schema version based on schema definition
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-schema-registry-api.html#aws-glue-api-schema-registry-api-GetSchemaByDefinition
     */
    toGetSchemaByDefinition() {
        return this.to('GetSchemaByDefinition');
    }
    /**
     * Grants permission to retrieve a schema version
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-schema-registry-api.html#aws-glue-api-schema-registry-api-GetSchemaVersion
     */
    toGetSchemaVersion() {
        return this.to('GetSchemaVersion');
    }
    /**
     * Grants permission to compare two schema versions in schema registry
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-schema-registry-api.html#aws-glue-api-schema-registry-api-GetSchemaVersionsDiff
     */
    toGetSchemaVersionsDiff() {
        return this.to('GetSchemaVersionsDiff');
    }
    /**
     * Grants permission to retrieve a security configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-security.html#aws-glue-api-jobs-security-GetSecurityConfiguration
     */
    toGetSecurityConfiguration() {
        return this.to('GetSecurityConfiguration');
    }
    /**
     * Grants permission to retrieve one or more security configurations
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-security.html#aws-glue-api-jobs-security-GetSecurityConfigurations
     */
    toGetSecurityConfigurations() {
        return this.to('GetSecurityConfigurations');
    }
    /**
     * Grants permission to retrieve an interactive session
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-interactive-sessions.html#aws-glue-interactive-sessions-GetSession
     */
    toGetSession() {
        return this.to('GetSession');
    }
    /**
     * Grants permission to retrieve result and information about a statement in an interactive session
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-interactive-sessions.html#aws-glue-interactive-sessions-GetStatement
     */
    toGetStatement() {
        return this.to('GetStatement');
    }
    /**
     * Grants permission to retrieve a table
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-GetTable
     */
    toGetTable() {
        return this.to('GetTable');
    }
    /**
     * Grants permission to retrieve a version of a table
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-GetTableVersion
     */
    toGetTableVersion() {
        return this.to('GetTableVersion');
    }
    /**
     * Grants permission to retrieve a list of versions of a table
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-GetTableVersions
     */
    toGetTableVersions() {
        return this.to('GetTableVersions');
    }
    /**
     * Grants permission to retrieve the tables in a database
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-GetTables
     */
    toGetTables() {
        return this.to('GetTables');
    }
    /**
     * Grants permission to retrieve all tags associated with a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-tags.html#aws-glue-api-tags-UntagResource
     */
    toGetTags() {
        return this.to('GetTags');
    }
    /**
     * Grants permission to retrieve a trigger
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-trigger.html#aws-glue-api-jobs-trigger-GetTrigger
     */
    toGetTrigger() {
        return this.to('GetTrigger');
    }
    /**
     * Grants permission to retrieve the triggers associated with a job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-trigger.html#aws-glue-api-jobs-trigger-GetTriggers
     */
    toGetTriggers() {
        return this.to('GetTriggers');
    }
    /**
     * Grants permission to retrieve a function definition
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-functions.html#aws-glue-api-catalog-functions-GetUserDefinedFunction
     */
    toGetUserDefinedFunction() {
        return this.to('GetUserDefinedFunction');
    }
    /**
     * Grants permission to retrieve multiple function definitions
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-functions.html#aws-glue-api-catalog-functions-GetUserDefinedFunctions
     */
    toGetUserDefinedFunctions() {
        return this.to('GetUserDefinedFunctions');
    }
    /**
     * Grants permission to retrieve a workflow
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-workflow.html#aws-glue-api-workflow-GetWorkflow
     */
    toGetWorkflow() {
        return this.to('GetWorkflow');
    }
    /**
     * Grants permission to retrieve a workflow run
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-workflow.html#aws-glue-api-workflow-GetWorkflowRun
     */
    toGetWorkflowRun() {
        return this.to('GetWorkflowRun');
    }
    /**
     * Grants permission to retrieve workflow run properties
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-workflow.html#aws-glue-api-workflow-GetWorkflowRunProperties
     */
    toGetWorkflowRunProperties() {
        return this.to('GetWorkflowRunProperties');
    }
    /**
     * Grants permission to retrieve all runs of a workflow
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-workflow.html#aws-glue-api-workflow-GetWorkflowRuns
     */
    toGetWorkflowRuns() {
        return this.to('GetWorkflowRuns');
    }
    /**
     * Grants permission to access Glue Studio Notebooks
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/glue/latest/ug/notebook-getting-started.html#create-notebook-permissions-operations
     */
    toGlueNotebookAuthorize() {
        return this.to('GlueNotebookAuthorize');
    }
    /**
     * Grants permission to refresh Glue Studio Notebooks credentials
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/glue/latest/ug/notebook-getting-started.html#create-notebook-permissions-operations
     */
    toGlueNotebookRefreshCredentials() {
        return this.to('GlueNotebookRefreshCredentials');
    }
    /**
     * Grants permission to import an Athena data catalog into AWS Glue
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-migration.html#aws-glue-api-catalog-migration-ImportCatalogToGlue
     */
    toImportCatalogToGlue() {
        return this.to('ImportCatalogToGlue');
    }
    /**
     * Grants permission to retrieve all blueprints
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-workflow.html#aws-glue-api-workflow-ListBlueprints
     */
    toListBlueprints() {
        return this.to('ListBlueprints');
    }
    /**
     * Grants permission to retrieve all crawlers
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-crawling.html#aws-glue-api-crawler-crawling-ListCrawlers
     */
    toListCrawlers() {
        return this.to('ListCrawlers');
    }
    /**
     * Grants permission to retrieve crawl run history for a crawler
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-crawling.html#aws-glue-api-crawler-crawling-ListCrawls
     */
    toListCrawls() {
        return this.to('ListCrawls');
    }
    /**
     * Grants permission to retrieve all Custom Entity Types
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-sensitive-data-api.html#aws-glue-api-sensitive-data-api-ListGetCustomEntityTypes
     */
    toListCustomEntityTypes() {
        return this.to('ListCustomEntityTypes');
    }
    /**
     * Grants permission to retrieve all Data Quality results
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-data-quality-api.html#aws-glue-api-data-quality-api-ListDataQualityResults
     */
    toListDataQualityResults() {
        return this.to('ListDataQualityResults');
    }
    /**
     * Grants permission to retrieve all Data Quality rule recommendation runs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-data-quality-api.html#aws-glue-api-data-quality-api-ListDataQualityRuleRecommendationRuns
     */
    toListDataQualityRuleRecommendationRuns() {
        return this.to('ListDataQualityRuleRecommendationRuns');
    }
    /**
     * Grants permission to retrieve all Data Quality rule recommendation runs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-data-quality-api.html#aws-glue-api-data-quality-api-ListDataQualityRulesetEvaluationRuns
     */
    toListDataQualityRulesetEvaluationRuns() {
        return this.to('ListDataQualityRulesetEvaluationRuns');
    }
    /**
     * Grants permission to retrieve a list of Data Quality rulesets
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-data-quality-api.html#aws-glue-api-data-quality-api-ListDataQualityRulesets
     */
    toListDataQualityRulesets() {
        return this.to('ListDataQualityRulesets');
    }
    /**
     * Grants permission to retrieve all development endpoints
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-dev-endpoint.html#aws-glue-api-dev-endpoint-ListDevEndpoints
     */
    toListDevEndpoints() {
        return this.to('ListDevEndpoints');
    }
    /**
     * Grants permission to retrieve all current jobs
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-job.html#aws-glue-api-jobs-job-ListJobs
     */
    toListJobs() {
        return this.to('ListJobs');
    }
    /**
     * Grants permission to retrieve all ML Transforms
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-machine-learning-api.html#aws-glue-api-machine-learning-api-ListMLTransforms
     */
    toListMLTransforms() {
        return this.to('ListMLTransforms');
    }
    /**
     * Grants permission to retrieve a list of schema registries
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-schema-registry-api.html#aws-glue-api-schema-registry-api-ListRegistries
     */
    toListRegistries() {
        return this.to('ListRegistries');
    }
    /**
     * Grants permission to retrieve a list of schema versions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-schema-registry-api.html#aws-glue-api-schema-registry-api-ListSchemaVersions
     */
    toListSchemaVersions() {
        return this.to('ListSchemaVersions');
    }
    /**
     * Grants permission to retrieve a list of schema containers
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-schema-registry-api.html#aws-glue-api-schema-registry-api-ListSchemas
     */
    toListSchemas() {
        return this.to('ListSchemas');
    }
    /**
     * Grants permission to retrieve a list of interactive session
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-interactive-sessions.html#aws-glue-interactive-sessions-ListSessions
     */
    toListSessions() {
        return this.to('ListSessions');
    }
    /**
     * Grants permission to retrieve a list of statements in an interactive session
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-interactive-sessions.html#aws-glue-interactive-sessions-ListStatements
     */
    toListStatements() {
        return this.to('ListStatements');
    }
    /**
     * Grants permission to retrieve all triggers
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-trigger.html#aws-glue-api-jobs-trigger-ListTriggers
     */
    toListTriggers() {
        return this.to('ListTriggers');
    }
    /**
     * Grants permission to retrieve all workflows
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-workflow.html#aws-glue-api-workflow-ListWorkflows
     */
    toListWorkflows() {
        return this.to('ListWorkflows');
    }
    /**
     * Grants permission to notify an event to the event-driven workflow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/starting-workflow-eventbridge.html
     */
    toNotifyEvent() {
        return this.to('NotifyEvent');
    }
    /**
     * Grants permission to publish Data Quality results
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-data-quality-api.html
     */
    toPublishDataQuality() {
        return this.to('PublishDataQuality');
    }
    /**
     * Grants permission to update catalog encryption settings
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-security.html#aws-glue-api-jobs-security-PutDataCatalogEncryptionSettings
     */
    toPutDataCatalogEncryptionSettings() {
        return this.to('PutDataCatalogEncryptionSettings');
    }
    /**
     * Grants permission to update a resource policy
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-security.html#aws-glue-api-jobs-security-PutResourcePolicy
     */
    toPutResourcePolicy() {
        return this.to('PutResourcePolicy');
    }
    /**
     * Grants permission to add metadata to schema version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-schema-registry-api.html#aws-glue-api-schema-registry-api-PutSchemaVersionMetadata
     */
    toPutSchemaVersionMetadata() {
        return this.to('PutSchemaVersionMetadata');
    }
    /**
     * Grants permission to update workflow run properties
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-workflow.html#aws-glue-api-workflow-PutWorkflowRunProperties
     */
    toPutWorkflowRunProperties() {
        return this.to('PutWorkflowRunProperties');
    }
    /**
     * Grants permission to fetch metadata for a schema version
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-schema-registry-api.html#aws-glue-api-schema-registry-api-QuerySchemaVersionMetadata
     */
    toQuerySchemaVersionMetadata() {
        return this.to('QuerySchemaVersionMetadata');
    }
    /**
     * Grants permission to create a new schema version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-schema-registry-api.html#aws-glue-api-schema-registry-api-RegisterSchemaVersion
     */
    toRegisterSchemaVersion() {
        return this.to('RegisterSchemaVersion');
    }
    /**
     * Grants permission to remove metadata from schema version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-schema-registry-api.html#aws-glue-api-schema-registry-api-RemoveSchemaVersionMetadata
     */
    toRemoveSchemaVersionMetadata() {
        return this.to('RemoveSchemaVersionMetadata');
    }
    /**
     * Grants permission to reset a job bookmark
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-runs.html#aws-glue-api-jobs-runs-ResetJobBookmark
     */
    toResetJobBookmark() {
        return this.to('ResetJobBookmark');
    }
    /**
     * Grants permission to resume a workflow run
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-workflow.html#aws-glue-api-workflow-ResumeWorkflowRun
     */
    toResumeWorkflowRun() {
        return this.to('ResumeWorkflowRun');
    }
    /**
     * Grants permission to run a code or statement in an interactive session
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-interactive-sessions.html#aws-glue-interactive-sessions-RunStatement
     */
    toRunStatement() {
        return this.to('RunStatement');
    }
    /**
     * Grants permission to retrieve the tables in the catalog
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-SearchTables
     */
    toSearchTables() {
        return this.to('SearchTables');
    }
    /**
     * Grants permission to start running a blueprint
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-workflow.html#aws-glue-api-workflow-StartBlueprintRun
     */
    toStartBlueprintRun() {
        return this.to('StartBlueprintRun');
    }
    /**
     * Grants permission to start a crawler
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-crawling.html#aws-glue-api-crawler-crawling-StartCrawler
     */
    toStartCrawler() {
        return this.to('StartCrawler');
    }
    /**
     * Grants permission to change the schedule state of a crawler to SCHEDULED
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-scheduler.html#aws-glue-api-crawler-scheduler-StartCrawlerSchedule
     */
    toStartCrawlerSchedule() {
        return this.to('StartCrawlerSchedule');
    }
    /**
     * Grants permission to start a Data Quality rule recommendation run
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-data-quality-api.html#aws-glue-api-data-quality-api-StartDataQualityRuleRecommendationRun
     */
    toStartDataQualityRuleRecommendationRun() {
        return this.to('StartDataQualityRuleRecommendationRun');
    }
    /**
     * Grants permission to start a Data Quality rule recommendation run
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-data-quality-api.html#aws-glue-api-data-quality-api-StartDataQualityRulesetEvaluationRun
     */
    toStartDataQualityRulesetEvaluationRun() {
        return this.to('StartDataQualityRulesetEvaluationRun');
    }
    /**
     * Grants permission to start an Export Labels ML Task Run
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-machine-learning-api.html#aws-glue-api-machine-learning-api-StartExportLabelsTaskRun
     */
    toStartExportLabelsTaskRun() {
        return this.to('StartExportLabelsTaskRun');
    }
    /**
     * Grants permission to start an Import Labels ML Task Run
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-machine-learning-api.html#aws-glue-api-machine-learning-api-StartImportLabelsTaskRun
     */
    toStartImportLabelsTaskRun() {
        return this.to('StartImportLabelsTaskRun');
    }
    /**
     * Grants permission to start running a job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-runs.html#aws-glue-api-jobs-runs-StartJobRun
     */
    toStartJobRun() {
        return this.to('StartJobRun');
    }
    /**
     * Grants permission to start an Evaluation ML Task Run
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-machine-learning-api.html#aws-glue-api-machine-learning-api-StartMLEvaluationTaskRun
     */
    toStartMLEvaluationTaskRun() {
        return this.to('StartMLEvaluationTaskRun');
    }
    /**
     * Grants permission to start a Labeling Set Generation ML Task Run
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-machine-learning-api.html#aws-glue-api-machine-learning-api-StartMLLabelingSetGenerationTaskRun
     */
    toStartMLLabelingSetGenerationTaskRun() {
        return this.to('StartMLLabelingSetGenerationTaskRun');
    }
    /**
     * Grants permission to start Glue Studio Notebooks
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/glue/latest/ug/notebook-getting-started.html#create-notebook-permissions-operations
     */
    toStartNotebook() {
        return this.to('StartNotebook');
    }
    /**
     * Grants permission to start a trigger
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-trigger.html#aws-glue-api-jobs-trigger-StartTrigger
     */
    toStartTrigger() {
        return this.to('StartTrigger');
    }
    /**
     * Grants permission to start running a workflow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-workflow.html#aws-glue-api-workflow-StartWorkflowRun
     */
    toStartWorkflowRun() {
        return this.to('StartWorkflowRun');
    }
    /**
     * Grants permission to stop a running crawler
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-crawling.html#aws-glue-api-crawler-crawling-StopCrawler
     */
    toStopCrawler() {
        return this.to('StopCrawler');
    }
    /**
     * Grants permission to set the schedule state of a crawler to NOT_SCHEDULED
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-scheduler.html#aws-glue-api-crawler-scheduler-StopCrawlerSchedule
     */
    toStopCrawlerSchedule() {
        return this.to('StopCrawlerSchedule');
    }
    /**
     * Grants permission to stop an interactive session
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-interactive-sessions.html#aws-glue-interactive-sessions-StopSession
     */
    toStopSession() {
        return this.to('StopSession');
    }
    /**
     * Grants permission to stop a trigger
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-trigger.html#aws-glue-api-jobs-trigger-StopTrigger
     */
    toStopTrigger() {
        return this.to('StopTrigger');
    }
    /**
     * Grants permission to stop a workflow run
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-workflow.html#aws-glue-api-workflow-StopWorkflowRun
     */
    toStopWorkflowRun() {
        return this.to('StopWorkflowRun');
    }
    /**
     * Grants permission to add tags to a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-tags.html#aws-glue-api-tags-TagResource
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to terminate Glue Studio Notebooks
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/glue/latest/ug/notebook-getting-started.html#create-notebook-permissions-operations
     */
    toTerminateNotebook() {
        return this.to('TerminateNotebook');
    }
    /**
     * Grants permission to remove tags associated with a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-tags.html#aws-glue-api-tags-UntagResource
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to update a blueprint
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-workflow.html#aws-glue-api-workflow-UpdateBlueprint
     */
    toUpdateBlueprint() {
        return this.to('UpdateBlueprint');
    }
    /**
     * Grants permission to update a classifier
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-classifiers.html#aws-glue-api-crawler-classifiers-UpdateClassifier
     */
    toUpdateClassifier() {
        return this.to('UpdateClassifier');
    }
    /**
     * Grants permission to update partition statistics of columns
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-partitions.html#aws-glue-api-catalog-partitions-UpdateColumnStatisticsForPartition
     */
    toUpdateColumnStatisticsForPartition() {
        return this.to('UpdateColumnStatisticsForPartition');
    }
    /**
     * Grants permission to update table statistics of columns
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-UpdateColumnStatisticsForTable
     */
    toUpdateColumnStatisticsForTable() {
        return this.to('UpdateColumnStatisticsForTable');
    }
    /**
     * Grants permission to update a connection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-connections.html#aws-glue-api-catalog-connections-UpdateConnection
     */
    toUpdateConnection() {
        return this.to('UpdateConnection');
    }
    /**
     * Grants permission to update a crawler
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-crawling.html#aws-glue-api-crawler-crawling-UpdateCrawler
     */
    toUpdateCrawler() {
        return this.to('UpdateCrawler');
    }
    /**
     * Grants permission to update the schedule of a crawler
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-scheduler.html#aws-glue-api-crawler-scheduler-UpdateCrawlerSchedule
     */
    toUpdateCrawlerSchedule() {
        return this.to('UpdateCrawlerSchedule');
    }
    /**
     * Grants permission to update a Data Quality ruleset
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-data-quality-api.html#aws-glue-api-data-quality-api-UpdateDataQualityRuleset
     */
    toUpdateDataQualityRuleset() {
        return this.to('UpdateDataQualityRuleset');
    }
    /**
     * Grants permission to update a database
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-databases.html#aws-glue-api-catalog-databases-UpdateDatabase
     */
    toUpdateDatabase() {
        return this.to('UpdateDatabase');
    }
    /**
     * Grants permission to update a development endpoint
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-dev-endpoint.html#aws-glue-api-dev-endpoint-UpdateDevEndpoint
     */
    toUpdateDevEndpoint() {
        return this.to('UpdateDevEndpoint');
    }
    /**
     * Grants permission to update a job
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifVpcIds()
     * - .ifSubnetIds()
     * - .ifSecurityGroupIds()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-job.html#aws-glue-api-jobs-job-UpdateJob
     */
    toUpdateJob() {
        return this.to('UpdateJob');
    }
    /**
     * Grants permission to update a job from source control provider
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-job.html#aws-glue-api-jobs-job-UpdateJobFromSourceControl
     */
    toUpdateJobFromSourceControl() {
        return this.to('UpdateJobFromSourceControl');
    }
    /**
     * Grants permission to update an ML Transform
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-machine-learning-api.html#aws-glue-api-machine-learning-api-UpdateMLTransform
     */
    toUpdateMLTransform() {
        return this.to('UpdateMLTransform');
    }
    /**
     * Grants permission to update a partition
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-partitions.html#aws-glue-api-catalog-partitions-UpdatePartition
     */
    toUpdatePartition() {
        return this.to('UpdatePartition');
    }
    /**
     * Grants permission to update a schema registry
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-schema-registry-api.html#aws-glue-api-schema-registry-api-UpdateRegistry
     */
    toUpdateRegistry() {
        return this.to('UpdateRegistry');
    }
    /**
     * Grants permission to update a schema container
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-schema-registry-api.html#aws-glue-api-schema-registry-api-UpdateSchema
     */
    toUpdateSchema() {
        return this.to('UpdateSchema');
    }
    /**
     * Grants permission to update source control provider from a job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-job.html#aws-glue-api-jobs-job-UpdateSourceControlFromJob
     */
    toUpdateSourceControlFromJob() {
        return this.to('UpdateSourceControlFromJob');
    }
    /**
     * Grants permission to update a table
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-UpdateTable
     */
    toUpdateTable() {
        return this.to('UpdateTable');
    }
    /**
     * Grants permission to update a trigger
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-trigger.html#aws-glue-api-jobs-trigger-UpdateTrigger
     */
    toUpdateTrigger() {
        return this.to('UpdateTrigger');
    }
    /**
     * Grants permission to update a function definition
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-functions.html#aws-glue-api-catalog-functions-UpdateUserDefinedFunction
     */
    toUpdateUserDefinedFunction() {
        return this.to('UpdateUserDefinedFunction');
    }
    /**
     * Grants permission to update a workflow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-workflow.html#aws-glue-api-workflow-UpdateWorkflow
     */
    toUpdateWorkflow() {
        return this.to('UpdateWorkflow');
    }
    /**
     * Grants permission to use Glue Studio and access its internal APIs
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/glue/latest/ug/setting-up.html#getting-started-min-privs
     */
    toUseGlueStudio() {
        return this.to('UseGlueStudio');
    }
    /**
     * Grants permission to use an ML Transform from within a Glue ETL Script
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-machine-learning-api.html
     */
    toUseMLTransforms() {
        return this.to('UseMLTransforms');
    }
    /**
     * Adds a resource of type catalog to the statement
     *
     * https://docs.aws.amazon.com/glue/latest/dg/glue-specifying-resource-arns.html
     *
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onCatalog(account, region, partition) {
        return this.on(`arn:${partition || Glue.defaultPartition}:glue:${region || '*'}:${account || '*'}:catalog`);
    }
    /**
     * Adds a resource of type database to the statement
     *
     * https://docs.aws.amazon.com/glue/latest/dg/glue-specifying-resource-arns.html
     *
     * @param databaseName - Identifier for the databaseName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onDatabase(databaseName, account, region, partition) {
        return this.on(`arn:${partition || Glue.defaultPartition}:glue:${region || '*'}:${account || '*'}:database/${databaseName}`);
    }
    /**
     * Adds a resource of type table to the statement
     *
     * https://docs.aws.amazon.com/glue/latest/dg/glue-specifying-resource-arns.html
     *
     * @param databaseName - Identifier for the databaseName.
     * @param tableName - Identifier for the tableName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onTable(databaseName, tableName, account, region, partition) {
        return this.on(`arn:${partition || Glue.defaultPartition}:glue:${region || '*'}:${account || '*'}:table/${databaseName}/${tableName}`);
    }
    /**
     * Adds a resource of type tableversion to the statement
     *
     * https://docs.aws.amazon.com/glue/latest/dg/glue-specifying-resource-arns.html
     *
     * @param databaseName - Identifier for the databaseName.
     * @param tableName - Identifier for the tableName.
     * @param tableVersionName - Identifier for the tableVersionName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onTableversion(databaseName, tableName, tableVersionName, account, region, partition) {
        return this.on(`arn:${partition || Glue.defaultPartition}:glue:${region || '*'}:${account || '*'}:tableVersion/${databaseName}/${tableName}/${tableVersionName}`);
    }
    /**
     * Adds a resource of type connection to the statement
     *
     * https://docs.aws.amazon.com/glue/latest/dg/glue-specifying-resource-arns.html
     *
     * @param connectionName - Identifier for the connectionName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onConnection(connectionName, account, region, partition) {
        return this.on(`arn:${partition || Glue.defaultPartition}:glue:${region || '*'}:${account || '*'}:connection/${connectionName}`);
    }
    /**
     * Adds a resource of type userdefinedfunction to the statement
     *
     * https://docs.aws.amazon.com/glue/latest/dg/glue-specifying-resource-arns.html
     *
     * @param databaseName - Identifier for the databaseName.
     * @param userDefinedFunctionName - Identifier for the userDefinedFunctionName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onUserdefinedfunction(databaseName, userDefinedFunctionName, account, region, partition) {
        return this.on(`arn:${partition || Glue.defaultPartition}:glue:${region || '*'}:${account || '*'}:userDefinedFunction/${databaseName}/${userDefinedFunctionName}`);
    }
    /**
     * Adds a resource of type devendpoint to the statement
     *
     * https://docs.aws.amazon.com/glue/latest/dg/glue-specifying-resource-arns.html
     *
     * @param devEndpointName - Identifier for the devEndpointName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDevendpoint(devEndpointName, account, region, partition) {
        return this.on(`arn:${partition || Glue.defaultPartition}:glue:${region || '*'}:${account || '*'}:devEndpoint/${devEndpointName}`);
    }
    /**
     * Adds a resource of type job to the statement
     *
     * https://docs.aws.amazon.com/glue/latest/dg/glue-specifying-resource-arns.html
     *
     * @param jobName - Identifier for the jobName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onJob(jobName, account, region, partition) {
        return this.on(`arn:${partition || Glue.defaultPartition}:glue:${region || '*'}:${account || '*'}:job/${jobName}`);
    }
    /**
     * Adds a resource of type trigger to the statement
     *
     * https://docs.aws.amazon.com/glue/latest/dg/glue-specifying-resource-arns.html
     *
     * @param triggerName - Identifier for the triggerName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onTrigger(triggerName, account, region, partition) {
        return this.on(`arn:${partition || Glue.defaultPartition}:glue:${region || '*'}:${account || '*'}:trigger/${triggerName}`);
    }
    /**
     * Adds a resource of type crawler to the statement
     *
     * https://docs.aws.amazon.com/glue/latest/dg/glue-specifying-resource-arns.html
     *
     * @param crawlerName - Identifier for the crawlerName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onCrawler(crawlerName, account, region, partition) {
        return this.on(`arn:${partition || Glue.defaultPartition}:glue:${region || '*'}:${account || '*'}:crawler/${crawlerName}`);
    }
    /**
     * Adds a resource of type workflow to the statement
     *
     * https://docs.aws.amazon.com/glue/latest/dg/glue-specifying-resource-arns.html
     *
     * @param workflowName - Identifier for the workflowName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onWorkflow(workflowName, account, region, partition) {
        return this.on(`arn:${partition || Glue.defaultPartition}:glue:${region || '*'}:${account || '*'}:workflow/${workflowName}`);
    }
    /**
     * Adds a resource of type blueprint to the statement
     *
     * https://docs.aws.amazon.com/glue/latest/dg/glue-specifying-resource-arns.html
     *
     * @param blueprintName - Identifier for the blueprintName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onBlueprint(blueprintName, account, region, partition) {
        return this.on(`arn:${partition || Glue.defaultPartition}:glue:${region || '*'}:${account || '*'}:blueprint/${blueprintName}`);
    }
    /**
     * Adds a resource of type mlTransform to the statement
     *
     * https://docs.aws.amazon.com/glue/latest/dg/glue-specifying-resource-arns.html
     *
     * @param transformId - Identifier for the transformId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onMlTransform(transformId, account, region, partition) {
        return this.on(`arn:${partition || Glue.defaultPartition}:glue:${region || '*'}:${account || '*'}:mlTransform/${transformId}`);
    }
    /**
     * Adds a resource of type registry to the statement
     *
     * https://docs.aws.amazon.com/glue/latest/dg/glue-specifying-resource-arns.html
     *
     * @param registryName - Identifier for the registryName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onRegistry(registryName, account, region, partition) {
        return this.on(`arn:${partition || Glue.defaultPartition}:glue:${region || '*'}:${account || '*'}:registry/${registryName}`);
    }
    /**
     * Adds a resource of type schema to the statement
     *
     * https://docs.aws.amazon.com/glue/latest/dg/glue-specifying-resource-arns.html
     *
     * @param schemaName - Identifier for the schemaName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onSchema(schemaName, account, region, partition) {
        return this.on(`arn:${partition || Glue.defaultPartition}:glue:${region || '*'}:${account || '*'}:schema/${schemaName}`);
    }
    /**
     * Adds a resource of type session to the statement
     *
     * https://docs.aws.amazon.com/glue/latest/dg/glue-specifying-resource-arns.html
     *
     * @param sessionId - Identifier for the sessionId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onSession(sessionId, account, region, partition) {
        return this.on(`arn:${partition || Glue.defaultPartition}:glue:${region || '*'}:${account || '*'}:session/${sessionId}`);
    }
    /**
     * Adds a resource of type dataQualityRuleset to the statement
     *
     * https://docs.aws.amazon.com/glue/latest/dg/glue-specifying-resource-arns.html
     *
     * @param rulesetName - Identifier for the rulesetName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDataQualityRuleset(rulesetName, account, region, partition) {
        return this.on(`arn:${partition || Glue.defaultPartition}:glue:${region || '*'}:${account || '*'}:dataQualityRuleset/${rulesetName}`);
    }
    /**
     * Filters access by the service from which the credentials of the request is issued
     *
     * https://docs.aws.amazon.com/glue/latest/dg/using-identity-based-policies.html#glue-identity-based-policy-condition-keys
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifCredentialIssuingService(value, operator) {
        return this.if(`CredentialIssuingService`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the service from which the credentials of the request is obtained by assuming the customer role
     *
     * https://docs.aws.amazon.com/glue/latest/dg/using-identity-based-policies.html#glue-identity-based-policy-condition-keys
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifRoleAssumedBy(value, operator) {
        return this.if(`RoleAssumedBy`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the ID of security groups configured for the Glue job
     *
     * https://docs.aws.amazon.com/glue/latest/dg/using-identity-based-policies.html#glue-identity-based-policy-condition-keys
     *
     * Applies to actions:
     * - .toCreateJob()
     * - .toUpdateJob()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifSecurityGroupIds(value, operator) {
        return this.if(`SecurityGroupIds`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the ID of subnets configured for the Glue job
     *
     * https://docs.aws.amazon.com/glue/latest/dg/using-identity-based-policies.html#glue-identity-based-policy-condition-keys
     *
     * Applies to actions:
     * - .toCreateJob()
     * - .toUpdateJob()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifSubnetIds(value, operator) {
        return this.if(`SubnetIds`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the ID of the VPC configured for the Glue job
     *
     * https://docs.aws.amazon.com/glue/latest/dg/using-identity-based-policies.html#glue-identity-based-policy-condition-keys
     *
     * Applies to actions:
     * - .toCreateJob()
     * - .toUpdateJob()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifVpcIds(value, operator) {
        return this.if(`VpcIds`, value, operator || 'StringLike');
    }
}
exports.Glue = Glue;
_a = JSII_RTTI_SYMBOL_1;
Glue[_a] = { fqn: "iam-floyd.Glue", version: "0.491.0" };
//# sourceMappingURL=data:application/json;base64,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