"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Machinelearning = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [machinelearning](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmachinelearning.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Machinelearning extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [machinelearning](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmachinelearning.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'machinelearning';
        this.accessLevelList = {
            Tagging: [
                'AddTags',
                'DeleteTags'
            ],
            Write: [
                'CreateBatchPrediction',
                'CreateDataSourceFromRDS',
                'CreateDataSourceFromRedshift',
                'CreateDataSourceFromS3',
                'CreateEvaluation',
                'CreateMLModel',
                'CreateRealtimeEndpoint',
                'DeleteBatchPrediction',
                'DeleteDataSource',
                'DeleteEvaluation',
                'DeleteMLModel',
                'DeleteRealtimeEndpoint',
                'Predict',
                'UpdateBatchPrediction',
                'UpdateDataSource',
                'UpdateEvaluation',
                'UpdateMLModel'
            ],
            List: [
                'DescribeBatchPredictions',
                'DescribeDataSources',
                'DescribeEvaluations',
                'DescribeMLModels',
                'DescribeTags'
            ],
            Read: [
                'GetBatchPrediction',
                'GetDataSource',
                'GetEvaluation',
                'GetMLModel'
            ]
        };
    }
    /**
     * Adds one or more tags to an object, up to a limit of 10. Each tag consists of a key and an optional value
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_AddTags.html
     */
    toAddTags() {
        return this.to('AddTags');
    }
    /**
     * Generates predictions for a group of observations
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_CreateBatchPrediction.html
     */
    toCreateBatchPrediction() {
        return this.to('CreateBatchPrediction');
    }
    /**
     * Creates a DataSource object from an Amazon RDS
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_CreateDataSourceFromRDS.html
     */
    toCreateDataSourceFromRDS() {
        return this.to('CreateDataSourceFromRDS');
    }
    /**
     * Creates a DataSource from a database hosted on an Amazon Redshift cluster
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_CreateDataSourceFromRedshift.html
     */
    toCreateDataSourceFromRedshift() {
        return this.to('CreateDataSourceFromRedshift');
    }
    /**
     * Creates a DataSource object from S3
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_CreateDataSourceFromS3.html
     */
    toCreateDataSourceFromS3() {
        return this.to('CreateDataSourceFromS3');
    }
    /**
     * Creates a new Evaluation of an MLModel
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_CreateEvaluation.html
     */
    toCreateEvaluation() {
        return this.to('CreateEvaluation');
    }
    /**
     * Creates a new MLModel
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_CreateMLModel.html
     */
    toCreateMLModel() {
        return this.to('CreateMLModel');
    }
    /**
     * Creates a real-time endpoint for the MLModel
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_CreateRealtimeEndpoint.html
     */
    toCreateRealtimeEndpoint() {
        return this.to('CreateRealtimeEndpoint');
    }
    /**
     * Assigns the DELETED status to a BatchPrediction, rendering it unusable
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_DeleteBatchPrediction.html
     */
    toDeleteBatchPrediction() {
        return this.to('DeleteBatchPrediction');
    }
    /**
     * Assigns the DELETED status to a DataSource, rendering it unusable
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_DeleteDataSource.html
     */
    toDeleteDataSource() {
        return this.to('DeleteDataSource');
    }
    /**
     * Assigns the DELETED status to an Evaluation, rendering it unusable
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_DeleteEvaluation.html
     */
    toDeleteEvaluation() {
        return this.to('DeleteEvaluation');
    }
    /**
     * Assigns the DELETED status to an MLModel, rendering it unusable
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_DeleteMLModel.html
     */
    toDeleteMLModel() {
        return this.to('DeleteMLModel');
    }
    /**
     * Deletes a real time endpoint of an MLModel
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_DeleteRealtimeEndpoint.html
     */
    toDeleteRealtimeEndpoint() {
        return this.to('DeleteRealtimeEndpoint');
    }
    /**
     * Deletes the specified tags associated with an ML object. After this operation is complete, you can't recover deleted tags
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_DeleteTags.html
     */
    toDeleteTags() {
        return this.to('DeleteTags');
    }
    /**
     * Returns a list of BatchPrediction operations that match the search criteria in the request
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_DescribeBatchPredictions.html
     */
    toDescribeBatchPredictions() {
        return this.to('DescribeBatchPredictions');
    }
    /**
     * Returns a list of DataSource that match the search criteria in the request
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_DescribeDataSources.html
     */
    toDescribeDataSources() {
        return this.to('DescribeDataSources');
    }
    /**
     * Returns a list of DescribeEvaluations that match the search criteria in the request
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_DescribeEvaluations.html
     */
    toDescribeEvaluations() {
        return this.to('DescribeEvaluations');
    }
    /**
     * Returns a list of MLModel that match the search criteria in the request
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_DescribeMLModels.html
     */
    toDescribeMLModels() {
        return this.to('DescribeMLModels');
    }
    /**
     * Describes one or more of the tags for your Amazon ML object
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_DescribeTags.html
     */
    toDescribeTags() {
        return this.to('DescribeTags');
    }
    /**
     * Returns a BatchPrediction that includes detailed metadata, status, and data file information
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_GetBatchPrediction.html
     */
    toGetBatchPrediction() {
        return this.to('GetBatchPrediction');
    }
    /**
     * Returns a DataSource that includes metadata and data file information, as well as the current status of the DataSource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_GetDataSource.html
     */
    toGetDataSource() {
        return this.to('GetDataSource');
    }
    /**
     * Returns an Evaluation that includes metadata as well as the current status of the Evaluation
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_GetEvaluation.html
     */
    toGetEvaluation() {
        return this.to('GetEvaluation');
    }
    /**
     * Returns an MLModel that includes detailed metadata, and data source information as well as the current status of the MLModel
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_GetMLModel.html
     */
    toGetMLModel() {
        return this.to('GetMLModel');
    }
    /**
     * Generates a prediction for the observation using the specified ML Model
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_Predict.html
     */
    toPredict() {
        return this.to('Predict');
    }
    /**
     * Updates the BatchPredictionName of a BatchPrediction
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_UpdateBatchPrediction.html
     */
    toUpdateBatchPrediction() {
        return this.to('UpdateBatchPrediction');
    }
    /**
     * Updates the DataSourceName of a DataSource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_UpdateDataSource.html
     */
    toUpdateDataSource() {
        return this.to('UpdateDataSource');
    }
    /**
     * Updates the EvaluationName of an Evaluation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_UpdateEvaluation.html
     */
    toUpdateEvaluation() {
        return this.to('UpdateEvaluation');
    }
    /**
     * Updates the MLModelName and the ScoreThreshold of an MLModel
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_UpdateMLModel.html
     */
    toUpdateMLModel() {
        return this.to('UpdateMLModel');
    }
    /**
     * Adds a resource of type batchprediction to the statement
     *
     * https://docs.aws.amazon.com/machine-learning/latest/dg/amazon-machine-learning-key-concepts.html#batch-predictions
     *
     * @param batchPredictionId - Identifier for the batchPredictionId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onBatchprediction(batchPredictionId, account, region, partition) {
        return this.on(`arn:${partition || Machinelearning.defaultPartition}:machinelearning:${region || '*'}:${account || '*'}:batchprediction/${batchPredictionId}`);
    }
    /**
     * Adds a resource of type datasource to the statement
     *
     * https://docs.aws.amazon.com/machine-learning/latest/dg/amazon-machine-learning-key-concepts.html#datasources
     *
     * @param datasourceId - Identifier for the datasourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onDatasource(datasourceId, account, region, partition) {
        return this.on(`arn:${partition || Machinelearning.defaultPartition}:machinelearning:${region || '*'}:${account || '*'}:datasource/${datasourceId}`);
    }
    /**
     * Adds a resource of type evaluation to the statement
     *
     * https://docs.aws.amazon.com/machine-learning/latest/dg/amazon-machine-learning-key-concepts.html#evaluations
     *
     * @param evaluationId - Identifier for the evaluationId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onEvaluation(evaluationId, account, region, partition) {
        return this.on(`arn:${partition || Machinelearning.defaultPartition}:machinelearning:${region || '*'}:${account || '*'}:evaluation/${evaluationId}`);
    }
    /**
     * Adds a resource of type mlmodel to the statement
     *
     * https://docs.aws.amazon.com/machine-learning/latest/dg/amazon-machine-learning-key-concepts.html#ml-models
     *
     * @param mlModelId - Identifier for the mlModelId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onMlmodel(mlModelId, account, region, partition) {
        return this.on(`arn:${partition || Machinelearning.defaultPartition}:machinelearning:${region || '*'}:${account || '*'}:mlmodel/${mlModelId}`);
    }
}
exports.Machinelearning = Machinelearning;
_a = JSII_RTTI_SYMBOL_1;
Machinelearning[_a] = { fqn: "iam-floyd.Machinelearning", version: "0.491.0" };
//# sourceMappingURL=data:application/json;base64,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