import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [macie2](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmacie.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Macie2 extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [macie2](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmacie.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to accept an Amazon Macie membership invitation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/invitations-accept.html
     */
    toAcceptInvitation(): this;
    /**
     * Grants permission to retrieve information about one or more custom data identifiers
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/custom-data-identifiers-get.html
     */
    toBatchGetCustomDataIdentifiers(): this;
    /**
     * Grants permission to create and define the settings for an allow list
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/allow-lists.html
     */
    toCreateAllowList(): this;
    /**
     * Grants permission to create and define the settings for a sensitive data discovery job
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/jobs.html
     */
    toCreateClassificationJob(): this;
    /**
     * Grants permission to create and define the settings for a custom data identifier
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/custom-data-identifiers.html
     */
    toCreateCustomDataIdentifier(): this;
    /**
     * Grants permission to create and define the settings for a findings filter
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/findingsfilters.html
     */
    toCreateFindingsFilter(): this;
    /**
     * Grants permission to send an Amazon Macie membership invitation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/invitations.html
     */
    toCreateInvitations(): this;
    /**
     * Grants permission to associate an account with an Amazon Macie administrator account
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/members.html
     */
    toCreateMember(): this;
    /**
     * Grants permission to create sample findings
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/findings-sample.html
     */
    toCreateSampleFindings(): this;
    /**
     * Grants permission to decline Amazon Macie membership invitations
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/invitations-decline.html
     */
    toDeclineInvitations(): this;
    /**
     * Grants permission to delete an allow list
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/allow-lists-id.html
     */
    toDeleteAllowList(): this;
    /**
     * Grants permission to delete a custom data identifier
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/custom-data-identifiers-id.html
     */
    toDeleteCustomDataIdentifier(): this;
    /**
     * Grants permission to delete a findings filter
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/findingsfilters-id.html
     */
    toDeleteFindingsFilter(): this;
    /**
     * Grants permission to delete Amazon Macie membership invitations
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/invitations-delete.html
     */
    toDeleteInvitations(): this;
    /**
     * Grants permission to delete the association between an Amazon Macie administrator account and an account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/members-id.html
     */
    toDeleteMember(): this;
    /**
     * Grants permission to retrieve statistical data and other information about S3 buckets that Amazon Macie monitors and analyzes
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/datasources-s3.html
     */
    toDescribeBuckets(): this;
    /**
     * Grants permission to retrieve information about the status and settings for a sensitive data discovery job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/jobs-jobid.html
     */
    toDescribeClassificationJob(): this;
    /**
     * Grants permission to retrieve information about the Amazon Macie configuration settings for an AWS organization
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/admin-configuration.html
     */
    toDescribeOrganizationConfiguration(): this;
    /**
     * Grants permission to disable an Amazon Macie account, which also deletes Macie resources for the account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/macie.html
     */
    toDisableMacie(): this;
    /**
     * Grants permission to disable an account as the delegated Amazon Macie administrator account for an AWS organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/admin.html
     */
    toDisableOrganizationAdminAccount(): this;
    /**
     * Grants permission to an Amazon Macie member account to disassociate from its Macie administrator account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/administrator-disassociate.html
     */
    toDisassociateFromAdministratorAccount(): this;
    /**
     * Grants permission to an Amazon Macie member account to disassociate from its Macie administrator account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/master-disassociate.html
     */
    toDisassociateFromMasterAccount(): this;
    /**
     * Grants permission to an Amazon Macie administrator account to disassociate from a Macie member account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/members-disassociate-id.html
     */
    toDisassociateMember(): this;
    /**
     * Grants permission to enable and specify the configuration settings for a new Amazon Macie account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/macie.html
     */
    toEnableMacie(): this;
    /**
     * Grants permission to enable an account as the delegated Amazon Macie administrator account for an AWS organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/admin.html
     */
    toEnableOrganizationAdminAccount(): this;
    /**
     * Grants permission to retrieve information about the Amazon Macie administrator account for an account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/administrator.html
     */
    toGetAdministratorAccount(): this;
    /**
     * Grants permission to retrieve the settings and status of an allow list
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/allow-lists-id.html
     */
    toGetAllowList(): this;
    /**
     * Grants permission to retrieve the configuration settings and status of automated sensitive data discovery for an account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/automated-discovery-configuration.html
     */
    toGetAutomatedDiscoveryConfiguration(): this;
    /**
     * Grants permission to retrieve aggregated statistical data for all the S3 buckets that Amazon Macie monitors and analyzes
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/datasources-s3-statistics.html
     */
    toGetBucketStatistics(): this;
    /**
     * Grants permission to retrieve the settings for exporting sensitive data discovery results
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/classification-export-configuration.html
     */
    toGetClassificationExportConfiguration(): this;
    /**
     * Grants permission to retrieve the classification scope settings for an account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/classification-scopes-id.html
     */
    toGetClassificationScope(): this;
    /**
     * Grants permission to retrieve information about the settings for a custom data identifier
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/custom-data-identifiers-id.html
     */
    toGetCustomDataIdentifier(): this;
    /**
     * Grants permission to retrieve aggregated statistical data about findings
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/findings-statistics.html
     */
    toGetFindingStatistics(): this;
    /**
     * Grants permission to retrieve the details of one or more findings
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/findings-describe.html
     */
    toGetFindings(): this;
    /**
     * Grants permission to retrieve information about the settings for a findings filter
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/findingsfilters-id.html
     */
    toGetFindingsFilter(): this;
    /**
     * Grants permission to retrieve the configuration settings for publishing findings to AWS Security Hub
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/findings-publication-configuration.html
     */
    toGetFindingsPublicationConfiguration(): this;
    /**
     * Grants permission to retrieve the count of Amazon Macie membership invitations that were received by an account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/invitations-count.html
     */
    toGetInvitationsCount(): this;
    /**
     * Grants permission to retrieve information about the status and configuration settings for an Amazon Macie account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/macie.html
     */
    toGetMacieSession(): this;
    /**
     * Grants permission to retrieve information about the Amazon Macie administrator account for an account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/master.html
     */
    toGetMasterAccount(): this;
    /**
     * Grants permission to retrieve information about an account that's associated with an Amazon Macie administrator account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/members-id.html
     */
    toGetMember(): this;
    /**
     * Grants permission to retrieve sensitive data discovery statistics and the sensitivity score for an S3 bucket
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/resource-profiles.html
     */
    toGetResourceProfile(): this;
    /**
     * Grants permission to retrieve the status and configuration settings for retrieving occurrences of sensitive data reported by findings
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/reveal-configuration.html
     */
    toGetRevealConfiguration(): this;
    /**
     * Grants permission to retrieve occurrences of sensitive data reported by a finding
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/findings-findingid-reveal.html
     */
    toGetSensitiveDataOccurrences(): this;
    /**
     * Grants permission to check whether occurrences of sensitive data can be retrieved for a finding
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/findings-findingid-reveal-availability.html
     */
    toGetSensitiveDataOccurrencesAvailability(): this;
    /**
     * Grants permission to retrieve the sensitivity inspection template settings for an account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/templates-sensitivity-inspections-id.html
     */
    toGetSensitivityInspectionTemplate(): this;
    /**
     * Grants permission to retrieve quotas and aggregated usage data for one or more accounts
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/usage-statistics.html
     */
    toGetUsageStatistics(): this;
    /**
     * Grants permission to retrieve aggregated usage data for an account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/usage.html
     */
    toGetUsageTotals(): this;
    /**
     * Grants permission to retrieve a subset of information about all the allow lists for an account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/allow-lists.html
     */
    toListAllowLists(): this;
    /**
     * Grants permission to retrieve a subset of information about the status and settings for one or more sensitive data discovery jobs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/jobs-list.html
     */
    toListClassificationJobs(): this;
    /**
     * Grants permission to retrieve a subset of information about the classification scope for an account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/classification-scopes.html
     */
    toListClassificationScopes(): this;
    /**
     * Grants permission to retrieve information about all custom data identifiers
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/custom-data-identifiers-list.html
     */
    toListCustomDataIdentifiers(): this;
    /**
     * Grants permission to retrieve a subset of information about one or more findings
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/findings.html
     */
    toListFindings(): this;
    /**
     * Grants permission to retrieve information about all findings filters
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/findingsfilters.html
     */
    toListFindingsFilters(): this;
    /**
     * Grants permission to retrieve information about all the Amazon Macie membership invitations that were received by an account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/invitations.html
     */
    toListInvitations(): this;
    /**
     * Grants permission to retrieve information about managed data identifiers
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/managed-data-identifiers-list.html
     */
    toListManagedDataIdentifiers(): this;
    /**
     * Grants permission to retrieve information about the Amazon Macie member accounts that are associated with a Macie administrator account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/members.html
     */
    toListMembers(): this;
    /**
     * Grants permission to retrieve information about the delegated, Amazon Macie administrator account for an AWS organization
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/admin.html
     */
    toListOrganizationAdminAccounts(): this;
    /**
     * Grants permission to retrieve information about objects that were selected from an S3 bucket for automated sensitive data discovery
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/resource-profiles-artifacts.html
     */
    toListResourceProfileArtifacts(): this;
    /**
     * Grants permission to retrieve information about the types and amount of sensitive data that Amazon Macie found in an S3 bucket
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/resource-profiles-detections.html
     */
    toListResourceProfileDetections(): this;
    /**
     * Grants permission to retrieve a subset of information about the sensitivity inspection template for an account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/templates-sensitivity-inspections.html
     */
    toListSensitivityInspectionTemplates(): this;
    /**
     * Grants permission to retrieve the tags for an Amazon Macie resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/tags-resourcearn.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to create or update the settings for storing sensitive data discovery results
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/classification-export-configuration.html
     */
    toPutClassificationExportConfiguration(): this;
    /**
     * Grants permission to update the configuration settings for publishing findings to AWS Security Hub
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/findings-publication-configuration.html
     */
    toPutFindingsPublicationConfiguration(): this;
    /**
     * Grants permission to retrieve statistical data and other information about AWS resources that Amazon Macie monitors and analyzes
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/datasources-search-resources.html
     */
    toSearchResources(): this;
    /**
     * Grants permission to add or update the tags for an Amazon Macie resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/tags-resourcearn.html
     */
    toTagResource(): this;
    /**
     * Grants permission to test a custom data identifier
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/custom-data-identifiers-test.html
     */
    toTestCustomDataIdentifier(): this;
    /**
     * Grants permission to remove tags from an Amazon Macie resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/tags-resourcearn.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update the settings for an allow list
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/allow-lists-id.html
     */
    toUpdateAllowList(): this;
    /**
     * Grants permission to enable or disable automated sensitive data discovery for an account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/automated-discovery-configuration.html
     */
    toUpdateAutomatedDiscoveryConfiguration(): this;
    /**
     * Grants permission to change the status of a sensitive data discovery job
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/jobs-jobid.html
     */
    toUpdateClassificationJob(): this;
    /**
     * Grants permission to update the classification scope settings for an account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/classification-scopes-id.html
     */
    toUpdateClassificationScope(): this;
    /**
     * Grants permission to update the settings for a findings filter
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/findingsfilters-id.html
     */
    toUpdateFindingsFilter(): this;
    /**
     * Grants permission to suspend or re-enable an Amazon Macie account, or update the configuration settings for a Macie account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/macie.html
     */
    toUpdateMacieSession(): this;
    /**
     * Grants permission to an Amazon Macie administrator account to suspend or re-enable a Macie member account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/macie-members-id.html
     */
    toUpdateMemberSession(): this;
    /**
     * Grants permission to update Amazon Macie configuration settings for an AWS organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/admin-configuration.html
     */
    toUpdateOrganizationConfiguration(): this;
    /**
     * Grants permission to update the sensitivity score for an S3 bucket
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/resource-profiles.html
     */
    toUpdateResourceProfile(): this;
    /**
     * Grants permission to update the sensitivity scoring settings for an S3 bucket
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/resource-profiles-detections.html
     */
    toUpdateResourceProfileDetections(): this;
    /**
     * Grants permission to update the status and configuration settings for retrieving occurrences of sensitive data reported by findings
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/reveal-configuration.html
     */
    toUpdateRevealConfiguration(): this;
    /**
     * Grants permission to update the sensitivity inspection template settings for an account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/templates-sensitivity-inspections-id.html
     */
    toUpdateSensitivityInspectionTemplate(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type AllowList to the statement
     *
     * https://docs.aws.amazon.com/macie/latest/user/what-is-macie.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onAllowList(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type ClassificationJob to the statement
     *
     * https://docs.aws.amazon.com/macie/latest/user/what-is-macie.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onClassificationJob(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type CustomDataIdentifier to the statement
     *
     * https://docs.aws.amazon.com/macie/latest/user/what-is-macie.html.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onCustomDataIdentifier(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type FindingsFilter to the statement
     *
     * https://docs.aws.amazon.com/macie/latest/user/what-is-macie.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onFindingsFilter(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type Member to the statement
     *
     * https://docs.aws.amazon.com/macie/latest/user/what-is-macie.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onMember(resourceId: string, account?: string, region?: string, partition?: string): this;
}
