import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [private-networks](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsserviceprovidingmanagedprivatenetworks.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class PrivateNetworks extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [private-networks](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsserviceprovidingmanagedprivatenetworks.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to acknowledge that an order has been received
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/private-networks/latest/APIReference/API_AcknowledgeOrderReceipt.html
     */
    toAcknowledgeOrderReceipt(): this;
    /**
     * Grants permission to activate a device identifier
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/private-networks/latest/APIReference/API_ActivateDeviceIdentifier.html
     */
    toActivateDeviceIdentifier(): this;
    /**
     * Grants permission to activate a network site
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/private-networks/latest/APIReference/API_ActivateNetworkSite.html
     */
    toActivateNetworkSite(): this;
    /**
     * Grants permission to configure an access point
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/private-networks/latest/APIReference/API_ConfigureAccessPoint.html
     */
    toConfigureAccessPoint(): this;
    /**
     * Grants permission to create a network
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/private-networks/latest/APIReference/API_CreateNetwork.html
     */
    toCreateNetwork(): this;
    /**
     * Grants permission to create a network site
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/private-networks/latest/APIReference/API_CreateNetworkSite.html
     */
    toCreateNetworkSite(): this;
    /**
     * Grants permission to deactivate a device identifier
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/private-networks/latest/APIReference/API_DeactivateDeviceIdentifier.html
     */
    toDeactivateDeviceIdentifier(): this;
    /**
     * Grants permission to delete a network
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/private-networks/latest/APIReference/API_DeleteNetwork.html
     */
    toDeleteNetwork(): this;
    /**
     * Grants permission to delete a network site
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/private-networks/latest/APIReference/API_DeleteNetworkSite.html
     */
    toDeleteNetworkSite(): this;
    /**
     * Grants permission to get a device identifier
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/private-networks/latest/APIReference/API_GetDeviceIdentifier.html
     */
    toGetDeviceIdentifier(): this;
    /**
     * Grants permission to get a network
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/private-networks/latest/APIReference/API_GetNetwork.html
     */
    toGetNetwork(): this;
    /**
     * Grants permission to get a network resource
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/private-networks/latest/APIReference/API_GetNetworkResource.html
     */
    toGetNetworkResource(): this;
    /**
     * Grants permission to get a network site
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/private-networks/latest/APIReference/API_GetNetworkSite.html
     */
    toGetNetworkSite(): this;
    /**
     * Grants permission to get a network order
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/private-networks/latest/APIReference/API_GetOrder.html
     */
    toGetOrder(): this;
    /**
     * Grants permission to list device identifiers
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/private-networks/latest/APIReference/API_ListDeviceIdentifiers.html
     */
    toListDeviceIdentifiers(): this;
    /**
     * Grants permission to list network resources
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/private-networks/latest/APIReference/API_ListNetworkResources.html
     */
    toListNetworkResources(): this;
    /**
     * Grants permission to list network sites
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/private-networks/latest/APIReference/API_ListNetworkSites.html
     */
    toListNetworkSites(): this;
    /**
     * Grants permission to list networks
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/private-networks/latest/APIReference/API_ListNetworks.html
     */
    toListNetworks(): this;
    /**
     * Grants permission to list network orders
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/private-networks/latest/APIReference/API_ListOrders.html
     */
    toListOrders(): this;
    /**
     * Grants permission to return a list of tags for a resource
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/private-networks/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to check the health of the service
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/private-networks/latest/APIReference/API_Ping.html
     */
    toPing(): this;
    /**
     * Grants permission to adds tags to the specified resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/private-networks/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to removes tags from the specified resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/private-networks/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update a network site
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/private-networks/latest/APIReference/API_UpdateNetworkSite.html
     */
    toUpdateNetworkSite(): this;
    /**
     * Grants permission to update a plan at a network site
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/private-networks/latest/APIReference/API_UpdateNetworkSitePlan.html
     */
    toUpdateNetworkSitePlan(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type network to the statement
     *
     * https://docs.aws.amazon.com/private-networks/latest/userguide/identity-access-management.html
     *
     * @param networkName - Identifier for the networkName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onNetwork(networkName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type network-site to the statement
     *
     * https://docs.aws.amazon.com/private-networks/latest/userguide/identity-access-management.html
     *
     * @param networkName - Identifier for the networkName.
     * @param networkSiteName - Identifier for the networkSiteName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onNetworkSite(networkName: string, networkSiteName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type network-resource to the statement
     *
     * https://docs.aws.amazon.com/private-networks/latest/userguide/identity-access-management.html
     *
     * @param networkName - Identifier for the networkName.
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onNetworkResource(networkName: string, resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type order to the statement
     *
     * https://docs.aws.amazon.com/private-networks/latest/userguide/identity-access-management.html
     *
     * @param networkName - Identifier for the networkName.
     * @param orderId - Identifier for the orderId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onOrder(networkName: string, orderId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type device-identifier to the statement
     *
     * https://docs.aws.amazon.com/private-networks/latest/userguide/identity-access-management.html
     *
     * @param networkName - Identifier for the networkName.
     * @param deviceId - Identifier for the deviceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDeviceIdentifier(networkName: string, deviceId: string, account?: string, region?: string, partition?: string): this;
}
