import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [sqs](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonsqs.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Sqs extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [sqs](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonsqs.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to a queue for a specific principal
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_AddPermission.html
     */
    toAddPermission(): this;
    /**
     * Grants permission to change the visibility timeout of a specified message in a queue to a new value
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_ChangeMessageVisibility.html
     */
    toChangeMessageVisibility(): this;
    /**
     * Grants permission to create a new queue, or returns the URL of an existing one
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_CreateQueue.html
     */
    toCreateQueue(): this;
    /**
     * Grants permission to delete the specified message from the specified queue
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_DeleteMessage.html
     */
    toDeleteMessage(): this;
    /**
     * Grants permission to delete the queue specified by the queue URL, regardless of whether the queue is empty
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_DeleteQueue.html
     */
    toDeleteQueue(): this;
    /**
     * Grants permission to get attributes for the specified queue
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_GetQueueAttributes.html
     */
    toGetQueueAttributes(): this;
    /**
     * Grants permission to return the URL of an existing queue
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_GetQueueUrl.html
     */
    toGetQueueUrl(): this;
    /**
     * Grants permission to return a list of your queues that have the RedrivePolicy queue attribute configured with a dead letter queue
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_ListDeadLetterSourceQueues.html
     */
    toListDeadLetterSourceQueues(): this;
    /**
     * Grants permission to list tags added to an SQS queue
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_ListQueueTags.html
     */
    toListQueueTags(): this;
    /**
     * Grants permission to return a list of your queues
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_ListQueues.html
     */
    toListQueues(): this;
    /**
     * Grants permission to delete the messages in a queue specified by the queue URL
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_PurgeQueue.html
     */
    toPurgeQueue(): this;
    /**
     * Grants permission to retrieve one or more messages, with a maximum limit of 10 messages, from the specified queue
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_ReceiveMessage.html
     */
    toReceiveMessage(): this;
    /**
     * Grants permission to revoke any permissions in the queue policy that matches the specified Label parameter
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_RemovePermission.html
     */
    toRemovePermission(): this;
    /**
     * Grants permission to deliver a message to the specified queue
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_SendMessage.html
     */
    toSendMessage(): this;
    /**
     * Grants permission to set the value of one or more queue attributes
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_SetQueueAttributes.html
     */
    toSetQueueAttributes(): this;
    /**
     * Grants permission to add tags to the specified SQS queue
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_TagQueue.html
     */
    toTagQueue(): this;
    /**
     * Grants permission to remove tags from the specified SQS queue
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_UntagQueue.html
     */
    toUntagQueue(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type queue to the statement
     *
     * https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-queue-types.html
     *
     * @param queueName - Identifier for the queueName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onQueue(queueName: string, account?: string, region?: string, partition?: string): this;
}
