"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Workdocs = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [workdocs](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonworkdocs.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Workdocs extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [workdocs](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonworkdocs.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'workdocs';
        this.accessLevelList = {
            Write: [
                'AbortDocumentVersionUpload',
                'ActivateUser',
                'AddNotificationPermissions',
                'AddResourcePermissions',
                'AddUserToGroup',
                'CreateComment',
                'CreateCustomMetadata',
                'CreateFolder',
                'CreateInstance',
                'CreateLabels',
                'CreateNotificationSubscription',
                'CreateUser',
                'DeactivateUser',
                'DeleteComment',
                'DeleteCustomMetadata',
                'DeleteDocument',
                'DeleteDocumentVersion',
                'DeleteFolder',
                'DeleteFolderContents',
                'DeleteInstance',
                'DeleteLabels',
                'DeleteNotificationPermissions',
                'DeleteNotificationSubscription',
                'DeleteUser',
                'DeregisterDirectory',
                'InitiateDocumentVersionUpload',
                'RegisterDirectory',
                'RemoveAllResourcePermissions',
                'RemoveResourcePermission',
                'RestoreDocumentVersions',
                'UpdateDocument',
                'UpdateDocumentVersion',
                'UpdateFolder',
                'UpdateInstanceAlias',
                'UpdateUser'
            ],
            Read: [
                'CheckAlias',
                'DownloadDocumentVersion',
                'GetCurrentUser',
                'GetDocument',
                'GetDocumentPath',
                'GetDocumentVersion',
                'GetFolder',
                'GetFolderPath',
                'GetGroup',
                'GetResources'
            ],
            List: [
                'DescribeActivities',
                'DescribeAvailableDirectories',
                'DescribeComments',
                'DescribeDocumentVersions',
                'DescribeFolderContents',
                'DescribeGroups',
                'DescribeInstances',
                'DescribeNotificationPermissions',
                'DescribeNotificationSubscriptions',
                'DescribeResourcePermissions',
                'DescribeRootFolders',
                'DescribeUsers'
            ]
        };
    }
    /**
     * Grants permission to abort the upload of the specified document version that was previously initiated by InitiateDocumentVersionUpload
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_AbortDocumentVersionUpload.html
     */
    toAbortDocumentVersionUpload() {
        return this.to('AbortDocumentVersionUpload');
    }
    /**
     * Grants permission to activate the specified user. Only active users can access Amazon WorkDocs
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_ActivateUser.html
     */
    toActivateUser() {
        return this.to('ActivateUser');
    }
    /**
     * Grants permission to add principals that are allowed to call notification subscription APIs for a given WorkDocs site
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/adminguide/manage-notifications.html
     */
    toAddNotificationPermissions() {
        return this.to('AddNotificationPermissions');
    }
    /**
     * Grants permission to create a set of permissions for the specified folder or document
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_AddResourcePermissions.html
     */
    toAddResourcePermissions() {
        return this.to('AddResourcePermissions');
    }
    /**
     * Grants permission to add a user to a group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/adminguide/manage_set_admin.html
     */
    toAddUserToGroup() {
        return this.to('AddUserToGroup');
    }
    /**
     * Grants permission to check an alias
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workdocs/latest/adminguide/cloud_quick_start.html
     */
    toCheckAlias() {
        return this.to('CheckAlias');
    }
    /**
     * Grants permission to add a new comment to the specified document version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_CreateComment.html
     */
    toCreateComment() {
        return this.to('CreateComment');
    }
    /**
     * Grants permission to add one or more custom properties to the specified resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_CreateCustomMetadata.html
     */
    toCreateCustomMetadata() {
        return this.to('CreateCustomMetadata');
    }
    /**
     * Grants permission to create a folder with the specified name and parent folder
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_CreateFolder.html
     */
    toCreateFolder() {
        return this.to('CreateFolder');
    }
    /**
     * Grants permission to create an instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/adminguide/getting_started.html
     */
    toCreateInstance() {
        return this.to('CreateInstance');
    }
    /**
     * Grants permission to add labels to the given resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_CreateLabels.html
     */
    toCreateLabels() {
        return this.to('CreateLabels');
    }
    /**
     * Grants permission to configure WorkDocs to use Amazon SNS notifications
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_CreateNotificationSubscription.html
     */
    toCreateNotificationSubscription() {
        return this.to('CreateNotificationSubscription');
    }
    /**
     * Grants permission to create a user in a Simple AD or Microsoft AD directory
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_CreateUser.html
     */
    toCreateUser() {
        return this.to('CreateUser');
    }
    /**
     * Grants permission to deactivate the specified user, which revokes the user's access to Amazon WorkDocs
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DeactivateUser.html
     */
    toDeactivateUser() {
        return this.to('DeactivateUser');
    }
    /**
     * Grants permission to delete the specified comment from the document version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DeleteComment.html
     */
    toDeleteComment() {
        return this.to('DeleteComment');
    }
    /**
     * Grants permission to delete custom metadata from the specified resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DeleteCustomMetadata.html
     */
    toDeleteCustomMetadata() {
        return this.to('DeleteCustomMetadata');
    }
    /**
     * Grants permission to permanently delete the specified document and its associated metadata
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DeleteDocument.html
     */
    toDeleteDocument() {
        return this.to('DeleteDocument');
    }
    /**
     * Grants permission to delete versions of a specified document
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DeleteDocumentVersion.html
     */
    toDeleteDocumentVersion() {
        return this.to('DeleteDocumentVersion');
    }
    /**
     * Grants permission to permanently delete the specified folder and its contents
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DeleteFolder.html
     */
    toDeleteFolder() {
        return this.to('DeleteFolder');
    }
    /**
     * Grants permission to delete the contents of the specified folder
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DeleteFolderContents.html
     */
    toDeleteFolderContents() {
        return this.to('DeleteFolderContents');
    }
    /**
     * Grants permission to delete an instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/adminguide/manage-sites.html#delete_site
     */
    toDeleteInstance() {
        return this.to('DeleteInstance');
    }
    /**
     * Grants permission to delete one or more labels from a resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DeleteLabels.html
     */
    toDeleteLabels() {
        return this.to('DeleteLabels');
    }
    /**
     * Grants permission to delete principals that are allowed to call notification subscription APIs for a given WorkDocs site
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/adminguide/manage-notifications.html
     */
    toDeleteNotificationPermissions() {
        return this.to('DeleteNotificationPermissions');
    }
    /**
     * Grants permission to delete the specified subscription from the specified organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DeleteNotificationSubscription.html
     */
    toDeleteNotificationSubscription() {
        return this.to('DeleteNotificationSubscription');
    }
    /**
     * Grants permission to delete the specified user from a Simple AD or Microsoft AD directory
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DeleteUser.html
     */
    toDeleteUser() {
        return this.to('DeleteUser');
    }
    /**
     * Grants permission to deregister a directory
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/adminguide/manage-sites.html#delete_site
     */
    toDeregisterDirectory() {
        return this.to('DeregisterDirectory');
    }
    /**
     * Grants permission to fetch user activities in a specified time period
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DescribeActivities.html
     */
    toDescribeActivities() {
        return this.to('DescribeActivities');
    }
    /**
     * Grants permission to describe available directories
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workdocs/latest/adminguide/getting_started.html
     */
    toDescribeAvailableDirectories() {
        return this.to('DescribeAvailableDirectories');
    }
    /**
     * Grants permission to list all the comments for the specified document version
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DescribeComments.html
     */
    toDescribeComments() {
        return this.to('DescribeComments');
    }
    /**
     * Grants permission to retrieve the document versions for the specified document
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DescribeDocumentVersions.html
     */
    toDescribeDocumentVersions() {
        return this.to('DescribeDocumentVersions');
    }
    /**
     * Grants permission to describe the contents of the specified folder, including its documents and sub-folders
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DescribeFolderContents.html
     */
    toDescribeFolderContents() {
        return this.to('DescribeFolderContents');
    }
    /**
     * Grants permission to describe the user groups
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DescribeGroups.html
     */
    toDescribeGroups() {
        return this.to('DescribeGroups');
    }
    /**
     * Grants permission to describe instances
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workdocs/latest/adminguide/getting_started.html
     */
    toDescribeInstances() {
        return this.to('DescribeInstances');
    }
    /**
     * Grants permission to describe principals that are allowed to call notification subscription APIs for a given WorkDocs site
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workdocs/latest/adminguide/manage-notifications.html
     */
    toDescribeNotificationPermissions() {
        return this.to('DescribeNotificationPermissions');
    }
    /**
     * Grants permission to list the specified notification subscriptions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DescribeNotificationSubscriptions.html
     */
    toDescribeNotificationSubscriptions() {
        return this.to('DescribeNotificationSubscriptions');
    }
    /**
     * Grants permission to view a description of a specified resource's permissions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DescribeResourcePermissions.html
     */
    toDescribeResourcePermissions() {
        return this.to('DescribeResourcePermissions');
    }
    /**
     * Grants permission to describe the root folders
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DescribeRootFolders.html
     */
    toDescribeRootFolders() {
        return this.to('DescribeRootFolders');
    }
    /**
     * Grants permission to view a description of the specified users. You can describe all users or filter the results (for example, by status or organization)
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DescribeUsers.html
     */
    toDescribeUsers() {
        return this.to('DescribeUsers');
    }
    /**
     * Grants permission to download a specified document version
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_GetDocumentVersion.html
     */
    toDownloadDocumentVersion() {
        return this.to('DownloadDocumentVersion');
    }
    /**
     * Grants permission to retrieve the details of the current user
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_GetCurrentUser.html
     */
    toGetCurrentUser() {
        return this.to('GetCurrentUser');
    }
    /**
     * Grants permission to retrieve the specified document object
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_GetDocument.html
     */
    toGetDocument() {
        return this.to('GetDocument');
    }
    /**
     * Grants permission to retrieve the path information (the hierarchy from the root folder) for the requested document
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_GetDocumentPath.html
     */
    toGetDocumentPath() {
        return this.to('GetDocumentPath');
    }
    /**
     * Grants permission to retrieve version metadata for the specified document
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_GetDocumentVersion.html
     */
    toGetDocumentVersion() {
        return this.to('GetDocumentVersion');
    }
    /**
     * Grants permission to retrieve the metadata of the specified folder
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_GetFolder.html
     */
    toGetFolder() {
        return this.to('GetFolder');
    }
    /**
     * Grants permission to retrieve the path information (the hierarchy from the root folder) for the specified folder
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_GetFolderPath.html
     */
    toGetFolderPath() {
        return this.to('GetFolderPath');
    }
    /**
     * Grants permission to retrieve details for the specified group
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_Operations.html
     */
    toGetGroup() {
        return this.to('GetGroup');
    }
    /**
     * Grants permission to get a collection of resources
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_GetResources.html
     */
    toGetResources() {
        return this.to('GetResources');
    }
    /**
     * Grants permission to create a new document object and version object
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_InitiateDocumentVersionUpload.html
     */
    toInitiateDocumentVersionUpload() {
        return this.to('InitiateDocumentVersionUpload');
    }
    /**
     * Grants permission to register a directory
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/adminguide/existing-dir-setup.html
     */
    toRegisterDirectory() {
        return this.to('RegisterDirectory');
    }
    /**
     * Grants permission to remove all the permissions from the specified resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_RemoveAllResourcePermissions.html
     */
    toRemoveAllResourcePermissions() {
        return this.to('RemoveAllResourcePermissions');
    }
    /**
     * Grants permission to remove the permission for the specified principal from the specified resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_RemoveResourcePermission.html
     */
    toRemoveResourcePermission() {
        return this.to('RemoveResourcePermission');
    }
    /**
     * Grants permission to restore versions of a specified document
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_RestoreDocumentVersions.html
     */
    toRestoreDocumentVersions() {
        return this.to('RestoreDocumentVersions');
    }
    /**
     * Grants permission to update the specified attributes of the specified document
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_UpdateDocument.html
     */
    toUpdateDocument() {
        return this.to('UpdateDocument');
    }
    /**
     * Grants permission to change the status of the document version to ACTIVE
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_UpdateDocumentVersion.html
     */
    toUpdateDocumentVersion() {
        return this.to('UpdateDocumentVersion');
    }
    /**
     * Grants permission to update the specified attributes of the specified folder
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_UpdateFolder.html
     */
    toUpdateFolder() {
        return this.to('UpdateFolder');
    }
    /**
     * Grants permission to update an instance alias
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/adminguide/getting_started.html
     */
    toUpdateInstanceAlias() {
        return this.to('UpdateInstanceAlias');
    }
    /**
     * Grants permission to update the specified attributes of the specified user, and grants or revokes administrative privileges to the Amazon WorkDocs site
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_UpdateUser.html
     */
    toUpdateUser() {
        return this.to('UpdateUser');
    }
}
exports.Workdocs = Workdocs;
_a = JSII_RTTI_SYMBOL_1;
Workdocs[_a] = { fqn: "iam-floyd.Workdocs", version: "0.491.0" };
//# sourceMappingURL=data:application/json;base64,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