from pathlib import Path

from assertpy import assert_that, contents_of
from iseq_prof import fasta, filedb
from numpy.random import RandomState


def test_fasta_downsample(tmp_path: Path):
    acc = "AE014075.1"
    infasta = filedb.get(f"{acc}_cds_nucl.fasta")

    random = RandomState(34)
    outfasta = tmp_path / "downsample.fasta"
    fasta.downsample(infasta, outfasta, 2, random)

    downsample_content = """>AE014075.1:190-252|dna Escherichia coli CFT073, complete genome
ATGAAACGCATTAGCACCACCATTACCACCACCATCACCATTACCACAGGTAACGGTGCG
GGC
>AE014075.1:9921-10508|dna Escherichia coli CFT073, complete genome
TTGATGAATACTTTACGTATTGGCTTAGTTTCCATCTCTGATCGCGCATCCAGCGGCGTT
TATCAGGATAAAGGCATCCCTGCGCTGGAAGAATGGCTGACATCGGCGCTAACCACGCCG
TTTGAACTGGAAACCCGCTTAATCCCCGATGAGCAGGCGATCATCGAGCAAACGTTGTGT
GAGCTGGTGGATGAAATGAGTTGCCATCTGGTGCTCACCACGGGCGGAACTGGCCCGGCG
CGTCGTGACGTAACGCCCGATGCGACGCTGGCAGTAGCGGACCGCGAGATGCCAGGCTTT
GGTGAACAGATGCGCCAGATCAGCCTGCATTTTGTACCAACTGCGATCCTTTCGCGTCAG
GTGGGGGTGATTCGCAAACAGGCGCTGATCCTTAACTTACCCGGTCAACCGAAGTCTATT
AAAGAGACGCTGGAAGGTGTGAAGGACGCTGAGGGTAACGTTGTGGTGCACGGTATTTTT
GCCAGCGTACCGTACTGCATTCAGTTGCTGGAAGGGCCATACGTTGAAACGGCACCGGAA
GTGGTTGCAGCATTCAGACCGAAGAGTGCAAGACGCGAAGTTAGCGAA
"""

    assert_that(contents_of(outfasta)).is_equal_to(downsample_content)
