from avatar2.installer.config import AvatarConfig

class Architecture(object):
    
    @staticmethod 
    def _resolve_executable(exec_name):
        """
        Resolves the name of the executable for the endpoint, using the config
        file generated by avatar2's installer
        Convienently enough, this config already checks whether the executable
        is installed on the system
        """
        target_path = AvatarConfig().get_target_path(exec_name)
        if target_path is None:
            raise Exception(("Couldn't find executable for %s\n"
                             "Have you tried running the avatar2-installer "
                             "(python -m avatar2.installer)?" % exec_name))
        return target_path

    @staticmethod
    def resolve(exec_name):
        """
        This wrapper around _resolve_executable allows us to have targets
        only resolved when needed, and not when the arch-class gets imported
        """
        return staticmethod(lambda : Architecture._resolve_executable(exec_name))



    @staticmethod
    def init(avatar):
        pass
    
    registers = None
    special_registers = {}
    sr_name = None
