# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class GetDatabaseClusterResult:
    """
    A collection of values returned by getDatabaseCluster.
    """
    def __init__(__self__, database=None, engine=None, host=None, id=None, maintenance_windows=None, name=None, node_count=None, password=None, port=None, private_host=None, private_network_uuid=None, private_uri=None, region=None, size=None, tags=None, uri=None, urn=None, user=None, version=None):
        if database and not isinstance(database, str):
            raise TypeError("Expected argument 'database' to be a str")
        __self__.database = database
        """
        Name of the cluster's default database.
        """
        if engine and not isinstance(engine, str):
            raise TypeError("Expected argument 'engine' to be a str")
        __self__.engine = engine
        """
        Database engine used by the cluster (ex. `pg` for PostreSQL).
        """
        if host and not isinstance(host, str):
            raise TypeError("Expected argument 'host' to be a str")
        __self__.host = host
        """
        Database cluster's hostname.
        """
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        __self__.id = id
        """
        id is the provider-assigned unique ID for this managed resource.
        """
        if maintenance_windows and not isinstance(maintenance_windows, list):
            raise TypeError("Expected argument 'maintenance_windows' to be a list")
        __self__.maintenance_windows = maintenance_windows
        """
        Defines when the automatic maintenance should be performed for the database cluster.
        """
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        __self__.name = name
        if node_count and not isinstance(node_count, float):
            raise TypeError("Expected argument 'node_count' to be a float")
        __self__.node_count = node_count
        """
        Number of nodes that will be included in the cluster.
        """
        if password and not isinstance(password, str):
            raise TypeError("Expected argument 'password' to be a str")
        __self__.password = password
        """
        Password for the cluster's default user.
        """
        if port and not isinstance(port, float):
            raise TypeError("Expected argument 'port' to be a float")
        __self__.port = port
        """
        Network port that the database cluster is listening on.
        """
        if private_host and not isinstance(private_host, str):
            raise TypeError("Expected argument 'private_host' to be a str")
        __self__.private_host = private_host
        """
        Same as `host`, but only accessible from resources within the account and in the same region.
        """
        if private_network_uuid and not isinstance(private_network_uuid, str):
            raise TypeError("Expected argument 'private_network_uuid' to be a str")
        __self__.private_network_uuid = private_network_uuid
        """
        The ID of the VPC where the database cluster is located.
        """
        if private_uri and not isinstance(private_uri, str):
            raise TypeError("Expected argument 'private_uri' to be a str")
        __self__.private_uri = private_uri
        """
        Same as `uri`, but only accessible from resources within the account and in the same region.
        """
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        __self__.region = region
        """
        DigitalOcean region where the cluster will reside.
        """
        if size and not isinstance(size, str):
            raise TypeError("Expected argument 'size' to be a str")
        __self__.size = size
        """
        Database droplet size associated with the cluster (ex. `db-s-1vcpu-1gb`).
        """
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        __self__.tags = tags
        if uri and not isinstance(uri, str):
            raise TypeError("Expected argument 'uri' to be a str")
        __self__.uri = uri
        """
        The full URI for connecting to the database cluster.
        """
        if urn and not isinstance(urn, str):
            raise TypeError("Expected argument 'urn' to be a str")
        __self__.urn = urn
        """
        The uniform resource name of the database cluster.
        """
        if user and not isinstance(user, str):
            raise TypeError("Expected argument 'user' to be a str")
        __self__.user = user
        """
        Username for the cluster's default user.
        """
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        __self__.version = version
        """
        Engine version used by the cluster (ex. `11` for PostgreSQL 11).
        """
class AwaitableGetDatabaseClusterResult(GetDatabaseClusterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDatabaseClusterResult(
            database=self.database,
            engine=self.engine,
            host=self.host,
            id=self.id,
            maintenance_windows=self.maintenance_windows,
            name=self.name,
            node_count=self.node_count,
            password=self.password,
            port=self.port,
            private_host=self.private_host,
            private_network_uuid=self.private_network_uuid,
            private_uri=self.private_uri,
            region=self.region,
            size=self.size,
            tags=self.tags,
            uri=self.uri,
            urn=self.urn,
            user=self.user,
            version=self.version)

def get_database_cluster(name=None,tags=None,opts=None):
    """
    Provides information on a DigitalOcean database cluster resource.




    :param str name: The name of the database cluster.
    """
    __args__ = dict()


    __args__['name'] = name
    __args__['tags'] = tags
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = utilities.get_version()
    __ret__ = pulumi.runtime.invoke('digitalocean:index/getDatabaseCluster:getDatabaseCluster', __args__, opts=opts).value

    return AwaitableGetDatabaseClusterResult(
        database=__ret__.get('database'),
        engine=__ret__.get('engine'),
        host=__ret__.get('host'),
        id=__ret__.get('id'),
        maintenance_windows=__ret__.get('maintenanceWindows'),
        name=__ret__.get('name'),
        node_count=__ret__.get('nodeCount'),
        password=__ret__.get('password'),
        port=__ret__.get('port'),
        private_host=__ret__.get('privateHost'),
        private_network_uuid=__ret__.get('privateNetworkUuid'),
        private_uri=__ret__.get('privateUri'),
        region=__ret__.get('region'),
        size=__ret__.get('size'),
        tags=__ret__.get('tags'),
        uri=__ret__.get('uri'),
        urn=__ret__.get('urn'),
        user=__ret__.get('user'),
        version=__ret__.get('version'))
