# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['geoip2_extras']

package_data = \
{'': ['*']}

install_requires = \
['django>=2.2,<4.0', 'geoip2>=3.0.0,<4.0.0']

setup_kwargs = {
    'name': 'django-geoip2-extras',
    'version': '2.0.1',
    'description': 'Additional functionality using the GeoIP2 database.',
    'long_description': '# Django GeoIP2 Extras\n\nUseful extras based on the `django.contrib.gis.geoip2` module, using\nthe [MaxMind GeoIP2 Lite](http://dev.maxmind.com/geoip/geoip2/geolite2/) database.\n\nThe first feature in this package is a Django middleware class that can\nbe used to add city, country level information to inbound requests.\n\n## Requirements\n\nThis package requires Django 2.2 or above, and Python 3.7 or above.\n\nThis package wraps the existing Django functionality, and as a result\nrelies on the same underlying requirements:\n\n    In order to perform IP-based geolocation, the GeoIP2 object\n    requires the geoip2 Python library and the GeoIP Country and/or City\n    datasets in binary format (the CSV files will not work!). Grab the\n    GeoLite2-Country.mmdb.gz and GeoLite2-City.mmdb.gz files and unzip\n    them in a directory corresponding to the GEOIP_PATH setting.\n\nNB The MaxMind database is not included with this package. It is your\nresponsiblity to download this and include it as part of your project.\n\n## Installation\n\nThis package can be installed from PyPI as `django-geoip2-extras`:\n\n```\n$ pip install django-geoip2-extras\n```\n\nIf you want to add the country-level information to incoming requests,\nadd the middleware to your project settings.\n\n```python\n# settings.py\nMIDDLEWARE = (\n    ...,\n    \'geoip2_extras.middleware.GeoIP2Middleware\',\n)\n```\n\nThe middleware will not be active unless you add a setting for the\ndefault `GEOIP_PATH` - this is the default Django GeoIP2 behaviour:\n\n```python\n# settings.py\nGEOIP_PATH = os.path.dirname(__file__)\n```\n\nYou must also configure a cache called `geoip2-extras`:\n\n```python\n# settings\nCACHES = {\n    "default": { ... },\n    "geoip2-extras": { ... },\n    ...\n}\n```\n\nTip: see `/demo/settings.py` for a full working example.\n\n### Settings\n\nThe following settings can be overridden in `django.conf.settings`.\n\n* `GEOIP2_EXTRAS_CACHE_TIMEOUT`\n\nTime to cache IP <> address data in seconds - default to 1hr (3600s)\n\n* `GEOIP2_EXTRAS_ADD_RESPONSE_HEADERS`\n\nSet to True to write out the GeoIP data to the response headers. Defaults to use\nthe `DEBUG` value. This value can be overridden on a per-request basis by adding\nthe `X-GeoIP2-Debug` request header, or adding `geoip2=1` to the request\nquerystring. This is useful for debugging in a production environment where you\nmay not be adding the response headers by default.\n\n## Usage\n\nOnce the middleware is added, you will be able to access City and / or\nCountry level information on the request object via the `geo_data` dict:\n\n```python\n>>> request.geo_data\n{\n    "city": ""\n    "continent-code": "NA"\n    "continent-name": "North America"\n    "country-code": "US"\n    "country-name": "United States"\n    "dma-code": ""\n    "is-in-european-union": False\n    "latitude": 37.751\n    "longitude": -97.822\n    "postal-code": ""\n    "region": ""\n    "time-zone": "America/Chicago"\n    "remote-addr": "142.250.180.3"\n}\n```\n\nThe same information will be added to the HttpResponse headers if\n`GEOIP2_EXTRAS_ADD_RESPONSE_HEADERS` is True. Values are set using the\n`X-GeoIP2-` prefix.\n\nNB blank (`""`) values are **not** added to the response:\n\n```shell\n# use the google.co.uk IP\n$ curl -I -H "x-forwarded-for: 142.250.180.3" localhost:8000\nHTTP/1.1 200 OK\nDate: Sun, 29 Aug 2021 15:47:22 GMT\nServer: WSGIServer/0.2 CPython/3.9.4\nContent-Type: text/html\nX-GeoIP2-Continent-Code: NA\nX-GeoIP2-Continent-Name: North America\nX-GeoIP2-Country-Code: US\nX-GeoIP2-Country-Name: United States\nX-GeoIP2-Is-In-European-Union: False\nX-GeoIP2-Latitude: 37.751\nX-GeoIP2-Longitude: -97.822\nX-GeoIP2-Time-Zone: America/Chicago\nX-GeoIP2-Remote-Addr: 142.250.180.3\nContent-Length: 10697\n```\n\nIf the IP address cannot be found (e.g. \'127.0.0.1\'), then a default\n\'unknown\' country is used, with a code of \'XX\'.\n\n```shell\n$ curl -I -H "x-forwarded-for: 127.0.0.1" localhost:8000\nHTTP/1.1 200 OK\nDate: Sun, 29 Aug 2021 15:47:22 GMT\nServer: WSGIServer/0.2 CPython/3.9.4\nContent-Type: text/html\nX-GeoIP2-Country-Code: XX\nX-GeoIP2-Country-Name: unknown\nX-GeoIP2-Remote-Addr: 127.0.0.1\nContent-Length: 10697\n```\n\n## Tests\n\nThe project tests are run through `pytest`.\n',
    'author': 'YunoJuno',
    'author_email': 'code@yunojuno.com',
    'maintainer': 'YunoJuno',
    'maintainer_email': 'code@yunojuno.com',
    'url': 'https://github.com/yunojuno/django-geoip2-extras',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
