# Generated by Django 4.0 on 2022-09-15 13:55

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import settings_app.upload_utils


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('custom', '0001_initial'),
        ('auth', '0012_alter_user_first_name_max_length'),
        ('employee', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='BasicSalary',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('amount', models.DecimalField(blank=True, decimal_places=2, max_digits=5, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Category',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100)),
            ],
        ),
        migrations.CreateModel(
            name='Contract',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_active', models.BooleanField(default=True)),
                ('is_lock', models.BooleanField(default=False, null=True)),
                ('start_date', models.DateField(blank=True, null=True)),
                ('end_date', models.DateField(blank=True, null=True)),
                ('terminate_date', models.DateField(blank=True, null=True)),
                ('file', models.FileField(blank=True, null=True, upload_to=settings_app.upload_utils.upload_contract, validators=[django.core.validators.FileExtensionValidator(allowed_extensions=['pdf'])], verbose_name='Attach Dispatch')),
                ('disp_number', models.CharField(blank=True, max_length=50, null=True, verbose_name='Dispatch Number')),
                ('hashed', models.CharField(max_length=32, null=True)),
                ('category', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract', to='contract.category', verbose_name='RJS')),
            ],
        ),
        migrations.CreateModel(
            name='ContractType',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100)),
            ],
        ),
        migrations.CreateModel(
            name='PositionSalary',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('amount', models.DecimalField(blank=True, decimal_places=2, max_digits=7, null=True)),
                ('position', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='positionsalary', to='custom.position')),
            ],
        ),
        migrations.CreateModel(
            name='EmpSalary',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('transport', models.DecimalField(blank=True, decimal_places=2, max_digits=5, null=True)),
                ('total', models.DecimalField(blank=True, decimal_places=2, max_digits=7, null=True)),
                ('is_active', models.BooleanField(default=True)),
                ('is_lock', models.BooleanField(default=True, null=True)),
                ('datetime', models.DateTimeField(null=True)),
                ('hashed', models.CharField(max_length=32, null=True)),
                ('basic_salary', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='empsalary', to='contract.basicsalary')),
                ('contract', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='empsalary', to='contract.contract')),
                ('employee', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='empsalary', to='employee.employee')),
                ('position', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='empsalary', to='custom.position')),
                ('position_salary', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='empsalary', to='contract.positionsalary')),
                ('user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='auth.user')),
            ],
        ),
        migrations.CreateModel(
            name='EmpPlacement',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('start_date', models.DateField(blank=True, null=True)),
                ('end_date', models.DateField(blank=True, null=True)),
                ('end_reason', models.CharField(blank=True, max_length=200, null=True)),
                ('is_active', models.BooleanField(default=True)),
                ('is_confirm', models.BooleanField(default=False, null=True)),
                ('file', models.FileField(blank=True, null=True, upload_to=settings_app.upload_utils.upload_place, validators=[django.core.validators.FileExtensionValidator(allowed_extensions=['pdf'])], verbose_name='Attach Dispatch')),
                ('disp_number', models.CharField(blank=True, max_length=50, null=True, verbose_name='Dispatch Number')),
                ('datetime', models.DateTimeField(null=True)),
                ('hashed', models.CharField(max_length=32, null=True)),
                ('de', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='placement', to='custom.de')),
                ('employee', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='placement', to='employee.employee')),
                ('position', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='placement', to='custom.position')),
                ('section', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='placement', to='custom.section')),
                ('unit', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='placement', to='custom.unit')),
                ('user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='auth.user')),
            ],
        ),
        migrations.AddField(
            model_name='contract',
            name='contract_type',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract', to='contract.contracttype', verbose_name='RJS'),
        ),
        migrations.AddField(
            model_name='contract',
            name='de',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract', to='custom.de', verbose_name='ED/Deputy'),
        ),
        migrations.AddField(
            model_name='contract',
            name='employee',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='contract', to='employee.employee'),
        ),
        migrations.AddField(
            model_name='contract',
            name='position',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract', to='custom.position'),
        ),
        migrations.AddField(
            model_name='contract',
            name='section',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract', to='custom.section'),
        ),
        migrations.AddField(
            model_name='contract',
            name='unit',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract', to='custom.unit'),
        ),
        migrations.AddField(
            model_name='contract',
            name='user',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='auth.user'),
        ),
        migrations.AddField(
            model_name='basicsalary',
            name='category',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='basicsalary', to='contract.category'),
        ),
    ]
