from tests.test_all import (
    test_function,
    test_dependencies
)

from tests.data.geolayers import (
    geolayer_fr_dept_data_only,
    geolayer_fr_dept_data_and_geometry,
)

from tests.data.fields_metadata import geolayer_data_fields_metadata_complete

from geoformat_lib.conversion.feature_conversion import feature_serialize

from geoformat_lib.conversion.geolayer_conversion import (
    create_geolayer_from_i_feat_list,
    reproject_geolayer,
)

create_geolayer_from_i_feat_list_parameters = {
    0: {
        "geolayer": geolayer_fr_dept_data_only,
        "i_feat_list": 0,
        "serialize": False,
        "reset_i_feat": True,
        "return_value": {
            "metadata": {
                "fields": geolayer_data_fields_metadata_complete,
                "name": "FRANCE_DPT_GENERALIZE_LAMB93_ROUND_DATA_ONLY",
            },
            "features": {0: {"attributes": {"CODE_DEPT": "32", "NOM_DEPT": "GERS"}}},
        },
    },
    1: {
        "geolayer": geolayer_fr_dept_data_only,
        "i_feat_list": [0],
        "serialize": False,
        "reset_i_feat": True,
        "return_value": {
            "metadata": {
                "fields": geolayer_data_fields_metadata_complete,
                "name": "FRANCE_DPT_GENERALIZE_LAMB93_ROUND_DATA_ONLY",
            },
            "features": {0: {"attributes": {"CODE_DEPT": "32", "NOM_DEPT": "GERS"}}},
        },
    },
    2: {
        "geolayer": geolayer_fr_dept_data_only,
        "i_feat_list": [0, 95],
        "serialize": False,
        "reset_i_feat": True,
        "return_value": {
            "metadata": {
                "fields": geolayer_data_fields_metadata_complete,
                "name": "FRANCE_DPT_GENERALIZE_LAMB93_ROUND_DATA_ONLY",
            },
            "features": {
                0: {"attributes": {"CODE_DEPT": "32", "NOM_DEPT": "GERS"}},
                1: {"attributes": {"CODE_DEPT": "93", "NOM_DEPT": "SEINE-SAINT-DENIS"}},
            },
        },
    },
    3: {
        "geolayer": geolayer_fr_dept_data_only,
        "i_feat_list": [0, 95],
        "serialize": False,
        "reset_i_feat": False,
        "return_value": {
            "metadata": {
                "fields": geolayer_data_fields_metadata_complete,
                "name": "FRANCE_DPT_GENERALIZE_LAMB93_ROUND_DATA_ONLY",
            },
            "features": {
                0: {"attributes": {"CODE_DEPT": "32", "NOM_DEPT": "GERS"}},
                95: {
                    "attributes": {"CODE_DEPT": "93", "NOM_DEPT": "SEINE-SAINT-DENIS"}
                },
            },
        },
    },
    4: {
        "geolayer": geolayer_fr_dept_data_only,
        "i_feat_list": [0, 95],
        "serialize": True,
        "reset_i_feat": False,
        "return_value": {
            "metadata": {
                "fields": geolayer_data_fields_metadata_complete,
                "name": "FRANCE_DPT_GENERALIZE_LAMB93_ROUND_DATA_ONLY",
            },
            "features": {
                0: feature_serialize(
                    {"attributes": {"CODE_DEPT": "32", "NOM_DEPT": "GERS"}}
                ),
                95: feature_serialize(
                    {"attributes": {"CODE_DEPT": "93", "NOM_DEPT": "SEINE-SAINT-DENIS"}}
                ),
            },
        },
    },
}

reproject_geolayer_parameters = {
    0: {
        "geolayer": geolayer_fr_dept_data_and_geometry,
        "out_crs": 4326,
        "in_crs": None,
        "bbox": True,
        "return_value": {
            "metadata": {
                "name": "FRANCE_DPT_GENERALIZE_LAMB93_ROUND_DATA_AND_GEOMETRY",
                "fields": {
                    "CODE_DEPT": {"type": "String", "width": 2, "index": 0},
                    "NOM_DEPT": {"type": "String", "width": 23, "index": 1},
                },
                "geometry_ref": {
                    "type": {"Polygon", "MultiPolygon"},
                    "crs": 4326,
                    "extent": (
                        41.368214489339856,
                        -4.793344007924674,
                        51.08854281218866,
                        9.558834031337039,
                    ),
                },
            },
            "features": {
                0: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            43.31088599158549,
                            -0.2428365587430673,
                            44.078227249212006,
                            1.2013370084855526,
                        ),
                        "coordinates": [
                            [
                                [43.31088599158549, 0.6068109749570955],
                                [43.31720926544647, 0.6559378827169783],
                                [43.376630810082574, 0.7175914463388223],
                                [43.416975022578875, 0.8205416805525506],
                                [43.4063326892777, 0.917251134513719],
                                [43.3626517065442, 0.9780837577086208],
                                [43.473338092390065, 1.0181843408377866],
                                [43.59481295502015, 1.2013370084855526],
                                [43.634175893375954, 1.1475492440427302],
                                [43.64497503168885, 1.0876957388199553],
                                [43.78737246570886, 0.9539831166064945],
                                [43.78433052070778, 0.906155770674725],
                                [43.864698458132736, 0.8994393128667493],
                                [43.923289163046476, 0.8628924476067087],
                                [43.94224249346573, 0.7600848328151357],
                                [44.040785422701155, 0.8604173969632192],
                                [44.03591070642859, 0.7757831291372458],
                                [44.06519923501576, 0.7418847912050011],
                                [44.025145965594625, 0.6665917738469163],
                                [44.078227249212006, 0.5979775801101926],
                                [44.053722419531994, 0.5390309523710256],
                                [44.055237448974, 0.4595156323439901],
                                [44.0287619833259, 0.44244991475496326],
                                [43.993057181274324, 0.30409006822726914],
                                [44.0146417100197, 0.18957513112649643],
                                [43.98314313658292, 0.07604560969926086],
                                [43.916471143129584, 0.07664688901341983],
                                [43.90018804605384, 0.032556764180923806],
                                [43.94504687607565, -0.07359844651969412],
                                [43.93791976442837, -0.1791090595179048],
                                [43.891067750109656, -0.23393876198190033],
                                [43.875183336159544, -0.19099217321599574],
                                [43.73701668569468, -0.19414330237234037],
                                [43.71408748429112, -0.23258236946731775],
                                [43.58497620901365, -0.2428365587430673],
                                [43.596404001570654, -0.17641328064610742],
                                [43.5824058976317, -0.0967829732087753],
                                [43.60465738319822, -0.015780894995831136],
                                [43.56554046143868, -0.0019248187812953763],
                                [43.5188072498529, 0.056081443916197675],
                                [43.517369919818584, 0.11212423457670333],
                                [43.43291627195161, 0.13798238183895667],
                                [43.37118267445077, 0.1820312140000635],
                                [43.385790922905464, 0.2772545000281133],
                                [43.32618057240136, 0.4980338187920962],
                                [43.31088599158549, 0.6068109749570955],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "32", "NOM_DEPT": "GERS"},
                },
                1: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            43.98314313658292,
                            -0.1406884798527587,
                            44.762284673952365,
                            1.0751408247250978,
                        ),
                        "coordinates": [
                            [
                                [44.577324783565565, 1.0751408247250978],
                                [44.64361045554161, 0.9791284687246183],
                                [44.59730727091491, 0.8699961633461994],
                                [44.627001476439105, 0.8170042739845019],
                                [44.69188957907682, 0.8270009642517763],
                                [44.67784707846914, 0.6574344166312163],
                                [44.70652766853691, 0.6304884773468264],
                                [44.64633711715288, 0.41470651574900513],
                                [44.66221103663619, 0.36557538473802004],
                                [44.73743575883074, 0.3354490861907089],
                                [44.762284673952365, 0.2973255098237856],
                                [44.730481039785595, 0.15300384600841968],
                                [44.682444103785436, 0.13372640074632025],
                                [44.661072124006985, 0.182677659153478],
                                [44.61612295595807, 0.15360786253340622],
                                [44.55304661779892, 0.04056782018280631],
                                [44.50506278713605, -0.015453699893016915],
                                [44.418543403742476, -0.01055239618525492],
                                [44.38987879184508, 0.018233646559888256],
                                [44.33761004988665, -0.08575207965013022],
                                [44.2967257980246, -0.034811250980738874],
                                [44.246757992226044, -0.06662475964814332],
                                [44.226404747689884, -0.1406884798527587],
                                [44.15240992875157, -0.12915451548994528],
                                [44.14999595086847, -0.004232390832892187],
                                [44.13065240342956, 0.03459384382220977],
                                [44.12422070347952, 0.13510828700872374],
                                [44.08677044166998, 0.10082062971801448],
                                [44.00084249917964, 0.06269801329290979],
                                [43.98314313658292, 0.07604560969926086],
                                [44.0146417100197, 0.18957513112649643],
                                [43.993057181274324, 0.30409006822726914],
                                [44.0287619833259, 0.44244991475496326],
                                [44.055237448974, 0.4595156323439901],
                                [44.053722419531994, 0.5390309523710256],
                                [44.078227249212006, 0.5979775801101926],
                                [44.025145965594625, 0.6665917738469163],
                                [44.06519923501576, 0.7418847912050011],
                                [44.10226981270581, 0.7528835731451475],
                                [44.12632969467469, 0.86877365550795],
                                [44.23827002933658, 0.9190898187097757],
                                [44.27644247710553, 0.9499239562135766],
                                [44.32330810855775, 0.8734701152053458],
                                [44.36637485759438, 0.8873307771559802],
                                [44.36263857861528, 1.049803151007228],
                                [44.378513265035394, 1.0640838318649108],
                                [44.480041109061666, 1.0090253989657332],
                                [44.53612714227498, 1.0131666459229496],
                                [44.577324783565565, 1.0751408247250978],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "47", "NOM_DEPT": "LOT-ET-GARONNE"},
                },
                2: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            44.6960702841541,
                            4.755996992712003,
                            45.88327273564142,
                            6.3588400606704845,
                        ),
                        "coordinates": [
                            [
                                [45.29836066114294, 4.800493926884063],
                                [45.297454009351384, 4.880237763487565],
                                [45.344046640836105, 4.989191483458711],
                                [45.31905467974735, 5.05431872757624],
                                [45.248335918090646, 5.121425532367966],
                                [45.2484020449113, 5.176540876984406],
                                [45.17126853879258, 5.188573507748233],
                                [45.08331022009428, 5.1793846576859695],
                                [45.03613916354606, 5.388382939418146],
                                [45.07078365917332, 5.449788835244157],
                                [45.02278614732907, 5.483609211781887],
                                [44.922290598248225, 5.483647138020397],
                                [44.79242749679306, 5.4641587549688655],
                                [44.75246442874924, 5.62708487257189],
                                [44.6960702841541, 5.759044078047863],
                                [44.70677851287, 5.801469996094522],
                                [44.75074454418582, 5.850398663313628],
                                [44.754705804536066, 5.915233300411789],
                                [44.80453012289716, 5.94951924784745],
                                [44.83809609775419, 6.030210546238998],
                                [44.815908261733654, 6.056342958572753],
                                [44.86407279122649, 6.136224190737252],
                                [44.85265497741959, 6.25054409332542],
                                [44.87325988167463, 6.302846745398276],
                                [44.854778989917435, 6.355361452664249],
                                [44.94128447146301, 6.3588400606704845],
                                [45.003856776770675, 6.3181981975765975],
                                [45.01246916508484, 6.203927022398643],
                                [45.108750055807405, 6.229388123209472],
                                [45.126847913866314, 6.260566197557926],
                                [45.163732283278, 6.189207693158914],
                                [45.244270268835876, 6.125696481423487],
                                [45.288287215984546, 6.131944929909638],
                                [45.317948507606715, 6.184450320779225],
                                [45.39316148783123, 6.177450938299202],
                                [45.438897845399275, 6.121272339213556],
                                [45.43791952965108, 6.049753851710852],
                                [45.4923087213814, 5.966169653050879],
                                [45.406796712103805, 5.879738401559338],
                                [45.44065533936712, 5.782081150720109],
                                [45.47254042424705, 5.736372335642621],
                                [45.613268326764185, 5.623748035268078],
                                [45.71359345746489, 5.5455415978088505],
                                [45.80712379566377, 5.42264142008713],
                                [45.8310937764943, 5.434944676804955],
                                [45.88327273564142, 5.3538271958050325],
                                [45.85493340191009, 5.309169396437734],
                                [45.78936901099018, 5.266894883868229],
                                [45.77168800093879, 5.191532760208243],
                                [45.81337808264366, 5.101067478338777],
                                [45.73945335950924, 5.094526879742294],
                                [45.70770885564475, 5.131048366350085],
                                [45.63720294798378, 5.035148740524161],
                                [45.60626780465844, 4.901457719834113],
                                [45.5723005698916, 4.808696981728118],
                                [45.5234402120416, 4.868481734036511],
                                [45.45570734978023, 4.756935570818616],
                                [45.36567226076599, 4.755996992712003],
                                [45.29836066114294, 4.800493926884063],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "38", "NOM_DEPT": "ISERE"},
                },
                3: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            50.04217932424791,
                            1.5577890976332025,
                            51.006505154665284,
                            3.173376482382538,
                        ),
                        "coordinates": [
                            [
                                [51.006505154665284, 2.067712027611001],
                                [50.984084640724895, 1.915776261224723],
                                [50.937891615577456, 1.7288531641107558],
                                [50.89013244896873, 1.6640946642444194],
                                [50.86734568892891, 1.5806383872468284],
                                [50.79187042766536, 1.604213474027494],
                                [50.69967640419992, 1.5607115203796038],
                                [50.5373524567793, 1.5854134517805314],
                                [50.40471793675981, 1.5577890976332025],
                                [50.35215320244089, 1.641543920995599],
                                [50.33101039989745, 1.670715509846568],
                                [50.36186618072208, 1.7787842601942672],
                                [50.31177877534883, 1.9180007470953697],
                                [50.287428042736344, 1.9461316429136999],
                                [50.24882125974279, 2.0778202954555876],
                                [50.20554490563295, 2.0957483707167426],
                                [50.226839899619605, 2.2738282654200974],
                                [50.20977035832257, 2.370204907638782],
                                [50.23030237700429, 2.4517852065078483],
                                [50.194562024118035, 2.4956903275727766],
                                [50.1554848214444, 2.3897770566865675],
                                [50.10064240686793, 2.4145079258525888],
                                [50.136999469996475, 2.4766865519087604],
                                [50.141605436861035, 2.551329915710551],
                                [50.11341281005765, 2.576019813733672],
                                [50.07739311900277, 2.857843650412817],
                                [50.04217932424791, 2.87653264314694],
                                [50.05374055513492, 3.090253620620082],
                                [50.12420173433414, 3.0957569207512843],
                                [50.183715151473976, 3.1561320895920617],
                                [50.24110767125754, 3.173376482382538],
                                [50.379846956513916, 2.993078464231492],
                                [50.4416400980408, 3.037672306035308],
                                [50.48176905740127, 3.0207925423124586],
                                [50.512778020799246, 2.9647097377674005],
                                [50.501557815660604, 2.8989518584324676],
                                [50.52538845142136, 2.8259824668620874],
                                [50.6032712281948, 2.8051660601438893],
                                [50.65656635139436, 2.8404494526472543],
                                [50.663678139297865, 2.7690409100193936],
                                [50.63129225354633, 2.713850503520111],
                                [50.617951505356416, 2.630516060197486],
                                [50.631244941936494, 2.495948921017839],
                                [50.672765602799466, 2.40779242678447],
                                [50.74090632543495, 2.34089102647672],
                                [50.81054861626229, 2.2134304216785434],
                                [50.883452469254024, 2.18390456104644],
                                [50.998427200370195, 2.097600537080802],
                                [51.006505154665284, 2.067712027611001],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "62", "NOM_DEPT": "PAS-DE-CALAIS"},
                },
                4: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            49.235656063432884,
                            4.031390794494156,
                            50.1607314288971,
                            5.393536658328508,
                        ),
                        "coordinates": [
                            [
                                [49.405642294757534, 4.047972977986833],
                                [49.40418703243856, 4.143169752612987],
                                [49.38225617648581, 4.24830818454738],
                                [49.32779732810991, 4.306756525620349],
                                [49.28064492915537, 4.422583188651028],
                                [49.296651189312385, 4.575868215345435],
                                [49.235656063432884, 4.625104107270341],
                                [49.256759043801544, 4.686074799511886],
                                [49.23576093816036, 4.826941205469512],
                                [49.25907433894352, 4.8942062202820455],
                                [49.23686584630137, 4.950989232683009],
                                [49.27405171210352, 5.051180998120573],
                                [49.335913874705334, 5.026436999727152],
                                [49.421924473125145, 5.1158969719764285],
                                [49.4991534717053, 5.062396105126222],
                                [49.59307211738767, 5.118278729173794],
                                [49.563534256220265, 5.162975033383016],
                                [49.55928995633117, 5.311756637860767],
                                [49.61708773850276, 5.393536658328508],
                                [49.63085901368822, 5.350332008544783],
                                [49.69607357001345, 5.26917913122673],
                                [49.6929164776751, 5.166194556636604],
                                [49.76373048634974, 5.093503384949336],
                                [49.76192871159604, 5.063182643598133],
                                [49.820795061082386, 4.873874799688422],
                                [49.864787135293696, 4.854192609787469],
                                [49.896178950948524, 4.8833076505019655],
                                [49.94647303906409, 4.8501895621955295],
                                [49.95839770922962, 4.790903141595087],
                                [50.09762527596348, 4.8685301585153855],
                                [50.15202976662415, 4.879551552800034],
                                [50.1607314288971, 4.824292330401957],
                                [50.13639695682964, 4.762161208292365],
                                [50.06492226522151, 4.683190239835278],
                                [49.995498425939175, 4.6888659727293],
                                [49.98550714809432, 4.593059650212624],
                                [49.94668308724302, 4.510410432978069],
                                [49.93750459397252, 4.446940783287939],
                                [49.963560807658, 4.333646634903396],
                                [49.95782375745278, 4.233068423333533],
                                [49.856522649594936, 4.2485071443588325],
                                [49.78178059627039, 4.20958854124873],
                                [49.75710160233298, 4.250088858677236],
                                [49.67792125134356, 4.127021546188527],
                                [49.628478163833556, 4.099316041330109],
                                [49.614289972299225, 4.031390794494156],
                                [49.57112749860687, 4.076570889635557],
                                [49.50853465720682, 4.040711745102368],
                                [49.405642294757534, 4.047972977986833],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "08", "NOM_DEPT": "ARDENNES"},
                },
                5: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            47.9256762348538,
                            3.3919598867876517,
                            48.70745423752744,
                            4.858919933219106,
                        ),
                        "coordinates": [
                            [
                                [48.39027303882033, 3.4147915595010967],
                                [48.36909719472573, 3.4981527640993844],
                                [48.27133989892487, 3.6168043332338455],
                                [48.225740470572546, 3.6216038851697063],
                                [48.13921190362741, 3.667869602845747],
                                [48.169707832950834, 3.740291245795231],
                                [48.10254956016531, 3.8049683849961107],
                                [47.98379240722837, 3.850029315571996],
                                [47.93917007405483, 3.9020865465480417],
                                [47.92699565753336, 4.1117857473984065],
                                [47.9699414025263, 4.199158053352666],
                                [47.9256762348538, 4.2934241069450065],
                                [47.961173282793276, 4.309003616780037],
                                [47.95715474758692, 4.448998378066956],
                                [47.97142319627392, 4.5599688756782095],
                                [48.02946360188034, 4.582678644289108],
                                [48.0202323762219, 4.704238250439468],
                                [48.07312791926578, 4.688818526238874],
                                [48.11820899819213, 4.730610406781701],
                                [48.10319242347872, 4.8193072949588815],
                                [48.141758855401065, 4.850099917169891],
                                [48.26363849150269, 4.858919933219106],
                                [48.347359803339394, 4.809737759938721],
                                [48.39485512882371, 4.716095686333967],
                                [48.47054866778951, 4.653455248176321],
                                [48.53188730232318, 4.670183207291811],
                                [48.553807130712464, 4.614026636401957],
                                [48.525252271641655, 4.545406992928758],
                                [48.56126039348743, 4.40306312166006],
                                [48.615578923326495, 4.315905486866125],
                                [48.700277029531, 4.3255940122986445],
                                [48.70745423752744, 4.166386793257749],
                                [48.70106898077084, 4.080262439820496],
                                [48.66387541820995, 4.001695483416846],
                                [48.60343162808371, 3.9492266572894206],
                                [48.516104417807576, 3.822742058660399],
                                [48.53746785521082, 3.730879401425958],
                                [48.541298263185546, 3.634028277746641],
                                [48.62028467657408, 3.5556137492385345],
                                [48.604809134470905, 3.5038535314822115],
                                [48.533562692399734, 3.4234423807070566],
                                [48.424322153455364, 3.3919598867876517],
                                [48.39027303882033, 3.4147915595010967],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "10", "NOM_DEPT": "AUBE"},
                },
                6: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            43.48006801088501,
                            6.636395800176685,
                            44.36104783803612,
                            7.716933970025215,
                        ),
                        "coordinates": [
                            [
                                [44.36104783803612, 6.887429900902961],
                                [44.31610570751232, 6.796090992510113],
                                [44.24984330468263, 6.723993885002385],
                                [44.169253930861004, 6.686536427072905],
                                [44.078606586955765, 6.755280297628582],
                                [44.043235362043184, 6.745713950501123],
                                [43.99060185096185, 6.836004210977612],
                                [43.95479401195955, 6.8518918622455915],
                                [43.92796536503885, 6.913088787529998],
                                [43.88912075689406, 6.884610185550848],
                                [43.91836301148648, 6.830709312232407],
                                [43.87210825687496, 6.745556290785885],
                                [43.87365480225297, 6.697323345466609],
                                [43.788950567095455, 6.636395800176685],
                                [43.738166980478354, 6.753535969205429],
                                [43.66648795918856, 6.760801398395701],
                                [43.62818033606128, 6.798740654262],
                                [43.59907918794692, 6.908012993627824],
                                [43.502535727819236, 6.884230099335205],
                                [43.48006801088501, 6.933726236453418],
                                [43.54544860181737, 6.971832403990882],
                                [43.54158089325735, 7.040446281575287],
                                [43.60527535172133, 7.12646929285388],
                                [43.65740341986589, 7.167667333361663],
                                [43.68848477342175, 7.241890731724426],
                                [43.69132686392644, 7.3202910753685595],
                                [43.79051515053247, 7.52851338181802],
                                [43.86435489125911, 7.495439796908122],
                                [43.8972946323181, 7.559218845189717],
                                [43.94367801378083, 7.567109183508686],
                                [43.974108783080936, 7.648594461131101],
                                [44.03066821354588, 7.664986572845552],
                                [44.081761260593375, 7.716933970025215],
                                [44.15374050304117, 7.670852285754872],
                                [44.14365239533755, 7.505741191835109],
                                [44.1128794460913, 7.426949388266545],
                                [44.143451305507774, 7.281965966624222],
                                [44.19780338462857, 7.188914616489549],
                                [44.232949828024594, 7.071037600740729],
                                [44.236431060526996, 7.008054894297459],
                                [44.2808914278525, 6.993446820816494],
                                [44.36104783803612, 6.887429900902961],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "06", "NOM_DEPT": "ALPES-MARITIMES"},
                },
                7: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            45.23644648192783,
                            3.6940178008729885,
                            46.27590543921817,
                            4.756935570818616,
                        ),
                        "coordinates": [
                            [
                                [45.93073235641238, 3.6940178008729885],
                                [45.88603083611283, 3.7543707578917007],
                                [45.783181674804744, 3.699758022143211],
                                [45.72434927186397, 3.7808499481107716],
                                [45.63241694241681, 3.823453198078696],
                                [45.5990224663249, 3.903596234209209],
                                [45.555962683335494, 3.954348408158434],
                                [45.44826954913943, 3.9751057509236487],
                                [45.410307649293415, 3.899187761612733],
                                [45.357083781715595, 3.897408424881887],
                                [45.37513435596747, 3.97965057221058],
                                [45.3428877136373, 4.02482405154612],
                                [45.39260487868634, 4.177926371804465],
                                [45.37098690693708, 4.308199323181692],
                                [45.33699593440974, 4.366534405291163],
                                [45.264395356817886, 4.3625488691169565],
                                [45.27542410166107, 4.418571110077436],
                                [45.23644648192783, 4.483134616383878],
                                [45.25170405771359, 4.602422910281467],
                                [45.30983662841339, 4.614497435388506],
                                [45.3461123269119, 4.679512199699749],
                                [45.36567226076599, 4.755996992712003],
                                [45.45570734978023, 4.756935570818616],
                                [45.49429755062865, 4.722336796597095],
                                [45.48675363928719, 4.661741865018664],
                                [45.575468343903715, 4.614858045826019],
                                [45.57325450372858, 4.5197664589356545],
                                [45.63205080632734, 4.410284239143386],
                                [45.69851909472673, 4.365516200673114],
                                [45.754934723712715, 4.391252031699621],
                                [45.86399385908122, 4.383032288498641],
                                [45.9005013366276, 4.3239261660748465],
                                [45.95339953385286, 4.2939122642052165],
                                [46.02122907041072, 4.30609575897843],
                                [46.05294444469335, 4.280409632428634],
                                [46.12922273900979, 4.321566636697419],
                                [46.16787882969538, 4.438590902796802],
                                [46.21978851671502, 4.388079599211451],
                                [46.1569500147692, 4.282499756804288],
                                [46.17875080608761, 4.261021127340283],
                                [46.17782633253049, 4.132418427256319],
                                [46.198394922848955, 4.104090700200876],
                                [46.16980977454083, 3.988786873539472],
                                [46.20271202778807, 3.972545422490283],
                                [46.214490641438644, 3.8901323277345172],
                                [46.27590543921817, 3.8995333931893303],
                                [46.25485708711847, 3.8048868330812957],
                                [46.154851332057156, 3.7897619940586127],
                                [46.08798388977018, 3.8218687105012146],
                                [46.04562293029197, 3.80676406021388],
                                [45.995967743331704, 3.8254431917706775],
                                [45.97385869263016, 3.788909241913359],
                                [45.97378454864044, 3.708883724363124],
                                [45.93073235641238, 3.6940178008729885],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "42", "NOM_DEPT": "LOIRE"},
                },
                8: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            42.69999034279792,
                            0.4419985587106278,
                            43.91831715512138,
                            2.02913283879736,
                        ),
                        "coordinates": [
                            [
                                [43.31088599158549, 0.6068109749570955],
                                [43.28903679046807, 0.6162800547565972],
                                [43.236102503746785, 0.5515684940570376],
                                [43.20914713009289, 0.5518748957180638],
                                [43.13127313187027, 0.4419985587106278],
                                [43.093864488407256, 0.5322696523895425],
                                [43.01746794817708, 0.5630044583601441],
                                [43.000102873234276, 0.6274179241908857],
                                [42.870825923039746, 0.575935146951876],
                                [42.87810749616207, 0.47730134412302644],
                                [42.828145214268325, 0.4588995164240373],
                                [42.728060641999555, 0.4550942250736491],
                                [42.69999034279792, 0.4777495403273698],
                                [42.7089682536352, 0.6822635276176592],
                                [42.7830764658169, 0.6445405045620637],
                                [42.838529465461015, 0.6590147498491506],
                                [42.86140184526932, 0.7083777796309813],
                                [42.825719089084465, 0.8583056667230169],
                                [42.91998800205083, 0.8324133769327755],
                                [42.95777574631528, 0.8749113719387418],
                                [42.97443096191435, 0.9791013887263268],
                                [43.007591006439135, 1.0070461604480825],
                                [43.06705628157321, 0.9851687313481592],
                                [43.100552820032235, 1.038835682734409],
                                [43.14182620134684, 1.058912548014145],
                                [43.156907404761775, 1.1240820844542168],
                                [43.117951050809886, 1.2087344680123449],
                                [43.18389310581045, 1.2274806300813899],
                                [43.18999472443669, 1.3146078107375299],
                                [43.21374576570539, 1.3743734334754005],
                                [43.28533747712757, 1.2933102990704717],
                                [43.31560605476546, 1.3436519696346765],
                                [43.25657153586671, 1.4253606535844832],
                                [43.21060079806052, 1.4637105789844813],
                                [43.27567426925569, 1.54752004958837],
                                [43.25511535449163, 1.6372035311274424],
                                [43.27355372810048, 1.688419720914751],
                                [43.3437401011229, 1.747732597304773],
                                [43.341403596986645, 1.81342406452215],
                                [43.391684804856155, 1.8040846789340412],
                                [43.44382089121736, 1.8587429714302222],
                                [43.40405939980915, 1.9101007956285103],
                                [43.43689796484212, 2.02913283879736],
                                [43.47035021960434, 2.018141282533191],
                                [43.520928759682434, 1.882609451533412],
                                [43.5808317662611, 1.824800921390715],
                                [43.63070037401987, 1.687771093611741],
                                [43.65775037692843, 1.730869381606712],
                                [43.71621951436253, 1.7064455963184253],
                                [43.74183402488211, 1.6604214137506872],
                                [43.800257495357435, 1.644787627039312],
                                [43.815488439336, 1.5910292905659653],
                                [43.868315400129546, 1.5554632454868464],
                                [43.91831715512138, 1.5556171726831818],
                                [43.87355299852184, 1.4478772809200224],
                                [43.884191550555926, 1.3568133196337082],
                                [43.82107440669022, 1.360890148995833],
                                [43.77077752425893, 1.2191934244058245],
                                [43.82229820079683, 1.144597614414948],
                                [43.78737246570886, 0.9539831166064945],
                                [43.64497503168885, 1.0876957388199553],
                                [43.634175893375954, 1.1475492440427302],
                                [43.59481295502015, 1.2013370084855526],
                                [43.473338092390065, 1.0181843408377866],
                                [43.3626517065442, 0.9780837577086208],
                                [43.4063326892777, 0.917251134513719],
                                [43.416975022578875, 0.8205416805525506],
                                [43.376630810082574, 0.7175914463388223],
                                [43.31720926544647, 0.6559378827169783],
                                [43.31088599158549, 0.6068109749570955],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "31", "NOM_DEPT": "HAUTE-GARONNE"},
                },
                9: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            46.1569500147692,
                            3.629423683496518,
                            47.15541168354447,
                            5.459286424114922,
                        ),
                        "coordinates": [
                            [
                                [46.21978851671502, 4.388079599211451],
                                [46.29606050757101, 4.405813600867753],
                                [46.26712984788543, 4.503987529872384],
                                [46.26479308755153, 4.618551541036954],
                                [46.30219481477719, 4.693107175516046],
                                [46.178372127719896, 4.730529789085251],
                                [46.17667702271938, 4.780213475718984],
                                [46.25992151697564, 4.810994882268941],
                                [46.40298160185767, 4.8882077017045455],
                                [46.43991436571944, 4.891817622919295],
                                [46.51719845218087, 4.940023082647429],
                                [46.484872844561906, 5.052374107055715],
                                [46.508209505159336, 5.201145108499204],
                                [46.468359273121585, 5.215064143095116],
                                [46.44676642071987, 5.310560613770375],
                                [46.47313865941285, 5.415741925117895],
                                [46.522560963527845, 5.359190879639876],
                                [46.63754001470946, 5.441107903009742],
                                [46.728695545924005, 5.391088772820641],
                                [46.82617125942893, 5.370244880835242],
                                [46.85524478563492, 5.459286424114922],
                                [46.90405615619232, 5.316959409128448],
                                [46.93591076096911, 5.263264616775811],
                                [46.9798880946405, 5.255236339191406],
                                [46.95576520247547, 5.106281375832608],
                                [46.98158693341567, 5.049303736126251],
                                [46.919374625937934, 4.728129651701318],
                                [46.94082023678555, 4.623230215613321],
                                [47.028371557104066, 4.493691403385164],
                                [47.049999892555, 4.406283415170733],
                                [47.08164281958383, 4.405487083945717],
                                [47.11432625058055, 4.259600310936345],
                                [47.15541168354447, 4.209834279044644],
                                [47.15050513981915, 4.181888404407953],
                                [47.12333757652633, 4.1159670699158095],
                                [47.12104166410018, 4.06142733788571],
                                [47.080010034285166, 4.038726355028209],
                                [47.05449482938563, 4.072015136934213],
                                [46.98511001230654, 4.039401951235417],
                                [46.918155606841836, 4.037221978317054],
                                [46.87473433322919, 4.093851364443379],
                                [46.84327237673586, 4.056234450174584],
                                [46.789364691282145, 4.062709832615211],
                                [46.7767510975447, 3.9919591863262944],
                                [46.73887265980929, 3.9233937335663813],
                                [46.701502637145154, 3.797329518692337],
                                [46.75247120098577, 3.73619002089105],
                                [46.74945902193753, 3.629423683496518],
                                [46.70720877171206, 3.6379005417614154],
                                [46.660582165836225, 3.6969523102437005],
                                [46.56756978217593, 3.7432867634118923],
                                [46.519899554588264, 3.8017563441985818],
                                [46.53113227681356, 3.8340059039329697],
                                [46.48125092995185, 3.8904705648097107],
                                [46.489755621859324, 3.957937642803863],
                                [46.46546757106011, 3.9980416518372484],
                                [46.39922459383981, 3.9772154801510964],
                                [46.31919378739559, 3.9866257932147806],
                                [46.27590543921817, 3.8995333931893303],
                                [46.214490641438644, 3.8901323277345172],
                                [46.20271202778807, 3.972545422490283],
                                [46.16980977454083, 3.988786873539472],
                                [46.198394922848955, 4.104090700200876],
                                [46.17782633253049, 4.132418427256319],
                                [46.17875080608761, 4.261021127340283],
                                [46.1569500147692, 4.282499756804288],
                                [46.21978851671502, 4.388079599211451],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "71", "NOM_DEPT": "SAONE-ET-LOIRE"},
                },
                10: {
                    "attributes": {"CODE_DEPT": "53", "NOM_DEPT": "MAYENNE"},
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            47.73568882742972,
                            -1.2382517343256687,
                            48.56294475916397,
                            -0.051896256193192866,
                        ),
                        "coordinates": [
                            [
                                [48.50849381419033, -1.0701645143702043],
                                [48.433058231677805, -1.0827940655347785],
                                [48.327727830000974, -1.0450195299623035],
                                [48.25928012122702, -1.1000610480389654],
                                [48.08980493061708, -1.0496060893987509],
                                [48.06891120316757, -1.0232833455698922],
                                [47.99494016249537, -1.021261028476561],
                                [47.9890627829139, -1.1026711686637327],
                                [47.96582099565697, -1.1539940378788582],
                                [47.86797794678783, -1.189183999002136],
                                [47.80999146298685, -1.2382517343256687],
                                [47.77444246694106, -1.142627284404155],
                                [47.7819668412532, -1.0999157158854143],
                                [47.76199058809525, -0.9786565126647941],
                                [47.79649707221334, -0.9520300471637984],
                                [47.752273303191295, -0.8392941203736615],
                                [47.738107486283226, -0.7417076584328766],
                                [47.73568882742972, -0.6108182423666904],
                                [47.765090867872736, -0.4604118623353693],
                                [47.76056283995014, -0.3817032700427246],
                                [47.80531865640705, -0.38820058256862927],
                                [47.83221637946878, -0.4478589178811479],
                                [47.88002461791636, -0.37067332986759677],
                                [47.930844658498074, -0.3848402809484052],
                                [47.95819180740854, -0.2826331784456301],
                                [48.04309552281351, -0.3416648270919381],
                                [48.05898535750186, -0.23094244360355798],
                                [48.10695966457705, -0.21717400338852627],
                                [48.157106805256795, -0.24992127138834272],
                                [48.20500891985258, -0.1468370673865568],
                                [48.25554245624927, -0.16309583433799862],
                                [48.36135559567944, -0.1379780943180353],
                                [48.38200345781552, -0.05453120471342586],
                                [48.4532597698412, -0.051896256193192866],
                                [48.45806753461724, -0.14871347253945932],
                                [48.53697035216617, -0.16938268000563395],
                                [48.56294475916397, -0.20693829348513745],
                                [48.506988913211536, -0.2782279440483014],
                                [48.492944315128234, -0.3676233888648996],
                                [48.51181992419309, -0.43075405116636184],
                                [48.50579601256293, -0.5050654278707298],
                                [48.473117087352556, -0.5517177835994801],
                                [48.44428211569599, -0.6539938321279792],
                                [48.43655146991278, -0.7572811397545346],
                                [48.501458496522545, -0.8603629154348689],
                                [48.516618079595695, -0.9563792193607108],
                                [48.489170559999316, -1.0039987501163459],
                                [48.50849381419033, -1.0701645143702043],
                            ]
                        ],
                    },
                },
                11: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            45.191632555616025,
                            -0.41583863552489936,
                            46.138574721782,
                            0.942591996012476,
                        ),
                        "coordinates": [
                            [
                                [45.96965998523795, -0.10293687953014748],
                                [45.91102062998216, -0.13166445066648028],
                                [45.87066390237826, -0.11540038254695688],
                                [45.79573700033925, -0.15309474428582864],
                                [45.775745644085404, -0.2217452863431165],
                                [45.80655862747694, -0.2731191101089069],
                                [45.741668657543315, -0.41583863552489936],
                                [45.65617988507809, -0.4089294944559108],
                                [45.608919202664524, -0.37591965312829384],
                                [45.5644938737933, -0.2967152234141246],
                                [45.49164146613392, -0.2461560346224077],
                                [45.455677709323595, -0.2674239730736361],
                                [45.40874172938641, -0.2497593835924437],
                                [45.359870837250256, -0.28089591660714885],
                                [45.32143289837574, -0.22670231706753935],
                                [45.28895157818027, -0.10878607028506979],
                                [45.24807269185132, -0.11538526357329361],
                                [45.24789117263397, -0.04416800947411795],
                                [45.191632555616025, 0.004330746876933936],
                                [45.226854975561835, 0.05343044144838209],
                                [45.209111965868274, 0.12772449711041312],
                                [45.297748756812105, 0.2666092126294511],
                                [45.3630432815919, 0.24932982871876253],
                                [45.46087036559336, 0.3078489404274546],
                                [45.46547909899255, 0.3565371468549886],
                                [45.5444880543905, 0.4962604525540846],
                                [45.61725930045946, 0.49964715509464347],
                                [45.67214440425978, 0.6006928771045711],
                                [45.71456998977267, 0.6297424639524395],
                                [45.76311968057405, 0.714888400126834],
                                [45.80561793866405, 0.7164398059782177],
                                [45.82108209588079, 0.7822321483214054],
                                [45.91975549444778, 0.8629055339639634],
                                [45.95743607843123, 0.942591996012476],
                                [46.010453963771624, 0.9256254984735032],
                                [46.04787811648369, 0.8179096763959524],
                                [46.128581728488285, 0.8234337839605995],
                                [46.138574721782, 0.746904536639973],
                                [46.09725460634644, 0.6874528960648784],
                                [46.08555812252824, 0.5399728471342742],
                                [46.131953549867, 0.5064169377082222],
                                [46.06267560392233, 0.40265550901998215],
                                [46.06096626231274, 0.2798061440667491],
                                [46.0955500415297, 0.19735350521616218],
                                [46.09389590958498, 0.07297225926176226],
                                [46.052847829356985, 0.019272784617024384],
                                [46.05592180291526, -0.03199529342544053],
                                [45.99347998149095, -0.04143104082306168],
                                [45.96965998523795, -0.10293687953014748],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "16", "NOM_DEPT": "CHARENTE"},
                },
                12: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            48.45828455072381,
                            -1.9461788272965446,
                            49.72555529334811,
                            -0.7526143435139804,
                        ),
                        "coordinates": [
                            [
                                [48.75222016383323, -0.8409353560137922],
                                [48.786077720208596, -0.9670546190041182],
                                [48.781514884249376, -1.0894728333388966],
                                [48.848851642164846, -1.1326273918673393],
                                [48.87028515761763, -1.0711805139009567],
                                [48.96770698487004, -0.9427299538328557],
                                [49.06790310099278, -0.8690886128916935],
                                [49.12943404142506, -0.8865942987279166],
                                [49.14557431338926, -0.9314549410204019],
                                [49.20297333585717, -0.9008729068582105],
                                [49.20338541623966, -1.0226729579413136],
                                [49.26132689823427, -1.1134233752175775],
                                [49.309870859750724, -1.1395424010513058],
                                [49.3555679898469, -1.1196225402660513],
                                [49.36665848650392, -1.1639520107160874],
                                [49.42401948471984, -1.1825295039826573],
                                [49.538927340535665, -1.3063594927131816],
                                [49.573681923567534, -1.3041977944390684],
                                [49.6246500905728, -1.2295992003173195],
                                [49.692593173710435, -1.2878424776340338],
                                [49.70370298113619, -1.4211576721789985],
                                [49.654110262842224, -1.541574554113602],
                                [49.66123264657622, -1.6783876038065542],
                                [49.72555529334811, -1.942245186733018],
                                [49.67434830154208, -1.9461788272965446],
                                [49.65019279204105, -1.8603000418191276],
                                [49.57173433702396, -1.8410273136069895],
                                [49.54039147246038, -1.8856955118557936],
                                [49.45291724937305, -1.8267724913131993],
                                [49.3904836803198, -1.819828581172189],
                                [49.32509928438261, -1.711168264458309],
                                [49.169205064269555, -1.5988432590535966],
                                [49.07927811770437, -1.6094115242692357],
                                [49.001482910319716, -1.5607059456223331],
                                [48.92158406951217, -1.5643431050154546],
                                [48.83471201976927, -1.5941451540783493],
                                [48.75184944838185, -1.5744067767391599],
                                [48.68740346333083, -1.5049438127030472],
                                [48.65052438367011, -1.3931950000571642],
                                [48.6234182091528, -1.4491620818766187],
                                [48.62644574305228, -1.571087121326364],
                                [48.56659421958315, -1.5189153941473403],
                                [48.4893748476061, -1.4899474351423645],
                                [48.45828455072381, -1.3772458850979696],
                                [48.533924823055, -1.2722484935647256],
                                [48.54220594454137, -1.206555726308375],
                                [48.50849381419033, -1.0701645143702043],
                                [48.489170559999316, -1.0039987501163459],
                                [48.516618079595695, -0.9563792193607108],
                                [48.501458496522545, -0.8603629154348689],
                                [48.56267832832824, -0.7741715461672727],
                                [48.617618520532695, -0.7526143435139804],
                                [48.710188837806285, -0.7989559815697868],
                                [48.75222016383323, -0.8409353560137922],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "50", "NOM_DEPT": "MANCHE"},
                },
                13: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            48.45760028606413,
                            1.4577625828067997,
                            49.0781511731843,
                            2.2265593271545225,
                        ),
                        "coordinates": [
                            [
                                [48.94105360615515, 1.5015238197988665],
                                [48.89157660948184, 1.5572502545823868],
                                [48.814869639400584, 1.5912030850964909],
                                [48.70181187348942, 1.5795458299182847],
                                [48.663769109280636, 1.6024984234215411],
                                [48.57802434626237, 1.70925278746701],
                                [48.56937104099975, 1.7653297161980415],
                                [48.46608795961456, 1.8014458379190346],
                                [48.45760028606413, 1.9221489648373704],
                                [48.53307136184394, 1.9674261909808515],
                                [48.557597387423435, 2.0175740602972896],
                                [48.64208882251873, 2.020005696381871],
                                [48.68585180710444, 2.082221274606409],
                                [48.73956019802753, 2.111889242882012],
                                [48.77610203162177, 2.2265593271545225],
                                [48.81702039834037, 2.1515778037276103],
                                [48.87333985214219, 2.1528691414227357],
                                [48.90867932989047, 2.2005910092695036],
                                [48.94974074221645, 2.20585834678071],
                                [49.01467871491032, 2.084914920835882],
                                [48.998755806188655, 2.0247730444607903],
                                [49.021776326372276, 1.9378021652564323],
                                [49.07636122204013, 1.8239503630063805],
                                [49.04497657550693, 1.7234571618642331],
                                [49.0781511731843, 1.6736891270071166],
                                [49.07789415353795, 1.6087960706299216],
                                [49.06854572684407, 1.5217661561843225],
                                [49.026291046220386, 1.4577625828067997],
                                [48.94105360615515, 1.5015238197988665],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "78", "NOM_DEPT": "YVELINES"},
                },
                14: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            46.557660399034056,
                            5.698725742766406,
                            47.562955627817956,
                            7.062193873000226,
                        ),
                        "coordinates": [
                            [
                                [47.56280181879927, 6.806992048333126],
                                [47.53641528724466, 6.780972040773947],
                                [47.562955627817956, 6.685554362876694],
                                [47.535260638072835, 6.646719240296149],
                                [47.53987013332597, 6.5817761531248],
                                [47.492797262167244, 6.55356252302069],
                                [47.52029975346226, 6.401377017027886],
                                [47.50596607054917, 6.334353737417102],
                                [47.430569873278635, 6.262328582663191],
                                [47.35403647499406, 6.080045800270596],
                                [47.327623386353956, 5.989355047833264],
                                [47.34425359386964, 5.94137455282545],
                                [47.26499677497705, 5.698725742766406],
                                [47.21993674300857, 5.720409103677726],
                                [47.16905381606457, 5.811467446057154],
                                [47.134339348805675, 5.816084496368169],
                                [47.08943503996253, 5.768548742190094],
                                [47.02033909341784, 5.815050562004316],
                                [46.98044449059872, 5.968560305501438],
                                [46.94807945340021, 5.9640723607092],
                                [46.8730528372109, 6.0057784127798],
                                [46.82066736980736, 6.151793978046819],
                                [46.77268138485168, 6.203329933961532],
                                [46.74157523839264, 6.180271003478626],
                                [46.689524885344895, 6.06982847991084],
                                [46.6498184099785, 6.1037670236188335],
                                [46.60772285612785, 6.048566902902156],
                                [46.557660399034056, 6.1381085470292716],
                                [46.57631320344644, 6.1107480156789],
                                [46.691241021954745, 6.285329368806657],
                                [46.76174754330358, 6.438107473498827],
                                [46.81241169394881, 6.431004694945304],
                                [46.89020983338595, 6.4645708895250955],
                                [46.9286020853725, 6.432669440426171],
                                [46.9708582524052, 6.51880021365156],
                                [47.00275740209691, 6.640345422140116],
                                [47.04912442357012, 6.7140493259380465],
                                [47.108056539328445, 6.7399076404183615],
                                [47.1643834770384, 6.858349567867174],
                                [47.20161558472105, 6.882433031143579],
                                [47.24294090315342, 6.95497425319866],
                                [47.29554511881349, 6.993126569921015],
                                [47.34415792273254, 7.062193873000226],
                                [47.371836167175545, 7.016179011339008],
                                [47.35617732664824, 6.917301026972028],
                                [47.433373721422306, 6.940536510867674],
                                [47.49454608019349, 6.90760985982366],
                                [47.54736152102862, 6.90566962763424],
                                [47.56280181879927, 6.806992048333126],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "25", "NOM_DEPT": "DOUBS"},
                },
                15: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            48.42092912174115,
                            4.888760929797642,
                            49.61708773850276,
                            5.823066740236896,
                        ),
                        "coordinates": [
                            [
                                [48.49649260851312, 5.765154701602299],
                                [48.54035925156704, 5.7762118887724645],
                                [48.56142416981741, 5.71608982178375],
                                [48.60939047859851, 5.7617670452603855],
                                [48.695698334229284, 5.7577093395619],
                                [48.744533308856504, 5.714036349479591],
                                [48.826749431285386, 5.780971762726475],
                                [48.915257872637035, 5.747161790828688],
                                [48.9467460575909, 5.800245290300757],
                                [49.02310661815185, 5.823066740236896],
                                [49.08617366650139, 5.818638375145698],
                                [49.10787996559759, 5.763360758388861],
                                [49.15659587123615, 5.744467916779598],
                                [49.198088628043735, 5.765544232834612],
                                [49.21598694642171, 5.719044394768754],
                                [49.311343191085655, 5.731786006583375],
                                [49.41510555457393, 5.688147604064061],
                                [49.43743606551584, 5.634565984546508],
                                [49.40737462726647, 5.529099312496953],
                                [49.45269148819386, 5.461779526865533],
                                [49.49720502129503, 5.470910130592771],
                                [49.597347493736514, 5.426918930815697],
                                [49.61708773850276, 5.393536658328508],
                                [49.55928995633117, 5.311756637860767],
                                [49.563534256220265, 5.162975033383016],
                                [49.59307211738767, 5.118278729173794],
                                [49.4991534717053, 5.062396105126222],
                                [49.421924473125145, 5.1158969719764285],
                                [49.335913874705334, 5.026436999727152],
                                [49.27405171210352, 5.051180998120573],
                                [49.23686584630137, 4.950989232683009],
                                [49.18506820457861, 4.9397619983736725],
                                [49.11490008827158, 4.992117611940037],
                                [49.03495195077164, 5.0076814026818575],
                                [49.024332549540816, 5.036321445219878],
                                [48.95690245547182, 5.030128675561755],
                                [48.92214239512387, 4.9362093920054075],
                                [48.81720971453768, 4.888760929797642],
                                [48.74183736486811, 4.990124563499124],
                                [48.684418562233176, 4.988427677798425],
                                [48.634035501163716, 5.005925627052495],
                                [48.59572522098937, 5.070888258264775],
                                [48.59551086053376, 5.118346103266606],
                                [48.53861075457746, 5.208425883036941],
                                [48.48198867902053, 5.349469998299744],
                                [48.42092912174115, 5.470048195176172],
                                [48.43974531395933, 5.615963788740979],
                                [48.49649260851312, 5.765154701602299],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "55", "NOM_DEPT": "MEUSE"},
                },
                16: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            44.193809246235574,
                            -1.2602820243561477,
                            45.574693032813535,
                            0.2973255098237856,
                        ),
                        "coordinates": [
                            [
                                [44.762284673952365, 0.2973255098237856],
                                [44.85689385892574, 0.24175347207714187],
                                [44.82668350830169, 0.17043367429958434],
                                [44.831221061823996, 0.08302335597727034],
                                [44.857716516943654, -0.015447847302468334],
                                [44.91546925454322, 0.03436214413600625],
                                [44.947298811504744, 0.007378970051309284],
                                [45.07012096510983, 0.07329671773303688],
                                [45.11322788942682, 0.0460600817105796],
                                [45.10238433596342, -0.0402003397896402],
                                [45.1213888362867, -0.08770283087044228],
                                [45.08880721589074, -0.15295329411286412],
                                [45.11408527738146, -0.2550869802991912],
                                [45.16755837660476, -0.34233753875966755],
                                [45.16477966588985, -0.3940718179854259],
                                [45.2794739946481, -0.4291954727294871],
                                [45.29770833934139, -0.5595072006432503],
                                [45.32114282458838, -0.5944806728104985],
                                [45.32176994097864, -0.7526821734869675],
                                [45.3692088136439, -0.7740181405098189],
                                [45.43508336826085, -0.8410572249719415],
                                [45.574693032813535, -1.0257418763479118],
                                [45.56240962499771, -1.0911993078778213],
                                [45.47037006217617, -1.1570402521876126],
                                [45.29786685383699, -1.1623411294779722],
                                [44.864826144114005, -1.2229024029196527],
                                [44.70957693396086, -1.222955997695759],
                                [44.7746635368112, -1.160522506721865],
                                [44.69356358853642, -1.0363572283194813],
                                [44.648040902290475, -1.00536452930634],
                                [44.640602706356376, -1.080794255404563],
                                [44.66072655577172, -1.191539567755165],
                                [44.5757510136334, -1.227400657614334],
                                [44.539506550906935, -1.2602820243561477],
                                [44.46760421234612, -1.2538901028077152],
                                [44.502772891337074, -1.1064909647292627],
                                [44.53219457167761, -1.0851664955491256],
                                [44.48287893553745, -0.980696991457649],
                                [44.43765239133863, -1.0074534242441238],
                                [44.443344362596, -0.9191704541834174],
                                [44.418974549624615, -0.8452736279017063],
                                [44.446374662072536, -0.7307029568976181],
                                [44.443192240874566, -0.6287774027434528],
                                [44.39814566253359, -0.6276476111842939],
                                [44.36465404326284, -0.5281031072972922],
                                [44.33911112646834, -0.5176354697700617],
                                [44.32257705443087, -0.4318395413151788],
                                [44.286310667736586, -0.38338729038705555],
                                [44.20948462715674, -0.3896173620609178],
                                [44.193809246235574, -0.27211852903661166],
                                [44.205898263801814, -0.22344709828329445],
                                [44.26904045949535, -0.19411335198198051],
                                [44.226404747689884, -0.1406884798527587],
                                [44.246757992226044, -0.06662475964814332],
                                [44.2967257980246, -0.034811250980738874],
                                [44.33761004988665, -0.08575207965013022],
                                [44.38987879184508, 0.018233646559888256],
                                [44.418543403742476, -0.01055239618525492],
                                [44.50506278713605, -0.015453699893016915],
                                [44.55304661779892, 0.04056782018280631],
                                [44.61612295595807, 0.15360786253340622],
                                [44.661072124006985, 0.182677659153478],
                                [44.682444103785436, 0.13372640074632025],
                                [44.730481039785595, 0.15300384600841968],
                                [44.762284673952365, 0.2973255098237856],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "33", "NOM_DEPT": "GIRONDE"},
                },
                17: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            48.75222016383323,
                            -1.1395424010513058,
                            49.429861637283,
                            0.43675135320661196,
                        ),
                        "coordinates": [
                            [
                                [49.429861637283, 0.2972244202906149],
                                [49.42676180478786, 0.21994001130961904],
                                [49.39426193746853, 0.11038005889157709],
                                [49.321203481541424, -0.013368582587024589],
                                [49.29760052804955, -0.09959949005984037],
                                [49.28181693021673, -0.22569330389903117],
                                [49.33558104324267, -0.4148485981637238],
                                [49.34501616988367, -0.5153140242090215],
                                [49.34700416593967, -0.7222488013847806],
                                [49.36254475176417, -0.8511656303754815],
                                [49.39504220855989, -0.9393846923333837],
                                [49.38849350541247, -1.0782173743324184],
                                [49.3555679898469, -1.1196225402660513],
                                [49.309870859750724, -1.1395424010513058],
                                [49.26132689823427, -1.1134233752175775],
                                [49.20338541623966, -1.0226729579413136],
                                [49.20297333585717, -0.9008729068582105],
                                [49.14557431338926, -0.9314549410204019],
                                [49.12943404142506, -0.8865942987279166],
                                [49.06790310099278, -0.8690886128916935],
                                [48.96770698487004, -0.9427299538328557],
                                [48.87028515761763, -1.0711805139009567],
                                [48.848851642164846, -1.1326273918673393],
                                [48.781514884249376, -1.0894728333388966],
                                [48.786077720208596, -0.9670546190041182],
                                [48.75222016383323, -0.8409353560137922],
                                [48.79986774271756, -0.7146786118899515],
                                [48.87136647587905, -0.4637527288822026],
                                [48.87014004741071, -0.41151869249428463],
                                [48.821999140746335, -0.3462445710154047],
                                [48.858307152999124, -0.30592108673909135],
                                [48.83444909949477, -0.14634308820607572],
                                [48.85358688783118, -0.05880746358844414],
                                [48.90246403865731, 0.05639799250068904],
                                [48.95221907078784, 0.12760760912750208],
                                [48.924787583562484, 0.1564748700538276],
                                [48.96474519879868, 0.2756400197144897],
                                [48.942883562782185, 0.3337726147565274],
                                [48.95062636769437, 0.4128145328890876],
                                [49.008190235684026, 0.43675135320661196],
                                [49.04945033019972, 0.37767980975475124],
                                [49.130194368095964, 0.42487479285721214],
                                [49.15011747492428, 0.39468800874102034],
                                [49.264016474812756, 0.382786744119418],
                                [49.29699256482139, 0.32302317286212956],
                                [49.429861637283, 0.2972244202906149],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "14", "NOM_DEPT": "CALVADOS"},
                },
                18: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            47.81305372460471,
                            5.408721169498744,
                            48.51359226555661,
                            7.198281537029947,
                        ),
                        "coordinates": [
                            [
                                [47.92604714858532, 5.884726375202079],
                                [47.97971039136252, 5.94752101881473],
                                [47.956089699040746, 6.002262047573574],
                                [48.015666213333766, 6.072563808399439],
                                [48.00694405924028, 6.156057875261972],
                                [47.95235039238132, 6.167984818891344],
                                [47.93284210199926, 6.237987058178878],
                                [47.961944790786475, 6.366146412024702],
                                [47.94381595263879, 6.431707255957785],
                                [47.885521773703914, 6.4786018541765715],
                                [47.9026105653117, 6.5421528235861155],
                                [47.944398619135356, 6.601781921638085],
                                [47.904021106485565, 6.645533181556614],
                                [47.84962275518448, 6.784821909572193],
                                [47.81305372460471, 6.823538854548165],
                                [47.82294519701528, 6.846179818400714],
                                [47.850287916338935, 6.920034363859818],
                                [47.891191372726894, 6.900213335139268],
                                [47.9979579468772, 6.943356419805965],
                                [48.022399095831105, 7.001883743858899],
                                [48.13726637155602, 7.058912798901165],
                                [48.245940550021665, 7.133555808547299],
                                [48.31046786103526, 7.198281537029947],
                                [48.33329037920514, 7.121908440975998],
                                [48.40564467453035, 7.097427065168084],
                                [48.51359226555661, 7.123165369028565],
                                [48.47905957978557, 6.9829860045628855],
                                [48.4180943151424, 6.890810652427116],
                                [48.39884620056533, 6.815166528707747],
                                [48.41308754075586, 6.6994983396482075],
                                [48.46050916362014, 6.584971476704244],
                                [48.419031847017656, 6.56697422886565],
                                [48.397598877997915, 6.178419125638965],
                                [48.35403844099854, 6.116723785728533],
                                [48.34989070446764, 5.961559100039156],
                                [48.50684438558553, 5.856069666360071],
                                [48.49649260851312, 5.765154701602299],
                                [48.43974531395933, 5.615963788740979],
                                [48.42092912174115, 5.470048195176172],
                                [48.38310019043651, 5.408721169498744],
                                [48.35620132426793, 5.482149185087856],
                                [48.24235420494441, 5.640901189478503],
                                [48.21992832819691, 5.710843767915566],
                                [48.14504209498631, 5.68431870758825],
                                [48.08398621524326, 5.630534001339329],
                                [48.07722956641849, 5.696798789098754],
                                [48.03136192327879, 5.77774789858366],
                                [47.95259697311841, 5.787280985479235],
                                [47.96283504724515, 5.850003923490582],
                                [47.92604714858532, 5.884726375202079],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "88", "NOM_DEPT": "VOSGES"},
                },
                19: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            46.42040537318102,
                            1.7745813093652696,
                            47.6289623689043,
                            3.0793297925031697,
                        ),
                        "coordinates": [
                            [
                                [47.62097830787993, 2.2392136309887465],
                                [47.584697964594106, 2.1279686465889993],
                                [47.54857375641657, 2.1956362774138967],
                                [47.472342931945946, 2.2382190791314827],
                                [47.38678255688259, 2.101692730986123],
                                [47.285486220264254, 2.1389909561599825],
                                [47.26543934027617, 1.9970384773235634],
                                [47.29013078287711, 1.940816059215001],
                                [47.2156553664379, 1.9040800791132237],
                                [47.21930815773424, 1.8390792420529518],
                                [47.17802935443287, 1.8421086266284743],
                                [47.130846812692134, 1.7745813093652696],
                                [47.101949545642825, 1.882721849834433],
                                [47.125417513727896, 1.9664139793909294],
                                [47.10601550210712, 2.048374881247615],
                                [47.040016048649505, 2.051487760798448],
                                [47.01573583572996, 2.0933838995940373],
                                [46.93399643786305, 2.0706986163554206],
                                [46.87986509549618, 2.1262038890477335],
                                [46.82944826814362, 2.0488103323451234],
                                [46.774358601474674, 2.1153606164888155],
                                [46.74249480206491, 2.065751312591214],
                                [46.69555371540337, 2.1407244355816926],
                                [46.60286242584107, 2.18562886154938],
                                [46.55734628168219, 2.158700190947214],
                                [46.48439997524805, 2.2043972607989812],
                                [46.45796019235814, 2.1516716067091237],
                                [46.4240665008181, 2.167785718138384],
                                [46.42040537318102, 2.2810476101300576],
                                [46.45351915029326, 2.2857578150118907],
                                [46.512211347274814, 2.3520035556502914],
                                [46.53269744464404, 2.4829288047758253],
                                [46.51969984591659, 2.536652020779054],
                                [46.55328003970227, 2.614955459722656],
                                [46.6372195698165, 2.5966478252098466],
                                [46.7393873052656, 2.7049751251942706],
                                [46.71890739681203, 2.774488053228389],
                                [46.73528787880109, 2.8276163881602265],
                                [46.803876576773305, 2.9599146908207157],
                                [46.794911188525944, 3.0320681893946824],
                                [46.87767673133036, 3.0680947893123323],
                                [46.91063036589821, 3.0502941730720203],
                                [46.955118753700106, 3.0793297925031697],
                                [47.01914457943622, 3.0757376737966906],
                                [47.06261687352467, 3.0232152406674615],
                                [47.129067685143006, 3.0280852399597813],
                                [47.221996957251605, 2.9816846477683376],
                                [47.25976318039041, 2.9834041014118906],
                                [47.34839595883525, 2.8734906167112504],
                                [47.444566735803356, 2.928902314704163],
                                [47.520423112556664, 2.8746252064056805],
                                [47.49445932903693, 2.8064837781833747],
                                [47.523527275666915, 2.7680263231364863],
                                [47.49216663238491, 2.7193534234556664],
                                [47.48789924167961, 2.658459112358834],
                                [47.55368570340879, 2.599892421980175],
                                [47.568295437652175, 2.491358293796867],
                                [47.60977811486517, 2.4373472313231086],
                                [47.58552457239423, 2.3730210260695963],
                                [47.6289623689043, 2.286237981293774],
                                [47.62097830787993, 2.2392136309887465],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "18", "NOM_DEPT": "CHER"},
                },
                20: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            44.26478557642796,
                            3.862527190139651,
                            45.36567226076599,
                            4.886589299843449,
                        ),
                        "coordinates": [
                            [
                                [44.45979755586323, 3.998162987763964],
                                [44.40511357294199, 4.068441217053273],
                                [44.317323657117, 4.051451662788466],
                                [44.31335085540007, 4.142867700090412],
                                [44.26478557642796, 4.2588461979825505],
                                [44.314658687843355, 4.288416558058853],
                                [44.33952274370027, 4.336073225463424],
                                [44.34018845123076, 4.503536213064646],
                                [44.30244463260489, 4.55869985714841],
                                [44.27035986501095, 4.649223666100485],
                                [44.32980579151128, 4.650615013437554],
                                [44.43066448441976, 4.667367377491741],
                                [44.452309460126756, 4.69865229412497],
                                [44.542230674151796, 4.693639580520507],
                                [44.581549114708366, 4.7102664999416985],
                                [44.65469880413612, 4.779060115885166],
                                [44.77862679935857, 4.76621554467615],
                                [44.81708784467795, 4.822513080923934],
                                [44.93665163053356, 4.886589299843449],
                                [45.004791813947854, 4.837672652853049],
                                [45.16448183151871, 4.812473966213054],
                                [45.29836066114294, 4.800493926884063],
                                [45.36567226076599, 4.755996992712003],
                                [45.3461123269119, 4.679512199699749],
                                [45.30983662841339, 4.614497435388506],
                                [45.25170405771359, 4.602422910281467],
                                [45.23644648192783, 4.483134616383878],
                                [45.14083295591157, 4.443262789803058],
                                [45.1443595905019, 4.376558944791765],
                                [45.10483231156165, 4.375306064703463],
                                [44.99730682920296, 4.289827924670837],
                                [44.961336129386744, 4.221702631142119],
                                [44.87333360834132, 4.156154791813548],
                                [44.87316201331411, 4.039638866980704],
                                [44.83408100300616, 4.028374858328879],
                                [44.7954172172997, 3.937001123548729],
                                [44.743863434670935, 3.862527190139651],
                                [44.592708047769605, 3.9051719910706293],
                                [44.57379092180415, 3.9451489956301886],
                                [44.45979755586323, 3.998162987763964],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "07", "NOM_DEPT": "ARDECHE"},
                },
                21: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            48.85190849437287,
                            2.97439031593416,
                            50.069274635963545,
                            4.250088858677236,
                        ),
                        "coordinates": [
                            [
                                [49.405642294757534, 4.047972977986833],
                                [49.50853465720682, 4.040711745102368],
                                [49.57112749860687, 4.076570889635557],
                                [49.614289972299225, 4.031390794494156],
                                [49.628478163833556, 4.099316041330109],
                                [49.67792125134356, 4.127021546188527],
                                [49.75710160233298, 4.250088858677236],
                                [49.78178059627039, 4.20958854124873],
                                [49.856522649594936, 4.2485071443588325],
                                [49.95782375745278, 4.233068423333533],
                                [49.978759598994436, 4.140895251736092],
                                [49.969187585411916, 4.08712850474961],
                                [49.99537608693849, 3.9803763118726994],
                                [50.026430676607156, 3.923501465982155],
                                [50.05360423497288, 3.7463798889650586],
                                [50.069274635963545, 3.715184685025503],
                                [50.025418579177284, 3.6136399192005855],
                                [50.05379395526909, 3.54484649487849],
                                [50.01885605079539, 3.4913598357111555],
                                [50.035859344668864, 3.3529820366555496],
                                [50.0151825508069, 3.2801740988851327],
                                [50.03130959186552, 3.2305405050170397],
                                [50.01199494467939, 3.1727072271768164],
                                [49.977464696263276, 3.1926752854802194],
                                [49.91427637798353, 3.117968662907868],
                                [49.822415215784225, 3.078694114076548],
                                [49.705968560150744, 3.1184031553047866],
                                [49.656683091231635, 3.09777622468101],
                                [49.543377651791836, 3.1314803354793224],
                                [49.51340305901281, 3.0957783548212805],
                                [49.451589762665364, 3.1605832452848968],
                                [49.43374686813427, 3.0937834703774705],
                                [49.37711907478125, 3.0953874973379834],
                                [49.302338848225304, 2.97439031593416],
                                [49.27553205719088, 3.0268878942941857],
                                [49.19273857569733, 3.0640875194145396],
                                [49.152576953634764, 3.1396578896700365],
                                [49.117554218816146, 3.071884293834167],
                                [49.09965085798759, 3.16523032905892],
                                [49.014123184303735, 3.171683982224406],
                                [48.948764278944545, 3.3047494707754015],
                                [48.908706088642376, 3.3302994547269797],
                                [48.8646865193221, 3.4032194510047127],
                                [48.85190849437287, 3.4851874436586847],
                                [48.91214102895303, 3.528576443116953],
                                [48.94407204131733, 3.6015984944904185],
                                [49.04058839070318, 3.646307433571441],
                                [49.12069184512517, 3.600004656260229],
                                [49.151103693376655, 3.622246623748466],
                                [49.18137302346899, 3.7043920469634597],
                                [49.31515350351225, 3.646953205074641],
                                [49.36458662943729, 3.8474771401321166],
                                [49.406181771288736, 3.9244337055179424],
                                [49.359904159430094, 4.035496373111564],
                                [49.405642294757534, 4.047972977986833],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "02", "NOM_DEPT": "AISNE"},
                },
                22: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            42.79316107597115,
                            -1.762027538655403,
                            43.596404001570654,
                            0.009598314167784467,
                        ),
                        "coordinates": [
                            [
                                [43.52970134669009, -1.524866548422101],
                                [43.43749281443975, -1.5973846756448384],
                                [43.40836090393235, -1.6391097857903014],
                                [43.37589158909485, -1.762027538655403],
                                [43.29567717164443, -1.729746317485463],
                                [43.3140776879947, -1.6657616159233792],
                                [43.25212549943678, -1.6089349856953201],
                                [43.2879116835355, -1.564715648901561],
                                [43.29278486875202, -1.505324531987169],
                                [43.25329431428316, -1.382786289109042],
                                [43.19081965347401, -1.3838290836545226],
                                [43.129178211984154, -1.4139466293353435],
                                [43.0810930732876, -1.4717353538630287],
                                [43.045032714608894, -1.4351852539528482],
                                [43.02846729741783, -1.3547480564678602],
                                [43.09537933451567, -1.3432933078866276],
                                [43.04456744579185, -1.2642856059829328],
                                [43.05449581378487, -1.2311433515565404],
                                [42.98899399788973, -1.0064443208237919],
                                [42.95406127408886, -0.9464504061324431],
                                [42.95143307665447, -0.8100187374291923],
                                [42.96693889977146, -0.751639105301494],
                                [42.896559178660695, -0.7297615302313328],
                                [42.79316107597115, -0.5438135992737804],
                                [42.82539255578589, -0.5096457244615787],
                                [42.796462278452985, -0.4397499421861355],
                                [42.79955853388815, -0.3925972910093663],
                                [42.84937505970757, -0.31344286349808953],
                                [42.915781623764374, -0.3270821344018897],
                                [42.93356279018236, -0.28159092548449965],
                                [42.98776781593242, -0.29155187666703314],
                                [43.033687539643886, -0.22395152380116173],
                                [43.11120001485185, -0.19098404402245117],
                                [43.128235959977104, -0.14613235140227182],
                                [43.180326663081885, -0.11770146168361191],
                                [43.27045317593498, -0.017007531250724548],
                                [43.300855792903974, -0.046122416801734976],
                                [43.42210994370382, 0.009598314167784467],
                                [43.43734927067611, -0.06903100203309719],
                                [43.512605402100824, -0.04013178615004061],
                                [43.5824058976317, -0.0967829732087753],
                                [43.596404001570654, -0.17641328064610742],
                                [43.58497620901365, -0.2428365587430673],
                                [43.560276850255974, -0.3036904680467346],
                                [43.56822563862102, -0.4060419475368964],
                                [43.596089226471534, -0.4482922578476395],
                                [43.542797175106195, -0.557174431652949],
                                [43.566716972183386, -0.6708071861709698],
                                [43.54111406021403, -0.7153911507395111],
                                [43.56416715906682, -0.7817805196343687],
                                [43.55048921576566, -0.896690646890469],
                                [43.50538804684213, -0.9933935609538066],
                                [43.51412989565136, -1.1092478299389088],
                                [43.54560988391761, -1.1708199655376677],
                                [43.49820457476753, -1.2911822396099015],
                                [43.49776692584455, -1.4177740978934008],
                                [43.539184056404956, -1.47661986699547],
                                [43.52970134669009, -1.524866548422101],
                            ]
                        ],
                    },
                    "attributes": {
                        "CODE_DEPT": "64",
                        "NOM_DEPT": "PYRENEES-ATLANTIQUES",
                    },
                },
                23: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            47.18622542473178,
                            0.5805178732790713,
                            48.12749350968226,
                            2.2392136309887465,
                        ),
                        "coordinates": [
                            [
                                [47.62097830787993, 2.2392136309887465],
                                [47.67814460516368, 2.20255850774907],
                                [47.675630779123125, 1.9424229848119656],
                                [47.68635321601097, 1.8436947697611497],
                                [47.63843148089739, 1.7985957016041196],
                                [47.66153396919206, 1.739938252775079],
                                [47.738393484182936, 1.6973528002323046],
                                [47.76976159023591, 1.5478779921036048],
                                [47.820525929167275, 1.5337009096463892],
                                [47.87642659620686, 1.5881377383696464],
                                [47.92911358021597, 1.5254235639039049],
                                [47.98227847700271, 1.5201238283340488],
                                [47.95385379978459, 1.3086281518302278],
                                [47.968500516699756, 1.2096430686639734],
                                [48.03911591949663, 1.121233516589401],
                                [48.080729125955024, 1.112233332007327],
                                [48.08312677901136, 1.0085477409246664],
                                [48.12749350968226, 0.9973300079370282],
                                [48.10306240933593, 0.8412172317044129],
                                [48.03755441455243, 0.7974846748199685],
                                [47.94140146385974, 0.8458005593594105],
                                [47.89822684022154, 0.7598746908928177],
                                [47.839687295150355, 0.7745788175007324],
                                [47.790036219738816, 0.7126298064021259],
                                [47.71232800972911, 0.5805178732790713],
                                [47.69421364606961, 0.6144311990931551],
                                [47.69540180185664, 0.7353105618986349],
                                [47.66920726991006, 0.8595037193186874],
                                [47.632609060103235, 0.9190111731399363],
                                [47.60701157047614, 1.0333525357335167],
                                [47.56322155433421, 1.0763363652479008],
                                [47.53148801134601, 1.0452908534068046],
                                [47.44646665748557, 1.132364189106744],
                                [47.4113254251562, 1.1074833948523175],
                                [47.35401667090686, 1.1228353402815718],
                                [47.29839804393137, 1.1081270826014082],
                                [47.27219609172912, 1.1620645187006384],
                                [47.29408083062265, 1.2235368646048146],
                                [47.25470690394847, 1.2769082168277972],
                                [47.18622542473178, 1.3266655450453897],
                                [47.237967921224396, 1.448462247960517],
                                [47.27667661630457, 1.5924281213159723],
                                [47.26587806829791, 1.7058305011298698],
                                [47.21930815773424, 1.8390792420529518],
                                [47.2156553664379, 1.9040800791132237],
                                [47.29013078287711, 1.940816059215001],
                                [47.26543934027617, 1.9970384773235634],
                                [47.285486220264254, 2.1389909561599825],
                                [47.38678255688259, 2.101692730986123],
                                [47.472342931945946, 2.2382190791314827],
                                [47.54857375641657, 2.1956362774138967],
                                [47.584697964594106, 2.1279686465889993],
                                [47.62097830787993, 2.2392136309887465],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "41", "NOM_DEPT": "LOIR-ET-CHER"},
                },
                24: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            48.52759644354931,
                            5.893401083719673,
                            49.5100225584692,
                            7.635285449703197,
                        ),
                        "coordinates": [
                            [
                                [48.536417612700156, 7.079359770973246],
                                [48.52759644354931, 7.167909935894844],
                                [48.588675507652006, 7.256281654444217],
                                [48.63810720117092, 7.283044927480475],
                                [48.69154313190619, 7.242487615031407],
                                [48.76730084431057, 7.311900506296782],
                                [48.84470403837187, 7.149408408912651],
                                [48.801142358200266, 7.126799106595456],
                                [48.813704386223854, 7.054514540544794],
                                [48.87154914036644, 7.0453428905310576],
                                [48.90452526765522, 6.964601688658047],
                                [48.95992878867804, 6.98921640979739],
                                [49.03061918771655, 7.054911912536334],
                                [49.04411352331478, 7.107657105402387],
                                [49.006365681338195, 7.174240270723143],
                                [48.97341645090749, 7.293048848802893],
                                [48.94337274202096, 7.326851980608825],
                                [48.96577914855414, 7.446887904100119],
                                [48.932961584940934, 7.5382590392502085],
                                [48.95740241810784, 7.57839213753989],
                                [49.0541613551771, 7.635285449703197],
                                [49.09206519190207, 7.539004820203112],
                                [49.18079327995296, 7.4399513148130945],
                                [49.17183619631744, 7.365078240855518],
                                [49.11745711801211, 7.298652796709717],
                                [49.12798155802856, 7.247787410384875],
                                [49.11458391989877, 7.066094084474562],
                                [49.18812137477419, 7.010704448405599],
                                [49.22215638708473, 6.935411827637279],
                                [49.21132385245782, 6.835378369933188],
                                [49.15146671246839, 6.834537718950126],
                                [49.16366113912632, 6.738512367681465],
                                [49.22444557282531, 6.688137831919717],
                                [49.28060494669888, 6.669191900827955],
                                [49.3473501703592, 6.56583851528285],
                                [49.38493582882031, 6.587074296882196],
                                [49.42334910853593, 6.552234581612261],
                                [49.4763981473342, 6.43012234409301],
                                [49.46446473286874, 6.391962714585447],
                                [49.48010694491308, 6.296571041016305],
                                [49.5100225584692, 6.256413026994873],
                                [49.504389798567836, 6.156886905838471],
                                [49.47375617437316, 6.123493803074785],
                                [49.45333363561611, 5.988987531307048],
                                [49.49131664375855, 5.971769533719511],
                                [49.49690975011092, 5.893401083719673],
                                [49.45289553695899, 5.942619950432162],
                                [49.37550729349813, 5.928530586493157],
                                [49.23047199221416, 6.029385386695151],
                                [49.20961691713356, 5.987627297222747],
                                [49.165118935990016, 6.0261499402444025],
                                [49.10910433832356, 5.931603285178869],
                                [49.07185221973813, 5.935399690626695],
                                [49.01041872049325, 6.044996956010202],
                                [48.977477915970994, 6.043435324319259],
                                [48.967833205844386, 6.116898532084446],
                                [48.93472094774055, 6.132207146051102],
                                [48.9331355970772, 6.271977767337417],
                                [48.834058199828384, 6.338947107825573],
                                [48.78165892451309, 6.35503013356845],
                                [48.75409250995719, 6.554148775117042],
                                [48.71569079778236, 6.598965570952483],
                                [48.7080472862827, 6.658407329856351],
                                [48.672840395381456, 6.6922838813846575],
                                [48.66938665042789, 6.75467285145004],
                                [48.62597500455583, 6.844053536871702],
                                [48.61186293045215, 6.982882241286179],
                                [48.536417612700156, 7.079359770973246],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "57", "NOM_DEPT": "MOSELLE"},
                },
                25: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            46.06096626231274,
                            -0.10212095637964816,
                            47.16373008265527,
                            1.212690238083345,
                        ),
                        "coordinates": [
                            [
                                [46.0955500415297, 0.19735350521616218],
                                [46.06096626231274, 0.2798061440667491],
                                [46.06267560392233, 0.40265550901998215],
                                [46.131953549867, 0.5064169377082222],
                                [46.08555812252824, 0.5399728471342742],
                                [46.09725460634644, 0.6874528960648784],
                                [46.138574721782, 0.746904536639973],
                                [46.128581728488285, 0.8234337839605995],
                                [46.21096277430388, 0.7963255053030057],
                                [46.285257481169126, 0.9072715939898939],
                                [46.28097399864579, 1.0058867393780462],
                                [46.34303442800397, 1.026995442933731],
                                [46.360466281243085, 1.1297576486963083],
                                [46.383951622152935, 1.1772799568053667],
                                [46.43222161336161, 1.212690238083345],
                                [46.449236175812, 1.1516045347766355],
                                [46.50640188056708, 1.1459353661062848],
                                [46.567763998821995, 1.0147644249831798],
                                [46.580792108421264, 0.94202375883659],
                                [46.625736651822876, 0.8943018154002147],
                                [46.69279335231604, 0.9247556936578988],
                                [46.74821910504848, 0.8674688807081561],
                                [46.79450796471715, 0.8119017840639386],
                                [46.852391083185935, 0.7903284955617977],
                                [46.90329335315584, 0.704324392050786],
                                [46.97430706301783, 0.6925692823646332],
                                [47.00227037444165, 0.5669489614197056],
                                [46.95676414686082, 0.5983482495759433],
                                [46.95924736173615, 0.5061414593305557],
                                [46.92958207105905, 0.4387096602536596],
                                [46.973827658647814, 0.30073625724988373],
                                [47.0539187252087, 0.29823142261819696],
                                [47.07127519606643, 0.17422061595767882],
                                [47.12158055414751, 0.13613090268194533],
                                [47.123931948888234, 0.07637120084195193],
                                [47.16373008265527, 0.05382761471070587],
                                [47.15750952036683, -0.01073662557135027],
                                [47.09324258439809, -0.04416541443323783],
                                [47.064797190818, -0.10212095637964816],
                                [47.023133335712934, -0.08769647758767064],
                                [46.90747700605924, -0.009032410299882686],
                                [46.81265392500652, -0.020316336069380696],
                                [46.71623331657765, 0.0007042720140887955],
                                [46.66371702380725, -0.04042619019472192],
                                [46.5947435067776, 0.02598963802815841],
                                [46.52498101941567, -0.031351255287517144],
                                [46.411322394513704, -0.01709282434894281],
                                [46.373496799479916, 0.034219979012944574],
                                [46.32552885451101, 0.037602239808067595],
                                [46.304933538922825, 0.07821800902702593],
                                [46.34939518270097, 0.13759784994026172],
                                [46.32811314059693, 0.1773687959824542],
                                [46.267231548998694, 0.12883677213786546],
                                [46.210932609573995, 0.11283682536372644],
                                [46.157168244596924, 0.1551113740904494],
                                [46.13884556432993, 0.21492180826491442],
                                [46.0955500415297, 0.19735350521616218],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "86", "NOM_DEPT": "VIENNE"},
                },
                26: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            44.577324783565565,
                            -0.0402003397896402,
                            45.71456998977267,
                            1.4482615439322115,
                        ),
                        "coordinates": [
                            [
                                [45.71456998977267, 0.6297424639524395],
                                [45.67214440425978, 0.6006928771045711],
                                [45.61725930045946, 0.49964715509464347],
                                [45.5444880543905, 0.4962604525540846],
                                [45.46547909899255, 0.3565371468549886],
                                [45.46087036559336, 0.3078489404274546],
                                [45.3630432815919, 0.24932982871876253],
                                [45.297748756812105, 0.2666092126294511],
                                [45.209111965868274, 0.12772449711041312],
                                [45.226854975561835, 0.05343044144838209],
                                [45.191632555616025, 0.004330746876933936],
                                [45.10238433596342, -0.0402003397896402],
                                [45.11322788942682, 0.0460600817105796],
                                [45.07012096510983, 0.07329671773303688],
                                [44.947298811504744, 0.007378970051309284],
                                [44.91546925454322, 0.03436214413600625],
                                [44.857716516943654, -0.015447847302468334],
                                [44.831221061823996, 0.08302335597727034],
                                [44.82668350830169, 0.17043367429958434],
                                [44.85689385892574, 0.24175347207714187],
                                [44.762284673952365, 0.2973255098237856],
                                [44.73743575883074, 0.3354490861907089],
                                [44.66221103663619, 0.36557538473802004],
                                [44.64633711715288, 0.41470651574900513],
                                [44.70652766853691, 0.6304884773468264],
                                [44.67784707846914, 0.6574344166312163],
                                [44.69188957907682, 0.8270009642517763],
                                [44.627001476439105, 0.8170042739845019],
                                [44.59730727091491, 0.8699961633461994],
                                [44.64361045554161, 0.9791284687246183],
                                [44.577324783565565, 1.0751408247250978],
                                [44.6394062697152, 1.1537937079861709],
                                [44.67034606645627, 1.1466718447537776],
                                [44.684266348929604, 1.2245500554542499],
                                [44.71478109653049, 1.2877821394602265],
                                [44.81156818641523, 1.3641029713426986],
                                [44.84079526684298, 1.3614038259537622],
                                [44.87757922298133, 1.441920482742166],
                                [44.99938624261527, 1.413299030000565],
                                [45.019313158674045, 1.4482615439322115],
                                [45.10288137852398, 1.3864424774272137],
                                [45.140188825629004, 1.2965184989870575],
                                [45.24208241912198, 1.2774962889939248],
                                [45.27197997099894, 1.2271194403372108],
                                [45.382659361364226, 1.3227969726587205],
                                [45.39834890279047, 1.2596039598397968],
                                [45.44421907802482, 1.2531518386328937],
                                [45.487782926278754, 1.1197844789851372],
                                [45.60020929025313, 1.0358490435954522],
                                [45.611582010503184, 0.9345523684647926],
                                [45.575870643461926, 0.811500332264728],
                                [45.61832385402003, 0.7515297126109166],
                                [45.6675695723418, 0.775843134926025],
                                [45.71456998977267, 0.6297424639524395],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "24", "NOM_DEPT": "DORDOGNE"},
                },
                27: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            46.260729204793954,
                            5.255236339191406,
                            47.30418661946959,
                            6.203329933961532,
                        ),
                        "coordinates": [
                            [
                                [46.44676642071987, 5.310560613770375],
                                [46.41681731886722, 5.307691028342544],
                                [46.38135905559832, 5.377044586181938],
                                [46.35223630468514, 5.3734622886202095],
                                [46.31511297122548, 5.437795113853318],
                                [46.265063763323475, 5.473055311573813],
                                [46.270201908707435, 5.542037828826235],
                                [46.33949103303637, 5.649339135998931],
                                [46.3087688477459, 5.714717731644379],
                                [46.260729204793954, 5.725183003095843],
                                [46.26206360332614, 5.849846074176259],
                                [46.283951620059554, 5.908938421371526],
                                [46.364873088758074, 5.986841317727858],
                                [46.416226988931534, 6.06400848181829],
                                [46.463946006284665, 6.073927085793577],
                                [46.54546817311972, 6.156435507165684],
                                [46.557660399034056, 6.1381085470292716],
                                [46.60772285612785, 6.048566902902156],
                                [46.6498184099785, 6.1037670236188335],
                                [46.689524885344895, 6.06982847991084],
                                [46.74157523839264, 6.180271003478626],
                                [46.77268138485168, 6.203329933961532],
                                [46.82066736980736, 6.151793978046819],
                                [46.8730528372109, 6.0057784127798],
                                [46.94807945340021, 5.9640723607092],
                                [46.98044449059872, 5.968560305501438],
                                [47.02033909341784, 5.815050562004316],
                                [47.08943503996253, 5.768548742190094],
                                [47.134339348805675, 5.816084496368169],
                                [47.16905381606457, 5.811467446057154],
                                [47.21993674300857, 5.720409103677726],
                                [47.26499677497705, 5.698725742766406],
                                [47.26053058451154, 5.602110210787404],
                                [47.30418661946959, 5.518538729512594],
                                [47.289347470334135, 5.488282961724511],
                                [47.21602767128051, 5.47662851608292],
                                [47.144397191390595, 5.439973300314684],
                                [47.081977110214815, 5.386011880946295],
                                [47.07298220144243, 5.322186205925132],
                                [47.0180208967574, 5.310049747453535],
                                [46.9798880946405, 5.255236339191406],
                                [46.93591076096911, 5.263264616775811],
                                [46.90405615619232, 5.316959409128448],
                                [46.85524478563492, 5.459286424114922],
                                [46.82617125942893, 5.370244880835242],
                                [46.728695545924005, 5.391088772820641],
                                [46.63754001470946, 5.441107903009742],
                                [46.522560963527845, 5.359190879639876],
                                [46.47313865941285, 5.415741925117895],
                                [46.44676642071987, 5.310560613770375],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "39", "NOM_DEPT": "JURA"},
                },
                28: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            43.77077752425893,
                            0.7418847912050011,
                            44.378513265035394,
                            1.9901707126503436,
                        ),
                        "coordinates": [
                            [
                                [44.340065248844205, 1.882082857535903],
                                [44.31381428140451, 1.6995029158165782],
                                [44.28680580678515, 1.651620766314853],
                                [44.29839388706526, 1.5691379539986452],
                                [44.263269755581916, 1.5205387676670992],
                                [44.224857733084384, 1.3803681196871467],
                                [44.23578619286305, 1.2813793816235721],
                                [44.327402883405846, 1.1079385683846072],
                                [44.378513265035394, 1.0640838318649108],
                                [44.36263857861528, 1.049803151007228],
                                [44.36637485759438, 0.8873307771559802],
                                [44.32330810855775, 0.8734701152053458],
                                [44.27644247710553, 0.9499239562135766],
                                [44.23827002933658, 0.9190898187097757],
                                [44.12632969467469, 0.86877365550795],
                                [44.10226981270581, 0.7528835731451475],
                                [44.06519923501576, 0.7418847912050011],
                                [44.03591070642859, 0.7757831291372458],
                                [44.040785422701155, 0.8604173969632192],
                                [43.94224249346573, 0.7600848328151357],
                                [43.923289163046476, 0.8628924476067087],
                                [43.864698458132736, 0.8994393128667493],
                                [43.78433052070778, 0.906155770674725],
                                [43.78737246570886, 0.9539831166064945],
                                [43.82229820079683, 1.144597614414948],
                                [43.77077752425893, 1.2191934244058245],
                                [43.82107440669022, 1.360890148995833],
                                [43.884191550555926, 1.3568133196337082],
                                [43.87355299852184, 1.4478772809200224],
                                [43.91831715512138, 1.5556171726831818],
                                [43.96302664758977, 1.5522914897522986],
                                [43.974001636165994, 1.6185715580365614],
                                [44.02434074044873, 1.6913900365689167],
                                [44.11641211601675, 1.6589585652250582],
                                [44.116267124994856, 1.7455400915583978],
                                [44.09681615657593, 1.7775202074591068],
                                [44.14369109998093, 1.8417039588173185],
                                [44.16294029634056, 1.9196921618272453],
                                [44.14945256348434, 1.9901707126503436],
                                [44.17992355171284, 1.976683004728593],
                                [44.20432736443666, 1.9021988872029416],
                                [44.27643627943402, 1.9704438024330744],
                                [44.27911646341683, 1.901390505373501],
                                [44.340065248844205, 1.882082857535903],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "82", "NOM_DEPT": "TARN-ET-GARONNE"},
                },
                29: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            46.97581784960786,
                            -1.3051085022277937,
                            47.80999146298685,
                            0.23000172635318478,
                        ),
                        "coordinates": [
                            [
                                [46.97581784960786, -0.8919599503022404],
                                [47.004252209132005, -0.7738774456713039],
                                [46.98607221005182, -0.7130578012324359],
                                [46.993322065658454, -0.6199767888274355],
                                [47.01942614381194, -0.5654683969778384],
                                [47.06188673077479, -0.559531871926381],
                                [47.08238521770843, -0.4953402437613732],
                                [47.070771034609585, -0.40077950615793034],
                                [47.10572466544676, -0.24153794845204798],
                                [47.10833699690518, -0.18483982751841418],
                                [47.064797190818, -0.10212095637964816],
                                [47.09324258439809, -0.04416541443323783],
                                [47.15750952036683, -0.01073662557135027],
                                [47.16373008265527, 0.05382761471070587],
                                [47.28282475506665, 0.07897484723536188],
                                [47.424733449390715, 0.18528045906678237],
                                [47.50195329713312, 0.22010925240137172],
                                [47.54432775642862, 0.20150312551615113],
                                [47.608398291933675, 0.23000172635318478],
                                [47.58153476849178, 0.15160368312924158],
                                [47.60651520171703, 0.05165930848592362],
                                [47.6476884238069, -0.004507638464452976],
                                [47.65800746667541, -0.07183106759512606],
                                [47.632519977213676, -0.13503673265540417],
                                [47.647916580390344, -0.19315724780649807],
                                [47.707562003167396, -0.23306038777944318],
                                [47.72116575999532, -0.3340770241988634],
                                [47.76056283995014, -0.3817032700427246],
                                [47.765090867872736, -0.4604118623353693],
                                [47.73568882742972, -0.6108182423666904],
                                [47.738107486283226, -0.7417076584328766],
                                [47.752273303191295, -0.8392941203736615],
                                [47.79649707221334, -0.9520300471637984],
                                [47.76199058809525, -0.9786565126647941],
                                [47.7819668412532, -1.0999157158854143],
                                [47.77444246694106, -1.142627284404155],
                                [47.80999146298685, -1.2382517343256687],
                                [47.77671754769661, -1.2458823462890545],
                                [47.73364175152332, -1.2545772523262662],
                                [47.694565013846024, -1.1749295691501485],
                                [47.6194570478612, -1.1382017900650407],
                                [47.58905339489953, -1.0068639898836467],
                                [47.56335191106952, -1.045909504072581],
                                [47.57300754719196, -1.1724160661946539],
                                [47.51008306960625, -1.1572331855798599],
                                [47.49280029691793, -0.9674825559179046],
                                [47.38646685235786, -0.9464433335100018],
                                [47.365062263189614, -1.0178737847602033],
                                [47.36588723515685, -1.167609698077546],
                                [47.337623665323235, -1.2998771573086019],
                                [47.303169978196514, -1.3051085022277937],
                                [47.24985628237829, -1.2541747505718956],
                                [47.25058116645216, -1.1977216097650178],
                                [47.17778408754902, -1.1632160710080481],
                                [47.138781593624955, -1.2352482689031201],
                                [47.10995454752667, -1.2311457136088386],
                                [47.06256455498823, -1.1154625363954862],
                                [47.02954516258657, -1.1485704887534407],
                                [47.00568547430042, -1.0554031085144766],
                                [47.00890804339756, -0.9334603151811864],
                                [46.97581784960786, -0.8919599503022404],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "49", "NOM_DEPT": "MAINE-ET-LOIRE"},
                },
                30: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            45.45570734978023,
                            4.280409632428634,
                            46.30219481477719,
                            5.131048366350085,
                        ),
                        "coordinates": [
                            [
                                [45.81337808264366, 5.101067478338777],
                                [45.80399936996712, 4.923799133458053],
                                [45.90461654376232, 4.8645021533563355],
                                [45.949092212302176, 4.729096921230878],
                                [45.97362201497272, 4.7546312797683195],
                                [46.04720888365027, 4.739530214170903],
                                [46.0941499665971, 4.750325275584826],
                                [46.140701464361854, 4.797433206939167],
                                [46.17667702271938, 4.780213475718984],
                                [46.178372127719896, 4.730529789085251],
                                [46.30219481477719, 4.693107175516046],
                                [46.26479308755153, 4.618551541036954],
                                [46.26712984788543, 4.503987529872384],
                                [46.29606050757101, 4.405813600867753],
                                [46.21978851671502, 4.388079599211451],
                                [46.16787882969538, 4.438590902796802],
                                [46.12922273900979, 4.321566636697419],
                                [46.05294444469335, 4.280409632428634],
                                [46.02122907041072, 4.30609575897843],
                                [45.95339953385286, 4.2939122642052165],
                                [45.9005013366276, 4.3239261660748465],
                                [45.86399385908122, 4.383032288498641],
                                [45.754934723712715, 4.391252031699621],
                                [45.69851909472673, 4.365516200673114],
                                [45.63205080632734, 4.410284239143386],
                                [45.57325450372858, 4.5197664589356545],
                                [45.575468343903715, 4.614858045826019],
                                [45.48675363928719, 4.661741865018664],
                                [45.49429755062865, 4.722336796597095],
                                [45.45570734978023, 4.756935570818616],
                                [45.5234402120416, 4.868481734036511],
                                [45.5723005698916, 4.808696981728118],
                                [45.60626780465844, 4.901457719834113],
                                [45.63720294798378, 5.035148740524161],
                                [45.70770885564475, 5.131048366350085],
                                [45.73945335950924, 5.094526879742294],
                                [45.81337808264366, 5.101067478338777],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "69", "NOM_DEPT": "RHONE"},
                },
                31: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            48.67016796018795,
                            0.2972244202906149,
                            49.47786858986832,
                            1.775628840636083,
                        ),
                        "coordinates": [
                            [
                                [49.409224988863485, 1.7139375433100608],
                                [49.39898608539559, 1.6593030583878112],
                                [49.440143979724375, 1.5754225666575],
                                [49.45649644272496, 1.4121220377546604],
                                [49.44805852414146, 1.3452333638981178],
                                [49.346289233389804, 1.2721366387570638],
                                [49.3419941567295, 1.1602558424773857],
                                [49.30984205819146, 1.133993537971445],
                                [49.2978832323054, 1.0481488434094983],
                                [49.252262976528414, 1.0133166256832071],
                                [49.33855254623689, 0.9214023473164947],
                                [49.38546058453573, 0.9181193706199334],
                                [49.41958304773064, 0.7648660757667747],
                                [49.402002347911484, 0.6652914150341133],
                                [49.43363577759451, 0.5818886055232164],
                                [49.47786858986832, 0.5249403531988144],
                                [49.44093130606127, 0.33898282435946203],
                                [49.429861637283, 0.2972244202906149],
                                [49.29699256482139, 0.32302317286212956],
                                [49.264016474812756, 0.382786744119418],
                                [49.15011747492428, 0.39468800874102034],
                                [49.130194368095964, 0.42487479285721214],
                                [49.04945033019972, 0.37767980975475124],
                                [49.008190235684026, 0.43675135320661196],
                                [48.95062636769437, 0.4128145328890876],
                                [48.91041450585283, 0.3861893489650419],
                                [48.87976248181588, 0.4573579962478969],
                                [48.875537831571705, 0.5525030083730612],
                                [48.83131414903287, 0.6102938086141846],
                                [48.78336423502616, 0.7335062460350473],
                                [48.73752726458569, 0.7749590431141294],
                                [48.7052077986587, 0.7305886446296774],
                                [48.67016796018795, 0.8148191028635925],
                                [48.7154924458169, 0.8767072376479725],
                                [48.7305834560073, 1.0316566693561058],
                                [48.77263016325768, 1.184730602501536],
                                [48.760965095552265, 1.319548414059536],
                                [48.79176905228099, 1.376964009060968],
                                [48.83417900337295, 1.3621810029001882],
                                [48.89221734449297, 1.4683503712150041],
                                [48.94105360615515, 1.5015238197988665],
                                [49.026291046220386, 1.4577625828067997],
                                [49.06854572684407, 1.5217661561843225],
                                [49.07789415353795, 1.6087960706299216],
                                [49.13016217033745, 1.655777439712795],
                                [49.211867057756656, 1.6757368125175731],
                                [49.232201775163404, 1.7043642065965865],
                                [49.26446416218004, 1.7104793339744566],
                                [49.2996937213467, 1.775628840636083],
                                [49.368149815393046, 1.759411755988114],
                                [49.409224988863485, 1.7139375433100608],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "27", "NOM_DEPT": "EURE"},
                },
                32: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            43.693077287037454,
                            1.8395995416341195,
                            44.94122218473673,
                            3.4507554815828207,
                        ),
                        "coordinates": [
                            [
                                [44.14945256348434, 1.9901707126503436],
                                [44.194394561916845, 2.106128564722785],
                                [44.19771468052574, 2.152470897558622],
                                [44.09349085014796, 2.389213772232005],
                                [44.055848637246484, 2.4102102719432614],
                                [44.05139799957896, 2.459937005782879],
                                [43.98128240119407, 2.522933752458295],
                                [43.95058625773123, 2.4993471763625212],
                                [43.921379933748845, 2.554997490001796],
                                [43.841331088723116, 2.564162540693876],
                                [43.7439636033151, 2.6813058930169467],
                                [43.72904476801738, 2.742838073038075],
                                [43.76171872931413, 2.813673557986314],
                                [43.73611367807565, 2.9211070453325663],
                                [43.694667785188855, 2.9354629666803715],
                                [43.708516252330526, 2.98535037366361],
                                [43.693077287037454, 3.060740509271366],
                                [43.83164737994541, 3.0598559764719786],
                                [43.81387268634425, 3.203111724562128],
                                [43.89835231151905, 3.275074750407491],
                                [43.913832893255, 3.3583594413044624],
                                [44.02078728434533, 3.4507554815828207],
                                [44.0790299038748, 3.3289104186209886],
                                [44.158672362655494, 3.3360602348274],
                                [44.17075587210565, 3.3736480448306843],
                                [44.197910434234956, 3.3577995033411128],
                                [44.22625501460891, 3.2298475773263053],
                                [44.2844635736958, 3.1252288254578002],
                                [44.30837023621564, 3.1542516260589815],
                                [44.38337811871574, 3.119711177226503],
                                [44.454870231099065, 3.13573609856136],
                                [44.50348970314472, 3.068542786200033],
                                [44.559014394432964, 3.083593896775788],
                                [44.6446766126243, 2.981676986530433],
                                [44.72863892315705, 2.9232644794453155],
                                [44.779198272865976, 2.9345215070232764],
                                [44.8030106101463, 2.8795722036394493],
                                [44.87148933996955, 2.8496583078406252],
                                [44.87362935290199, 2.8019551055054883],
                                [44.94122218473673, 2.738254293313791],
                                [44.9072261221646, 2.70643491497566],
                                [44.843167608376426, 2.6026810523917403],
                                [44.79280887269849, 2.5993575445949],
                                [44.77575324565893, 2.562709168390778],
                                [44.721284895454446, 2.556123813120712],
                                [44.63887764359621, 2.4350033478315978],
                                [44.66969245597248, 2.326785795750648],
                                [44.643844101683406, 2.208413991565611],
                                [44.61553167652982, 2.2074752855308404],
                                [44.5719014562647, 2.1538165441705135],
                                [44.58290555966192, 2.0573690252842414],
                                [44.50639427715403, 1.9314678023099068],
                                [44.475900168970036, 1.8395995416341195],
                                [44.340065248844205, 1.882082857535903],
                                [44.27911646341683, 1.901390505373501],
                                [44.27643627943402, 1.9704438024330744],
                                [44.20432736443666, 1.9021988872029416],
                                [44.17992355171284, 1.976683004728593],
                                [44.14945256348434, 1.9901707126503436],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "12", "NOM_DEPT": "AVEYRON"},
                },
                33: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            45.68060482956175,
                            1.3749003074212889,
                            46.43091738935583,
                            2.5944189201416936,
                        ),
                        "coordinates": [
                            [
                                [46.4240665008181, 2.167785718138384],
                                [46.40890318674807, 2.088941803334241],
                                [46.43091738935583, 1.9930823669027022],
                                [46.4300383389509, 1.819500417665562],
                                [46.38895871366094, 1.7277108990817451],
                                [46.386815849085174, 1.6448464161558107],
                                [46.42652499450048, 1.5223068332769552],
                                [46.34721849587296, 1.4151905101137503],
                                [46.305894207375275, 1.4437697350516507],
                                [46.21545110095231, 1.3749003074212889],
                                [46.17975461207027, 1.4527947858284072],
                                [46.03541014153877, 1.5491757848158922],
                                [45.95280423814569, 1.5325001755915217],
                                [45.9334124264404, 1.6087196458716777],
                                [45.85746515857901, 1.6023984681707657],
                                [45.835114020235736, 1.6766374034760068],
                                [45.84282757445294, 1.7727491731275804],
                                [45.797714818456456, 1.8808988285366512],
                                [45.7327797889896, 1.875140102478583],
                                [45.6982775512041, 1.898730779182943],
                                [45.755490360800245, 2.01760876898307],
                                [45.724775065025135, 2.113545472759344],
                                [45.73221596168252, 2.17435335428623],
                                [45.699047103880844, 2.1939584682323856],
                                [45.68060482956175, 2.3377545093277403],
                                [45.70947892430507, 2.3491828014700613],
                                [45.699275061444226, 2.4358558482207813],
                                [45.73767009540705, 2.4921255582417543],
                                [45.76985735244724, 2.434118730275934],
                                [45.82737590512424, 2.3880204308712214],
                                [45.86301255580736, 2.4425852582122802],
                                [45.86402992467917, 2.4922254101808226],
                                [45.98944187163357, 2.5944189201416936],
                                [46.11407139955365, 2.5490476236021444],
                                [46.143032182829025, 2.5653790586982073],
                                [46.23943958277255, 2.51631108338946],
                                [46.281147774598125, 2.478940668864652],
                                [46.329982476677515, 2.3918607677139923],
                                [46.32927925675374, 2.3230243720211274],
                                [46.42040537318102, 2.2810476101300576],
                                [46.4240665008181, 2.167785718138384],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "23", "NOM_DEPT": "CREUSE"},
                },
                34: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            47.48789924167961,
                            1.512975755811939,
                            48.320719459436056,
                            3.1284501214452565,
                        ),
                        "coordinates": [
                            [
                                [48.16339174416305, 2.936314411640624],
                                [48.16827665011798, 2.7989445730680167],
                                [48.124819245820404, 2.7065470696044738],
                                [48.140648103275275, 2.5381092459271755],
                                [48.23853573046793, 2.506191747348858],
                                [48.26029732659769, 2.4237635277023717],
                                [48.320719459436056, 2.402664267131608],
                                [48.308672482875515, 2.369810541415244],
                                [48.313745436024625, 2.1813499926674265],
                                [48.28658587795804, 1.9940847180593788],
                                [48.2554662453119, 1.9654790051841269],
                                [48.08385719873065, 1.8656712589157682],
                                [48.066144349606105, 1.7448338583126362],
                                [48.06722274292945, 1.6245928719693987],
                                [48.03069992075931, 1.5941156652809596],
                                [48.02872178085822, 1.512975755811939],
                                [47.98227847700271, 1.5201238283340488],
                                [47.92911358021597, 1.5254235639039049],
                                [47.87642659620686, 1.5881377383696464],
                                [47.820525929167275, 1.5337009096463892],
                                [47.76976159023591, 1.5478779921036048],
                                [47.738393484182936, 1.6973528002323046],
                                [47.66153396919206, 1.739938252775079],
                                [47.63843148089739, 1.7985957016041196],
                                [47.68635321601097, 1.8436947697611497],
                                [47.675630779123125, 1.9424229848119656],
                                [47.67814460516368, 2.20255850774907],
                                [47.62097830787993, 2.2392136309887465],
                                [47.6289623689043, 2.286237981293774],
                                [47.58552457239423, 2.3730210260695963],
                                [47.60977811486517, 2.4373472313231086],
                                [47.568295437652175, 2.491358293796867],
                                [47.55368570340879, 2.599892421980175],
                                [47.48789924167961, 2.658459112358834],
                                [47.49216663238491, 2.7193534234556664],
                                [47.523527275666915, 2.7680263231364863],
                                [47.49445932903693, 2.8064837781833747],
                                [47.520423112556664, 2.8746252064056805],
                                [47.565970182735235, 2.914297452553034],
                                [47.56942879711256, 2.9765380120036067],
                                [47.598884707750464, 2.937999037836789],
                                [47.68055969848399, 2.9231098081748264],
                                [47.71199289202637, 2.8585180302225814],
                                [47.7609264707902, 2.8566660682192713],
                                [47.7632462761762, 2.9350577707343026],
                                [47.786554679015424, 3.023798094359226],
                                [47.90471697202148, 3.0102926272319244],
                                [47.911447449150096, 3.0501042789379826],
                                [47.97097324036121, 3.1284501214452565],
                                [48.05393639482612, 3.0883177986514796],
                                [48.07233413114024, 3.0504714242752176],
                                [48.13320717201307, 3.0294654865478936],
                                [48.16339174416305, 2.936314411640624],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "45", "NOM_DEPT": "LOIRET"},
                },
                35: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            47.26053058451154,
                            5.374078595885573,
                            48.015666213333766,
                            6.823538854548165,
                        ),
                        "coordinates": [
                            [
                                [47.81305372460471, 6.823538854548165],
                                [47.84962275518448, 6.784821909572193],
                                [47.904021106485565, 6.645533181556614],
                                [47.944398619135356, 6.601781921638085],
                                [47.9026105653117, 6.5421528235861155],
                                [47.885521773703914, 6.4786018541765715],
                                [47.94381595263879, 6.431707255957785],
                                [47.961944790786475, 6.366146412024702],
                                [47.93284210199926, 6.237987058178878],
                                [47.95235039238132, 6.167984818891344],
                                [48.00694405924028, 6.156057875261972],
                                [48.015666213333766, 6.072563808399439],
                                [47.956089699040746, 6.002262047573574],
                                [47.97971039136252, 5.94752101881473],
                                [47.92604714858532, 5.884726375202079],
                                [47.86817605973291, 5.821435400588568],
                                [47.85933449218556, 5.7611912388659805],
                                [47.81860389080509, 5.690283323540387],
                                [47.77915825542385, 5.676611542335574],
                                [47.74481735499545, 5.709213007321317],
                                [47.68483888152057, 5.690066479915616],
                                [47.67168603173905, 5.596682241448044],
                                [47.68460287491279, 5.482567919490752],
                                [47.67340074449039, 5.406342872021028],
                                [47.60454165280248, 5.374078595885573],
                                [47.63211377458532, 5.425863186006296],
                                [47.60872207291229, 5.477547427463133],
                                [47.54414450478295, 5.496859255517604],
                                [47.496253655362196, 5.447063511552309],
                                [47.49901446301563, 5.3992024955272315],
                                [47.384062513467185, 5.451397515008267],
                                [47.30418661946959, 5.518538729512594],
                                [47.26053058451154, 5.602110210787404],
                                [47.26499677497705, 5.698725742766406],
                                [47.34425359386964, 5.94137455282545],
                                [47.327623386353956, 5.989355047833264],
                                [47.35403647499406, 6.080045800270596],
                                [47.430569873278635, 6.262328582663191],
                                [47.50596607054917, 6.334353737417102],
                                [47.52029975346226, 6.401377017027886],
                                [47.492797262167244, 6.55356252302069],
                                [47.53987013332597, 6.5817761531248],
                                [47.535260638072835, 6.646719240296149],
                                [47.562955627817956, 6.685554362876694],
                                [47.53641528724466, 6.780972040773947],
                                [47.56280181879927, 6.806992048333126],
                                [47.62526070546134, 6.780404771904787],
                                [47.747877966491, 6.757638483670513],
                                [47.81305372460471, 6.823538854548165],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "70", "NOM_DEPT": "HAUTE-SAONE"},
                },
                36: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            45.28712067830808,
                            2.3880204308712214,
                            46.255486129901755,
                            3.9751057509236487,
                        ),
                        "coordinates": [
                            [
                                [45.93073235641238, 3.6940178008729885],
                                [46.02413780633835, 3.5884696050346547],
                                [46.017936870152774, 3.4635034430082112],
                                [46.074292455804986, 3.419029561174583],
                                [46.05506094849443, 3.371595622264062],
                                [46.06567797651341, 3.166531859715606],
                                [46.12178012989871, 2.971756635840471],
                                [46.20349381071083, 2.9095928618303133],
                                [46.242917468274975, 2.9371457775851466],
                                [46.255486129901755, 2.8557252864968374],
                                [46.19621262362186, 2.810275114252155],
                                [46.223324326165475, 2.733052145656418],
                                [46.11847766171901, 2.6406912317167386],
                                [46.143032182829025, 2.5653790586982073],
                                [46.11407139955365, 2.5490476236021444],
                                [45.98944187163357, 2.5944189201416936],
                                [45.86402992467917, 2.4922254101808226],
                                [45.86301255580736, 2.4425852582122802],
                                [45.82737590512424, 2.3880204308712214],
                                [45.76985735244724, 2.434118730275934],
                                [45.73767009540705, 2.4921255582417543],
                                [45.681924336473706, 2.5283647797478266],
                                [45.639532080177666, 2.514296706686258],
                                [45.60082287582866, 2.46534961788347],
                                [45.553426613923115, 2.516332317304299],
                                [45.47849879874484, 2.508408697113082],
                                [45.44265505156296, 2.651429936294738],
                                [45.38155782083131, 2.714857227145231],
                                [45.3923406923832, 2.852378684057164],
                                [45.3657751174624, 2.9215557561638335],
                                [45.309125835256815, 2.9486247512965202],
                                [45.28712067830808, 3.016710134630249],
                                [45.35437310008832, 3.1034981328800555],
                                [45.352259807508005, 3.1680632240379363],
                                [45.40182189242603, 3.290691872112179],
                                [45.40028672539169, 3.4567465988864985],
                                [45.42757868705258, 3.501320580432494],
                                [45.3383456593203, 3.625846869344361],
                                [45.37619709113048, 3.667209012708465],
                                [45.349191883525556, 3.7722554467335283],
                                [45.39161196684209, 3.8083099578489272],
                                [45.357083781715595, 3.897408424881887],
                                [45.410307649293415, 3.899187761612733],
                                [45.44826954913943, 3.9751057509236487],
                                [45.555962683335494, 3.954348408158434],
                                [45.5990224663249, 3.903596234209209],
                                [45.63241694241681, 3.823453198078696],
                                [45.72434927186397, 3.7808499481107716],
                                [45.783181674804744, 3.699758022143211],
                                [45.88603083611283, 3.7543707578917007],
                                [45.93073235641238, 3.6940178008729885],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "63", "NOM_DEPT": "PUY-DE-DOME"},
                },
                37: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            43.395686947410056,
                            1.5522914897522986,
                            44.19771468052574,
                            2.9354629666803715,
                        ),
                        "coordinates": [
                            [
                                [43.91831715512138, 1.5556171726831818],
                                [43.868315400129546, 1.5554632454868464],
                                [43.815488439336, 1.5910292905659653],
                                [43.800257495357435, 1.644787627039312],
                                [43.74183402488211, 1.6604214137506872],
                                [43.71621951436253, 1.7064455963184253],
                                [43.65775037692843, 1.730869381606712],
                                [43.63070037401987, 1.687771093611741],
                                [43.5808317662611, 1.824800921390715],
                                [43.520928759682434, 1.882609451533412],
                                [43.47035021960434, 2.018141282533191],
                                [43.43689796484212, 2.02913283879736],
                                [43.395686947410056, 2.0728007398118375],
                                [43.43176717254867, 2.2241677335019907],
                                [43.4599295251568, 2.2591004793801175],
                                [43.418670700931195, 2.4036304838758644],
                                [43.43517605493273, 2.4331017858919792],
                                [43.422959744104, 2.5657873980365586],
                                [43.431093773006396, 2.606081177961043],
                                [43.48016355800575, 2.6595399785833935],
                                [43.525794099032574, 2.658651329156613],
                                [43.56663335506618, 2.615607192520078],
                                [43.650146162495055, 2.6432637215975134],
                                [43.64559678398747, 2.711169474843746],
                                [43.6141387864358, 2.7545235571938624],
                                [43.66002074537221, 2.9159815194674086],
                                [43.694667785188855, 2.9354629666803715],
                                [43.73611367807565, 2.9211070453325663],
                                [43.76171872931413, 2.813673557986314],
                                [43.72904476801738, 2.742838073038075],
                                [43.7439636033151, 2.6813058930169467],
                                [43.841331088723116, 2.564162540693876],
                                [43.921379933748845, 2.554997490001796],
                                [43.95058625773123, 2.4993471763625212],
                                [43.98128240119407, 2.522933752458295],
                                [44.05139799957896, 2.459937005782879],
                                [44.055848637246484, 2.4102102719432614],
                                [44.09349085014796, 2.389213772232005],
                                [44.19771468052574, 2.152470897558622],
                                [44.194394561916845, 2.106128564722785],
                                [44.14945256348434, 1.9901707126503436],
                                [44.16294029634056, 1.9196921618272453],
                                [44.14369109998093, 1.8417039588173185],
                                [44.09681615657593, 1.7775202074591068],
                                [44.116267124994856, 1.7455400915583978],
                                [44.11641211601675, 1.6589585652250582],
                                [44.02434074044873, 1.6913900365689167],
                                [43.974001636165994, 1.6185715580365614],
                                [43.96302664758977, 1.5522914897522986],
                                [43.91831715512138, 1.5556171726831818],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "81", "NOM_DEPT": "TARN"},
                },
                38: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            49.252262976528414,
                            0.06560687754986201,
                            50.06501467638129,
                            1.7838370588623413,
                        ),
                        "coordinates": [
                            [
                                [49.75830750106765, 1.7838370588623413],
                                [49.828884105223665, 1.7270555289768348],
                                [49.91813416149145, 1.6784506742272387],
                                [50.037833342652824, 1.4564621593341673],
                                [50.06501467638129, 1.379705037415187],
                                [49.96803785451211, 1.1943823852499285],
                                [49.92561385766795, 1.0659015382478343],
                                [49.919857551513566, 0.9631874837108026],
                                [49.872095613532025, 0.7697293792067499],
                                [49.84972067059468, 0.5729399803584807],
                                [49.74154748097868, 0.32055875091141733],
                                [49.71446864261743, 0.2116632434482712],
                                [49.648642302677665, 0.1545347165457159],
                                [49.51257112097312, 0.06560687754986201],
                                [49.46319090812617, 0.12124538314126901],
                                [49.44093130606127, 0.33898282435946203],
                                [49.47786858986832, 0.5249403531988144],
                                [49.43363577759451, 0.5818886055232164],
                                [49.402002347911484, 0.6652914150341133],
                                [49.41958304773064, 0.7648660757667747],
                                [49.38546058453573, 0.9181193706199334],
                                [49.33855254623689, 0.9214023473164947],
                                [49.252262976528414, 1.0133166256832071],
                                [49.2978832323054, 1.0481488434094983],
                                [49.30984205819146, 1.133993537971445],
                                [49.3419941567295, 1.1602558424773857],
                                [49.346289233389804, 1.2721366387570638],
                                [49.44805852414146, 1.3452333638981178],
                                [49.45649644272496, 1.4121220377546604],
                                [49.440143979724375, 1.5754225666575],
                                [49.39898608539559, 1.6593030583878112],
                                [49.409224988863485, 1.7139375433100608],
                                [49.466150363724154, 1.7663450271414043],
                                [49.50822302010687, 1.7192326604453183],
                                [49.531737693641695, 1.7451334451250167],
                                [49.60539892585883, 1.7045819685135704],
                                [49.67263435960493, 1.7252046142437356],
                                [49.69478564626097, 1.689575882111812],
                                [49.75830750106765, 1.7838370588623413],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "76", "NOM_DEPT": "SEINE-MARITIME"},
                },
                39: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            47.60454165280248,
                            4.653455248176321,
                            48.68871245199127,
                            5.884726375202079,
                        ),
                        "coordinates": [
                            [
                                [48.53188730232318, 4.670183207291811],
                                [48.47054866778951, 4.653455248176321],
                                [48.39485512882371, 4.716095686333967],
                                [48.347359803339394, 4.809737759938721],
                                [48.26363849150269, 4.858919933219106],
                                [48.141758855401065, 4.850099917169891],
                                [48.10319242347872, 4.8193072949588815],
                                [48.11820899819213, 4.730610406781701],
                                [48.07312791926578, 4.688818526238874],
                                [48.0202323762219, 4.704238250439468],
                                [48.00782938257308, 4.789083695644797],
                                [47.9642022255857, 4.78651260287447],
                                [47.956238623224316, 4.852043179350452],
                                [47.866768148099496, 4.9540942495981195],
                                [47.80034738345194, 4.982400768988487],
                                [47.76500253040028, 4.949610301299183],
                                [47.68776283651174, 4.979107142832904],
                                [47.64968494441666, 5.108878229414663],
                                [47.65256871238262, 5.173597037303847],
                                [47.61613009899267, 5.239232274239111],
                                [47.60454165280248, 5.374078595885573],
                                [47.67340074449039, 5.406342872021028],
                                [47.68460287491279, 5.482567919490752],
                                [47.67168603173905, 5.596682241448044],
                                [47.68483888152057, 5.690066479915616],
                                [47.74481735499545, 5.709213007321317],
                                [47.77915825542385, 5.676611542335574],
                                [47.81860389080509, 5.690283323540387],
                                [47.85933449218556, 5.7611912388659805],
                                [47.86817605973291, 5.821435400588568],
                                [47.92604714858532, 5.884726375202079],
                                [47.96283504724515, 5.850003923490582],
                                [47.95259697311841, 5.787280985479235],
                                [48.03136192327879, 5.77774789858366],
                                [48.07722956641849, 5.696798789098754],
                                [48.08398621524326, 5.630534001339329],
                                [48.14504209498631, 5.68431870758825],
                                [48.21992832819691, 5.710843767915566],
                                [48.24235420494441, 5.640901189478503],
                                [48.35620132426793, 5.482149185087856],
                                [48.38310019043651, 5.408721169498744],
                                [48.42092912174115, 5.470048195176172],
                                [48.48198867902053, 5.349469998299744],
                                [48.53861075457746, 5.208425883036941],
                                [48.59551086053376, 5.118346103266606],
                                [48.59572522098937, 5.070888258264775],
                                [48.634035501163716, 5.005925627052495],
                                [48.684418562233176, 4.988427677798425],
                                [48.68871245199127, 4.911268319875394],
                                [48.64966704551767, 4.84196138973274],
                                [48.62363257092489, 4.84925614314003],
                                [48.588688310630296, 4.769195892207036],
                                [48.52977987624909, 4.799180099828292],
                                [48.53188730232318, 4.670183207291811],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "52", "NOM_DEPT": "HAUTE-MARNE"},
                },
                40: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            43.460185432726384,
                            3.3289104186209886,
                            44.45979755586323,
                            4.842093969959472,
                        ),
                        "coordinates": [
                            [
                                [44.27035986501095, 4.649223666100485],
                                [44.30244463260489, 4.55869985714841],
                                [44.34018845123076, 4.503536213064646],
                                [44.33952274370027, 4.336073225463424],
                                [44.314658687843355, 4.288416558058853],
                                [44.26478557642796, 4.2588461979825505],
                                [44.31335085540007, 4.142867700090412],
                                [44.317323657117, 4.051451662788466],
                                [44.40511357294199, 4.068441217053273],
                                [44.45979755586323, 3.998162987763964],
                                [44.399567503492314, 3.944362317344653],
                                [44.387999052346906, 3.8859181039452233],
                                [44.32838999677705, 3.952331315351652],
                                [44.305217941025674, 3.922858913740669],
                                [44.247795429889, 3.9513171396124562],
                                [44.1707937260686, 3.9526044819739092],
                                [44.130073752440985, 3.862104986455048],
                                [44.12738907948688, 3.7969951126604835],
                                [44.18275878035751, 3.678640671819198],
                                [44.175488044182295, 3.637769161351025],
                                [44.122695330490544, 3.633491144032294],
                                [44.12909826593223, 3.4397298934659637],
                                [44.17075587210565, 3.3736480448306843],
                                [44.158672362655494, 3.3360602348274],
                                [44.0790299038748, 3.3289104186209886],
                                [44.02078728434533, 3.4507554815828207],
                                [43.913832893255, 3.3583594413044624],
                                [43.91159816844731, 3.424448067668623],
                                [43.855624713961625, 3.5307009207380955],
                                [43.86552224087741, 3.5754482408134063],
                                [43.916978566757564, 3.623588615095356],
                                [43.96901626259538, 3.726990344828379],
                                [43.96687037520115, 3.787325021892116],
                                [43.91929773950883, 3.824905456819552],
                                [43.8664240348707, 3.830797043559706],
                                [43.88559322066372, 3.917385092127717],
                                [43.81146444231582, 4.002046166191344],
                                [43.73388653553411, 4.144780927023586],
                                [43.654303826233026, 4.194441206758988],
                                [43.585562468156866, 4.150215691493674],
                                [43.554370946408625, 4.1010416754063925],
                                [43.53189642273346, 4.13912342859037],
                                [43.481945925465276, 4.13766421830876],
                                [43.460185432726384, 4.230283393392478],
                                [43.49762691783989, 4.238105541141803],
                                [43.5611278006361, 4.409349673740098],
                                [43.62067757183952, 4.4270280421178025],
                                [43.69923776661919, 4.487236861293796],
                                [43.68746240297296, 4.593032248301324],
                                [43.80640869163021, 4.654821446467849],
                                [43.86747754714164, 4.641909591242105],
                                [43.924059473490566, 4.739060856654237],
                                [43.98647454846487, 4.842093969959472],
                                [44.06505409747017, 4.787978024928094],
                                [44.10367246401243, 4.707458356688192],
                                [44.18742154948268, 4.722074664233517],
                                [44.27035986501095, 4.649223666100485],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "30", "NOM_DEPT": "GARD"},
                },
                41: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            48.12036852181815,
                            6.964601688658047,
                            49.06411681072389,
                            8.214337990422155,
                        ),
                        "coordinates": [
                            [
                                [48.31046786103526, 7.198281537029947],
                                [48.30523478706437, 7.275183721811301],
                                [48.24719461957464, 7.348562541549848],
                                [48.20353668429841, 7.476943375699941],
                                [48.161014524040404, 7.470560946722399],
                                [48.12611186664672, 7.519368638022094],
                                [48.12036852181815, 7.577312855212316],
                                [48.223910814477854, 7.667802806274936],
                                [48.30881209287648, 7.7031402606000405],
                                [48.32174822909557, 7.7398807675883825],
                                [48.40415792790444, 7.7359757519993035],
                                [48.489658145871125, 7.768185493209044],
                                [48.513571471609616, 7.805195566047566],
                                [48.59233465434716, 7.804169862129347],
                                [48.641373985105616, 7.83981724689541],
                                [48.7213530972908, 7.9631400450945655],
                                [48.757628209852165, 7.971745157755574],
                                [48.81038371014785, 8.096320563319823],
                                [48.9038081988035, 8.14793847273242],
                                [48.97509304800346, 8.214337990422155],
                                [48.98925821691501, 8.091376040143569],
                                [49.057809150306376, 7.934626827531663],
                                [49.03415707326485, 7.868785609773862],
                                [49.06411681072389, 7.800436670933281],
                                [49.04436019362859, 7.732229514556395],
                                [49.0541613551771, 7.635285449703197],
                                [48.95740241810784, 7.57839213753989],
                                [48.932961584940934, 7.5382590392502085],
                                [48.96577914855414, 7.446887904100119],
                                [48.94337274202096, 7.326851980608825],
                                [48.97341645090749, 7.293048848802893],
                                [49.006365681338195, 7.174240270723143],
                                [49.04411352331478, 7.107657105402387],
                                [49.03061918771655, 7.054911912536334],
                                [48.95992878867804, 6.98921640979739],
                                [48.90452526765522, 6.964601688658047],
                                [48.87154914036644, 7.0453428905310576],
                                [48.813704386223854, 7.054514540544794],
                                [48.801142358200266, 7.126799106595456],
                                [48.84470403837187, 7.149408408912651],
                                [48.76730084431057, 7.311900506296782],
                                [48.69154313190619, 7.242487615031407],
                                [48.63810720117092, 7.283044927480475],
                                [48.588675507652006, 7.256281654444217],
                                [48.52759644354931, 7.167909935894844],
                                [48.536417612700156, 7.079359770973246],
                                [48.51359226555661, 7.123165369028565],
                                [48.40564467453035, 7.097427065168084],
                                [48.33329037920514, 7.121908440975998],
                                [48.31046786103526, 7.198281537029947],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "67", "NOM_DEPT": "BAS-RHIN"},
                },
                42: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            42.66391836976527,
                            1.688419720914751,
                            43.4599295251568,
                            3.24056113717041,
                        ),
                        "coordinates": [
                            [
                                [43.21280863308409, 3.24056113717041],
                                [43.24916714805367, 3.2010265503923754],
                                [43.24700506844496, 3.1472079664155532],
                                [43.28853825294427, 3.004740938100306],
                                [43.32013114159761, 3.004349268167806],
                                [43.322412805617326, 2.8327620472635995],
                                [43.25778564580618, 2.772248225673249],
                                [43.298706986396866, 2.6016030790296316],
                                [43.34622186231968, 2.5399619094859687],
                                [43.422959744104, 2.5657873980365586],
                                [43.43517605493273, 2.4331017858919792],
                                [43.418670700931195, 2.4036304838758644],
                                [43.4599295251568, 2.2591004793801175],
                                [43.43176717254867, 2.2241677335019907],
                                [43.395686947410056, 2.0728007398118375],
                                [43.43689796484212, 2.02913283879736],
                                [43.40405939980915, 1.9101007956285103],
                                [43.44382089121736, 1.8587429714302222],
                                [43.391684804856155, 1.8040846789340412],
                                [43.341403596986645, 1.81342406452215],
                                [43.3437401011229, 1.747732597304773],
                                [43.27355372810048, 1.688419720914751],
                                [43.224524250769015, 1.723844068753025],
                                [43.18969803410896, 1.710056447799201],
                                [43.14581388915534, 1.824772198868932],
                                [43.119494438163784, 1.9494758652019246],
                                [43.052715472626694, 1.941132873290632],
                                [43.02627232234234, 1.9851004481943353],
                                [42.87101168756058, 1.986920914223352],
                                [42.852669269026464, 1.8804739886198156],
                                [42.767667043480046, 1.9081798281291227],
                                [42.73670079860314, 1.9553956635295406],
                                [42.7562228612599, 2.057204243184995],
                                [42.6827952243106, 2.1758741195218594],
                                [42.66391836976527, 2.166053682054993],
                                [42.70779157620242, 2.322006120391769],
                                [42.73412195489036, 2.357535079462851],
                                [42.837442775831846, 2.327116045977923],
                                [42.83693276356474, 2.452474760710876],
                                [42.8498316897035, 2.5090117260388043],
                                [42.830431065988684, 2.697577646248594],
                                [42.837574151816995, 2.7400003158100112],
                                [42.89598872881156, 2.789053819259419],
                                [42.918341437261006, 2.8652738803519484],
                                [42.88486022074883, 2.917114990593263],
                                [42.83815011921807, 3.0434985865888815],
                                [42.917059904945106, 3.060589297455898],
                                [42.96015378799919, 3.0428431893335772],
                                [43.10183913719124, 3.1172205062222833],
                                [43.21280863308409, 3.24056113717041],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "11", "NOM_DEPT": "AUDE"},
                },
                43: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            48.124819245820404,
                            2.402664267131608,
                            49.117554218816146,
                            3.5556137492385345,
                        ),
                        "coordinates": [
                            [
                                [48.16339174416305, 2.936314411640624],
                                [48.20767000036061, 3.0051556578134635],
                                [48.27202235762727, 3.043627253848888],
                                [48.36012035556558, 3.0495188960927044],
                                [48.371860839526576, 3.167737573570585],
                                [48.37228068710627, 3.3651592673815314],
                                [48.39027303882033, 3.4147915595010967],
                                [48.424322153455364, 3.3919598867876517],
                                [48.533562692399734, 3.4234423807070566],
                                [48.604809134470905, 3.5038535314822115],
                                [48.62028467657408, 3.5556137492385345],
                                [48.65300999879329, 3.460426313142606],
                                [48.69935806711918, 3.476963643099447],
                                [48.75357171634101, 3.435808986802742],
                                [48.85190849437287, 3.4851874436586847],
                                [48.8646865193221, 3.4032194510047127],
                                [48.908706088642376, 3.3302994547269797],
                                [48.948764278944545, 3.3047494707754015],
                                [49.014123184303735, 3.171683982224406],
                                [49.09965085798759, 3.16523032905892],
                                [49.117554218816146, 3.071884293834167],
                                [49.09151015780461, 3.0085155429257675],
                                [49.06044982525112, 2.7350126834936956],
                                [49.10837621896304, 2.633272965218076],
                                [49.07965484673244, 2.5905242793946224],
                                [49.00981711743891, 2.55306064485419],
                                [48.92935660278061, 2.6025984314319826],
                                [48.888884130524836, 2.5626221662429587],
                                [48.8074366758147, 2.5922804883088015],
                                [48.761027192292545, 2.6136476481340414],
                                [48.69201409164603, 2.571660318442073],
                                [48.65733138882678, 2.53361600680745],
                                [48.603849771145576, 2.5437765144069613],
                                [48.525239048001154, 2.49952467433224],
                                [48.439446016118225, 2.504749755053753],
                                [48.41125114633111, 2.533731834361712],
                                [48.362015783117755, 2.429832228504419],
                                [48.320719459436056, 2.402664267131608],
                                [48.26029732659769, 2.4237635277023717],
                                [48.23853573046793, 2.506191747348858],
                                [48.140648103275275, 2.5381092459271755],
                                [48.124819245820404, 2.7065470696044738],
                                [48.16827665011798, 2.7989445730680167],
                                [48.16339174416305, 2.936314411640624],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "77", "NOM_DEPT": "SEINE-ET-MARNE"},
                },
                44: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            49.58141197178742,
                            1.379705037415187,
                            50.36186618072208,
                            3.1926752854802194,
                        ),
                        "coordinates": [
                            [
                                [50.05374055513492, 3.090253620620082],
                                [50.04217932424791, 2.87653264314694],
                                [50.07739311900277, 2.857843650412817],
                                [50.11341281005765, 2.576019813733672],
                                [50.141605436861035, 2.551329915710551],
                                [50.136999469996475, 2.4766865519087604],
                                [50.10064240686793, 2.4145079258525888],
                                [50.1554848214444, 2.3897770566865675],
                                [50.194562024118035, 2.4956903275727766],
                                [50.23030237700429, 2.4517852065078483],
                                [50.20977035832257, 2.370204907638782],
                                [50.226839899619605, 2.2738282654200974],
                                [50.20554490563295, 2.0957483707167426],
                                [50.24882125974279, 2.0778202954555876],
                                [50.287428042736344, 1.9461316429136999],
                                [50.31177877534883, 1.9180007470953697],
                                [50.36186618072208, 1.7787842601942672],
                                [50.33101039989745, 1.670715509846568],
                                [50.35215320244089, 1.641543920995599],
                                [50.35032330173502, 1.5509358115042569],
                                [50.28266847458906, 1.537947734772934],
                                [50.255951023550146, 1.5902673346965241],
                                [50.16491841311899, 1.4787143993875134],
                                [50.110329098934855, 1.453881224461017],
                                [50.06501467638129, 1.379705037415187],
                                [50.037833342652824, 1.4564621593341673],
                                [49.91813416149145, 1.6784506742272387],
                                [49.828884105223665, 1.7270555289768348],
                                [49.75830750106765, 1.7838370588623413],
                                [49.69898823076107, 1.8938643249004958],
                                [49.71962996348948, 1.9332098221662726],
                                [49.68807409174484, 2.1214097069260887],
                                [49.70164087681329, 2.247168590692668],
                                [49.65626624025836, 2.373145663229162],
                                [49.639467268909165, 2.5047488992503943],
                                [49.59708062701417, 2.571493337841171],
                                [49.58141197178742, 2.670723151725744],
                                [49.625601863474394, 2.6891419821315017],
                                [49.6205860518149, 2.7994949073615056],
                                [49.65595422263167, 2.7936124229581845],
                                [49.702672388966874, 2.915712813038834],
                                [49.705968560150744, 3.1184031553047866],
                                [49.822415215784225, 3.078694114076548],
                                [49.91427637798353, 3.117968662907868],
                                [49.977464696263276, 3.1926752854802194],
                                [50.01199494467939, 3.1727072271768164],
                                [50.05374055513492, 3.090253620620082],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "80", "NOM_DEPT": "SOMME"},
                },
                45: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            44.743863434670935,
                            3.1034981328800555,
                            45.42757868705258,
                            4.483134616383878,
                        ),
                        "coordinates": [
                            [
                                [45.35437310008832, 3.1034981328800555],
                                [45.28418729762223, 3.1179979977042014],
                                [45.27197144658481, 3.222465248668949],
                                [45.12042440957931, 3.2880332175079103],
                                [45.09513611769881, 3.3257851579159827],
                                [45.03607778789878, 3.2972503187682016],
                                [45.014233878924166, 3.3471986847617567],
                                [44.971411709678975, 3.3613425807398936],
                                [44.94484250197586, 3.412834742275399],
                                [44.90076835769558, 3.4179705141646854],
                                [44.81537151910512, 3.475773707159976],
                                [44.83219404802294, 3.589348917106291],
                                [44.87542977006507, 3.5943359966689923],
                                [44.869938644505325, 3.6595223843815874],
                                [44.82877808873478, 3.666364914643008],
                                [44.83869734813899, 3.7406507355868404],
                                [44.743863434670935, 3.862527190139651],
                                [44.7954172172997, 3.937001123548729],
                                [44.83408100300616, 4.028374858328879],
                                [44.87316201331411, 4.039638866980704],
                                [44.87333360834132, 4.156154791813548],
                                [44.961336129386744, 4.221702631142119],
                                [44.99730682920296, 4.289827924670837],
                                [45.10483231156165, 4.375306064703463],
                                [45.1443595905019, 4.376558944791765],
                                [45.14083295591157, 4.443262789803058],
                                [45.23644648192783, 4.483134616383878],
                                [45.27542410166107, 4.418571110077436],
                                [45.264395356817886, 4.3625488691169565],
                                [45.33699593440974, 4.366534405291163],
                                [45.37098690693708, 4.308199323181692],
                                [45.39260487868634, 4.177926371804465],
                                [45.3428877136373, 4.02482405154612],
                                [45.37513435596747, 3.97965057221058],
                                [45.357083781715595, 3.897408424881887],
                                [45.39161196684209, 3.8083099578489272],
                                [45.349191883525556, 3.7722554467335283],
                                [45.37619709113048, 3.667209012708465],
                                [45.3383456593203, 3.625846869344361],
                                [45.42757868705258, 3.501320580432494],
                                [45.40028672539169, 3.4567465988864985],
                                [45.40182189242603, 3.290691872112179],
                                [45.352259807508005, 3.1680632240379363],
                                [45.35437310008832, 3.1034981328800555],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "43", "NOM_DEPT": "HAUTE-LOIRE"},
                },
                46: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            48.516104417807576,
                            3.435808986802742,
                            49.406181771288736,
                            5.036321445219878,
                        ),
                        "coordinates": [
                            [
                                [49.405642294757534, 4.047972977986833],
                                [49.359904159430094, 4.035496373111564],
                                [49.406181771288736, 3.9244337055179424],
                                [49.36458662943729, 3.8474771401321166],
                                [49.31515350351225, 3.646953205074641],
                                [49.18137302346899, 3.7043920469634597],
                                [49.151103693376655, 3.622246623748466],
                                [49.12069184512517, 3.600004656260229],
                                [49.04058839070318, 3.646307433571441],
                                [48.94407204131733, 3.6015984944904185],
                                [48.91214102895303, 3.528576443116953],
                                [48.85190849437287, 3.4851874436586847],
                                [48.75357171634101, 3.435808986802742],
                                [48.69935806711918, 3.476963643099447],
                                [48.65300999879329, 3.460426313142606],
                                [48.62028467657408, 3.5556137492385345],
                                [48.541298263185546, 3.634028277746641],
                                [48.53746785521082, 3.730879401425958],
                                [48.516104417807576, 3.822742058660399],
                                [48.60343162808371, 3.9492266572894206],
                                [48.66387541820995, 4.001695483416846],
                                [48.70106898077084, 4.080262439820496],
                                [48.70745423752744, 4.166386793257749],
                                [48.700277029531, 4.3255940122986445],
                                [48.615578923326495, 4.315905486866125],
                                [48.56126039348743, 4.40306312166006],
                                [48.525252271641655, 4.545406992928758],
                                [48.553807130712464, 4.614026636401957],
                                [48.53188730232318, 4.670183207291811],
                                [48.52977987624909, 4.799180099828292],
                                [48.588688310630296, 4.769195892207036],
                                [48.62363257092489, 4.84925614314003],
                                [48.64966704551767, 4.84196138973274],
                                [48.68871245199127, 4.911268319875394],
                                [48.684418562233176, 4.988427677798425],
                                [48.74183736486811, 4.990124563499124],
                                [48.81720971453768, 4.888760929797642],
                                [48.92214239512387, 4.9362093920054075],
                                [48.95690245547182, 5.030128675561755],
                                [49.024332549540816, 5.036321445219878],
                                [49.03495195077164, 5.0076814026818575],
                                [49.11490008827158, 4.992117611940037],
                                [49.18506820457861, 4.9397619983736725],
                                [49.23686584630137, 4.950989232683009],
                                [49.25907433894352, 4.8942062202820455],
                                [49.23576093816036, 4.826941205469512],
                                [49.256759043801544, 4.686074799511886],
                                [49.235656063432884, 4.625104107270341],
                                [49.296651189312385, 4.575868215345435],
                                [49.28064492915537, 4.422583188651028],
                                [49.32779732810991, 4.306756525620349],
                                [49.38225617648581, 4.24830818454738],
                                [49.40418703243856, 4.143169752612987],
                                [49.405642294757534, 4.047972977986833],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "51", "NOM_DEPT": "MARNE"},
                },
                47: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            42.674924581800944,
                            -0.3270821344018897,
                            43.60465738319822,
                            0.6274179241908857,
                        ),
                        "coordinates": [
                            [
                                [42.84937505970757, -0.31344286349808953],
                                [42.76846693245407, -0.14599159174135215],
                                [42.72082372641455, -0.10610940781291865],
                                [42.68438508509316, -0.010637584646292208],
                                [42.73648479569684, 0.1757204586573466],
                                [42.71581111366541, 0.259882956272081],
                                [42.674924581800944, 0.2928222485813244],
                                [42.72339183232152, 0.35962879548357923],
                                [42.69074972940033, 0.42927573387270157],
                                [42.69999034279792, 0.4777495403273698],
                                [42.728060641999555, 0.4550942250736491],
                                [42.828145214268325, 0.4588995164240373],
                                [42.87810749616207, 0.47730134412302644],
                                [42.870825923039746, 0.575935146951876],
                                [43.000102873234276, 0.6274179241908857],
                                [43.01746794817708, 0.5630044583601441],
                                [43.093864488407256, 0.5322696523895425],
                                [43.13127313187027, 0.4419985587106278],
                                [43.20914713009289, 0.5518748957180638],
                                [43.236102503746785, 0.5515684940570376],
                                [43.28903679046807, 0.6162800547565972],
                                [43.31088599158549, 0.6068109749570955],
                                [43.32618057240136, 0.4980338187920962],
                                [43.385790922905464, 0.2772545000281133],
                                [43.37118267445077, 0.1820312140000635],
                                [43.43291627195161, 0.13798238183895667],
                                [43.517369919818584, 0.11212423457670333],
                                [43.5188072498529, 0.056081443916197675],
                                [43.56554046143868, -0.0019248187812953763],
                                [43.60465738319822, -0.015780894995831136],
                                [43.5824058976317, -0.0967829732087753],
                                [43.512605402100824, -0.04013178615004061],
                                [43.43734927067611, -0.06903100203309719],
                                [43.42210994370382, 0.009598314167784467],
                                [43.300855792903974, -0.046122416801734976],
                                [43.27045317593498, -0.017007531250724548],
                                [43.180326663081885, -0.11770146168361191],
                                [43.128235959977104, -0.14613235140227182],
                                [43.11120001485185, -0.19098404402245117],
                                [43.033687539643886, -0.22395152380116173],
                                [42.98776781593242, -0.29155187666703314],
                                [42.93356279018236, -0.28159092548449965],
                                [42.915781623764374, -0.3270821344018897],
                                [42.84937505970757, -0.31344286349808953],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "65", "NOM_DEPT": "HAUTES-PYRENEES"},
                },
                48: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            44.224857733084384,
                            1.0090253989657332,
                            45.04628038727667,
                            2.2074752855308404,
                        ),
                        "coordinates": [
                            [
                                [44.577324783565565, 1.0751408247250978],
                                [44.53612714227498, 1.0131666459229496],
                                [44.480041109061666, 1.0090253989657332],
                                [44.378513265035394, 1.0640838318649108],
                                [44.327402883405846, 1.1079385683846072],
                                [44.23578619286305, 1.2813793816235721],
                                [44.224857733084384, 1.3803681196871467],
                                [44.263269755581916, 1.5205387676670992],
                                [44.29839388706526, 1.5691379539986452],
                                [44.28680580678515, 1.651620766314853],
                                [44.31381428140451, 1.6995029158165782],
                                [44.340065248844205, 1.882082857535903],
                                [44.475900168970036, 1.8395995416341195],
                                [44.50639427715403, 1.9314678023099068],
                                [44.58290555966192, 2.0573690252842414],
                                [44.5719014562647, 2.1538165441705135],
                                [44.61553167652982, 2.2074752855308404],
                                [44.63806619142596, 2.1694177928364122],
                                [44.75310757902523, 2.1534919160094748],
                                [44.790024398712326, 2.1716362748643747],
                                [44.87201148950672, 2.094212310672087],
                                [44.97650640551561, 2.062914291973062],
                                [44.978426771844674, 1.908156162007897],
                                [44.927682448456935, 1.8239145263410463],
                                [44.95495947953578, 1.7506251087427582],
                                [45.02501608647879, 1.650983768334641],
                                [45.04628038727667, 1.5357253751118864],
                                [45.019313158674045, 1.4482615439322115],
                                [44.99938624261527, 1.413299030000565],
                                [44.87757922298133, 1.441920482742166],
                                [44.84079526684298, 1.3614038259537622],
                                [44.81156818641523, 1.3641029713426986],
                                [44.71478109653049, 1.2877821394602265],
                                [44.684266348929604, 1.2245500554542499],
                                [44.67034606645627, 1.1466718447537776],
                                [44.6394062697152, 1.1537937079861709],
                                [44.577324783565565, 1.0751408247250978],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "46", "NOM_DEPT": "LOT"},
                },
                49: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            43.69416334085517,
                            5.498787806458752,
                            44.65949945810214,
                            6.948335091404862,
                        ),
                        "coordinates": [
                            [
                                [43.788950567095455, 6.636395800176685],
                                [43.87365480225297, 6.697323345466609],
                                [43.87210825687496, 6.745556290785885],
                                [43.91836301148648, 6.830709312232407],
                                [43.88912075689406, 6.884610185550848],
                                [43.92796536503885, 6.913088787529998],
                                [43.95479401195955, 6.8518918622455915],
                                [43.99060185096185, 6.836004210977612],
                                [44.043235362043184, 6.745713950501123],
                                [44.078606586955765, 6.755280297628582],
                                [44.169253930861004, 6.686536427072905],
                                [44.24984330468263, 6.723993885002385],
                                [44.31610570751232, 6.796090992510113],
                                [44.36104783803612, 6.887429900902961],
                                [44.477252952765674, 6.881957404401121],
                                [44.529129653944196, 6.854013487274842],
                                [44.57595174677901, 6.933506639572194],
                                [44.654816299146766, 6.948335091404862],
                                [44.65949945810214, 6.914488202179288],
                                [44.60858882906438, 6.83980166742822],
                                [44.58890871380474, 6.772207133133651],
                                [44.54130010645836, 6.684305299896708],
                                [44.44712877640474, 6.63237632755871],
                                [44.44549275371157, 6.562444503095604],
                                [44.46928995962832, 6.413884950226283],
                                [44.522072579043936, 6.362000081358196],
                                [44.46383091832782, 6.233718236049833],
                                [44.41225003856591, 6.262481962582939],
                                [44.381700391997015, 6.228221718294849],
                                [44.461959822985584, 6.15561504901071],
                                [44.45053588827667, 6.071139333430848],
                                [44.39505926669922, 5.953670382950493],
                                [44.27153166809449, 5.912323479912074],
                                [44.27890195531251, 5.823911889045942],
                                [44.210998662542806, 5.881793583616447],
                                [44.21020776523787, 5.75549419659688],
                                [44.191433131858965, 5.676037325543462],
                                [44.167586051913645, 5.639593544372252],
                                [44.188041650949074, 5.576187167563139],
                                [44.13639078272547, 5.543986124993946],
                                [44.11571934778836, 5.498787806458752],
                                [44.06343920865494, 5.5026367853279545],
                                [44.02870768768523, 5.543656674317526],
                                [43.946002285646465, 5.512089542555731],
                                [43.913772843753264, 5.607126670731598],
                                [43.82992112219788, 5.5781897912212175],
                                [43.82511098585936, 5.654445137414141],
                                [43.729409113755324, 5.7573329775827045],
                                [43.75565738832376, 5.781343238677484],
                                [43.732584595184825, 5.90120740256815],
                                [43.69416334085517, 6.036131813943927],
                                [43.76217559136371, 6.1828860082819075],
                                [43.799511976998794, 6.216709972579084],
                                [43.73636766488724, 6.356960735074889],
                                [43.76036041847219, 6.413483066219064],
                                [43.791594458434176, 6.414428052603499],
                                [43.806365977888035, 6.52476198332243],
                                [43.788950567095455, 6.636395800176685],
                            ]
                        ],
                    },
                    "attributes": {
                        "CODE_DEPT": "04",
                        "NOM_DEPT": "ALPES-DE-HAUTE-PROVENCE",
                    },
                },
                50: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            47.56910405527042,
                            -0.4478589178811479,
                            48.480174054010746,
                            0.8824911871126105,
                        ),
                        "coordinates": [
                            [
                                [47.69421364606961, 0.6144311990931551],
                                [47.71232800972911, 0.5805178732790713],
                                [47.790036219738816, 0.7126298064021259],
                                [47.839687295150355, 0.7745788175007324],
                                [47.89822684022154, 0.7598746908928177],
                                [47.94140146385974, 0.8458005593594105],
                                [48.03755441455243, 0.7974846748199685],
                                [48.10306240933593, 0.8412172317044129],
                                [48.161763238455514, 0.8824911871126105],
                                [48.194452217564375, 0.797655838494225],
                                [48.18907227443456, 0.7378268325294965],
                                [48.24858560387064, 0.6832238274745237],
                                [48.24984731425012, 0.5359730618565082],
                                [48.30780026964518, 0.48757228180388706],
                                [48.3338273937567, 0.3826045470591664],
                                [48.45163268082664, 0.36395898803578564],
                                [48.480174054010746, 0.29585999149911124],
                                [48.43555379652284, 0.11624508246972709],
                                [48.3822165318321, 0.06248837191072311],
                                [48.397313886217454, -0.0025588318946282674],
                                [48.38200345781552, -0.05453120471342586],
                                [48.36135559567944, -0.1379780943180353],
                                [48.25554245624927, -0.16309583433799862],
                                [48.20500891985258, -0.1468370673865568],
                                [48.157106805256795, -0.24992127138834272],
                                [48.10695966457705, -0.21717400338852627],
                                [48.05898535750186, -0.23094244360355798],
                                [48.04309552281351, -0.3416648270919381],
                                [47.95819180740854, -0.2826331784456301],
                                [47.930844658498074, -0.3848402809484052],
                                [47.88002461791636, -0.37067332986759677],
                                [47.83221637946878, -0.4478589178811479],
                                [47.80531865640705, -0.38820058256862927],
                                [47.76056283995014, -0.3817032700427246],
                                [47.72116575999532, -0.3340770241988634],
                                [47.707562003167396, -0.23306038777944318],
                                [47.647916580390344, -0.19315724780649807],
                                [47.632519977213676, -0.13503673265540417],
                                [47.65800746667541, -0.07183106759512606],
                                [47.6476884238069, -0.004507638464452976],
                                [47.60651520171703, 0.05165930848592362],
                                [47.58153476849178, 0.15160368312924158],
                                [47.608398291933675, 0.23000172635318478],
                                [47.56910405527042, 0.3789609617763961],
                                [47.638826411584255, 0.4566307036183553],
                                [47.656207138108634, 0.5428919700970383],
                                [47.69421364606961, 0.6144311990931551],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "72", "NOM_DEPT": "SARTHE"},
                },
                51: {
                    "geometry": {
                        "type": "MultiPolygon",
                        "bbox": (
                            47.283073725555035,
                            -3.69583851492298,
                            48.206363809489616,
                            -2.0495260703928677,
                        ),
                        "coordinates": [
                            [
                                [
                                    [47.32381750417184, -3.235445313568332],
                                    [47.283073725555035, -3.0865563158660554],
                                    [47.315134709442134, -3.093118374110733],
                                    [47.361084420864834, -3.1558608908337984],
                                    [47.37957604821457, -3.248774831164668],
                                    [47.32381750417184, -3.235445313568332],
                                ]
                            ],
                            [
                                [
                                    [47.84914685715854, -3.523004293499609],
                                    [47.78246448850765, -3.5299269866083183],
                                    [47.69534163730077, -3.452760568692728],
                                    [47.708362699566045, -3.344217792341288],
                                    [47.663420828536175, -3.208127827120786],
                                    [47.64069004036754, -3.209753080991345],
                                    [47.569508156886435, -3.1232589863704034],
                                    [47.57607169774949, -2.9751778282815953],
                                    [47.61902226485754, -2.851150732135118],
                                    [47.6191585697231, -2.7785737528565213],
                                    [47.589919045820096, -2.70195079899252],
                                    [47.542488706697725, -2.7305385199391004],
                                    [47.55297298270365, -2.8136159976601793],
                                    [47.53218358478734, -2.871566103275051],
                                    [47.487274625090585, -2.8002084412292936],
                                    [47.51863653795228, -2.664337299385736],
                                    [47.525679091444125, -2.537129650340703],
                                    [47.49623958284168, -2.441223914821732],
                                    [47.44812172073533, -2.45848916517333],
                                    [47.46446874949347, -2.31286829291468],
                                    [47.53105690026964, -2.107333643913478],
                                    [47.63135984403087, -2.097035597340287],
                                    [47.7222402621733, -2.131472084919136],
                                    [47.738560505874425, -2.0897121808782715],
                                    [47.81691739794516, -2.0495260703928677],
                                    [47.8809562899002, -2.1162985684590656],
                                    [47.91952249841039, -2.079088544973964],
                                    [47.9791168009217, -2.1368653813504155],
                                    [47.99946162799206, -2.239593524217945],
                                    [48.02636073133584, -2.2795950136703547],
                                    [48.0756278763605, -2.2332446439270166],
                                    [48.133745563473816, -2.2872784304005114],
                                    [48.122103008406654, -2.371364753161675],
                                    [48.168611326672774, -2.408904872170661],
                                    [48.157844785512516, -2.4948185697824816],
                                    [48.07041003849149, -2.5747859613043027],
                                    [48.03547931277979, -2.6311897590265936],
                                    [48.04788395292574, -2.6700509484423693],
                                    [48.11932466386193, -2.652301006956973],
                                    [48.1205797308541, -2.781951132488677],
                                    [48.199360646242376, -3.033540216127106],
                                    [48.206363809489616, -3.116373512585393],
                                    [48.15849094354359, -3.1552540693335716],
                                    [48.14001476485905, -3.27224433962783],
                                    [48.17112526547107, -3.336754735635011],
                                    [48.185746943072566, -3.564838973733329],
                                    [48.152211751235065, -3.69583851492298],
                                    [48.09349465948051, -3.695020686823406],
                                    [47.98524271313105, -3.640231533075075],
                                    [47.993098470477676, -3.5552758457516087],
                                    [47.96688978460307, -3.484812467813042],
                                    [47.954451158273805, -3.392624522513053],
                                    [47.87011455487803, -3.4034429894056735],
                                    [47.84914685715854, -3.523004293499609],
                                ]
                            ],
                        ],
                    },
                    "attributes": {"CODE_DEPT": "56", "NOM_DEPT": "MORBIHAN"},
                },
                52: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            47.95385379978459,
                            0.7621929543543107,
                            48.94105360615515,
                            1.9940847180593788,
                        ),
                        "coordinates": [
                            [
                                [48.67016796018795, 0.8148191028635925],
                                [48.582626730806226, 0.850642103767011],
                                [48.52274528507802, 0.9665513231299332],
                                [48.39900115345221, 0.9422407728065403],
                                [48.35667269476583, 0.8833710269390439],
                                [48.340427240284555, 0.7854319060188925],
                                [48.306876614025086, 0.7621929543543107],
                                [48.21071322673851, 0.8304834708324242],
                                [48.194452217564375, 0.797655838494225],
                                [48.161763238455514, 0.8824911871126105],
                                [48.10306240933593, 0.8412172317044129],
                                [48.12749350968226, 0.9973300079370282],
                                [48.08312677901136, 1.0085477409246664],
                                [48.080729125955024, 1.112233332007327],
                                [48.03911591949663, 1.121233516589401],
                                [47.968500516699756, 1.2096430686639734],
                                [47.95385379978459, 1.3086281518302278],
                                [47.98227847700271, 1.5201238283340488],
                                [48.02872178085822, 1.512975755811939],
                                [48.03069992075931, 1.5941156652809596],
                                [48.06722274292945, 1.6245928719693987],
                                [48.066144349606105, 1.7448338583126362],
                                [48.08385719873065, 1.8656712589157682],
                                [48.2554662453119, 1.9654790051841269],
                                [48.28658587795804, 1.9940847180593788],
                                [48.39938447447992, 1.9765777946992387],
                                [48.40412484182912, 1.9305557503485924],
                                [48.45760028606413, 1.9221489648373704],
                                [48.46608795961456, 1.8014458379190346],
                                [48.56937104099975, 1.7653297161980415],
                                [48.57802434626237, 1.70925278746701],
                                [48.663769109280636, 1.6024984234215411],
                                [48.70181187348942, 1.5795458299182847],
                                [48.814869639400584, 1.5912030850964909],
                                [48.89157660948184, 1.5572502545823868],
                                [48.94105360615515, 1.5015238197988665],
                                [48.89221734449297, 1.4683503712150041],
                                [48.83417900337295, 1.3621810029001882],
                                [48.79176905228099, 1.376964009060968],
                                [48.760965095552265, 1.319548414059536],
                                [48.77263016325768, 1.184730602501536],
                                [48.7305834560073, 1.0316566693561058],
                                [48.7154924458169, 0.8767072376479725],
                                [48.67016796018795, 0.8148191028635925],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "28", "NOM_DEPT": "EURE-ET-LOIR"},
                },
                53: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            41.368214489339856,
                            8.570335354249014,
                            42.38140571205032,
                            9.407323413987857,
                        ),
                        "coordinates": [
                            [
                                [41.85869824227228, 9.40226832441199],
                                [41.83681486608311, 9.329200877550077],
                                [41.85558903234784, 9.227497390904743],
                                [42.027596960539064, 9.22108402465599],
                                [42.026017143380564, 9.160818391906192],
                                [42.10777443178612, 9.119729450195367],
                                [42.13021371520013, 9.072186891776042],
                                [42.20692343140828, 9.04565931380628],
                                [42.253859280700944, 8.904766989145308],
                                [42.31755804188288, 8.819561377056068],
                                [42.37343635383299, 8.640801666424288],
                                [42.38140571205032, 8.573411068108614],
                                [42.2635239717512, 8.689105710448827],
                                [42.25545987316995, 8.616716018939046],
                                [42.230300263764974, 8.570335354249014],
                                [42.16388769237883, 8.590170524060467],
                                [42.10358657526462, 8.6605051108979],
                                [42.09582422568564, 8.710256944399482],
                                [42.04090929509705, 8.741332481964944],
                                [42.00934596433832, 8.65641983419225],
                                [41.982430657214024, 8.668873449917276],
                                [41.95324306386643, 8.59769539752256],
                                [41.909889114859915, 8.64145251301252],
                                [41.90925797590218, 8.72143021896541],
                                [41.93256867906004, 8.754903133430055],
                                [41.89138353772895, 8.803137234079097],
                                [41.811239551074216, 8.771293565923227],
                                [41.74700226740522, 8.684518163125169],
                                [41.722771268016935, 8.717235397872976],
                                [41.68972719719775, 8.914509146058743],
                                [41.652450901524396, 8.877266064638949],
                                [41.6295527238139, 8.79307422195644],
                                [41.55773356360863, 8.788528375117988],
                                [41.54654924536304, 8.841680682750065],
                                [41.48966696643905, 8.938397598811326],
                                [41.44197767283875, 9.08219781219703],
                                [41.41243171053319, 9.095532004302171],
                                [41.368214489339856, 9.219681605069646],
                                [41.42530280266712, 9.228899383902926],
                                [41.46599484844721, 9.265877253287044],
                                [41.530225532118976, 9.287551136639264],
                                [41.55924531057785, 9.340900099192767],
                                [41.616359707091576, 9.327204087148893],
                                [41.657362352253315, 9.387496558130868],
                                [41.76763912659151, 9.407323413987857],
                                [41.85869824227228, 9.40226832441199],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "2A", "NOM_DEPT": "CORSE-DU-SUD"},
                },
                54: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            48.34989070446764,
                            5.461779526865533,
                            49.55287086489331,
                            7.123165369028565,
                        ),
                        "coordinates": [
                            [
                                [49.49720502129503, 5.470910130592771],
                                [49.45269148819386, 5.461779526865533],
                                [49.40737462726647, 5.529099312496953],
                                [49.43743606551584, 5.634565984546508],
                                [49.41510555457393, 5.688147604064061],
                                [49.311343191085655, 5.731786006583375],
                                [49.21598694642171, 5.719044394768754],
                                [49.198088628043735, 5.765544232834612],
                                [49.15659587123615, 5.744467916779598],
                                [49.10787996559759, 5.763360758388861],
                                [49.08617366650139, 5.818638375145698],
                                [49.02310661815185, 5.823066740236896],
                                [48.9467460575909, 5.800245290300757],
                                [48.915257872637035, 5.747161790828688],
                                [48.826749431285386, 5.780971762726475],
                                [48.744533308856504, 5.714036349479591],
                                [48.695698334229284, 5.7577093395619],
                                [48.60939047859851, 5.7617670452603855],
                                [48.56142416981741, 5.71608982178375],
                                [48.54035925156704, 5.7762118887724645],
                                [48.49649260851312, 5.765154701602299],
                                [48.50684438558553, 5.856069666360071],
                                [48.34989070446764, 5.961559100039156],
                                [48.35403844099854, 6.116723785728533],
                                [48.397598877997915, 6.178419125638965],
                                [48.419031847017656, 6.56697422886565],
                                [48.46050916362014, 6.584971476704244],
                                [48.41308754075586, 6.6994983396482075],
                                [48.39884620056533, 6.815166528707747],
                                [48.4180943151424, 6.890810652427116],
                                [48.47905957978557, 6.9829860045628855],
                                [48.51359226555661, 7.123165369028565],
                                [48.536417612700156, 7.079359770973246],
                                [48.61186293045215, 6.982882241286179],
                                [48.62597500455583, 6.844053536871702],
                                [48.66938665042789, 6.75467285145004],
                                [48.672840395381456, 6.6922838813846575],
                                [48.7080472862827, 6.658407329856351],
                                [48.71569079778236, 6.598965570952483],
                                [48.75409250995719, 6.554148775117042],
                                [48.78165892451309, 6.35503013356845],
                                [48.834058199828384, 6.338947107825573],
                                [48.9331355970772, 6.271977767337417],
                                [48.93472094774055, 6.132207146051102],
                                [48.967833205844386, 6.116898532084446],
                                [48.977477915970994, 6.043435324319259],
                                [49.01041872049325, 6.044996956010202],
                                [49.07185221973813, 5.935399690626695],
                                [49.10910433832356, 5.931603285178869],
                                [49.165118935990016, 6.0261499402444025],
                                [49.20961691713356, 5.987627297222747],
                                [49.23047199221416, 6.029385386695151],
                                [49.37550729349813, 5.928530586493157],
                                [49.45289553695899, 5.942619950432162],
                                [49.49690975011092, 5.893401083719673],
                                [49.55124020373497, 5.793930405166045],
                                [49.53933978552671, 5.715278934594514],
                                [49.55287086489331, 5.659768488051475],
                                [49.49720502129503, 5.470910130592771],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "54", "NOM_DEPT": "MEURTHE-ET-MOSELLE"},
                },
                55: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            48.18907227443456,
                            -0.8603629154348689,
                            48.96474519879868,
                            0.9665513231299332,
                        ),
                        "coordinates": [
                            [
                                [48.95062636769437, 0.4128145328890876],
                                [48.942883562782185, 0.3337726147565274],
                                [48.96474519879868, 0.2756400197144897],
                                [48.924787583562484, 0.1564748700538276],
                                [48.95221907078784, 0.12760760912750208],
                                [48.90246403865731, 0.05639799250068904],
                                [48.85358688783118, -0.05880746358844414],
                                [48.83444909949477, -0.14634308820607572],
                                [48.858307152999124, -0.30592108673909135],
                                [48.821999140746335, -0.3462445710154047],
                                [48.87014004741071, -0.41151869249428463],
                                [48.87136647587905, -0.4637527288822026],
                                [48.79986774271756, -0.7146786118899515],
                                [48.75222016383323, -0.8409353560137922],
                                [48.710188837806285, -0.7989559815697868],
                                [48.617618520532695, -0.7526143435139804],
                                [48.56267832832824, -0.7741715461672727],
                                [48.501458496522545, -0.8603629154348689],
                                [48.43655146991278, -0.7572811397545346],
                                [48.44428211569599, -0.6539938321279792],
                                [48.473117087352556, -0.5517177835994801],
                                [48.50579601256293, -0.5050654278707298],
                                [48.51181992419309, -0.43075405116636184],
                                [48.492944315128234, -0.3676233888648996],
                                [48.506988913211536, -0.2782279440483014],
                                [48.56294475916397, -0.20693829348513745],
                                [48.53697035216617, -0.16938268000563395],
                                [48.45806753461724, -0.14871347253945932],
                                [48.4532597698412, -0.051896256193192866],
                                [48.38200345781552, -0.05453120471342586],
                                [48.397313886217454, -0.0025588318946282674],
                                [48.3822165318321, 0.06248837191072311],
                                [48.43555379652284, 0.11624508246972709],
                                [48.480174054010746, 0.29585999149911124],
                                [48.45163268082664, 0.36395898803578564],
                                [48.3338273937567, 0.3826045470591664],
                                [48.30780026964518, 0.48757228180388706],
                                [48.24984731425012, 0.5359730618565082],
                                [48.24858560387064, 0.6832238274745237],
                                [48.18907227443456, 0.7378268325294965],
                                [48.194452217564375, 0.797655838494225],
                                [48.21071322673851, 0.8304834708324242],
                                [48.306876614025086, 0.7621929543543107],
                                [48.340427240284555, 0.7854319060188925],
                                [48.35667269476583, 0.8833710269390439],
                                [48.39900115345221, 0.9422407728065403],
                                [48.52274528507802, 0.9665513231299332],
                                [48.582626730806226, 0.850642103767011],
                                [48.67016796018795, 0.8148191028635925],
                                [48.7052077986587, 0.7305886446296774],
                                [48.73752726458569, 0.7749590431141294],
                                [48.78336423502616, 0.7335062460350473],
                                [48.83131414903287, 0.6102938086141846],
                                [48.875537831571705, 0.5525030083730612],
                                [48.87976248181588, 0.4573579962478969],
                                [48.91041450585283, 0.3861893489650419],
                                [48.95062636769437, 0.4128145328890876],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "61", "NOM_DEPT": "ORNE"},
                },
                56: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            45.613268326764185,
                            4.729096921230878,
                            46.51719845218087,
                            6.169741660312735,
                        ),
                        "coordinates": [
                            [
                                [46.44676642071987, 5.310560613770375],
                                [46.468359273121585, 5.215064143095116],
                                [46.508209505159336, 5.201145108499204],
                                [46.484872844561906, 5.052374107055715],
                                [46.51719845218087, 4.940023082647429],
                                [46.43991436571944, 4.891817622919295],
                                [46.40298160185767, 4.8882077017045455],
                                [46.25992151697564, 4.810994882268941],
                                [46.17667702271938, 4.780213475718984],
                                [46.140701464361854, 4.797433206939167],
                                [46.0941499665971, 4.750325275584826],
                                [46.04720888365027, 4.739530214170903],
                                [45.97362201497272, 4.7546312797683195],
                                [45.949092212302176, 4.729096921230878],
                                [45.90461654376232, 4.8645021533563355],
                                [45.80399936996712, 4.923799133458053],
                                [45.81337808264366, 5.101067478338777],
                                [45.77168800093879, 5.191532760208243],
                                [45.78936901099018, 5.266894883868229],
                                [45.85493340191009, 5.309169396437734],
                                [45.88327273564142, 5.3538271958050325],
                                [45.8310937764943, 5.434944676804955],
                                [45.80712379566377, 5.42264142008713],
                                [45.71359345746489, 5.5455415978088505],
                                [45.613268326764185, 5.623748035268078],
                                [45.64850161239944, 5.689187102194641],
                                [45.71092632945919, 5.704119379498135],
                                [45.7292223955843, 5.7761608991802635],
                                [45.82295599649881, 5.7868562241797115],
                                [45.93845957829322, 5.831226413621036],
                                [45.98979960381867, 5.809643351753076],
                                [46.063934978382775, 5.807622444833504],
                                [46.10599585856306, 5.832300912634432],
                                [46.13208943594268, 5.956063159932634],
                                [46.23799614420533, 6.033127717153324],
                                [46.251012016472174, 6.124247271884755],
                                [46.28506396607944, 6.102638404712806],
                                [46.36793686221589, 6.169741660312735],
                                [46.416226988931534, 6.06400848181829],
                                [46.364873088758074, 5.986841317727858],
                                [46.283951620059554, 5.908938421371526],
                                [46.26206360332614, 5.849846074176259],
                                [46.260729204793954, 5.725183003095843],
                                [46.3087688477459, 5.714717731644379],
                                [46.33949103303637, 5.649339135998931],
                                [46.270201908707435, 5.542037828826235],
                                [46.265063763323475, 5.473055311573813],
                                [46.31511297122548, 5.437795113853318],
                                [46.35223630468514, 5.3734622886202095],
                                [46.38135905559832, 5.377044586181938],
                                [46.41681731886722, 5.307691028342544],
                                [46.44676642071987, 5.310560613770375],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "01", "NOM_DEPT": "AIN"},
                },
                57: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            42.57362343207788,
                            0.8324133769327755,
                            43.31560605476546,
                            2.1758741195218594,
                        ),
                        "coordinates": [
                            [
                                [42.825719089084465, 0.8583056667230169],
                                [42.78926022063215, 0.9273318147672919],
                                [42.78535096062724, 1.0751084975718934],
                                [42.71104632984594, 1.161848153380758],
                                [42.72758608076071, 1.2302117813358218],
                                [42.72390397060217, 1.32502612790918],
                                [42.68508287715745, 1.3895996264494757],
                                [42.60607634725255, 1.4350544962266247],
                                [42.65577628584985, 1.5492483438086206],
                                [42.62803932707508, 1.601470136798133],
                                [42.623904127991494, 1.6873586751619762],
                                [42.57362343207788, 1.7861250110638964],
                                [42.58140598425563, 1.8744850028357225],
                                [42.61692049379412, 1.9717596461471245],
                                [42.66156483553937, 2.0005149149001973],
                                [42.66391836976527, 2.166053682054993],
                                [42.6827952243106, 2.1758741195218594],
                                [42.7562228612599, 2.057204243184995],
                                [42.73670079860314, 1.9553956635295406],
                                [42.767667043480046, 1.9081798281291227],
                                [42.852669269026464, 1.8804739886198156],
                                [42.87101168756058, 1.986920914223352],
                                [43.02627232234234, 1.9851004481943353],
                                [43.052715472626694, 1.941132873290632],
                                [43.119494438163784, 1.9494758652019246],
                                [43.14581388915534, 1.824772198868932],
                                [43.18969803410896, 1.710056447799201],
                                [43.224524250769015, 1.723844068753025],
                                [43.27355372810048, 1.688419720914751],
                                [43.25511535449163, 1.6372035311274424],
                                [43.27567426925569, 1.54752004958837],
                                [43.21060079806052, 1.4637105789844813],
                                [43.25657153586671, 1.4253606535844832],
                                [43.31560605476546, 1.3436519696346765],
                                [43.28533747712757, 1.2933102990704717],
                                [43.21374576570539, 1.3743734334754005],
                                [43.18999472443669, 1.3146078107375299],
                                [43.18389310581045, 1.2274806300813899],
                                [43.117951050809886, 1.2087344680123449],
                                [43.156907404761775, 1.1240820844542168],
                                [43.14182620134684, 1.058912548014145],
                                [43.100552820032235, 1.038835682734409],
                                [43.06705628157321, 0.9851687313481592],
                                [43.007591006439135, 1.0070461604480825],
                                [42.97443096191435, 0.9791013887263268],
                                [42.95777574631528, 0.8749113719387418],
                                [42.91998800205083, 0.8324133769327755],
                                [42.825719089084465, 0.8583056667230169],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "09", "NOM_DEPT": "ARIEGE"},
                },
                58: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            44.927682448456935,
                            1.2271194403372108,
                            45.755490360800245,
                            2.5283647797478266,
                        ),
                        "coordinates": [
                            [
                                [45.44421907802482, 1.2531518386328937],
                                [45.39834890279047, 1.2596039598397968],
                                [45.382659361364226, 1.3227969726587205],
                                [45.27197997099894, 1.2271194403372108],
                                [45.24208241912198, 1.2774962889939248],
                                [45.140188825629004, 1.2965184989870575],
                                [45.10288137852398, 1.3864424774272137],
                                [45.019313158674045, 1.4482615439322115],
                                [45.04628038727667, 1.5357253751118864],
                                [45.02501608647879, 1.650983768334641],
                                [44.95495947953578, 1.7506251087427582],
                                [44.927682448456935, 1.8239145263410463],
                                [44.978426771844674, 1.908156162007897],
                                [44.97650640551561, 2.062914291973062],
                                [44.98552052019745, 2.1329789677394575],
                                [45.05602988503954, 2.09515947189117],
                                [45.081495873975626, 2.171755685373443],
                                [45.160192640152275, 2.2136969761815397],
                                [45.22085230029835, 2.195361138057307],
                                [45.29015191925762, 2.2714136874802593],
                                [45.32755821486306, 2.350479440865637],
                                [45.41430579076644, 2.378246243484016],
                                [45.384258469857066, 2.4418608930121475],
                                [45.41883841080893, 2.4874679068775096],
                                [45.47849879874484, 2.508408697113082],
                                [45.553426613923115, 2.516332317304299],
                                [45.60082287582866, 2.46534961788347],
                                [45.639532080177666, 2.514296706686258],
                                [45.681924336473706, 2.5283647797478266],
                                [45.73767009540705, 2.4921255582417543],
                                [45.699275061444226, 2.4358558482207813],
                                [45.70947892430507, 2.3491828014700613],
                                [45.68060482956175, 2.3377545093277403],
                                [45.699047103880844, 2.1939584682323856],
                                [45.73221596168252, 2.17435335428623],
                                [45.724775065025135, 2.113545472759344],
                                [45.755490360800245, 2.01760876898307],
                                [45.6982775512041, 1.898730779182943],
                                [45.664658270083336, 1.8713480467629338],
                                [45.68036337807322, 1.7838678002323438],
                                [45.58035190912391, 1.6376634511377184],
                                [45.54936632471628, 1.5571958047036873],
                                [45.56594313830816, 1.4803697950912302],
                                [45.528081031575745, 1.412058914052018],
                                [45.46688830500579, 1.350077879284767],
                                [45.48993789201231, 1.2870567570435631],
                                [45.44421907802482, 1.2531518386328937],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "19", "NOM_DEPT": "CORREZE"},
                },
                59: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            47.42220209989122,
                            6.846179818400714,
                            48.31046786103526,
                            7.622090012011826,
                        ),
                        "coordinates": [
                            [
                                [47.82294519701528, 6.846179818400714],
                                [47.785160874502324, 6.86347551612767],
                                [47.74323273949904, 7.015960767929836],
                                [47.671501710494844, 7.046314752908177],
                                [47.61938273175802, 7.00498323142151],
                                [47.59256219967389, 7.086270201422721],
                                [47.50302658240899, 7.130345969302944],
                                [47.44718259366279, 7.173076933987583],
                                [47.42220209989122, 7.2462970616937685],
                                [47.43781547828914, 7.301734408679477],
                                [47.43552354218881, 7.403411294214607],
                                [47.49563386054373, 7.506753671499357],
                                [47.54198029495234, 7.503407577023025],
                                [47.57726432342955, 7.5847059048213925],
                                [47.60177705410426, 7.592798217753343],
                                [47.66232148986579, 7.522345790100707],
                                [47.70281805791817, 7.513752001020273],
                                [47.739586644859074, 7.548078387714247],
                                [47.786758092756166, 7.531259755609871],
                                [47.87994110575861, 7.556704620769358],
                                [47.97227315829841, 7.622090012011826],
                                [48.030379632553434, 7.571623278915895],
                                [48.12036852181815, 7.577312855212316],
                                [48.12611186664672, 7.519368638022094],
                                [48.161014524040404, 7.470560946722399],
                                [48.20353668429841, 7.476943375699941],
                                [48.24719461957464, 7.348562541549848],
                                [48.30523478706437, 7.275183721811301],
                                [48.31046786103526, 7.198281537029947],
                                [48.245940550021665, 7.133555808547299],
                                [48.13726637155602, 7.058912798901165],
                                [48.022399095831105, 7.001883743858899],
                                [47.9979579468772, 6.943356419805965],
                                [47.891191372726894, 6.900213335139268],
                                [47.850287916338935, 6.920034363859818],
                                [47.82294519701528, 6.846179818400714],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "68", "NOM_DEPT": "HAUT-RHIN"},
                },
                60: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            46.74821910504848,
                            0.05382761471070587,
                            47.69540180185664,
                            1.3653609997076237,
                        ),
                        "coordinates": [
                            [
                                [47.18622542473178, 1.3266655450453897],
                                [47.25470690394847, 1.2769082168277972],
                                [47.29408083062265, 1.2235368646048146],
                                [47.27219609172912, 1.1620645187006384],
                                [47.29839804393137, 1.1081270826014082],
                                [47.35401667090686, 1.1228353402815718],
                                [47.4113254251562, 1.1074833948523175],
                                [47.44646665748557, 1.132364189106744],
                                [47.53148801134601, 1.0452908534068046],
                                [47.56322155433421, 1.0763363652479008],
                                [47.60701157047614, 1.0333525357335167],
                                [47.632609060103235, 0.9190111731399363],
                                [47.66920726991006, 0.8595037193186874],
                                [47.69540180185664, 0.7353105618986349],
                                [47.69421364606961, 0.6144311990931551],
                                [47.656207138108634, 0.5428919700970383],
                                [47.638826411584255, 0.4566307036183553],
                                [47.56910405527042, 0.3789609617763961],
                                [47.608398291933675, 0.23000172635318478],
                                [47.54432775642862, 0.20150312551615113],
                                [47.50195329713312, 0.22010925240137172],
                                [47.424733449390715, 0.18528045906678237],
                                [47.28282475506665, 0.07897484723536188],
                                [47.16373008265527, 0.05382761471070587],
                                [47.123931948888234, 0.07637120084195193],
                                [47.12158055414751, 0.13613090268194533],
                                [47.07127519606643, 0.17422061595767882],
                                [47.0539187252087, 0.29823142261819696],
                                [46.973827658647814, 0.30073625724988373],
                                [46.92958207105905, 0.4387096602536596],
                                [46.95924736173615, 0.5061414593305557],
                                [46.95676414686082, 0.5983482495759433],
                                [47.00227037444165, 0.5669489614197056],
                                [46.97430706301783, 0.6925692823646332],
                                [46.90329335315584, 0.704324392050786],
                                [46.852391083185935, 0.7903284955617977],
                                [46.79450796471715, 0.8119017840639386],
                                [46.74821910504848, 0.8674688807081561],
                                [46.76154066839267, 0.9888132945329691],
                                [46.98064041873546, 1.0498776400419187],
                                [47.015842398188234, 1.0776154683629737],
                                [47.039622972819544, 1.1614221724181901],
                                [47.03783413818556, 1.2730568495660919],
                                [47.096975273440314, 1.311672909460613],
                                [47.12205127770917, 1.3653609997076237],
                                [47.18622542473178, 1.3266655450453897],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "37", "NOM_DEPT": "INDRE-ET-LOIRE"},
                },
                61: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            49.969187585411916,
                            2.067712027611001,
                            51.08854281218866,
                            4.227998848506977,
                        ),
                        "coordinates": [
                            [
                                [51.006505154665284, 2.067712027611001],
                                [50.998427200370195, 2.097600537080802],
                                [50.883452469254024, 2.18390456104644],
                                [50.81054861626229, 2.2134304216785434],
                                [50.74090632543495, 2.34089102647672],
                                [50.672765602799466, 2.40779242678447],
                                [50.631244941936494, 2.495948921017839],
                                [50.617951505356416, 2.630516060197486],
                                [50.63129225354633, 2.713850503520111],
                                [50.663678139297865, 2.7690409100193936],
                                [50.65656635139436, 2.8404494526472543],
                                [50.6032712281948, 2.8051660601438893],
                                [50.52538845142136, 2.8259824668620874],
                                [50.501557815660604, 2.8989518584324676],
                                [50.512778020799246, 2.9647097377674005],
                                [50.48176905740127, 3.0207925423124586],
                                [50.4416400980408, 3.037672306035308],
                                [50.379846956513916, 2.993078464231492],
                                [50.24110767125754, 3.173376482382538],
                                [50.183715151473976, 3.1561320895920617],
                                [50.12420173433414, 3.0957569207512843],
                                [50.05374055513492, 3.090253620620082],
                                [50.01199494467939, 3.1727072271768164],
                                [50.03130959186552, 3.2305405050170397],
                                [50.0151825508069, 3.2801740988851327],
                                [50.035859344668864, 3.3529820366555496],
                                [50.01885605079539, 3.4913598357111555],
                                [50.05379395526909, 3.54484649487849],
                                [50.025418579177284, 3.6136399192005855],
                                [50.069274635963545, 3.715184685025503],
                                [50.05360423497288, 3.7463798889650586],
                                [50.026430676607156, 3.923501465982155],
                                [49.99537608693849, 3.9803763118726994],
                                [49.969187585411916, 4.08712850474961],
                                [49.978759598994436, 4.140895251736092],
                                [50.04898484693675, 4.162223866832849],
                                [50.066371644106745, 4.227998848506977],
                                [50.13107752152201, 4.199886857285581],
                                [50.13501086614893, 4.126926892460069],
                                [50.202535967141905, 4.160120194753328],
                                [50.256952603046614, 4.221850100147642],
                                [50.27430028766336, 4.136656244682008],
                                [50.34294913095138, 4.037614330208127],
                                [50.35036640688852, 3.967898522087576],
                                [50.32998024472696, 3.889799951126813],
                                [50.35159288086556, 3.8527555820958135],
                                [50.350929148402, 3.747403815562772],
                                [50.31582758312017, 3.694426981658982],
                                [50.371341179601195, 3.658270970690328],
                                [50.45317465879257, 3.664218477773235],
                                [50.49246946526615, 3.613009891798258],
                                [50.53356175114644, 3.4739635628750074],
                                [50.49182493572303, 3.3738916027191275],
                                [50.527575838126204, 3.2865173191905384],
                                [50.63804120853444, 3.248509229627794],
                                [50.70064952130496, 3.2583710099316026],
                                [50.72440644616072, 3.1912194219619847],
                                [50.78234329668403, 3.1519976780893755],
                                [50.78050085123832, 3.0613770323899683],
                                [50.744341238034195, 2.938073313612885],
                                [50.69423611297018, 2.8983800599236966],
                                [50.716947630173586, 2.813275390169948],
                                [50.81360773516545, 2.7174810677545755],
                                [50.81275641876223, 2.634982733121708],
                                [50.85333434260148, 2.599594701801672],
                                [50.94600519935865, 2.6326872836805335],
                                [51.01375274755887, 2.575982419777286],
                                [51.08854281218866, 2.5430346143752027],
                                [51.05562611741315, 2.4247542826080695],
                                [51.0598323621204, 2.347839655429636],
                                [51.00382398080942, 2.1097003640363865],
                                [51.006505154665284, 2.067712027611001],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "59", "NOM_DEPT": "NORD"},
                },
                62: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            47.433373721422306,
                            6.757638483670513,
                            47.82294519701528,
                            7.130345969302944,
                        ),
                        "coordinates": [
                            [
                                [47.50302658240899, 7.130345969302944],
                                [47.59256219967389, 7.086270201422721],
                                [47.61938273175802, 7.00498323142151],
                                [47.671501710494844, 7.046314752908177],
                                [47.74323273949904, 7.015960767929836],
                                [47.785160874502324, 6.86347551612767],
                                [47.82294519701528, 6.846179818400714],
                                [47.81305372460471, 6.823538854548165],
                                [47.747877966491, 6.757638483670513],
                                [47.62526070546134, 6.780404771904787],
                                [47.56280181879927, 6.806992048333126],
                                [47.54736152102862, 6.90566962763424],
                                [47.49454608019349, 6.90760985982366],
                                [47.433373721422306, 6.940536510867674],
                                [47.452299031235334, 6.998962818675517],
                                [47.493302817356266, 6.983118836626175],
                                [47.488863995885616, 7.079276690803703],
                                [47.50302658240899, 7.130345969302944],
                            ]
                        ],
                    },
                    "attributes": {
                        "CODE_DEPT": "90",
                        "NOM_DEPT": "TERRITOIRE DE BELFORT",
                    },
                },
                63: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            46.86007983436468,
                            -2.5341025675524835,
                            47.82828080116927,
                            -0.9464433335100018,
                        ),
                        "coordinates": [
                            [
                                [47.77671754769661, -1.2458823462890545],
                                [47.797692640089586, -1.3528642478531794],
                                [47.82828080116927, -1.3904279688415837],
                                [47.77605009179812, -1.5934074072820492],
                                [47.71259280237026, -1.6548203169539613],
                                [47.69845339610199, -1.772416302356319],
                                [47.70698467056549, -1.864013339310425],
                                [47.688369032584774, -1.96905397590764],
                                [47.63135984403087, -2.097035597340287],
                                [47.53105690026964, -2.107333643913478],
                                [47.46446874949347, -2.31286829291468],
                                [47.44812172073533, -2.45848916517333],
                                [47.38296506335942, -2.5341025675524835],
                                [47.298372267525686, -2.51380537508331],
                                [47.261755657502384, -2.447540278501034],
                                [47.28144600128057, -2.398380900159916],
                                [47.236404402309375, -2.301643363345214],
                                [47.280619489541195, -2.1873645299124624],
                                [47.20905347869715, -2.1583713304619327],
                                [47.166180499018125, -2.1670644777818096],
                                [47.13094036238745, -2.226823218085358],
                                [47.09412159709028, -2.0534725301465038],
                                [47.028906494075635, -1.980414486742876],
                                [46.99471092059495, -1.9432276192598656],
                                [46.9320337241545, -1.8309821821134158],
                                [46.92959568215277, -1.7510623002403711],
                                [46.89049286319805, -1.6897612739864445],
                                [46.86007983436468, -1.5485110748777025],
                                [46.88389115282978, -1.5007668577856463],
                                [46.98150474523172, -1.5535636972370026],
                                [47.01834875737957, -1.5523222833408654],
                                [47.03786198958929, -1.4821311833973994],
                                [46.926272854355254, -1.4561316296061424],
                                [46.95218446660972, -1.3729857700949506],
                                [47.03085386698655, -1.3786124689367822],
                                [47.03948346966516, -1.2946349782361042],
                                [47.08389319899775, -1.2712067087150385],
                                [47.02954516258657, -1.1485704887534407],
                                [47.06256455498823, -1.1154625363954862],
                                [47.10995454752667, -1.2311457136088386],
                                [47.138781593624955, -1.2352482689031201],
                                [47.17778408754902, -1.1632160710080481],
                                [47.25058116645216, -1.1977216097650178],
                                [47.24985628237829, -1.2541747505718956],
                                [47.303169978196514, -1.3051085022277937],
                                [47.337623665323235, -1.2998771573086019],
                                [47.36588723515685, -1.167609698077546],
                                [47.365062263189614, -1.0178737847602033],
                                [47.38646685235786, -0.9464433335100018],
                                [47.49280029691793, -0.9674825559179046],
                                [47.51008306960625, -1.1572331855798599],
                                [47.57300754719196, -1.1724160661946539],
                                [47.56335191106952, -1.045909504072581],
                                [47.58905339489953, -1.0068639898836467],
                                [47.6194570478612, -1.1382017900650407],
                                [47.694565013846024, -1.1749295691501485],
                                [47.73364175152332, -1.2545772523262662],
                                [47.77671754769661, -1.2458823462890545],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "44", "NOM_DEPT": "LOIRE-ATLANTIQUE"},
                },
                64: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            47.33271278537438,
                            2.8566660682192713,
                            48.39027303882033,
                            4.332471702607339,
                        ),
                        "coordinates": [
                            [
                                [47.56942879711256, 2.9765380120036067],
                                [47.558752776952176, 3.0256381393798466],
                                [47.58795617120515, 3.10199661377424],
                                [47.54104902333151, 3.122046633548593],
                                [47.522966343586994, 3.2046491761957805],
                                [47.48917911094721, 3.2354769572493565],
                                [47.49471952596052, 3.307051239784071],
                                [47.472438113851204, 3.3463147218972584],
                                [47.50886749595519, 3.3972880002653882],
                                [47.49392259510354, 3.487879079980051],
                                [47.52766801375831, 3.5135049928892266],
                                [47.497863236330566, 3.5806168100615214],
                                [47.46490071650613, 3.580113356556516],
                                [47.44553367789057, 3.6789914842274665],
                                [47.40683466664035, 3.7147823454353084],
                                [47.39054233152028, 3.7856341851420217],
                                [47.37831443829053, 3.9706779602609212],
                                [47.33271278537438, 3.9730845789314024],
                                [47.339255985508245, 4.106085850126875],
                                [47.40725128721285, 4.066060118363545],
                                [47.443553393328095, 4.119426533664949],
                                [47.515008579609535, 4.11550026231875],
                                [47.55325916322948, 4.17512808182493],
                                [47.62796570433963, 4.212381292101606],
                                [47.6814099239688, 4.268422869492534],
                                [47.72740297086132, 4.258164266526501],
                                [47.756511310408264, 4.332471702607339],
                                [47.84715746363821, 4.324394417243652],
                                [47.84385063868304, 4.2610008241447535],
                                [47.9256762348538, 4.2934241069450065],
                                [47.9699414025263, 4.199158053352666],
                                [47.92699565753336, 4.1117857473984065],
                                [47.93917007405483, 3.9020865465480417],
                                [47.98379240722837, 3.850029315571996],
                                [48.10254956016531, 3.8049683849961107],
                                [48.169707832950834, 3.740291245795231],
                                [48.13921190362741, 3.667869602845747],
                                [48.225740470572546, 3.6216038851697063],
                                [48.27133989892487, 3.6168043332338455],
                                [48.36909719472573, 3.4981527640993844],
                                [48.39027303882033, 3.4147915595010967],
                                [48.37228068710627, 3.3651592673815314],
                                [48.371860839526576, 3.167737573570585],
                                [48.36012035556558, 3.0495188960927044],
                                [48.27202235762727, 3.043627253848888],
                                [48.20767000036061, 3.0051556578134635],
                                [48.16339174416305, 2.936314411640624],
                                [48.13320717201307, 3.0294654865478936],
                                [48.07233413114024, 3.0504714242752176],
                                [48.05393639482612, 3.0883177986514796],
                                [47.97097324036121, 3.1284501214452565],
                                [47.911447449150096, 3.0501042789379826],
                                [47.90471697202148, 3.0102926272319244],
                                [47.786554679015424, 3.023798094359226],
                                [47.7632462761762, 2.9350577707343026],
                                [47.7609264707902, 2.8566660682192713],
                                [47.71199289202637, 2.8585180302225814],
                                [47.68055969848399, 2.9231098081748264],
                                [47.598884707750464, 2.937999037836789],
                                [47.56942879711256, 2.9765380120036067],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "89", "NOM_DEPT": "YONNE"},
                },
                65: {
                    "geometry": {
                        "type": "MultiPolygon",
                        "bbox": (
                            47.63135984403087,
                            -2.2872784304005114,
                            48.70485450481566,
                            -1.021261028476561,
                        ),
                        "coordinates": [
                            [
                                [
                                    [48.56611290198357, -2.006894935706843],
                                    [48.63697592731957, -2.0486879074738535],
                                    [48.6044100285603, -2.1237080247752895],
                                    [48.56767919673737, -2.075983866873217],
                                    [48.56611290198357, -2.006894935706843],
                                ]
                            ],
                            [
                                [
                                    [48.50849381419033, -1.0701645143702043],
                                    [48.54220594454137, -1.206555726308375],
                                    [48.533924823055, -1.2722484935647256],
                                    [48.45828455072381, -1.3772458850979696],
                                    [48.4893748476061, -1.4899474351423645],
                                    [48.56659421958315, -1.5189153941473403],
                                    [48.62644574305228, -1.571087121326364],
                                    [48.603560368601826, -1.7641518008716617],
                                    [48.61636825056999, -1.8450734275301934],
                                    [48.64741056211108, -1.8716564802791003],
                                    [48.70485450481566, -1.8561321209072572],
                                    [48.686323125327455, -1.9698282134951834],
                                    [48.64691471298053, -2.028959676879305],
                                    [48.53880790488251, -1.9480369010443905],
                                    [48.51884141988655, -1.9124900704350776],
                                    [48.31710984530666, -1.9548327221541837],
                                    [48.27953190981902, -2.0141005291993967],
                                    [48.29832786131649, -2.0532925486538494],
                                    [48.252903482093345, -2.110118931164647],
                                    [48.2463785700459, -2.186961247227295],
                                    [48.1705970187894, -2.2247373292770836],
                                    [48.133745563473816, -2.2872784304005114],
                                    [48.0756278763605, -2.2332446439270166],
                                    [48.02636073133584, -2.2795950136703547],
                                    [47.99946162799206, -2.239593524217945],
                                    [47.9791168009217, -2.1368653813504155],
                                    [47.91952249841039, -2.079088544973964],
                                    [47.8809562899002, -2.1162985684590656],
                                    [47.81691739794516, -2.0495260703928677],
                                    [47.738560505874425, -2.0897121808782715],
                                    [47.7222402621733, -2.131472084919136],
                                    [47.63135984403087, -2.097035597340287],
                                    [47.688369032584774, -1.96905397590764],
                                    [47.70698467056549, -1.864013339310425],
                                    [47.69845339610199, -1.772416302356319],
                                    [47.71259280237026, -1.6548203169539613],
                                    [47.77605009179812, -1.5934074072820492],
                                    [47.82828080116927, -1.3904279688415837],
                                    [47.797692640089586, -1.3528642478531794],
                                    [47.77671754769661, -1.2458823462890545],
                                    [47.80999146298685, -1.2382517343256687],
                                    [47.86797794678783, -1.189183999002136],
                                    [47.96582099565697, -1.1539940378788582],
                                    [47.9890627829139, -1.1026711686637327],
                                    [47.99494016249537, -1.021261028476561],
                                    [48.06891120316757, -1.0232833455698922],
                                    [48.08980493061708, -1.0496060893987509],
                                    [48.25928012122702, -1.1000610480389654],
                                    [48.327727830000974, -1.0450195299623035],
                                    [48.433058231677805, -1.0827940655347785],
                                    [48.50849381419033, -1.0701645143702043],
                                ]
                            ],
                        ],
                    },
                    "attributes": {"CODE_DEPT": "35", "NOM_DEPT": "ILLE-ET-VILAINE"},
                },
                66: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            43.49776692584455,
                            -1.524866548422101,
                            44.53219457167761,
                            0.13510828700872374,
                        ),
                        "coordinates": [
                            [
                                [43.52970134669009, -1.524866548422101],
                                [43.539184056404956, -1.47661986699547],
                                [43.49776692584455, -1.4177740978934008],
                                [43.49820457476753, -1.2911822396099015],
                                [43.54560988391761, -1.1708199655376677],
                                [43.51412989565136, -1.1092478299389088],
                                [43.50538804684213, -0.9933935609538066],
                                [43.55048921576566, -0.896690646890469],
                                [43.56416715906682, -0.7817805196343687],
                                [43.54111406021403, -0.7153911507395111],
                                [43.566716972183386, -0.6708071861709698],
                                [43.542797175106195, -0.557174431652949],
                                [43.596089226471534, -0.4482922578476395],
                                [43.56822563862102, -0.4060419475368964],
                                [43.560276850255974, -0.3036904680467346],
                                [43.58497620901365, -0.2428365587430673],
                                [43.71408748429112, -0.23258236946731775],
                                [43.73701668569468, -0.19414330237234037],
                                [43.875183336159544, -0.19099217321599574],
                                [43.891067750109656, -0.23393876198190033],
                                [43.93791976442837, -0.1791090595179048],
                                [43.94504687607565, -0.07359844651969412],
                                [43.90018804605384, 0.032556764180923806],
                                [43.916471143129584, 0.07664688901341983],
                                [43.98314313658292, 0.07604560969926086],
                                [44.00084249917964, 0.06269801329290979],
                                [44.08677044166998, 0.10082062971801448],
                                [44.12422070347952, 0.13510828700872374],
                                [44.13065240342956, 0.03459384382220977],
                                [44.14999595086847, -0.004232390832892187],
                                [44.15240992875157, -0.12915451548994528],
                                [44.226404747689884, -0.1406884798527587],
                                [44.26904045949535, -0.19411335198198051],
                                [44.205898263801814, -0.22344709828329445],
                                [44.193809246235574, -0.27211852903661166],
                                [44.20948462715674, -0.3896173620609178],
                                [44.286310667736586, -0.38338729038705555],
                                [44.32257705443087, -0.4318395413151788],
                                [44.33911112646834, -0.5176354697700617],
                                [44.36465404326284, -0.5281031072972922],
                                [44.39814566253359, -0.6276476111842939],
                                [44.443192240874566, -0.6287774027434528],
                                [44.446374662072536, -0.7307029568976181],
                                [44.418974549624615, -0.8452736279017063],
                                [44.443344362596, -0.9191704541834174],
                                [44.43765239133863, -1.0074534242441238],
                                [44.48287893553745, -0.980696991457649],
                                [44.53219457167761, -1.0851664955491256],
                                [44.502772891337074, -1.1064909647292627],
                                [44.46760421234612, -1.2538901028077152],
                                [44.144802425789706, -1.3123241886692387],
                                [43.91378891976494, -1.374986662948486],
                                [43.710565130021784, -1.4365038283323692],
                                [43.64227785427402, -1.4482041246762156],
                                [43.52970134669009, -1.524866548422101],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "40", "NOM_DEPT": "LANDES"},
                },
                67: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            47.76827885611337,
                            -4.793344007924674,
                            48.71193803703632,
                            -3.392624522513053,
                        ),
                        "coordinates": [
                            [
                                [48.65920978066925, -3.6591438196705757],
                                [48.69406986741948, -3.6609362536487686],
                                [48.71193803703632, -3.8323800958932215],
                                [48.67033253738436, -3.8644177127525783],
                                [48.65285953016301, -3.9494602787296587],
                                [48.69903337142497, -3.9757489429755535],
                                [48.6864612279009, -4.1869356904234065],
                                [48.64958226192499, -4.2727675202883395],
                                [48.676117521154396, -4.35140810886426],
                                [48.62710227835847, -4.462762668788339],
                                [48.62380353944807, -4.561475551373931],
                                [48.57769163687087, -4.630604970514318],
                                [48.556349210517865, -4.730582004767843],
                                [48.49100463761581, -4.775473394851904],
                                [48.41623318232073, -4.793344007924674],
                                [48.37274934621913, -4.760909970272357],
                                [48.337887485223526, -4.608723907528043],
                                [48.397597431903016, -4.424948261340765],
                                [48.35361514079129, -4.441760780702188],
                                [48.34377660538751, -4.302158218411381],
                                [48.297168113923405, -4.308030328849242],
                                [48.275155727113315, -4.384499553201254],
                                [48.29166824316697, -4.423777088962566],
                                [48.28634356728925, -4.566613794720503],
                                [48.23223061158217, -4.564023813101924],
                                [48.23563035676817, -4.44836228902972],
                                [48.19144690509731, -4.301125453787076],
                                [48.1330557098113, -4.271734463109185],
                                [48.089182615732675, -4.306988535338469],
                                [48.11016030592398, -4.374400199477134],
                                [48.086471142269275, -4.48860072225349],
                                [48.07020031865326, -4.66822216968598],
                                [48.0335962657083, -4.723030433108444],
                                [47.98177439190436, -4.453570861423831],
                                [47.889262907304456, -4.362572451765147],
                                [47.795743686186675, -4.362418521201161],
                                [47.79738016645033, -4.192310067833886],
                                [47.8491851080577, -4.163559448578029],
                                [47.86652658516891, -4.077726475728436],
                                [47.845999453357926, -4.041588845349637],
                                [47.87028016364018, -3.9115007019573915],
                                [47.83593985815636, -3.9024761254088056],
                                [47.78763239458594, -3.8006004190720057],
                                [47.802926739002665, -3.7325436278241773],
                                [47.77678956846733, -3.6808401232958063],
                                [47.76827885611337, -3.5323088913488188],
                                [47.84914685715854, -3.523004293499609],
                                [47.87011455487803, -3.4034429894056735],
                                [47.954451158273805, -3.392624522513053],
                                [47.96688978460307, -3.484812467813042],
                                [47.993098470477676, -3.5552758457516087],
                                [47.98524271313105, -3.640231533075075],
                                [48.09349465948051, -3.695020686823406],
                                [48.152211751235065, -3.69583851492298],
                                [48.185746943072566, -3.564838973733329],
                                [48.2822731470352, -3.518440717872892],
                                [48.33551998786712, -3.5567868257426127],
                                [48.37776678483146, -3.5545842830629764],
                                [48.42892323446267, -3.590415422993112],
                                [48.49643946876788, -3.604061396321586],
                                [48.54092077173928, -3.5538598863227393],
                                [48.610153346220144, -3.6493779946144103],
                                [48.65920978066925, -3.6591438196705757],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "29", "NOM_DEPT": "FINISTERE"},
                },
                68: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            45.685404763162595,
                            5.807622444833504,
                            46.40755389780494,
                            7.043893795018055,
                        ),
                        "coordinates": [
                            [
                                [45.77837197402194, 6.802516663522653],
                                [45.83497696816749, 6.818078636732782],
                                [45.84673210642239, 6.9396049391538215],
                                [45.86819987209144, 6.991719912014907],
                                [45.92208520277858, 7.043893795018055],
                                [45.98418643361579, 7.018245614212891],
                                [46.04995609942394, 6.951511564566568],
                                [46.08449157208839, 6.891454223590301],
                                [46.12256207039407, 6.898381393099359],
                                [46.1296964613652, 6.814732162900611],
                                [46.20434524954355, 6.80366083421475],
                                [46.282990769883504, 6.864509851829648],
                                [46.33688407311203, 6.78263705608952],
                                [46.39309255862677, 6.7956649275692085],
                                [46.40755389780494, 6.722868985320351],
                                [46.39472735936455, 6.545175304790927],
                                [46.340165634060874, 6.390036156687233],
                                [46.37112568338626, 6.3269978517135375],
                                [46.3510944327135, 6.279911924662279],
                                [46.27733425851669, 6.237797813525851],
                                [46.22605896768258, 6.295655645057158],
                                [46.20547030935733, 6.232071540724357],
                                [46.158149899601675, 6.175072377878082],
                                [46.13208943594268, 5.956063159932634],
                                [46.10599585856306, 5.832300912634432],
                                [46.063934978382775, 5.807622444833504],
                                [45.98979960381867, 5.809643351753076],
                                [45.93845957829322, 5.831226413621036],
                                [45.93240229486182, 5.862101395990038],
                                [45.838095558126746, 5.873426502484641],
                                [45.804140838702274, 5.913209603821917],
                                [45.739095951312514, 6.042939005987318],
                                [45.75571563232778, 6.166233910329839],
                                [45.704161749692204, 6.18971416977487],
                                [45.685404763162595, 6.239679907775353],
                                [45.69553113948381, 6.330635270345084],
                                [45.778055295582206, 6.383851558657904],
                                [45.80244240743692, 6.423672125473556],
                                [45.884692297393386, 6.470559679970141],
                                [45.90863287329888, 6.509087472467454],
                                [45.82687986970036, 6.552237633503553],
                                [45.795419923318136, 6.60173297249558],
                                [45.79890547186772, 6.661192099251397],
                                [45.72291967208872, 6.711938518958689],
                                [45.77837197402194, 6.802516663522653],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "74", "NOM_DEPT": "HAUTE-SAVOIE"},
                },
                69: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            49.06044982525112,
                            1.689575882111812,
                            49.75830750106765,
                            3.1605832452848968,
                        ),
                        "coordinates": [
                            [
                                [49.232201775163404, 1.7043642065965865],
                                [49.180155278024564, 1.742137397998168],
                                [49.18525912523885, 1.7954686863275515],
                                [49.16263786454188, 1.8852389528169067],
                                [49.17644980799869, 1.9968226136719944],
                                [49.20977574824026, 2.0808878042448358],
                                [49.15288152246086, 2.252488213818398],
                                [49.18640655833579, 2.3109290446865427],
                                [49.16181582456364, 2.3462570508145517],
                                [49.14580320714456, 2.4409026178736455],
                                [49.07965484673244, 2.5905242793946224],
                                [49.10837621896304, 2.633272965218076],
                                [49.06044982525112, 2.7350126834936956],
                                [49.09151015780461, 3.0085155429257675],
                                [49.117554218816146, 3.071884293834167],
                                [49.152576953634764, 3.1396578896700365],
                                [49.19273857569733, 3.0640875194145396],
                                [49.27553205719088, 3.0268878942941857],
                                [49.302338848225304, 2.97439031593416],
                                [49.37711907478125, 3.0953874973379834],
                                [49.43374686813427, 3.0937834703774705],
                                [49.451589762665364, 3.1605832452848968],
                                [49.51340305901281, 3.0957783548212805],
                                [49.543377651791836, 3.1314803354793224],
                                [49.656683091231635, 3.09777622468101],
                                [49.705968560150744, 3.1184031553047866],
                                [49.702672388966874, 2.915712813038834],
                                [49.65595422263167, 2.7936124229581845],
                                [49.6205860518149, 2.7994949073615056],
                                [49.625601863474394, 2.6891419821315017],
                                [49.58141197178742, 2.670723151725744],
                                [49.59708062701417, 2.571493337841171],
                                [49.639467268909165, 2.5047488992503943],
                                [49.65626624025836, 2.373145663229162],
                                [49.70164087681329, 2.247168590692668],
                                [49.68807409174484, 2.1214097069260887],
                                [49.71962996348948, 1.9332098221662726],
                                [49.69898823076107, 1.8938643249004958],
                                [49.75830750106765, 1.7838370588623413],
                                [49.69478564626097, 1.689575882111812],
                                [49.67263435960493, 1.7252046142437356],
                                [49.60539892585883, 1.7045819685135704],
                                [49.531737693641695, 1.7451334451250167],
                                [49.50822302010687, 1.7192326604453183],
                                [49.466150363724154, 1.7663450271414043],
                                [49.409224988863485, 1.7139375433100608],
                                [49.368149815393046, 1.759411755988114],
                                [49.2996937213467, 1.775628840636083],
                                [49.26446416218004, 1.7104793339744566],
                                [49.232201775163404, 1.7043642065965865],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "60", "NOM_DEPT": "OISE"},
                },
                70: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            48.90867932989047,
                            1.6087960706299216,
                            49.232201775163404,
                            2.5905242793946224,
                        ),
                        "coordinates": [
                            [
                                [49.07789415353795, 1.6087960706299216],
                                [49.0781511731843, 1.6736891270071166],
                                [49.04497657550693, 1.7234571618642331],
                                [49.07636122204013, 1.8239503630063805],
                                [49.021776326372276, 1.9378021652564323],
                                [48.998755806188655, 2.0247730444607903],
                                [49.01467871491032, 2.084914920835882],
                                [48.94974074221645, 2.20585834678071],
                                [48.90867932989047, 2.2005910092695036],
                                [48.95096678807721, 2.2909735732251613],
                                [48.97417666856734, 2.3664436276371537],
                                [48.95504632683333, 2.4594899596115933],
                                [49.00981711743891, 2.55306064485419],
                                [49.07965484673244, 2.5905242793946224],
                                [49.14580320714456, 2.4409026178736455],
                                [49.16181582456364, 2.3462570508145517],
                                [49.18640655833579, 2.3109290446865427],
                                [49.15288152246086, 2.252488213818398],
                                [49.20977574824026, 2.0808878042448358],
                                [49.17644980799869, 1.9968226136719944],
                                [49.16263786454188, 1.8852389528169067],
                                [49.18525912523885, 1.7954686863275515],
                                [49.180155278024564, 1.742137397998168],
                                [49.232201775163404, 1.7043642065965865],
                                [49.211867057756656, 1.6757368125175731],
                                [49.13016217033745, 1.655777439712795],
                                [49.07789415353795, 1.6087960706299216],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "95", "NOM_DEPT": "VAL-D'OISE"},
                },
                71: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            46.658252554713975,
                            2.8734906167112504,
                            47.58795617120515,
                            4.230655226496764,
                        ),
                        "coordinates": [
                            [
                                [47.339255985508245, 4.106085850126875],
                                [47.33271278537438, 3.9730845789314024],
                                [47.37831443829053, 3.9706779602609212],
                                [47.39054233152028, 3.7856341851420217],
                                [47.40683466664035, 3.7147823454353084],
                                [47.44553367789057, 3.6789914842274665],
                                [47.46490071650613, 3.580113356556516],
                                [47.497863236330566, 3.5806168100615214],
                                [47.52766801375831, 3.5135049928892266],
                                [47.49392259510354, 3.487879079980051],
                                [47.50886749595519, 3.3972880002653882],
                                [47.472438113851204, 3.3463147218972584],
                                [47.49471952596052, 3.307051239784071],
                                [47.48917911094721, 3.2354769572493565],
                                [47.522966343586994, 3.2046491761957805],
                                [47.54104902333151, 3.122046633548593],
                                [47.58795617120515, 3.10199661377424],
                                [47.558752776952176, 3.0256381393798466],
                                [47.56942879711256, 2.9765380120036067],
                                [47.565970182735235, 2.914297452553034],
                                [47.520423112556664, 2.8746252064056805],
                                [47.444566735803356, 2.928902314704163],
                                [47.34839595883525, 2.8734906167112504],
                                [47.25976318039041, 2.9834041014118906],
                                [47.221996957251605, 2.9816846477683376],
                                [47.129067685143006, 3.0280852399597813],
                                [47.06261687352467, 3.0232152406674615],
                                [47.01914457943622, 3.0757376737966906],
                                [46.955118753700106, 3.0793297925031697],
                                [46.91063036589821, 3.0502941730720203],
                                [46.87767673133036, 3.0680947893123323],
                                [46.794911188525944, 3.0320681893946824],
                                [46.75807894189367, 3.049065356287102],
                                [46.68289184476867, 3.2155498733945853],
                                [46.71674092868996, 3.2697920192933188],
                                [46.684416345410895, 3.3467088070518343],
                                [46.711906067614386, 3.4341330414396496],
                                [46.658252554713975, 3.487153284024355],
                                [46.7158646720816, 3.550392218815862],
                                [46.74945902193753, 3.629423683496518],
                                [46.75247120098577, 3.73619002089105],
                                [46.701502637145154, 3.797329518692337],
                                [46.73887265980929, 3.9233937335663813],
                                [46.7767510975447, 3.9919591863262944],
                                [46.789364691282145, 4.062709832615211],
                                [46.84327237673586, 4.056234450174584],
                                [46.87473433322919, 4.093851364443379],
                                [46.918155606841836, 4.037221978317054],
                                [46.98511001230654, 4.039401951235417],
                                [47.05449482938563, 4.072015136934213],
                                [47.080010034285166, 4.038726355028209],
                                [47.12104166410018, 4.06142733788571],
                                [47.12333757652633, 4.1159670699158095],
                                [47.15050513981915, 4.181888404407953],
                                [47.15541168354447, 4.209834279044644],
                                [47.19895127921225, 4.230655226496764],
                                [47.25028786310221, 4.1780522851486825],
                                [47.237396324140384, 4.135479914723283],
                                [47.339255985508245, 4.106085850126875],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "58", "NOM_DEPT": "NIEVRE"},
                },
                72: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            46.919374625937934,
                            4.066060118363545,
                            48.02946360188034,
                            5.518538729512594,
                        ),
                        "coordinates": [
                            [
                                [46.9798880946405, 5.255236339191406],
                                [47.0180208967574, 5.310049747453535],
                                [47.07298220144243, 5.322186205925132],
                                [47.081977110214815, 5.386011880946295],
                                [47.144397191390595, 5.439973300314684],
                                [47.21602767128051, 5.47662851608292],
                                [47.289347470334135, 5.488282961724511],
                                [47.30418661946959, 5.518538729512594],
                                [47.384062513467185, 5.451397515008267],
                                [47.49901446301563, 5.3992024955272315],
                                [47.496253655362196, 5.447063511552309],
                                [47.54414450478295, 5.496859255517604],
                                [47.60872207291229, 5.477547427463133],
                                [47.63211377458532, 5.425863186006296],
                                [47.60454165280248, 5.374078595885573],
                                [47.61613009899267, 5.239232274239111],
                                [47.65256871238262, 5.173597037303847],
                                [47.64968494441666, 5.108878229414663],
                                [47.68776283651174, 4.979107142832904],
                                [47.76500253040028, 4.949610301299183],
                                [47.80034738345194, 4.982400768988487],
                                [47.866768148099496, 4.9540942495981195],
                                [47.956238623224316, 4.852043179350452],
                                [47.9642022255857, 4.78651260287447],
                                [48.00782938257308, 4.789083695644797],
                                [48.0202323762219, 4.704238250439468],
                                [48.02946360188034, 4.582678644289108],
                                [47.97142319627392, 4.5599688756782095],
                                [47.95715474758692, 4.448998378066956],
                                [47.961173282793276, 4.309003616780037],
                                [47.9256762348538, 4.2934241069450065],
                                [47.84385063868304, 4.2610008241447535],
                                [47.84715746363821, 4.324394417243652],
                                [47.756511310408264, 4.332471702607339],
                                [47.72740297086132, 4.258164266526501],
                                [47.6814099239688, 4.268422869492534],
                                [47.62796570433963, 4.212381292101606],
                                [47.55325916322948, 4.17512808182493],
                                [47.515008579609535, 4.11550026231875],
                                [47.443553393328095, 4.119426533664949],
                                [47.40725128721285, 4.066060118363545],
                                [47.339255985508245, 4.106085850126875],
                                [47.237396324140384, 4.135479914723283],
                                [47.25028786310221, 4.1780522851486825],
                                [47.19895127921225, 4.230655226496764],
                                [47.15541168354447, 4.209834279044644],
                                [47.11432625058055, 4.259600310936345],
                                [47.08164281958383, 4.405487083945717],
                                [47.049999892555, 4.406283415170733],
                                [47.028371557104066, 4.493691403385164],
                                [46.94082023678555, 4.623230215613321],
                                [46.919374625937934, 4.728129651701318],
                                [46.98158693341567, 5.049303736126251],
                                [46.95576520247547, 5.106281375832608],
                                [46.9798880946405, 5.255236339191406],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "21", "NOM_DEPT": "COTE-D'OR"},
                },
                73: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            48.28658587795804,
                            1.9221489648373704,
                            48.77610203162177,
                            2.571660318442073,
                        ),
                        "coordinates": [
                            [
                                [48.77610203162177, 2.2265593271545225],
                                [48.73956019802753, 2.111889242882012],
                                [48.68585180710444, 2.082221274606409],
                                [48.64208882251873, 2.020005696381871],
                                [48.557597387423435, 2.0175740602972896],
                                [48.53307136184394, 1.9674261909808515],
                                [48.45760028606413, 1.9221489648373704],
                                [48.40412484182912, 1.9305557503485924],
                                [48.39938447447992, 1.9765777946992387],
                                [48.28658587795804, 1.9940847180593788],
                                [48.313745436024625, 2.1813499926674265],
                                [48.308672482875515, 2.369810541415244],
                                [48.320719459436056, 2.402664267131608],
                                [48.362015783117755, 2.429832228504419],
                                [48.41125114633111, 2.533731834361712],
                                [48.439446016118225, 2.504749755053753],
                                [48.525239048001154, 2.49952467433224],
                                [48.603849771145576, 2.5437765144069613],
                                [48.65733138882678, 2.53361600680745],
                                [48.69201409164603, 2.571660318442073],
                                [48.735211482171685, 2.5035365695581286],
                                [48.72017592253298, 2.370706732277135],
                                [48.748756235080634, 2.3207180175230313],
                                [48.77610203162177, 2.2265593271545225],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "91", "NOM_DEPT": "ESSONNE"},
                },
                74: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            45.96965998523795,
                            -0.8919599503022404,
                            47.10833699690518,
                            0.21492180826491442,
                        ),
                        "coordinates": [
                            [
                                [46.0955500415297, 0.19735350521616218],
                                [46.13884556432993, 0.21492180826491442],
                                [46.157168244596924, 0.1551113740904494],
                                [46.210932609573995, 0.11283682536372644],
                                [46.267231548998694, 0.12883677213786546],
                                [46.32811314059693, 0.1773687959824542],
                                [46.34939518270097, 0.13759784994026172],
                                [46.304933538922825, 0.07821800902702593],
                                [46.32552885451101, 0.037602239808067595],
                                [46.373496799479916, 0.034219979012944574],
                                [46.411322394513704, -0.01709282434894281],
                                [46.52498101941567, -0.031351255287517144],
                                [46.5947435067776, 0.02598963802815841],
                                [46.66371702380725, -0.04042619019472192],
                                [46.71623331657765, 0.0007042720140887955],
                                [46.81265392500652, -0.020316336069380696],
                                [46.90747700605924, -0.009032410299882686],
                                [47.023133335712934, -0.08769647758767064],
                                [47.064797190818, -0.10212095637964816],
                                [47.10833699690518, -0.18483982751841418],
                                [47.10572466544676, -0.24153794845204798],
                                [47.070771034609585, -0.40077950615793034],
                                [47.08238521770843, -0.4953402437613732],
                                [47.06188673077479, -0.559531871926381],
                                [47.01942614381194, -0.5654683969778384],
                                [46.993322065658454, -0.6199767888274355],
                                [46.98607221005182, -0.7130578012324359],
                                [47.004252209132005, -0.7738774456713039],
                                [46.97581784960786, -0.8919599503022404],
                                [46.93336473376701, -0.8291443983745113],
                                [46.84282850114093, -0.7816473761536221],
                                [46.8086267548513, -0.7008564794263525],
                                [46.767632454457974, -0.7273121698337293],
                                [46.700774642460914, -0.6561893352875904],
                                [46.638027907323625, -0.644063907848707],
                                [46.62039039102902, -0.6141139330666174],
                                [46.53328054778874, -0.6021285989587053],
                                [46.45873492951776, -0.6124259071699322],
                                [46.416229245155975, -0.6406445679433732],
                                [46.386465465455686, -0.5378004980121102],
                                [46.36344857378176, -0.5576498721967054],
                                [46.304258794361935, -0.7504755422947282],
                                [46.24507022173625, -0.7514619974841967],
                                [46.219202505698206, -0.690715475013079],
                                [46.13775275457054, -0.6199574101252718],
                                [46.14422952781576, -0.5469968076890206],
                                [46.10670520800869, -0.5060833286611991],
                                [46.084717640247526, -0.40050831263592807],
                                [46.079753777667634, -0.28173430941987676],
                                [45.96965998523795, -0.10293687953014748],
                                [45.99347998149095, -0.04143104082306168],
                                [46.05592180291526, -0.03199529342544053],
                                [46.052847829356985, 0.019272784617024384],
                                [46.09389590958498, 0.07297225926176226],
                                [46.0955500415297, 0.19735350521616218],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "79", "NOM_DEPT": "DEUX-SEVRES"},
                },
                75: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            48.03547931277979,
                            -3.6591438196705757,
                            48.867416308253006,
                            -1.9124900704350776,
                        ),
                        "coordinates": [
                            [
                                [48.133745563473816, -2.2872784304005114],
                                [48.1705970187894, -2.2247373292770836],
                                [48.2463785700459, -2.186961247227295],
                                [48.252903482093345, -2.110118931164647],
                                [48.29832786131649, -2.0532925486538494],
                                [48.27953190981902, -2.0141005291993967],
                                [48.31710984530666, -1.9548327221541837],
                                [48.51884141988655, -1.9124900704350776],
                                [48.53880790488251, -1.9480369010443905],
                                [48.56611290198357, -2.006894935706843],
                                [48.56767919673737, -2.075983866873217],
                                [48.6044100285603, -2.1237080247752895],
                                [48.57889313289854, -2.1642613521091087],
                                [48.595386986537584, -2.223947576787102],
                                [48.68092282170517, -2.3128652882169667],
                                [48.62251656640193, -2.473428281486323],
                                [48.538129672654826, -2.631267666969782],
                                [48.53113342751236, -2.681558937117988],
                                [48.5935282745742, -2.819598830141578],
                                [48.65056933154874, -2.826935021352181],
                                [48.727215066784595, -2.9479038576324985],
                                [48.75833756841586, -2.9436531177995517],
                                [48.77591418615603, -3.0293966218671415],
                                [48.86673762495404, -3.113976113733975],
                                [48.867416308253006, -3.231756943127049],
                                [48.79722346331915, -3.4307245025981694],
                                [48.83499877620536, -3.5131996274964488],
                                [48.775499964695776, -3.585008235573639],
                                [48.670017885042235, -3.5812485466634145],
                                [48.65920978066925, -3.6591438196705757],
                                [48.610153346220144, -3.6493779946144103],
                                [48.54092077173928, -3.5538598863227393],
                                [48.49643946876788, -3.604061396321586],
                                [48.42892323446267, -3.590415422993112],
                                [48.37776678483146, -3.5545842830629764],
                                [48.33551998786712, -3.5567868257426127],
                                [48.2822731470352, -3.518440717872892],
                                [48.185746943072566, -3.564838973733329],
                                [48.17112526547107, -3.336754735635011],
                                [48.14001476485905, -3.27224433962783],
                                [48.15849094354359, -3.1552540693335716],
                                [48.206363809489616, -3.116373512585393],
                                [48.199360646242376, -3.033540216127106],
                                [48.1205797308541, -2.781951132488677],
                                [48.11932466386193, -2.652301006956973],
                                [48.04788395292574, -2.6700509484423693],
                                [48.03547931277979, -2.6311897590265936],
                                [48.07041003849149, -2.5747859613043027],
                                [48.157844785512516, -2.4948185697824816],
                                [48.168611326672774, -2.408904872170661],
                                [48.122103008406654, -2.371364753161675],
                                [48.133745563473816, -2.2872784304005114],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "22", "NOM_DEPT": "COTES-D'ARMOR"},
                },
                76: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            45.93073235641238,
                            2.2810476101300576,
                            46.803876576773305,
                            3.9980416518372484,
                        ),
                        "coordinates": [
                            [
                                [46.794911188525944, 3.0320681893946824],
                                [46.803876576773305, 2.9599146908207157],
                                [46.73528787880109, 2.8276163881602265],
                                [46.71890739681203, 2.774488053228389],
                                [46.7393873052656, 2.7049751251942706],
                                [46.6372195698165, 2.5966478252098466],
                                [46.55328003970227, 2.614955459722656],
                                [46.51969984591659, 2.536652020779054],
                                [46.53269744464404, 2.4829288047758253],
                                [46.512211347274814, 2.3520035556502914],
                                [46.45351915029326, 2.2857578150118907],
                                [46.42040537318102, 2.2810476101300576],
                                [46.32927925675374, 2.3230243720211274],
                                [46.329982476677515, 2.3918607677139923],
                                [46.281147774598125, 2.478940668864652],
                                [46.23943958277255, 2.51631108338946],
                                [46.143032182829025, 2.5653790586982073],
                                [46.11847766171901, 2.6406912317167386],
                                [46.223324326165475, 2.733052145656418],
                                [46.19621262362186, 2.810275114252155],
                                [46.255486129901755, 2.8557252864968374],
                                [46.242917468274975, 2.9371457775851466],
                                [46.20349381071083, 2.9095928618303133],
                                [46.12178012989871, 2.971756635840471],
                                [46.06567797651341, 3.166531859715606],
                                [46.05506094849443, 3.371595622264062],
                                [46.074292455804986, 3.419029561174583],
                                [46.017936870152774, 3.4635034430082112],
                                [46.02413780633835, 3.5884696050346547],
                                [45.93073235641238, 3.6940178008729885],
                                [45.97378454864044, 3.708883724363124],
                                [45.97385869263016, 3.788909241913359],
                                [45.995967743331704, 3.8254431917706775],
                                [46.04562293029197, 3.80676406021388],
                                [46.08798388977018, 3.8218687105012146],
                                [46.154851332057156, 3.7897619940586127],
                                [46.25485708711847, 3.8048868330812957],
                                [46.27590543921817, 3.8995333931893303],
                                [46.31919378739559, 3.9866257932147806],
                                [46.39922459383981, 3.9772154801510964],
                                [46.46546757106011, 3.9980416518372484],
                                [46.489755621859324, 3.957937642803863],
                                [46.48125092995185, 3.8904705648097107],
                                [46.53113227681356, 3.8340059039329697],
                                [46.519899554588264, 3.8017563441985818],
                                [46.56756978217593, 3.7432867634118923],
                                [46.660582165836225, 3.6969523102437005],
                                [46.70720877171206, 3.6379005417614154],
                                [46.74945902193753, 3.629423683496518],
                                [46.7158646720816, 3.550392218815862],
                                [46.658252554713975, 3.487153284024355],
                                [46.711906067614386, 3.4341330414396496],
                                [46.684416345410895, 3.3467088070518343],
                                [46.71674092868996, 3.2697920192933188],
                                [46.68289184476867, 3.2155498733945853],
                                [46.75807894189367, 3.049065356287102],
                                [46.794911188525944, 3.0320681893946824],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "03", "NOM_DEPT": "ALLIER"},
                },
                77: {
                    "geometry": {
                        "type": "MultiPolygon",
                        "bbox": (
                            45.08880721589074,
                            -1.5353220120922217,
                            46.355624759961664,
                            0.004330746876933936,
                        ),
                        "coordinates": [
                            [
                                [
                                    [46.20012841110215, -1.3421247126758935],
                                    [46.204880769084305, -1.4221002716213327],
                                    [46.25771384564713, -1.5143725982265899],
                                    [46.204394676268265, -1.5353220120922217],
                                    [46.20211883930829, -1.461598406633688],
                                    [46.15588808122243, -1.3549590855946727],
                                    [46.20012841110215, -1.3421247126758935],
                                ]
                            ],
                            [
                                [
                                    [45.90668049019489, -1.215499860497111],
                                    [45.99041558337048, -1.2479234576289204],
                                    [45.992977450421975, -1.312761781453581],
                                    [46.02726602149255, -1.3659335056314696],
                                    [45.95144459142133, -1.3839143994579735],
                                    [45.87816722390549, -1.2661507817954076],
                                    [45.804536905465575, -1.2364229444496377],
                                    [45.82969725881442, -1.1956193786522464],
                                    [45.88674805159812, -1.188433122652762],
                                    [45.90668049019489, -1.215499860497111],
                                ]
                            ],
                            [
                                [
                                    [45.191632555616025, 0.004330746876933936],
                                    [45.24789117263397, -0.04416800947411795],
                                    [45.24807269185132, -0.11538526357329361],
                                    [45.28895157818027, -0.10878607028506979],
                                    [45.32143289837574, -0.22670231706753935],
                                    [45.359870837250256, -0.28089591660714885],
                                    [45.40874172938641, -0.2497593835924437],
                                    [45.455677709323595, -0.2674239730736361],
                                    [45.49164146613392, -0.2461560346224077],
                                    [45.5644938737933, -0.2967152234141246],
                                    [45.608919202664524, -0.37591965312829384],
                                    [45.65617988507809, -0.4089294944559108],
                                    [45.741668657543315, -0.41583863552489936],
                                    [45.80655862747694, -0.2731191101089069],
                                    [45.775745644085404, -0.2217452863431165],
                                    [45.79573700033925, -0.15309474428582864],
                                    [45.87066390237826, -0.11540038254695688],
                                    [45.91102062998216, -0.13166445066648028],
                                    [45.96965998523795, -0.10293687953014748],
                                    [46.079753777667634, -0.28173430941987676],
                                    [46.084717640247526, -0.40050831263592807],
                                    [46.10670520800869, -0.5060833286611991],
                                    [46.14422952781576, -0.5469968076890206],
                                    [46.13775275457054, -0.6199574101252718],
                                    [46.219202505698206, -0.690715475013079],
                                    [46.24507022173625, -0.7514619974841967],
                                    [46.304258794361935, -0.7504755422947282],
                                    [46.340369117324386, -0.839878203866059],
                                    [46.312856004616734, -0.9348886609093259],
                                    [46.355624759961664, -1.0138072401150018],
                                    [46.310276919155996, -1.129404177492153],
                                    [46.26134367831711, -1.1111638836886621],
                                    [46.21324548926303, -1.1989980101944613],
                                    [46.16594526939377, -1.2238754783330195],
                                    [46.1242629149501, -1.1264112813835243],
                                    [46.01118088641006, -1.0526867952056995],
                                    [45.990507551332094, -1.0989490769387051],
                                    [45.94990908084705, -1.0643196475545222],
                                    [45.819898614850615, -1.1371605532141837],
                                    [45.781571555535336, -1.242573859956351],
                                    [45.70589632544041, -1.2372284214926084],
                                    [45.6469813279075, -1.115849451052298],
                                    [45.61143397047429, -1.0096306936697144],
                                    [45.574693032813535, -1.0257418763479118],
                                    [45.43508336826085, -0.8410572249719415],
                                    [45.3692088136439, -0.7740181405098189],
                                    [45.32176994097864, -0.7526821734869675],
                                    [45.32114282458838, -0.5944806728104985],
                                    [45.29770833934139, -0.5595072006432503],
                                    [45.2794739946481, -0.4291954727294871],
                                    [45.16477966588985, -0.3940718179854259],
                                    [45.16755837660476, -0.34233753875966755],
                                    [45.11408527738146, -0.2550869802991912],
                                    [45.08880721589074, -0.15295329411286412],
                                    [45.1213888362867, -0.08770283087044228],
                                    [45.10238433596342, -0.0402003397896402],
                                    [45.191632555616025, 0.004330746876933936],
                                ]
                            ],
                        ],
                    },
                    "attributes": {"CODE_DEPT": "17", "NOM_DEPT": "CHARENTE-MARITIME"},
                },
                78: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            44.61553167652982,
                            2.062914291973062,
                            45.47849879874484,
                            3.3613425807398936,
                        ),
                        "coordinates": [
                            [
                                [44.971411709678975, 3.3613425807398936],
                                [45.014233878924166, 3.3471986847617567],
                                [45.03607778789878, 3.2972503187682016],
                                [45.09513611769881, 3.3257851579159827],
                                [45.12042440957931, 3.2880332175079103],
                                [45.27197144658481, 3.222465248668949],
                                [45.28418729762223, 3.1179979977042014],
                                [45.35437310008832, 3.1034981328800555],
                                [45.28712067830808, 3.016710134630249],
                                [45.309125835256815, 2.9486247512965202],
                                [45.3657751174624, 2.9215557561638335],
                                [45.3923406923832, 2.852378684057164],
                                [45.38155782083131, 2.714857227145231],
                                [45.44265505156296, 2.651429936294738],
                                [45.47849879874484, 2.508408697113082],
                                [45.41883841080893, 2.4874679068775096],
                                [45.384258469857066, 2.4418608930121475],
                                [45.41430579076644, 2.378246243484016],
                                [45.32755821486306, 2.350479440865637],
                                [45.29015191925762, 2.2714136874802593],
                                [45.22085230029835, 2.195361138057307],
                                [45.160192640152275, 2.2136969761815397],
                                [45.081495873975626, 2.171755685373443],
                                [45.05602988503954, 2.09515947189117],
                                [44.98552052019745, 2.1329789677394575],
                                [44.97650640551561, 2.062914291973062],
                                [44.87201148950672, 2.094212310672087],
                                [44.790024398712326, 2.1716362748643747],
                                [44.75310757902523, 2.1534919160094748],
                                [44.63806619142596, 2.1694177928364122],
                                [44.61553167652982, 2.2074752855308404],
                                [44.643844101683406, 2.208413991565611],
                                [44.66969245597248, 2.326785795750648],
                                [44.63887764359621, 2.4350033478315978],
                                [44.721284895454446, 2.556123813120712],
                                [44.77575324565893, 2.562709168390778],
                                [44.79280887269849, 2.5993575445949],
                                [44.843167608376426, 2.6026810523917403],
                                [44.9072261221646, 2.70643491497566],
                                [44.94122218473673, 2.738254293313791],
                                [44.87362935290199, 2.8019551055054883],
                                [44.87148933996955, 2.8496583078406252],
                                [44.8030106101463, 2.8795722036394493],
                                [44.779198272865976, 2.9345215070232764],
                                [44.72863892315705, 2.9232644794453155],
                                [44.6446766126243, 2.981676986530433],
                                [44.81717597962275, 3.0615255979734926],
                                [44.83358841808968, 3.0994768968798603],
                                [44.88677480310235, 3.1054983095640436],
                                [44.863734531317185, 3.182311971252496],
                                [44.91623789304496, 3.2496925236752454],
                                [44.971411709678975, 3.3613425807398936],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "15", "NOM_DEPT": "CANTAL"},
                },
                79: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            43.21280863308409,
                            2.5399619094859687,
                            43.96901626259538,
                            4.194441206758988,
                        ),
                        "coordinates": [
                            [
                                [43.422959744104, 2.5657873980365586],
                                [43.34622186231968, 2.5399619094859687],
                                [43.298706986396866, 2.6016030790296316],
                                [43.25778564580618, 2.772248225673249],
                                [43.322412805617326, 2.8327620472635995],
                                [43.32013114159761, 3.004349268167806],
                                [43.28853825294427, 3.004740938100306],
                                [43.24700506844496, 3.1472079664155532],
                                [43.24916714805367, 3.2010265503923754],
                                [43.21280863308409, 3.24056113717041],
                                [43.27039600610153, 3.343863387032852],
                                [43.290209536435995, 3.4303316940306616],
                                [43.27333336221085, 3.510954322025528],
                                [43.35542655651463, 3.6026190412473764],
                                [43.392279064377114, 3.66215922818193],
                                [43.441035909910426, 3.796663802013001],
                                [43.51684377775199, 3.9071342421308484],
                                [43.552446652511314, 4.011185334395634],
                                [43.554370946408625, 4.1010416754063925],
                                [43.585562468156866, 4.150215691493674],
                                [43.654303826233026, 4.194441206758988],
                                [43.73388653553411, 4.144780927023586],
                                [43.81146444231582, 4.002046166191344],
                                [43.88559322066372, 3.917385092127717],
                                [43.8664240348707, 3.830797043559706],
                                [43.91929773950883, 3.824905456819552],
                                [43.96687037520115, 3.787325021892116],
                                [43.96901626259538, 3.726990344828379],
                                [43.916978566757564, 3.623588615095356],
                                [43.86552224087741, 3.5754482408134063],
                                [43.855624713961625, 3.5307009207380955],
                                [43.91159816844731, 3.424448067668623],
                                [43.913832893255, 3.3583594413044624],
                                [43.89835231151905, 3.275074750407491],
                                [43.81387268634425, 3.203111724562128],
                                [43.83164737994541, 3.0598559764719786],
                                [43.693077287037454, 3.060740509271366],
                                [43.708516252330526, 2.98535037366361],
                                [43.694667785188855, 2.9354629666803715],
                                [43.66002074537221, 2.9159815194674086],
                                [43.6141387864358, 2.7545235571938624],
                                [43.64559678398747, 2.711169474843746],
                                [43.650146162495055, 2.6432637215975134],
                                [43.56663335506618, 2.615607192520078],
                                [43.525794099032574, 2.658651329156613],
                                [43.48016355800575, 2.6595399785833935],
                                [43.431093773006396, 2.606081177961043],
                                [43.422959744104, 2.5657873980365586],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "34", "NOM_DEPT": "HERAULT"},
                },
                80: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            44.11571934778836,
                            4.650615013437554,
                            45.344046640836105,
                            5.801469996094522,
                        ),
                        "coordinates": [
                            [
                                [44.70677851287, 5.801469996094522],
                                [44.6960702841541, 5.759044078047863],
                                [44.75246442874924, 5.62708487257189],
                                [44.79242749679306, 5.4641587549688655],
                                [44.922290598248225, 5.483647138020397],
                                [45.02278614732907, 5.483609211781887],
                                [45.07078365917332, 5.449788835244157],
                                [45.03613916354606, 5.388382939418146],
                                [45.08331022009428, 5.1793846576859695],
                                [45.17126853879258, 5.188573507748233],
                                [45.2484020449113, 5.176540876984406],
                                [45.248335918090646, 5.121425532367966],
                                [45.31905467974735, 5.05431872757624],
                                [45.344046640836105, 4.989191483458711],
                                [45.297454009351384, 4.880237763487565],
                                [45.29836066114294, 4.800493926884063],
                                [45.16448183151871, 4.812473966213054],
                                [45.004791813947854, 4.837672652853049],
                                [44.93665163053356, 4.886589299843449],
                                [44.81708784467795, 4.822513080923934],
                                [44.77862679935857, 4.76621554467615],
                                [44.65469880413612, 4.779060115885166],
                                [44.581549114708366, 4.7102664999416985],
                                [44.542230674151796, 4.693639580520507],
                                [44.452309460126756, 4.69865229412497],
                                [44.43066448441976, 4.667367377491741],
                                [44.32980579151128, 4.650615013437554],
                                [44.32538168266027, 4.762251228111599],
                                [44.29659556592805, 4.802876705944989],
                                [44.23231488509351, 4.814083573320775],
                                [44.30813976056078, 5.060564583015947],
                                [44.28208386834488, 5.14972713298067],
                                [44.230944996200954, 5.154903556803357],
                                [44.20104672066314, 5.384523055943826],
                                [44.15528473021912, 5.383240887752098],
                                [44.15224864024982, 5.435755865794636],
                                [44.11571934778836, 5.498787806458752],
                                [44.13639078272547, 5.543986124993946],
                                [44.188041650949074, 5.576187167563139],
                                [44.167586051913645, 5.639593544372252],
                                [44.191433131858965, 5.676037325543462],
                                [44.26691847226595, 5.686555113440127],
                                [44.26709147544853, 5.646781325357401],
                                [44.32830301747026, 5.631598076087924],
                                [44.337177520811714, 5.4930715607447445],
                                [44.42494737031899, 5.418530667075709],
                                [44.49113051875815, 5.513340558551903],
                                [44.465545293621936, 5.603638674628631],
                                [44.53159832212814, 5.630798606104504],
                                [44.54327372797923, 5.5972487980667855],
                                [44.6178810074043, 5.6496309488227565],
                                [44.65329030204329, 5.790619766631355],
                                [44.70677851287, 5.801469996094522],
                            ],
                            [
                                [44.36481842003465, 4.892909784975503],
                                [44.40778504385655, 4.918515009368784],
                                [44.43136994934865, 4.970436397484981],
                                [44.392766145968594, 5.015759498726315],
                                [44.32614028646893, 5.013377111169766],
                                [44.297463038388315, 4.978583367650993],
                                [44.30415309780472, 4.8895301353902365],
                                [44.36481842003465, 4.892909784975503],
                            ],
                        ],
                    },
                    "attributes": {"CODE_DEPT": "26", "NOM_DEPT": "DROME"},
                },
                81: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            42.33375178289351,
                            1.7298881048979535,
                            42.918341437261006,
                            3.1732198139368313,
                        ),
                        "coordinates": [
                            [
                                [42.57362343207788, 1.7861250110638964],
                                [42.56358508914754, 1.7498821218907066],
                                [42.49532568149937, 1.7298881048979535],
                                [42.48178622958981, 1.8346228986722801],
                                [42.42404869009333, 1.9582842085598802],
                                [42.362048166797734, 1.9859066164117019],
                                [42.36270013981574, 2.083598101455443],
                                [42.42342744508062, 2.156341756737746],
                                [42.43835800634602, 2.2578002255424416],
                                [42.38887656698712, 2.435482130866189],
                                [42.33964655377135, 2.4829628754848416],
                                [42.33375178289351, 2.5400343955805043],
                                [42.357933234601845, 2.5778245531567956],
                                [42.34117820769782, 2.6717654689105332],
                                [42.404968311039255, 2.675046174210866],
                                [42.42535725427018, 2.7532002138160783],
                                [42.41856867596309, 2.799242281304166],
                                [42.45852270899326, 2.8414109625242325],
                                [42.47314100863664, 3.0407621096853417],
                                [42.425509881233154, 3.085437328583658],
                                [42.434877393314636, 3.1732198139368313],
                                [42.51294127329124, 3.1335847928885587],
                                [42.55014015956973, 3.049606421697757],
                                [42.678248196502366, 3.0354222951214984],
                                [42.83815011921807, 3.0434985865888815],
                                [42.88486022074883, 2.917114990593263],
                                [42.918341437261006, 2.8652738803519484],
                                [42.89598872881156, 2.789053819259419],
                                [42.837574151816995, 2.7400003158100112],
                                [42.830431065988684, 2.697577646248594],
                                [42.8498316897035, 2.5090117260388043],
                                [42.83693276356474, 2.452474760710876],
                                [42.837442775831846, 2.327116045977923],
                                [42.73412195489036, 2.357535079462851],
                                [42.70779157620242, 2.322006120391769],
                                [42.66391836976527, 2.166053682054993],
                                [42.66156483553937, 2.0005149149001973],
                                [42.61692049379412, 1.9717596461471245],
                                [42.58140598425563, 1.8744850028357225],
                                [42.57362343207788, 1.7861250110638964],
                            ]
                        ],
                    },
                    "attributes": {
                        "CODE_DEPT": "66",
                        "NOM_DEPT": "PYRENEES-ORIENTALES",
                    },
                },
                82: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            45.05607309559144,
                            5.623748035268078,
                            45.93845957829322,
                            7.184274774893671,
                        ),
                        "coordinates": [
                            [
                                [45.126847913866314, 6.260566197557926],
                                [45.10449394991729, 6.36292281324225],
                                [45.06181851097422, 6.393914586674507],
                                [45.05607309559144, 6.486234598441579],
                                [45.09413629464072, 6.4812541096424034],
                                [45.109326928199906, 6.629987338137473],
                                [45.140124971361885, 6.68006735247428],
                                [45.15974375221742, 6.767935179515762],
                                [45.12716081574408, 6.84985884318955],
                                [45.208060557766785, 6.968757184292427],
                                [45.25569487340002, 7.13759030527828],
                                [45.326512299604914, 7.110695394012847],
                                [45.40748063151992, 7.184274774893671],
                                [45.4341946873311, 7.113516455211972],
                                [45.46943936219542, 7.0997891354009095],
                                [45.50441719658229, 7.000331708478396],
                                [45.63990159437462, 7.000690534148291],
                                [45.64709230917701, 6.934608837460737],
                                [45.70283279544943, 6.829114564865921],
                                [45.77837197402194, 6.802516663522653],
                                [45.72291967208872, 6.711938518958689],
                                [45.79890547186772, 6.661192099251397],
                                [45.795419923318136, 6.60173297249558],
                                [45.82687986970036, 6.552237633503553],
                                [45.90863287329888, 6.509087472467454],
                                [45.884692297393386, 6.470559679970141],
                                [45.80244240743692, 6.423672125473556],
                                [45.778055295582206, 6.383851558657904],
                                [45.69553113948381, 6.330635270345084],
                                [45.685404763162595, 6.239679907775353],
                                [45.704161749692204, 6.18971416977487],
                                [45.75571563232778, 6.166233910329839],
                                [45.739095951312514, 6.042939005987318],
                                [45.804140838702274, 5.913209603821917],
                                [45.838095558126746, 5.873426502484641],
                                [45.93240229486182, 5.862101395990038],
                                [45.93845957829322, 5.831226413621036],
                                [45.82295599649881, 5.7868562241797115],
                                [45.7292223955843, 5.7761608991802635],
                                [45.71092632945919, 5.704119379498135],
                                [45.64850161239944, 5.689187102194641],
                                [45.613268326764185, 5.623748035268078],
                                [45.47254042424705, 5.736372335642621],
                                [45.44065533936712, 5.782081150720109],
                                [45.406796712103805, 5.879738401559338],
                                [45.4923087213814, 5.966169653050879],
                                [45.43791952965108, 6.049753851710852],
                                [45.438897845399275, 6.121272339213556],
                                [45.39316148783123, 6.177450938299202],
                                [45.317948507606715, 6.184450320779225],
                                [45.288287215984546, 6.131944929909638],
                                [45.244270268835876, 6.125696481423487],
                                [45.163732283278, 6.189207693158914],
                                [45.126847913866314, 6.260566197557926],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "73", "NOM_DEPT": "SAVOIE"},
                },
                83: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            44.191433131858965,
                            5.418530667075709,
                            45.126847913866314,
                            7.077108800206923,
                        ),
                        "coordinates": [
                            [
                                [44.70677851287, 5.801469996094522],
                                [44.65329030204329, 5.790619766631355],
                                [44.6178810074043, 5.6496309488227565],
                                [44.54327372797923, 5.5972487980667855],
                                [44.53159832212814, 5.630798606104504],
                                [44.465545293621936, 5.603638674628631],
                                [44.49113051875815, 5.513340558551903],
                                [44.42494737031899, 5.418530667075709],
                                [44.337177520811714, 5.4930715607447445],
                                [44.32830301747026, 5.631598076087924],
                                [44.26709147544853, 5.646781325357401],
                                [44.26691847226595, 5.686555113440127],
                                [44.191433131858965, 5.676037325543462],
                                [44.21020776523787, 5.75549419659688],
                                [44.210998662542806, 5.881793583616447],
                                [44.27890195531251, 5.823911889045942],
                                [44.27153166809449, 5.912323479912074],
                                [44.39505926669922, 5.953670382950493],
                                [44.45053588827667, 6.071139333430848],
                                [44.461959822985584, 6.15561504901071],
                                [44.381700391997015, 6.228221718294849],
                                [44.41225003856591, 6.262481962582939],
                                [44.46383091832782, 6.233718236049833],
                                [44.522072579043936, 6.362000081358196],
                                [44.46928995962832, 6.413884950226283],
                                [44.44549275371157, 6.562444503095604],
                                [44.44712877640474, 6.63237632755871],
                                [44.54130010645836, 6.684305299896708],
                                [44.58890871380474, 6.772207133133651],
                                [44.60858882906438, 6.83980166742822],
                                [44.65949945810214, 6.914488202179288],
                                [44.654816299146766, 6.948335091404862],
                                [44.69014148867834, 6.987055135805779],
                                [44.680917509173426, 7.077108800206923],
                                [44.78944471324737, 6.999571239749256],
                                [44.83931596763314, 7.006773778890771],
                                [44.86202607200865, 6.933687243037528],
                                [44.852900819527065, 6.859863090422122],
                                [44.90736131510599, 6.749745773276749],
                                [44.971220086046884, 6.763455936171166],
                                [45.01672934689641, 6.7408068424989125],
                                [45.019617540780494, 6.673884165477502],
                                [45.109326928199906, 6.629987338137473],
                                [45.09413629464072, 6.4812541096424034],
                                [45.05607309559144, 6.486234598441579],
                                [45.06181851097422, 6.393914586674507],
                                [45.10449394991729, 6.36292281324225],
                                [45.126847913866314, 6.260566197557926],
                                [45.108750055807405, 6.229388123209472],
                                [45.01246916508484, 6.203927022398643],
                                [45.003856776770675, 6.3181981975765975],
                                [44.94128447146301, 6.3588400606704845],
                                [44.854778989917435, 6.355361452664249],
                                [44.87325988167463, 6.302846745398276],
                                [44.85265497741959, 6.25054409332542],
                                [44.86407279122649, 6.136224190737252],
                                [44.815908261733654, 6.056342958572753],
                                [44.83809609775419, 6.030210546238998],
                                [44.80453012289716, 5.94951924784745],
                                [44.754705804536066, 5.915233300411789],
                                [44.75074454418582, 5.850398663313628],
                                [44.70677851287, 5.801469996094522],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "05", "NOM_DEPT": "HAUTES-ALPES"},
                },
                84: {
                    "geometry": {
                        "type": "MultiPolygon",
                        "bbox": (
                            43.658685905164766,
                            4.649223666100485,
                            44.43136994934865,
                            5.7573329775827045,
                        ),
                        "coordinates": [
                            [
                                [
                                    [44.36481842003465, 4.892909784975503],
                                    [44.30415309780472, 4.8895301353902365],
                                    [44.297463038388315, 4.978583367650993],
                                    [44.32614028646893, 5.013377111169766],
                                    [44.392766145968594, 5.015759498726315],
                                    [44.43136994934865, 4.970436397484981],
                                    [44.40778504385655, 4.918515009368784],
                                    [44.36481842003465, 4.892909784975503],
                                ]
                            ],
                            [
                                [
                                    [43.924059473490566, 4.739060856654237],
                                    [43.91138205123055, 4.853093547765335],
                                    [43.87164726913833, 4.966309299927298],
                                    [43.827792913138744, 5.02953344530474],
                                    [43.78788168846555, 5.051490035086313],
                                    [43.73510332278255, 5.187972296540633],
                                    [43.74767288112557, 5.229990308924739],
                                    [43.735021431958224, 5.31850282672],
                                    [43.68110432174805, 5.439245661034277],
                                    [43.65901134759575, 5.531453034372501],
                                    [43.658685905164766, 5.6069435191164425],
                                    [43.72462253878876, 5.753638490630264],
                                    [43.729409113755324, 5.7573329775827045],
                                    [43.82511098585936, 5.654445137414141],
                                    [43.82992112219788, 5.5781897912212175],
                                    [43.913772843753264, 5.607126670731598],
                                    [43.946002285646465, 5.512089542555731],
                                    [44.02870768768523, 5.543656674317526],
                                    [44.06343920865494, 5.5026367853279545],
                                    [44.11571934778836, 5.498787806458752],
                                    [44.15224864024982, 5.435755865794636],
                                    [44.15528473021912, 5.383240887752098],
                                    [44.20104672066314, 5.384523055943826],
                                    [44.230944996200954, 5.154903556803357],
                                    [44.28208386834488, 5.14972713298067],
                                    [44.30813976056078, 5.060564583015947],
                                    [44.23231488509351, 4.814083573320775],
                                    [44.29659556592805, 4.802876705944989],
                                    [44.32538168266027, 4.762251228111599],
                                    [44.32980579151128, 4.650615013437554],
                                    [44.27035986501095, 4.649223666100485],
                                    [44.18742154948268, 4.722074664233517],
                                    [44.10367246401243, 4.707458356688192],
                                    [44.06505409747017, 4.787978024928094],
                                    [43.98647454846487, 4.842093969959472],
                                    [43.924059473490566, 4.739060856654237],
                                ]
                            ],
                        ],
                    },
                    "attributes": {"CODE_DEPT": "84", "NOM_DEPT": "VAUCLUSE"},
                },
                85: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            46.34721849587296,
                            0.8674688807081561,
                            47.27667661630457,
                            2.2043972607989812,
                        ),
                        "coordinates": [
                            [
                                [46.4240665008181, 2.167785718138384],
                                [46.45796019235814, 2.1516716067091237],
                                [46.48439997524805, 2.2043972607989812],
                                [46.55734628168219, 2.158700190947214],
                                [46.60286242584107, 2.18562886154938],
                                [46.69555371540337, 2.1407244355816926],
                                [46.74249480206491, 2.065751312591214],
                                [46.774358601474674, 2.1153606164888155],
                                [46.82944826814362, 2.0488103323451234],
                                [46.87986509549618, 2.1262038890477335],
                                [46.93399643786305, 2.0706986163554206],
                                [47.01573583572996, 2.0933838995940373],
                                [47.040016048649505, 2.051487760798448],
                                [47.10601550210712, 2.048374881247615],
                                [47.125417513727896, 1.9664139793909294],
                                [47.101949545642825, 1.882721849834433],
                                [47.130846812692134, 1.7745813093652696],
                                [47.17802935443287, 1.8421086266284743],
                                [47.21930815773424, 1.8390792420529518],
                                [47.26587806829791, 1.7058305011298698],
                                [47.27667661630457, 1.5924281213159723],
                                [47.237967921224396, 1.448462247960517],
                                [47.18622542473178, 1.3266655450453897],
                                [47.12205127770917, 1.3653609997076237],
                                [47.096975273440314, 1.311672909460613],
                                [47.03783413818556, 1.2730568495660919],
                                [47.039622972819544, 1.1614221724181901],
                                [47.015842398188234, 1.0776154683629737],
                                [46.98064041873546, 1.0498776400419187],
                                [46.76154066839267, 0.9888132945329691],
                                [46.74821910504848, 0.8674688807081561],
                                [46.69279335231604, 0.9247556936578988],
                                [46.625736651822876, 0.8943018154002147],
                                [46.580792108421264, 0.94202375883659],
                                [46.567763998821995, 1.0147644249831798],
                                [46.50640188056708, 1.1459353661062848],
                                [46.449236175812, 1.1516045347766355],
                                [46.43222161336161, 1.212690238083345],
                                [46.383951622152935, 1.1772799568053667],
                                [46.37099465262579, 1.303056786055347],
                                [46.40012317441315, 1.356022895309223],
                                [46.34721849587296, 1.4151905101137503],
                                [46.42652499450048, 1.5223068332769552],
                                [46.386815849085174, 1.6448464161558107],
                                [46.38895871366094, 1.7277108990817451],
                                [46.4300383389509, 1.819500417665562],
                                [46.43091738935583, 1.9930823669027022],
                                [46.40890318674807, 2.088941803334241],
                                [46.4240665008181, 2.167785718138384],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "36", "NOM_DEPT": "INDRE"},
                },
                86: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            41.83681486608311,
                            8.573411068108614,
                            43.0117229260943,
                            9.558834031337039,
                        ),
                        "coordinates": [
                            [
                                [41.85869824227228, 9.40226832441199],
                                [41.95247536073487, 9.412573752377247],
                                [42.10416397232962, 9.549983013016071],
                                [42.285263441361955, 9.558834031337039],
                                [42.37996722190875, 9.532670166153812],
                                [42.428489580925785, 9.543397471188387],
                                [42.545944023399095, 9.533193015205356],
                                [42.662236031630215, 9.449196243675715],
                                [42.68612187004434, 9.446380758225057],
                                [42.80510332631401, 9.49237931225356],
                                [42.87413170694094, 9.473063477929271],
                                [42.98640316480421, 9.463553614767086],
                                [43.0117229260943, 9.421761206671862],
                                [42.99446130565274, 9.340869996691138],
                                [42.916238918113834, 9.353823296916074],
                                [42.83467992024285, 9.311020338565653],
                                [42.794801298609066, 9.34256025591115],
                                [42.737812432908356, 9.344474787466684],
                                [42.67431591000078, 9.293321757624451],
                                [42.71851210134236, 9.254452272413712],
                                [42.73656106751822, 9.16688288642443],
                                [42.71460676752977, 9.085757984829682],
                                [42.644271176255096, 9.020690214855307],
                                [42.62897074250373, 8.886523760118468],
                                [42.599055946968434, 8.808932860020777],
                                [42.5698603416326, 8.804094980454657],
                                [42.51522405863273, 8.666504962154614],
                                [42.41573555548147, 8.655224073914713],
                                [42.416825413431944, 8.608422093704316],
                                [42.38140571205032, 8.573411068108614],
                                [42.37343635383299, 8.640801666424288],
                                [42.31755804188288, 8.819561377056068],
                                [42.253859280700944, 8.904766989145308],
                                [42.20692343140828, 9.04565931380628],
                                [42.13021371520013, 9.072186891776042],
                                [42.10777443178612, 9.119729450195367],
                                [42.026017143380564, 9.160818391906192],
                                [42.027596960539064, 9.22108402465599],
                                [41.85558903234784, 9.227497390904743],
                                [41.83681486608311, 9.329200877550077],
                                [41.85869824227228, 9.40226832441199],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "2B", "NOM_DEPT": "HAUTE-CORSE"},
                },
                87: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            45.44421907802482,
                            0.6297424639524395,
                            46.40012317441315,
                            1.898730779182943,
                        ),
                        "coordinates": [
                            [
                                [45.44421907802482, 1.2531518386328937],
                                [45.48993789201231, 1.2870567570435631],
                                [45.46688830500579, 1.350077879284767],
                                [45.528081031575745, 1.412058914052018],
                                [45.56594313830816, 1.4803697950912302],
                                [45.54936632471628, 1.5571958047036873],
                                [45.58035190912391, 1.6376634511377184],
                                [45.68036337807322, 1.7838678002323438],
                                [45.664658270083336, 1.8713480467629338],
                                [45.6982775512041, 1.898730779182943],
                                [45.7327797889896, 1.875140102478583],
                                [45.797714818456456, 1.8808988285366512],
                                [45.84282757445294, 1.7727491731275804],
                                [45.835114020235736, 1.6766374034760068],
                                [45.85746515857901, 1.6023984681707657],
                                [45.9334124264404, 1.6087196458716777],
                                [45.95280423814569, 1.5325001755915217],
                                [46.03541014153877, 1.5491757848158922],
                                [46.17975461207027, 1.4527947858284072],
                                [46.21545110095231, 1.3749003074212889],
                                [46.305894207375275, 1.4437697350516507],
                                [46.34721849587296, 1.4151905101137503],
                                [46.40012317441315, 1.356022895309223],
                                [46.37099465262579, 1.303056786055347],
                                [46.383951622152935, 1.1772799568053667],
                                [46.360466281243085, 1.1297576486963083],
                                [46.34303442800397, 1.026995442933731],
                                [46.28097399864579, 1.0058867393780462],
                                [46.285257481169126, 0.9072715939898939],
                                [46.21096277430388, 0.7963255053030057],
                                [46.128581728488285, 0.8234337839605995],
                                [46.04787811648369, 0.8179096763959524],
                                [46.010453963771624, 0.9256254984735032],
                                [45.95743607843123, 0.942591996012476],
                                [45.91975549444778, 0.8629055339639634],
                                [45.82108209588079, 0.7822321483214054],
                                [45.80561793866405, 0.7164398059782177],
                                [45.76311968057405, 0.714888400126834],
                                [45.71456998977267, 0.6297424639524395],
                                [45.6675695723418, 0.775843134926025],
                                [45.61832385402003, 0.7515297126109166],
                                [45.575870643461926, 0.811500332264728],
                                [45.611582010503184, 0.9345523684647926],
                                [45.60020929025313, 1.0358490435954522],
                                [45.487782926278754, 1.1197844789851372],
                                [45.44421907802482, 1.2531518386328937],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "87", "NOM_DEPT": "HAUTE-VIENNE"},
                },
                88: {
                    "geometry": {
                        "type": "MultiPolygon",
                        "bbox": (
                            46.266571614816904,
                            -2.301813103356834,
                            47.08389319899775,
                            -0.5378004980121102,
                        ),
                        "coordinates": [
                            [
                                [
                                    [46.989742762366824, -2.301813103356834],
                                    [46.96087838866197, -2.264380088499401],
                                    [47.00781894429174, -2.2183340290348834],
                                    [47.02462125927166, -2.2872305163820257],
                                    [46.989742762366824, -2.301813103356834],
                                ]
                            ],
                            [
                                [
                                    [47.028906494075635, -1.980414486742876],
                                    [47.00991814012838, -2.0273554296334564],
                                    [46.948066582804636, -2.0627409343597365],
                                    [46.89015018115229, -2.1538266883941843],
                                    [46.826396356812694, -2.144508393520906],
                                    [46.692704991393796, -1.9428810018395475],
                                    [46.60857792818521, -1.856017609992669],
                                    [46.493418144353235, -1.8123496382428275],
                                    [46.492758463623176, -1.777141798763278],
                                    [46.414221541074, -1.6270608317160031],
                                    [46.39734952406837, -1.502145422584782],
                                    [46.34235901019938, -1.465941563501806],
                                    [46.34861328663727, -1.3667425638808843],
                                    [46.266571614816904, -1.2073944924206372],
                                    [46.31634695785251, -1.201087723676226],
                                    [46.310276919155996, -1.129404177492153],
                                    [46.355624759961664, -1.0138072401150018],
                                    [46.312856004616734, -0.9348886609093259],
                                    [46.340369117324386, -0.839878203866059],
                                    [46.304258794361935, -0.7504755422947282],
                                    [46.36344857378176, -0.5576498721967054],
                                    [46.386465465455686, -0.5378004980121102],
                                    [46.416229245155975, -0.6406445679433732],
                                    [46.45873492951776, -0.6124259071699322],
                                    [46.53328054778874, -0.6021285989587053],
                                    [46.62039039102902, -0.6141139330666174],
                                    [46.638027907323625, -0.644063907848707],
                                    [46.700774642460914, -0.6561893352875904],
                                    [46.767632454457974, -0.7273121698337293],
                                    [46.8086267548513, -0.7008564794263525],
                                    [46.84282850114093, -0.7816473761536221],
                                    [46.93336473376701, -0.8291443983745113],
                                    [46.97581784960786, -0.8919599503022404],
                                    [47.00890804339756, -0.9334603151811864],
                                    [47.00568547430042, -1.0554031085144766],
                                    [47.02954516258657, -1.1485704887534407],
                                    [47.08389319899775, -1.2712067087150385],
                                    [47.03948346966516, -1.2946349782361042],
                                    [47.03085386698655, -1.3786124689367822],
                                    [46.95218446660972, -1.3729857700949506],
                                    [46.926272854355254, -1.4561316296061424],
                                    [47.03786198958929, -1.4821311833973994],
                                    [47.01834875737957, -1.5523222833408654],
                                    [46.98150474523172, -1.5535636972370026],
                                    [46.88389115282978, -1.5007668577856463],
                                    [46.86007983436468, -1.5485110748777025],
                                    [46.89049286319805, -1.6897612739864445],
                                    [46.92959568215277, -1.7510623002403711],
                                    [46.9320337241545, -1.8309821821134158],
                                    [46.99471092059495, -1.9432276192598656],
                                    [47.028906494075635, -1.980414486742876],
                                ]
                            ],
                        ],
                    },
                    "attributes": {"CODE_DEPT": "85", "NOM_DEPT": "VENDEE"},
                },
                89: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            43.046619004635104,
                            5.6718750056992775,
                            43.806365977888035,
                            6.933726236453418,
                        ),
                        "coordinates": [
                            [
                                [43.17926878690493, 5.6718750056992775],
                                [43.1435877868191, 5.694880043308294],
                                [43.10936452456005, 5.812729626801352],
                                [43.07828493675108, 5.804564531287972],
                                [43.046619004635104, 5.857450411938569],
                                [43.10766029019478, 5.941245658009144],
                                [43.077473324630404, 6.031440047836646],
                                [43.07930848251309, 6.124045766317685],
                                [43.10853535096938, 6.183993790284117],
                                [43.12104461810048, 6.26529674054148],
                                [43.0899129219639, 6.368261479285514],
                                [43.14489830267707, 6.387572821703614],
                                [43.15022275222098, 6.493498246377528],
                                [43.18862998328654, 6.559636361254335],
                                [43.17251047188624, 6.635531400239646],
                                [43.19592734658188, 6.659331915728428],
                                [43.27879196431358, 6.6773116237656085],
                                [43.31821636550589, 6.665952517510405],
                                [43.41288050528172, 6.739811023717541],
                                [43.41816384523436, 6.859478029180435],
                                [43.48006801088501, 6.933726236453418],
                                [43.502535727819236, 6.884230099335205],
                                [43.59907918794692, 6.908012993627824],
                                [43.62818033606128, 6.798740654262],
                                [43.66648795918856, 6.760801398395701],
                                [43.738166980478354, 6.753535969205429],
                                [43.788950567095455, 6.636395800176685],
                                [43.806365977888035, 6.52476198332243],
                                [43.791594458434176, 6.414428052603499],
                                [43.76036041847219, 6.413483066219064],
                                [43.73636766488724, 6.356960735074889],
                                [43.799511976998794, 6.216709972579084],
                                [43.76217559136371, 6.1828860082819075],
                                [43.69416334085517, 6.036131813943927],
                                [43.732584595184825, 5.90120740256815],
                                [43.75565738832376, 5.781343238677484],
                                [43.729409113755324, 5.7573329775827045],
                                [43.72462253878876, 5.753638490630264],
                                [43.68896399525111, 5.813243983394541],
                                [43.66051789095841, 5.799061112603832],
                                [43.641716113697846, 5.700215221457389],
                                [43.61373206007321, 5.682144833819898],
                                [43.55089752725021, 5.724610447116372],
                                [43.48217012690397, 5.698802592390259],
                                [43.434295125206056, 5.751846953791003],
                                [43.39915686931637, 5.682787396731936],
                                [43.26733799967126, 5.760928945485899],
                                [43.23605829449105, 5.683909137465822],
                                [43.17926878690493, 5.6718750056992775],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "83", "NOM_DEPT": "VAR"},
                },
                90: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            48.69201409164603,
                            2.3207180175230313,
                            48.860849617648306,
                            2.6136476481340414,
                        ),
                        "coordinates": [
                            [
                                [48.8074366758147, 2.5922804883088015],
                                [48.860849617648306, 2.4956469644616233],
                                [48.849238273407416, 2.416339717281352],
                                [48.817012713055696, 2.3318953139887446],
                                [48.748756235080634, 2.3207180175230313],
                                [48.72017592253298, 2.370706732277135],
                                [48.735211482171685, 2.5035365695581286],
                                [48.69201409164603, 2.571660318442073],
                                [48.761027192292545, 2.6136476481340414],
                                [48.8074366758147, 2.5922804883088015],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "94", "NOM_DEPT": "VAL-DE-MARNE"},
                },
                91: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            48.748756235080634,
                            2.1515778037276103,
                            48.95096678807721,
                            2.3318953139887446,
                        ),
                        "coordinates": [
                            [
                                [48.817012713055696, 2.3318953139887446],
                                [48.834807742280645, 2.255142901863683],
                                [48.869069480870024, 2.2317363464837308],
                                [48.90045886733916, 2.319884458526643],
                                [48.95096678807721, 2.2909735732251613],
                                [48.90867932989047, 2.2005910092695036],
                                [48.87333985214219, 2.1528691414227357],
                                [48.81702039834037, 2.1515778037276103],
                                [48.77610203162177, 2.2265593271545225],
                                [48.748756235080634, 2.3207180175230313],
                                [48.817012713055696, 2.3318953139887446],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "92", "NOM_DEPT": "HAUTS-DE-SEINE"},
                },
                92: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            44.122695330490544,
                            2.981676986530433,
                            44.971411709678975,
                            3.998162987763964,
                        ),
                        "coordinates": [
                            [
                                [44.6446766126243, 2.981676986530433],
                                [44.559014394432964, 3.083593896775788],
                                [44.50348970314472, 3.068542786200033],
                                [44.454870231099065, 3.13573609856136],
                                [44.38337811871574, 3.119711177226503],
                                [44.30837023621564, 3.1542516260589815],
                                [44.2844635736958, 3.1252288254578002],
                                [44.22625501460891, 3.2298475773263053],
                                [44.197910434234956, 3.3577995033411128],
                                [44.17075587210565, 3.3736480448306843],
                                [44.12909826593223, 3.4397298934659637],
                                [44.122695330490544, 3.633491144032294],
                                [44.175488044182295, 3.637769161351025],
                                [44.18275878035751, 3.678640671819198],
                                [44.12738907948688, 3.7969951126604835],
                                [44.130073752440985, 3.862104986455048],
                                [44.1707937260686, 3.9526044819739092],
                                [44.247795429889, 3.9513171396124562],
                                [44.305217941025674, 3.922858913740669],
                                [44.32838999677705, 3.952331315351652],
                                [44.387999052346906, 3.8859181039452233],
                                [44.399567503492314, 3.944362317344653],
                                [44.45979755586323, 3.998162987763964],
                                [44.57379092180415, 3.9451489956301886],
                                [44.592708047769605, 3.9051719910706293],
                                [44.743863434670935, 3.862527190139651],
                                [44.83869734813899, 3.7406507355868404],
                                [44.82877808873478, 3.666364914643008],
                                [44.869938644505325, 3.6595223843815874],
                                [44.87542977006507, 3.5943359966689923],
                                [44.83219404802294, 3.589348917106291],
                                [44.81537151910512, 3.475773707159976],
                                [44.90076835769558, 3.4179705141646854],
                                [44.94484250197586, 3.412834742275399],
                                [44.971411709678975, 3.3613425807398936],
                                [44.91623789304496, 3.2496925236752454],
                                [44.863734531317185, 3.182311971252496],
                                [44.88677480310235, 3.1054983095640436],
                                [44.83358841808968, 3.0994768968798603],
                                [44.81717597962275, 3.0615255979734926],
                                [44.6446766126243, 2.981676986530433],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "48", "NOM_DEPT": "LOZERE"},
                },
                93: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            43.16254563167401,
                            4.230283393392478,
                            43.924059473490566,
                            5.813243983394541,
                        ),
                        "coordinates": [
                            [
                                [43.460185432726384, 4.230283393392478],
                                [43.44621502092873, 4.554920338571666],
                                [43.422706954965456, 4.5880988691773705],
                                [43.372136705961424, 4.562800334318894],
                                [43.34641234548359, 4.6617830951472214],
                                [43.34994067645596, 4.759588900377178],
                                [43.33261665440881, 4.855048529182454],
                                [43.40468173427723, 4.8668500280141265],
                                [43.42610491918483, 4.967705599857735],
                                [43.32728665294986, 5.041038908355625],
                                [43.33171447327496, 5.240586909552984],
                                [43.36087640052119, 5.311030077911203],
                                [43.32195654694643, 5.3620550042845565],
                                [43.28236341769543, 5.345688435376646],
                                [43.207124911642964, 5.363644360087066],
                                [43.21449364341566, 5.536931681001044],
                                [43.16254563167401, 5.600889900320151],
                                [43.17926878690493, 5.6718750056992775],
                                [43.23605829449105, 5.683909137465822],
                                [43.26733799967126, 5.760928945485899],
                                [43.39915686931637, 5.682787396731936],
                                [43.434295125206056, 5.751846953791003],
                                [43.48217012690397, 5.698802592390259],
                                [43.55089752725021, 5.724610447116372],
                                [43.61373206007321, 5.682144833819898],
                                [43.641716113697846, 5.700215221457389],
                                [43.66051789095841, 5.799061112603832],
                                [43.68896399525111, 5.813243983394541],
                                [43.72462253878876, 5.753638490630264],
                                [43.658685905164766, 5.6069435191164425],
                                [43.65901134759575, 5.531453034372501],
                                [43.68110432174805, 5.439245661034277],
                                [43.735021431958224, 5.31850282672],
                                [43.74767288112557, 5.229990308924739],
                                [43.73510332278255, 5.187972296540633],
                                [43.78788168846555, 5.051490035086313],
                                [43.827792913138744, 5.02953344530474],
                                [43.87164726913833, 4.966309299927298],
                                [43.91138205123055, 4.853093547765335],
                                [43.924059473490566, 4.739060856654237],
                                [43.86747754714164, 4.641909591242105],
                                [43.80640869163021, 4.654821446467849],
                                [43.68746240297296, 4.593032248301324],
                                [43.69923776661919, 4.487236861293796],
                                [43.62067757183952, 4.4270280421178025],
                                [43.5611278006361, 4.409349673740098],
                                [43.49762691783989, 4.238105541141803],
                                [43.460185432726384, 4.230283393392478],
                            ],
                            [
                                [43.401407831650545, 5.096382025203831],
                                [43.40397723018537, 5.05956976393125],
                                [43.463556640011085, 5.051880922172624],
                                [43.46966221650609, 5.006007239562997],
                                [43.529723334348155, 5.015464900192831],
                                [43.52549492153407, 5.108666384243251],
                                [43.40958412270749, 5.157538221661901],
                                [43.401407831650545, 5.096382025203831],
                            ],
                        ],
                    },
                    "attributes": {"CODE_DEPT": "13", "NOM_DEPT": "BOUCHES-DU-RHONE"},
                },
                94: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            48.817012713055696,
                            2.2317363464837308,
                            48.902007792208785,
                            2.416339717281352,
                        ),
                        "coordinates": [
                            [
                                [48.817012713055696, 2.3318953139887446],
                                [48.849238273407416, 2.416339717281352],
                                [48.902007792208785, 2.385151006972503],
                                [48.90045886733916, 2.319884458526643],
                                [48.869069480870024, 2.2317363464837308],
                                [48.834807742280645, 2.255142901863683],
                                [48.817012713055696, 2.3318953139887446],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "75", "NOM_DEPT": "PARIS"},
                },
                95: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            48.8074366758147,
                            2.2909735732251613,
                            49.00981711743891,
                            2.6025984314319826,
                        ),
                        "coordinates": [
                            [
                                [48.8074366758147, 2.5922804883088015],
                                [48.888884130524836, 2.5626221662429587],
                                [48.92935660278061, 2.6025984314319826],
                                [49.00981711743891, 2.55306064485419],
                                [48.95504632683333, 2.4594899596115933],
                                [48.97417666856734, 2.3664436276371537],
                                [48.95096678807721, 2.2909735732251613],
                                [48.90045886733916, 2.319884458526643],
                                [48.902007792208785, 2.385151006972503],
                                [48.849238273407416, 2.416339717281352],
                                [48.860849617648306, 2.4956469644616233],
                                [48.8074366758147, 2.5922804883088015],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "93", "NOM_DEPT": "SEINE-SAINT-DENIS"},
                },
            },
        },
    },
    1: {
        "geolayer": geolayer_fr_dept_data_and_geometry,
        "out_crs": 4326,
        "in_crs": 2154,
        "bbox": True,
        "return_value": {
            "metadata": {
                "name": "FRANCE_DPT_GENERALIZE_LAMB93_ROUND_DATA_AND_GEOMETRY",
                "fields": {
                    "CODE_DEPT": {"type": "String", "width": 2, "index": 0},
                    "NOM_DEPT": {"type": "String", "width": 23, "index": 1},
                },
                "geometry_ref": {
                    "type": {"Polygon", "MultiPolygon"},
                    "crs": 4326,
                    "extent": (
                        41.368214489339856,
                        -4.793344007924674,
                        51.08854281218866,
                        9.558834031337039,
                    ),
                },
            },
            "features": {
                0: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            43.31088599158549,
                            -0.2428365587430673,
                            44.078227249212006,
                            1.2013370084855526,
                        ),
                        "coordinates": [
                            [
                                [43.31088599158549, 0.6068109749570955],
                                [43.31720926544647, 0.6559378827169783],
                                [43.376630810082574, 0.7175914463388223],
                                [43.416975022578875, 0.8205416805525506],
                                [43.4063326892777, 0.917251134513719],
                                [43.3626517065442, 0.9780837577086208],
                                [43.473338092390065, 1.0181843408377866],
                                [43.59481295502015, 1.2013370084855526],
                                [43.634175893375954, 1.1475492440427302],
                                [43.64497503168885, 1.0876957388199553],
                                [43.78737246570886, 0.9539831166064945],
                                [43.78433052070778, 0.906155770674725],
                                [43.864698458132736, 0.8994393128667493],
                                [43.923289163046476, 0.8628924476067087],
                                [43.94224249346573, 0.7600848328151357],
                                [44.040785422701155, 0.8604173969632192],
                                [44.03591070642859, 0.7757831291372458],
                                [44.06519923501576, 0.7418847912050011],
                                [44.025145965594625, 0.6665917738469163],
                                [44.078227249212006, 0.5979775801101926],
                                [44.053722419531994, 0.5390309523710256],
                                [44.055237448974, 0.4595156323439901],
                                [44.0287619833259, 0.44244991475496326],
                                [43.993057181274324, 0.30409006822726914],
                                [44.0146417100197, 0.18957513112649643],
                                [43.98314313658292, 0.07604560969926086],
                                [43.916471143129584, 0.07664688901341983],
                                [43.90018804605384, 0.032556764180923806],
                                [43.94504687607565, -0.07359844651969412],
                                [43.93791976442837, -0.1791090595179048],
                                [43.891067750109656, -0.23393876198190033],
                                [43.875183336159544, -0.19099217321599574],
                                [43.73701668569468, -0.19414330237234037],
                                [43.71408748429112, -0.23258236946731775],
                                [43.58497620901365, -0.2428365587430673],
                                [43.596404001570654, -0.17641328064610742],
                                [43.5824058976317, -0.0967829732087753],
                                [43.60465738319822, -0.015780894995831136],
                                [43.56554046143868, -0.0019248187812953763],
                                [43.5188072498529, 0.056081443916197675],
                                [43.517369919818584, 0.11212423457670333],
                                [43.43291627195161, 0.13798238183895667],
                                [43.37118267445077, 0.1820312140000635],
                                [43.385790922905464, 0.2772545000281133],
                                [43.32618057240136, 0.4980338187920962],
                                [43.31088599158549, 0.6068109749570955],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "32", "NOM_DEPT": "GERS"},
                },
                1: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            43.98314313658292,
                            -0.1406884798527587,
                            44.762284673952365,
                            1.0751408247250978,
                        ),
                        "coordinates": [
                            [
                                [44.577324783565565, 1.0751408247250978],
                                [44.64361045554161, 0.9791284687246183],
                                [44.59730727091491, 0.8699961633461994],
                                [44.627001476439105, 0.8170042739845019],
                                [44.69188957907682, 0.8270009642517763],
                                [44.67784707846914, 0.6574344166312163],
                                [44.70652766853691, 0.6304884773468264],
                                [44.64633711715288, 0.41470651574900513],
                                [44.66221103663619, 0.36557538473802004],
                                [44.73743575883074, 0.3354490861907089],
                                [44.762284673952365, 0.2973255098237856],
                                [44.730481039785595, 0.15300384600841968],
                                [44.682444103785436, 0.13372640074632025],
                                [44.661072124006985, 0.182677659153478],
                                [44.61612295595807, 0.15360786253340622],
                                [44.55304661779892, 0.04056782018280631],
                                [44.50506278713605, -0.015453699893016915],
                                [44.418543403742476, -0.01055239618525492],
                                [44.38987879184508, 0.018233646559888256],
                                [44.33761004988665, -0.08575207965013022],
                                [44.2967257980246, -0.034811250980738874],
                                [44.246757992226044, -0.06662475964814332],
                                [44.226404747689884, -0.1406884798527587],
                                [44.15240992875157, -0.12915451548994528],
                                [44.14999595086847, -0.004232390832892187],
                                [44.13065240342956, 0.03459384382220977],
                                [44.12422070347952, 0.13510828700872374],
                                [44.08677044166998, 0.10082062971801448],
                                [44.00084249917964, 0.06269801329290979],
                                [43.98314313658292, 0.07604560969926086],
                                [44.0146417100197, 0.18957513112649643],
                                [43.993057181274324, 0.30409006822726914],
                                [44.0287619833259, 0.44244991475496326],
                                [44.055237448974, 0.4595156323439901],
                                [44.053722419531994, 0.5390309523710256],
                                [44.078227249212006, 0.5979775801101926],
                                [44.025145965594625, 0.6665917738469163],
                                [44.06519923501576, 0.7418847912050011],
                                [44.10226981270581, 0.7528835731451475],
                                [44.12632969467469, 0.86877365550795],
                                [44.23827002933658, 0.9190898187097757],
                                [44.27644247710553, 0.9499239562135766],
                                [44.32330810855775, 0.8734701152053458],
                                [44.36637485759438, 0.8873307771559802],
                                [44.36263857861528, 1.049803151007228],
                                [44.378513265035394, 1.0640838318649108],
                                [44.480041109061666, 1.0090253989657332],
                                [44.53612714227498, 1.0131666459229496],
                                [44.577324783565565, 1.0751408247250978],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "47", "NOM_DEPT": "LOT-ET-GARONNE"},
                },
                2: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            44.6960702841541,
                            4.755996992712003,
                            45.88327273564142,
                            6.3588400606704845,
                        ),
                        "coordinates": [
                            [
                                [45.29836066114294, 4.800493926884063],
                                [45.297454009351384, 4.880237763487565],
                                [45.344046640836105, 4.989191483458711],
                                [45.31905467974735, 5.05431872757624],
                                [45.248335918090646, 5.121425532367966],
                                [45.2484020449113, 5.176540876984406],
                                [45.17126853879258, 5.188573507748233],
                                [45.08331022009428, 5.1793846576859695],
                                [45.03613916354606, 5.388382939418146],
                                [45.07078365917332, 5.449788835244157],
                                [45.02278614732907, 5.483609211781887],
                                [44.922290598248225, 5.483647138020397],
                                [44.79242749679306, 5.4641587549688655],
                                [44.75246442874924, 5.62708487257189],
                                [44.6960702841541, 5.759044078047863],
                                [44.70677851287, 5.801469996094522],
                                [44.75074454418582, 5.850398663313628],
                                [44.754705804536066, 5.915233300411789],
                                [44.80453012289716, 5.94951924784745],
                                [44.83809609775419, 6.030210546238998],
                                [44.815908261733654, 6.056342958572753],
                                [44.86407279122649, 6.136224190737252],
                                [44.85265497741959, 6.25054409332542],
                                [44.87325988167463, 6.302846745398276],
                                [44.854778989917435, 6.355361452664249],
                                [44.94128447146301, 6.3588400606704845],
                                [45.003856776770675, 6.3181981975765975],
                                [45.01246916508484, 6.203927022398643],
                                [45.108750055807405, 6.229388123209472],
                                [45.126847913866314, 6.260566197557926],
                                [45.163732283278, 6.189207693158914],
                                [45.244270268835876, 6.125696481423487],
                                [45.288287215984546, 6.131944929909638],
                                [45.317948507606715, 6.184450320779225],
                                [45.39316148783123, 6.177450938299202],
                                [45.438897845399275, 6.121272339213556],
                                [45.43791952965108, 6.049753851710852],
                                [45.4923087213814, 5.966169653050879],
                                [45.406796712103805, 5.879738401559338],
                                [45.44065533936712, 5.782081150720109],
                                [45.47254042424705, 5.736372335642621],
                                [45.613268326764185, 5.623748035268078],
                                [45.71359345746489, 5.5455415978088505],
                                [45.80712379566377, 5.42264142008713],
                                [45.8310937764943, 5.434944676804955],
                                [45.88327273564142, 5.3538271958050325],
                                [45.85493340191009, 5.309169396437734],
                                [45.78936901099018, 5.266894883868229],
                                [45.77168800093879, 5.191532760208243],
                                [45.81337808264366, 5.101067478338777],
                                [45.73945335950924, 5.094526879742294],
                                [45.70770885564475, 5.131048366350085],
                                [45.63720294798378, 5.035148740524161],
                                [45.60626780465844, 4.901457719834113],
                                [45.5723005698916, 4.808696981728118],
                                [45.5234402120416, 4.868481734036511],
                                [45.45570734978023, 4.756935570818616],
                                [45.36567226076599, 4.755996992712003],
                                [45.29836066114294, 4.800493926884063],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "38", "NOM_DEPT": "ISERE"},
                },
                3: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            50.04217932424791,
                            1.5577890976332025,
                            51.006505154665284,
                            3.173376482382538,
                        ),
                        "coordinates": [
                            [
                                [51.006505154665284, 2.067712027611001],
                                [50.984084640724895, 1.915776261224723],
                                [50.937891615577456, 1.7288531641107558],
                                [50.89013244896873, 1.6640946642444194],
                                [50.86734568892891, 1.5806383872468284],
                                [50.79187042766536, 1.604213474027494],
                                [50.69967640419992, 1.5607115203796038],
                                [50.5373524567793, 1.5854134517805314],
                                [50.40471793675981, 1.5577890976332025],
                                [50.35215320244089, 1.641543920995599],
                                [50.33101039989745, 1.670715509846568],
                                [50.36186618072208, 1.7787842601942672],
                                [50.31177877534883, 1.9180007470953697],
                                [50.287428042736344, 1.9461316429136999],
                                [50.24882125974279, 2.0778202954555876],
                                [50.20554490563295, 2.0957483707167426],
                                [50.226839899619605, 2.2738282654200974],
                                [50.20977035832257, 2.370204907638782],
                                [50.23030237700429, 2.4517852065078483],
                                [50.194562024118035, 2.4956903275727766],
                                [50.1554848214444, 2.3897770566865675],
                                [50.10064240686793, 2.4145079258525888],
                                [50.136999469996475, 2.4766865519087604],
                                [50.141605436861035, 2.551329915710551],
                                [50.11341281005765, 2.576019813733672],
                                [50.07739311900277, 2.857843650412817],
                                [50.04217932424791, 2.87653264314694],
                                [50.05374055513492, 3.090253620620082],
                                [50.12420173433414, 3.0957569207512843],
                                [50.183715151473976, 3.1561320895920617],
                                [50.24110767125754, 3.173376482382538],
                                [50.379846956513916, 2.993078464231492],
                                [50.4416400980408, 3.037672306035308],
                                [50.48176905740127, 3.0207925423124586],
                                [50.512778020799246, 2.9647097377674005],
                                [50.501557815660604, 2.8989518584324676],
                                [50.52538845142136, 2.8259824668620874],
                                [50.6032712281948, 2.8051660601438893],
                                [50.65656635139436, 2.8404494526472543],
                                [50.663678139297865, 2.7690409100193936],
                                [50.63129225354633, 2.713850503520111],
                                [50.617951505356416, 2.630516060197486],
                                [50.631244941936494, 2.495948921017839],
                                [50.672765602799466, 2.40779242678447],
                                [50.74090632543495, 2.34089102647672],
                                [50.81054861626229, 2.2134304216785434],
                                [50.883452469254024, 2.18390456104644],
                                [50.998427200370195, 2.097600537080802],
                                [51.006505154665284, 2.067712027611001],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "62", "NOM_DEPT": "PAS-DE-CALAIS"},
                },
                4: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            49.235656063432884,
                            4.031390794494156,
                            50.1607314288971,
                            5.393536658328508,
                        ),
                        "coordinates": [
                            [
                                [49.405642294757534, 4.047972977986833],
                                [49.40418703243856, 4.143169752612987],
                                [49.38225617648581, 4.24830818454738],
                                [49.32779732810991, 4.306756525620349],
                                [49.28064492915537, 4.422583188651028],
                                [49.296651189312385, 4.575868215345435],
                                [49.235656063432884, 4.625104107270341],
                                [49.256759043801544, 4.686074799511886],
                                [49.23576093816036, 4.826941205469512],
                                [49.25907433894352, 4.8942062202820455],
                                [49.23686584630137, 4.950989232683009],
                                [49.27405171210352, 5.051180998120573],
                                [49.335913874705334, 5.026436999727152],
                                [49.421924473125145, 5.1158969719764285],
                                [49.4991534717053, 5.062396105126222],
                                [49.59307211738767, 5.118278729173794],
                                [49.563534256220265, 5.162975033383016],
                                [49.55928995633117, 5.311756637860767],
                                [49.61708773850276, 5.393536658328508],
                                [49.63085901368822, 5.350332008544783],
                                [49.69607357001345, 5.26917913122673],
                                [49.6929164776751, 5.166194556636604],
                                [49.76373048634974, 5.093503384949336],
                                [49.76192871159604, 5.063182643598133],
                                [49.820795061082386, 4.873874799688422],
                                [49.864787135293696, 4.854192609787469],
                                [49.896178950948524, 4.8833076505019655],
                                [49.94647303906409, 4.8501895621955295],
                                [49.95839770922962, 4.790903141595087],
                                [50.09762527596348, 4.8685301585153855],
                                [50.15202976662415, 4.879551552800034],
                                [50.1607314288971, 4.824292330401957],
                                [50.13639695682964, 4.762161208292365],
                                [50.06492226522151, 4.683190239835278],
                                [49.995498425939175, 4.6888659727293],
                                [49.98550714809432, 4.593059650212624],
                                [49.94668308724302, 4.510410432978069],
                                [49.93750459397252, 4.446940783287939],
                                [49.963560807658, 4.333646634903396],
                                [49.95782375745278, 4.233068423333533],
                                [49.856522649594936, 4.2485071443588325],
                                [49.78178059627039, 4.20958854124873],
                                [49.75710160233298, 4.250088858677236],
                                [49.67792125134356, 4.127021546188527],
                                [49.628478163833556, 4.099316041330109],
                                [49.614289972299225, 4.031390794494156],
                                [49.57112749860687, 4.076570889635557],
                                [49.50853465720682, 4.040711745102368],
                                [49.405642294757534, 4.047972977986833],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "08", "NOM_DEPT": "ARDENNES"},
                },
                5: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            47.9256762348538,
                            3.3919598867876517,
                            48.70745423752744,
                            4.858919933219106,
                        ),
                        "coordinates": [
                            [
                                [48.39027303882033, 3.4147915595010967],
                                [48.36909719472573, 3.4981527640993844],
                                [48.27133989892487, 3.6168043332338455],
                                [48.225740470572546, 3.6216038851697063],
                                [48.13921190362741, 3.667869602845747],
                                [48.169707832950834, 3.740291245795231],
                                [48.10254956016531, 3.8049683849961107],
                                [47.98379240722837, 3.850029315571996],
                                [47.93917007405483, 3.9020865465480417],
                                [47.92699565753336, 4.1117857473984065],
                                [47.9699414025263, 4.199158053352666],
                                [47.9256762348538, 4.2934241069450065],
                                [47.961173282793276, 4.309003616780037],
                                [47.95715474758692, 4.448998378066956],
                                [47.97142319627392, 4.5599688756782095],
                                [48.02946360188034, 4.582678644289108],
                                [48.0202323762219, 4.704238250439468],
                                [48.07312791926578, 4.688818526238874],
                                [48.11820899819213, 4.730610406781701],
                                [48.10319242347872, 4.8193072949588815],
                                [48.141758855401065, 4.850099917169891],
                                [48.26363849150269, 4.858919933219106],
                                [48.347359803339394, 4.809737759938721],
                                [48.39485512882371, 4.716095686333967],
                                [48.47054866778951, 4.653455248176321],
                                [48.53188730232318, 4.670183207291811],
                                [48.553807130712464, 4.614026636401957],
                                [48.525252271641655, 4.545406992928758],
                                [48.56126039348743, 4.40306312166006],
                                [48.615578923326495, 4.315905486866125],
                                [48.700277029531, 4.3255940122986445],
                                [48.70745423752744, 4.166386793257749],
                                [48.70106898077084, 4.080262439820496],
                                [48.66387541820995, 4.001695483416846],
                                [48.60343162808371, 3.9492266572894206],
                                [48.516104417807576, 3.822742058660399],
                                [48.53746785521082, 3.730879401425958],
                                [48.541298263185546, 3.634028277746641],
                                [48.62028467657408, 3.5556137492385345],
                                [48.604809134470905, 3.5038535314822115],
                                [48.533562692399734, 3.4234423807070566],
                                [48.424322153455364, 3.3919598867876517],
                                [48.39027303882033, 3.4147915595010967],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "10", "NOM_DEPT": "AUBE"},
                },
                6: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            43.48006801088501,
                            6.636395800176685,
                            44.36104783803612,
                            7.716933970025215,
                        ),
                        "coordinates": [
                            [
                                [44.36104783803612, 6.887429900902961],
                                [44.31610570751232, 6.796090992510113],
                                [44.24984330468263, 6.723993885002385],
                                [44.169253930861004, 6.686536427072905],
                                [44.078606586955765, 6.755280297628582],
                                [44.043235362043184, 6.745713950501123],
                                [43.99060185096185, 6.836004210977612],
                                [43.95479401195955, 6.8518918622455915],
                                [43.92796536503885, 6.913088787529998],
                                [43.88912075689406, 6.884610185550848],
                                [43.91836301148648, 6.830709312232407],
                                [43.87210825687496, 6.745556290785885],
                                [43.87365480225297, 6.697323345466609],
                                [43.788950567095455, 6.636395800176685],
                                [43.738166980478354, 6.753535969205429],
                                [43.66648795918856, 6.760801398395701],
                                [43.62818033606128, 6.798740654262],
                                [43.59907918794692, 6.908012993627824],
                                [43.502535727819236, 6.884230099335205],
                                [43.48006801088501, 6.933726236453418],
                                [43.54544860181737, 6.971832403990882],
                                [43.54158089325735, 7.040446281575287],
                                [43.60527535172133, 7.12646929285388],
                                [43.65740341986589, 7.167667333361663],
                                [43.68848477342175, 7.241890731724426],
                                [43.69132686392644, 7.3202910753685595],
                                [43.79051515053247, 7.52851338181802],
                                [43.86435489125911, 7.495439796908122],
                                [43.8972946323181, 7.559218845189717],
                                [43.94367801378083, 7.567109183508686],
                                [43.974108783080936, 7.648594461131101],
                                [44.03066821354588, 7.664986572845552],
                                [44.081761260593375, 7.716933970025215],
                                [44.15374050304117, 7.670852285754872],
                                [44.14365239533755, 7.505741191835109],
                                [44.1128794460913, 7.426949388266545],
                                [44.143451305507774, 7.281965966624222],
                                [44.19780338462857, 7.188914616489549],
                                [44.232949828024594, 7.071037600740729],
                                [44.236431060526996, 7.008054894297459],
                                [44.2808914278525, 6.993446820816494],
                                [44.36104783803612, 6.887429900902961],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "06", "NOM_DEPT": "ALPES-MARITIMES"},
                },
                7: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            45.23644648192783,
                            3.6940178008729885,
                            46.27590543921817,
                            4.756935570818616,
                        ),
                        "coordinates": [
                            [
                                [45.93073235641238, 3.6940178008729885],
                                [45.88603083611283, 3.7543707578917007],
                                [45.783181674804744, 3.699758022143211],
                                [45.72434927186397, 3.7808499481107716],
                                [45.63241694241681, 3.823453198078696],
                                [45.5990224663249, 3.903596234209209],
                                [45.555962683335494, 3.954348408158434],
                                [45.44826954913943, 3.9751057509236487],
                                [45.410307649293415, 3.899187761612733],
                                [45.357083781715595, 3.897408424881887],
                                [45.37513435596747, 3.97965057221058],
                                [45.3428877136373, 4.02482405154612],
                                [45.39260487868634, 4.177926371804465],
                                [45.37098690693708, 4.308199323181692],
                                [45.33699593440974, 4.366534405291163],
                                [45.264395356817886, 4.3625488691169565],
                                [45.27542410166107, 4.418571110077436],
                                [45.23644648192783, 4.483134616383878],
                                [45.25170405771359, 4.602422910281467],
                                [45.30983662841339, 4.614497435388506],
                                [45.3461123269119, 4.679512199699749],
                                [45.36567226076599, 4.755996992712003],
                                [45.45570734978023, 4.756935570818616],
                                [45.49429755062865, 4.722336796597095],
                                [45.48675363928719, 4.661741865018664],
                                [45.575468343903715, 4.614858045826019],
                                [45.57325450372858, 4.5197664589356545],
                                [45.63205080632734, 4.410284239143386],
                                [45.69851909472673, 4.365516200673114],
                                [45.754934723712715, 4.391252031699621],
                                [45.86399385908122, 4.383032288498641],
                                [45.9005013366276, 4.3239261660748465],
                                [45.95339953385286, 4.2939122642052165],
                                [46.02122907041072, 4.30609575897843],
                                [46.05294444469335, 4.280409632428634],
                                [46.12922273900979, 4.321566636697419],
                                [46.16787882969538, 4.438590902796802],
                                [46.21978851671502, 4.388079599211451],
                                [46.1569500147692, 4.282499756804288],
                                [46.17875080608761, 4.261021127340283],
                                [46.17782633253049, 4.132418427256319],
                                [46.198394922848955, 4.104090700200876],
                                [46.16980977454083, 3.988786873539472],
                                [46.20271202778807, 3.972545422490283],
                                [46.214490641438644, 3.8901323277345172],
                                [46.27590543921817, 3.8995333931893303],
                                [46.25485708711847, 3.8048868330812957],
                                [46.154851332057156, 3.7897619940586127],
                                [46.08798388977018, 3.8218687105012146],
                                [46.04562293029197, 3.80676406021388],
                                [45.995967743331704, 3.8254431917706775],
                                [45.97385869263016, 3.788909241913359],
                                [45.97378454864044, 3.708883724363124],
                                [45.93073235641238, 3.6940178008729885],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "42", "NOM_DEPT": "LOIRE"},
                },
                8: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            42.69999034279792,
                            0.4419985587106278,
                            43.91831715512138,
                            2.02913283879736,
                        ),
                        "coordinates": [
                            [
                                [43.31088599158549, 0.6068109749570955],
                                [43.28903679046807, 0.6162800547565972],
                                [43.236102503746785, 0.5515684940570376],
                                [43.20914713009289, 0.5518748957180638],
                                [43.13127313187027, 0.4419985587106278],
                                [43.093864488407256, 0.5322696523895425],
                                [43.01746794817708, 0.5630044583601441],
                                [43.000102873234276, 0.6274179241908857],
                                [42.870825923039746, 0.575935146951876],
                                [42.87810749616207, 0.47730134412302644],
                                [42.828145214268325, 0.4588995164240373],
                                [42.728060641999555, 0.4550942250736491],
                                [42.69999034279792, 0.4777495403273698],
                                [42.7089682536352, 0.6822635276176592],
                                [42.7830764658169, 0.6445405045620637],
                                [42.838529465461015, 0.6590147498491506],
                                [42.86140184526932, 0.7083777796309813],
                                [42.825719089084465, 0.8583056667230169],
                                [42.91998800205083, 0.8324133769327755],
                                [42.95777574631528, 0.8749113719387418],
                                [42.97443096191435, 0.9791013887263268],
                                [43.007591006439135, 1.0070461604480825],
                                [43.06705628157321, 0.9851687313481592],
                                [43.100552820032235, 1.038835682734409],
                                [43.14182620134684, 1.058912548014145],
                                [43.156907404761775, 1.1240820844542168],
                                [43.117951050809886, 1.2087344680123449],
                                [43.18389310581045, 1.2274806300813899],
                                [43.18999472443669, 1.3146078107375299],
                                [43.21374576570539, 1.3743734334754005],
                                [43.28533747712757, 1.2933102990704717],
                                [43.31560605476546, 1.3436519696346765],
                                [43.25657153586671, 1.4253606535844832],
                                [43.21060079806052, 1.4637105789844813],
                                [43.27567426925569, 1.54752004958837],
                                [43.25511535449163, 1.6372035311274424],
                                [43.27355372810048, 1.688419720914751],
                                [43.3437401011229, 1.747732597304773],
                                [43.341403596986645, 1.81342406452215],
                                [43.391684804856155, 1.8040846789340412],
                                [43.44382089121736, 1.8587429714302222],
                                [43.40405939980915, 1.9101007956285103],
                                [43.43689796484212, 2.02913283879736],
                                [43.47035021960434, 2.018141282533191],
                                [43.520928759682434, 1.882609451533412],
                                [43.5808317662611, 1.824800921390715],
                                [43.63070037401987, 1.687771093611741],
                                [43.65775037692843, 1.730869381606712],
                                [43.71621951436253, 1.7064455963184253],
                                [43.74183402488211, 1.6604214137506872],
                                [43.800257495357435, 1.644787627039312],
                                [43.815488439336, 1.5910292905659653],
                                [43.868315400129546, 1.5554632454868464],
                                [43.91831715512138, 1.5556171726831818],
                                [43.87355299852184, 1.4478772809200224],
                                [43.884191550555926, 1.3568133196337082],
                                [43.82107440669022, 1.360890148995833],
                                [43.77077752425893, 1.2191934244058245],
                                [43.82229820079683, 1.144597614414948],
                                [43.78737246570886, 0.9539831166064945],
                                [43.64497503168885, 1.0876957388199553],
                                [43.634175893375954, 1.1475492440427302],
                                [43.59481295502015, 1.2013370084855526],
                                [43.473338092390065, 1.0181843408377866],
                                [43.3626517065442, 0.9780837577086208],
                                [43.4063326892777, 0.917251134513719],
                                [43.416975022578875, 0.8205416805525506],
                                [43.376630810082574, 0.7175914463388223],
                                [43.31720926544647, 0.6559378827169783],
                                [43.31088599158549, 0.6068109749570955],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "31", "NOM_DEPT": "HAUTE-GARONNE"},
                },
                9: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            46.1569500147692,
                            3.629423683496518,
                            47.15541168354447,
                            5.459286424114922,
                        ),
                        "coordinates": [
                            [
                                [46.21978851671502, 4.388079599211451],
                                [46.29606050757101, 4.405813600867753],
                                [46.26712984788543, 4.503987529872384],
                                [46.26479308755153, 4.618551541036954],
                                [46.30219481477719, 4.693107175516046],
                                [46.178372127719896, 4.730529789085251],
                                [46.17667702271938, 4.780213475718984],
                                [46.25992151697564, 4.810994882268941],
                                [46.40298160185767, 4.8882077017045455],
                                [46.43991436571944, 4.891817622919295],
                                [46.51719845218087, 4.940023082647429],
                                [46.484872844561906, 5.052374107055715],
                                [46.508209505159336, 5.201145108499204],
                                [46.468359273121585, 5.215064143095116],
                                [46.44676642071987, 5.310560613770375],
                                [46.47313865941285, 5.415741925117895],
                                [46.522560963527845, 5.359190879639876],
                                [46.63754001470946, 5.441107903009742],
                                [46.728695545924005, 5.391088772820641],
                                [46.82617125942893, 5.370244880835242],
                                [46.85524478563492, 5.459286424114922],
                                [46.90405615619232, 5.316959409128448],
                                [46.93591076096911, 5.263264616775811],
                                [46.9798880946405, 5.255236339191406],
                                [46.95576520247547, 5.106281375832608],
                                [46.98158693341567, 5.049303736126251],
                                [46.919374625937934, 4.728129651701318],
                                [46.94082023678555, 4.623230215613321],
                                [47.028371557104066, 4.493691403385164],
                                [47.049999892555, 4.406283415170733],
                                [47.08164281958383, 4.405487083945717],
                                [47.11432625058055, 4.259600310936345],
                                [47.15541168354447, 4.209834279044644],
                                [47.15050513981915, 4.181888404407953],
                                [47.12333757652633, 4.1159670699158095],
                                [47.12104166410018, 4.06142733788571],
                                [47.080010034285166, 4.038726355028209],
                                [47.05449482938563, 4.072015136934213],
                                [46.98511001230654, 4.039401951235417],
                                [46.918155606841836, 4.037221978317054],
                                [46.87473433322919, 4.093851364443379],
                                [46.84327237673586, 4.056234450174584],
                                [46.789364691282145, 4.062709832615211],
                                [46.7767510975447, 3.9919591863262944],
                                [46.73887265980929, 3.9233937335663813],
                                [46.701502637145154, 3.797329518692337],
                                [46.75247120098577, 3.73619002089105],
                                [46.74945902193753, 3.629423683496518],
                                [46.70720877171206, 3.6379005417614154],
                                [46.660582165836225, 3.6969523102437005],
                                [46.56756978217593, 3.7432867634118923],
                                [46.519899554588264, 3.8017563441985818],
                                [46.53113227681356, 3.8340059039329697],
                                [46.48125092995185, 3.8904705648097107],
                                [46.489755621859324, 3.957937642803863],
                                [46.46546757106011, 3.9980416518372484],
                                [46.39922459383981, 3.9772154801510964],
                                [46.31919378739559, 3.9866257932147806],
                                [46.27590543921817, 3.8995333931893303],
                                [46.214490641438644, 3.8901323277345172],
                                [46.20271202778807, 3.972545422490283],
                                [46.16980977454083, 3.988786873539472],
                                [46.198394922848955, 4.104090700200876],
                                [46.17782633253049, 4.132418427256319],
                                [46.17875080608761, 4.261021127340283],
                                [46.1569500147692, 4.282499756804288],
                                [46.21978851671502, 4.388079599211451],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "71", "NOM_DEPT": "SAONE-ET-LOIRE"},
                },
                10: {
                    "attributes": {"CODE_DEPT": "53", "NOM_DEPT": "MAYENNE"},
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            47.73568882742972,
                            -1.2382517343256687,
                            48.56294475916397,
                            -0.051896256193192866,
                        ),
                        "coordinates": [
                            [
                                [48.50849381419033, -1.0701645143702043],
                                [48.433058231677805, -1.0827940655347785],
                                [48.327727830000974, -1.0450195299623035],
                                [48.25928012122702, -1.1000610480389654],
                                [48.08980493061708, -1.0496060893987509],
                                [48.06891120316757, -1.0232833455698922],
                                [47.99494016249537, -1.021261028476561],
                                [47.9890627829139, -1.1026711686637327],
                                [47.96582099565697, -1.1539940378788582],
                                [47.86797794678783, -1.189183999002136],
                                [47.80999146298685, -1.2382517343256687],
                                [47.77444246694106, -1.142627284404155],
                                [47.7819668412532, -1.0999157158854143],
                                [47.76199058809525, -0.9786565126647941],
                                [47.79649707221334, -0.9520300471637984],
                                [47.752273303191295, -0.8392941203736615],
                                [47.738107486283226, -0.7417076584328766],
                                [47.73568882742972, -0.6108182423666904],
                                [47.765090867872736, -0.4604118623353693],
                                [47.76056283995014, -0.3817032700427246],
                                [47.80531865640705, -0.38820058256862927],
                                [47.83221637946878, -0.4478589178811479],
                                [47.88002461791636, -0.37067332986759677],
                                [47.930844658498074, -0.3848402809484052],
                                [47.95819180740854, -0.2826331784456301],
                                [48.04309552281351, -0.3416648270919381],
                                [48.05898535750186, -0.23094244360355798],
                                [48.10695966457705, -0.21717400338852627],
                                [48.157106805256795, -0.24992127138834272],
                                [48.20500891985258, -0.1468370673865568],
                                [48.25554245624927, -0.16309583433799862],
                                [48.36135559567944, -0.1379780943180353],
                                [48.38200345781552, -0.05453120471342586],
                                [48.4532597698412, -0.051896256193192866],
                                [48.45806753461724, -0.14871347253945932],
                                [48.53697035216617, -0.16938268000563395],
                                [48.56294475916397, -0.20693829348513745],
                                [48.506988913211536, -0.2782279440483014],
                                [48.492944315128234, -0.3676233888648996],
                                [48.51181992419309, -0.43075405116636184],
                                [48.50579601256293, -0.5050654278707298],
                                [48.473117087352556, -0.5517177835994801],
                                [48.44428211569599, -0.6539938321279792],
                                [48.43655146991278, -0.7572811397545346],
                                [48.501458496522545, -0.8603629154348689],
                                [48.516618079595695, -0.9563792193607108],
                                [48.489170559999316, -1.0039987501163459],
                                [48.50849381419033, -1.0701645143702043],
                            ]
                        ],
                    },
                },
                11: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            45.191632555616025,
                            -0.41583863552489936,
                            46.138574721782,
                            0.942591996012476,
                        ),
                        "coordinates": [
                            [
                                [45.96965998523795, -0.10293687953014748],
                                [45.91102062998216, -0.13166445066648028],
                                [45.87066390237826, -0.11540038254695688],
                                [45.79573700033925, -0.15309474428582864],
                                [45.775745644085404, -0.2217452863431165],
                                [45.80655862747694, -0.2731191101089069],
                                [45.741668657543315, -0.41583863552489936],
                                [45.65617988507809, -0.4089294944559108],
                                [45.608919202664524, -0.37591965312829384],
                                [45.5644938737933, -0.2967152234141246],
                                [45.49164146613392, -0.2461560346224077],
                                [45.455677709323595, -0.2674239730736361],
                                [45.40874172938641, -0.2497593835924437],
                                [45.359870837250256, -0.28089591660714885],
                                [45.32143289837574, -0.22670231706753935],
                                [45.28895157818027, -0.10878607028506979],
                                [45.24807269185132, -0.11538526357329361],
                                [45.24789117263397, -0.04416800947411795],
                                [45.191632555616025, 0.004330746876933936],
                                [45.226854975561835, 0.05343044144838209],
                                [45.209111965868274, 0.12772449711041312],
                                [45.297748756812105, 0.2666092126294511],
                                [45.3630432815919, 0.24932982871876253],
                                [45.46087036559336, 0.3078489404274546],
                                [45.46547909899255, 0.3565371468549886],
                                [45.5444880543905, 0.4962604525540846],
                                [45.61725930045946, 0.49964715509464347],
                                [45.67214440425978, 0.6006928771045711],
                                [45.71456998977267, 0.6297424639524395],
                                [45.76311968057405, 0.714888400126834],
                                [45.80561793866405, 0.7164398059782177],
                                [45.82108209588079, 0.7822321483214054],
                                [45.91975549444778, 0.8629055339639634],
                                [45.95743607843123, 0.942591996012476],
                                [46.010453963771624, 0.9256254984735032],
                                [46.04787811648369, 0.8179096763959524],
                                [46.128581728488285, 0.8234337839605995],
                                [46.138574721782, 0.746904536639973],
                                [46.09725460634644, 0.6874528960648784],
                                [46.08555812252824, 0.5399728471342742],
                                [46.131953549867, 0.5064169377082222],
                                [46.06267560392233, 0.40265550901998215],
                                [46.06096626231274, 0.2798061440667491],
                                [46.0955500415297, 0.19735350521616218],
                                [46.09389590958498, 0.07297225926176226],
                                [46.052847829356985, 0.019272784617024384],
                                [46.05592180291526, -0.03199529342544053],
                                [45.99347998149095, -0.04143104082306168],
                                [45.96965998523795, -0.10293687953014748],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "16", "NOM_DEPT": "CHARENTE"},
                },
                12: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            48.45828455072381,
                            -1.9461788272965446,
                            49.72555529334811,
                            -0.7526143435139804,
                        ),
                        "coordinates": [
                            [
                                [48.75222016383323, -0.8409353560137922],
                                [48.786077720208596, -0.9670546190041182],
                                [48.781514884249376, -1.0894728333388966],
                                [48.848851642164846, -1.1326273918673393],
                                [48.87028515761763, -1.0711805139009567],
                                [48.96770698487004, -0.9427299538328557],
                                [49.06790310099278, -0.8690886128916935],
                                [49.12943404142506, -0.8865942987279166],
                                [49.14557431338926, -0.9314549410204019],
                                [49.20297333585717, -0.9008729068582105],
                                [49.20338541623966, -1.0226729579413136],
                                [49.26132689823427, -1.1134233752175775],
                                [49.309870859750724, -1.1395424010513058],
                                [49.3555679898469, -1.1196225402660513],
                                [49.36665848650392, -1.1639520107160874],
                                [49.42401948471984, -1.1825295039826573],
                                [49.538927340535665, -1.3063594927131816],
                                [49.573681923567534, -1.3041977944390684],
                                [49.6246500905728, -1.2295992003173195],
                                [49.692593173710435, -1.2878424776340338],
                                [49.70370298113619, -1.4211576721789985],
                                [49.654110262842224, -1.541574554113602],
                                [49.66123264657622, -1.6783876038065542],
                                [49.72555529334811, -1.942245186733018],
                                [49.67434830154208, -1.9461788272965446],
                                [49.65019279204105, -1.8603000418191276],
                                [49.57173433702396, -1.8410273136069895],
                                [49.54039147246038, -1.8856955118557936],
                                [49.45291724937305, -1.8267724913131993],
                                [49.3904836803198, -1.819828581172189],
                                [49.32509928438261, -1.711168264458309],
                                [49.169205064269555, -1.5988432590535966],
                                [49.07927811770437, -1.6094115242692357],
                                [49.001482910319716, -1.5607059456223331],
                                [48.92158406951217, -1.5643431050154546],
                                [48.83471201976927, -1.5941451540783493],
                                [48.75184944838185, -1.5744067767391599],
                                [48.68740346333083, -1.5049438127030472],
                                [48.65052438367011, -1.3931950000571642],
                                [48.6234182091528, -1.4491620818766187],
                                [48.62644574305228, -1.571087121326364],
                                [48.56659421958315, -1.5189153941473403],
                                [48.4893748476061, -1.4899474351423645],
                                [48.45828455072381, -1.3772458850979696],
                                [48.533924823055, -1.2722484935647256],
                                [48.54220594454137, -1.206555726308375],
                                [48.50849381419033, -1.0701645143702043],
                                [48.489170559999316, -1.0039987501163459],
                                [48.516618079595695, -0.9563792193607108],
                                [48.501458496522545, -0.8603629154348689],
                                [48.56267832832824, -0.7741715461672727],
                                [48.617618520532695, -0.7526143435139804],
                                [48.710188837806285, -0.7989559815697868],
                                [48.75222016383323, -0.8409353560137922],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "50", "NOM_DEPT": "MANCHE"},
                },
                13: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            48.45760028606413,
                            1.4577625828067997,
                            49.0781511731843,
                            2.2265593271545225,
                        ),
                        "coordinates": [
                            [
                                [48.94105360615515, 1.5015238197988665],
                                [48.89157660948184, 1.5572502545823868],
                                [48.814869639400584, 1.5912030850964909],
                                [48.70181187348942, 1.5795458299182847],
                                [48.663769109280636, 1.6024984234215411],
                                [48.57802434626237, 1.70925278746701],
                                [48.56937104099975, 1.7653297161980415],
                                [48.46608795961456, 1.8014458379190346],
                                [48.45760028606413, 1.9221489648373704],
                                [48.53307136184394, 1.9674261909808515],
                                [48.557597387423435, 2.0175740602972896],
                                [48.64208882251873, 2.020005696381871],
                                [48.68585180710444, 2.082221274606409],
                                [48.73956019802753, 2.111889242882012],
                                [48.77610203162177, 2.2265593271545225],
                                [48.81702039834037, 2.1515778037276103],
                                [48.87333985214219, 2.1528691414227357],
                                [48.90867932989047, 2.2005910092695036],
                                [48.94974074221645, 2.20585834678071],
                                [49.01467871491032, 2.084914920835882],
                                [48.998755806188655, 2.0247730444607903],
                                [49.021776326372276, 1.9378021652564323],
                                [49.07636122204013, 1.8239503630063805],
                                [49.04497657550693, 1.7234571618642331],
                                [49.0781511731843, 1.6736891270071166],
                                [49.07789415353795, 1.6087960706299216],
                                [49.06854572684407, 1.5217661561843225],
                                [49.026291046220386, 1.4577625828067997],
                                [48.94105360615515, 1.5015238197988665],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "78", "NOM_DEPT": "YVELINES"},
                },
                14: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            46.557660399034056,
                            5.698725742766406,
                            47.562955627817956,
                            7.062193873000226,
                        ),
                        "coordinates": [
                            [
                                [47.56280181879927, 6.806992048333126],
                                [47.53641528724466, 6.780972040773947],
                                [47.562955627817956, 6.685554362876694],
                                [47.535260638072835, 6.646719240296149],
                                [47.53987013332597, 6.5817761531248],
                                [47.492797262167244, 6.55356252302069],
                                [47.52029975346226, 6.401377017027886],
                                [47.50596607054917, 6.334353737417102],
                                [47.430569873278635, 6.262328582663191],
                                [47.35403647499406, 6.080045800270596],
                                [47.327623386353956, 5.989355047833264],
                                [47.34425359386964, 5.94137455282545],
                                [47.26499677497705, 5.698725742766406],
                                [47.21993674300857, 5.720409103677726],
                                [47.16905381606457, 5.811467446057154],
                                [47.134339348805675, 5.816084496368169],
                                [47.08943503996253, 5.768548742190094],
                                [47.02033909341784, 5.815050562004316],
                                [46.98044449059872, 5.968560305501438],
                                [46.94807945340021, 5.9640723607092],
                                [46.8730528372109, 6.0057784127798],
                                [46.82066736980736, 6.151793978046819],
                                [46.77268138485168, 6.203329933961532],
                                [46.74157523839264, 6.180271003478626],
                                [46.689524885344895, 6.06982847991084],
                                [46.6498184099785, 6.1037670236188335],
                                [46.60772285612785, 6.048566902902156],
                                [46.557660399034056, 6.1381085470292716],
                                [46.57631320344644, 6.1107480156789],
                                [46.691241021954745, 6.285329368806657],
                                [46.76174754330358, 6.438107473498827],
                                [46.81241169394881, 6.431004694945304],
                                [46.89020983338595, 6.4645708895250955],
                                [46.9286020853725, 6.432669440426171],
                                [46.9708582524052, 6.51880021365156],
                                [47.00275740209691, 6.640345422140116],
                                [47.04912442357012, 6.7140493259380465],
                                [47.108056539328445, 6.7399076404183615],
                                [47.1643834770384, 6.858349567867174],
                                [47.20161558472105, 6.882433031143579],
                                [47.24294090315342, 6.95497425319866],
                                [47.29554511881349, 6.993126569921015],
                                [47.34415792273254, 7.062193873000226],
                                [47.371836167175545, 7.016179011339008],
                                [47.35617732664824, 6.917301026972028],
                                [47.433373721422306, 6.940536510867674],
                                [47.49454608019349, 6.90760985982366],
                                [47.54736152102862, 6.90566962763424],
                                [47.56280181879927, 6.806992048333126],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "25", "NOM_DEPT": "DOUBS"},
                },
                15: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            48.42092912174115,
                            4.888760929797642,
                            49.61708773850276,
                            5.823066740236896,
                        ),
                        "coordinates": [
                            [
                                [48.49649260851312, 5.765154701602299],
                                [48.54035925156704, 5.7762118887724645],
                                [48.56142416981741, 5.71608982178375],
                                [48.60939047859851, 5.7617670452603855],
                                [48.695698334229284, 5.7577093395619],
                                [48.744533308856504, 5.714036349479591],
                                [48.826749431285386, 5.780971762726475],
                                [48.915257872637035, 5.747161790828688],
                                [48.9467460575909, 5.800245290300757],
                                [49.02310661815185, 5.823066740236896],
                                [49.08617366650139, 5.818638375145698],
                                [49.10787996559759, 5.763360758388861],
                                [49.15659587123615, 5.744467916779598],
                                [49.198088628043735, 5.765544232834612],
                                [49.21598694642171, 5.719044394768754],
                                [49.311343191085655, 5.731786006583375],
                                [49.41510555457393, 5.688147604064061],
                                [49.43743606551584, 5.634565984546508],
                                [49.40737462726647, 5.529099312496953],
                                [49.45269148819386, 5.461779526865533],
                                [49.49720502129503, 5.470910130592771],
                                [49.597347493736514, 5.426918930815697],
                                [49.61708773850276, 5.393536658328508],
                                [49.55928995633117, 5.311756637860767],
                                [49.563534256220265, 5.162975033383016],
                                [49.59307211738767, 5.118278729173794],
                                [49.4991534717053, 5.062396105126222],
                                [49.421924473125145, 5.1158969719764285],
                                [49.335913874705334, 5.026436999727152],
                                [49.27405171210352, 5.051180998120573],
                                [49.23686584630137, 4.950989232683009],
                                [49.18506820457861, 4.9397619983736725],
                                [49.11490008827158, 4.992117611940037],
                                [49.03495195077164, 5.0076814026818575],
                                [49.024332549540816, 5.036321445219878],
                                [48.95690245547182, 5.030128675561755],
                                [48.92214239512387, 4.9362093920054075],
                                [48.81720971453768, 4.888760929797642],
                                [48.74183736486811, 4.990124563499124],
                                [48.684418562233176, 4.988427677798425],
                                [48.634035501163716, 5.005925627052495],
                                [48.59572522098937, 5.070888258264775],
                                [48.59551086053376, 5.118346103266606],
                                [48.53861075457746, 5.208425883036941],
                                [48.48198867902053, 5.349469998299744],
                                [48.42092912174115, 5.470048195176172],
                                [48.43974531395933, 5.615963788740979],
                                [48.49649260851312, 5.765154701602299],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "55", "NOM_DEPT": "MEUSE"},
                },
                16: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            44.193809246235574,
                            -1.2602820243561477,
                            45.574693032813535,
                            0.2973255098237856,
                        ),
                        "coordinates": [
                            [
                                [44.762284673952365, 0.2973255098237856],
                                [44.85689385892574, 0.24175347207714187],
                                [44.82668350830169, 0.17043367429958434],
                                [44.831221061823996, 0.08302335597727034],
                                [44.857716516943654, -0.015447847302468334],
                                [44.91546925454322, 0.03436214413600625],
                                [44.947298811504744, 0.007378970051309284],
                                [45.07012096510983, 0.07329671773303688],
                                [45.11322788942682, 0.0460600817105796],
                                [45.10238433596342, -0.0402003397896402],
                                [45.1213888362867, -0.08770283087044228],
                                [45.08880721589074, -0.15295329411286412],
                                [45.11408527738146, -0.2550869802991912],
                                [45.16755837660476, -0.34233753875966755],
                                [45.16477966588985, -0.3940718179854259],
                                [45.2794739946481, -0.4291954727294871],
                                [45.29770833934139, -0.5595072006432503],
                                [45.32114282458838, -0.5944806728104985],
                                [45.32176994097864, -0.7526821734869675],
                                [45.3692088136439, -0.7740181405098189],
                                [45.43508336826085, -0.8410572249719415],
                                [45.574693032813535, -1.0257418763479118],
                                [45.56240962499771, -1.0911993078778213],
                                [45.47037006217617, -1.1570402521876126],
                                [45.29786685383699, -1.1623411294779722],
                                [44.864826144114005, -1.2229024029196527],
                                [44.70957693396086, -1.222955997695759],
                                [44.7746635368112, -1.160522506721865],
                                [44.69356358853642, -1.0363572283194813],
                                [44.648040902290475, -1.00536452930634],
                                [44.640602706356376, -1.080794255404563],
                                [44.66072655577172, -1.191539567755165],
                                [44.5757510136334, -1.227400657614334],
                                [44.539506550906935, -1.2602820243561477],
                                [44.46760421234612, -1.2538901028077152],
                                [44.502772891337074, -1.1064909647292627],
                                [44.53219457167761, -1.0851664955491256],
                                [44.48287893553745, -0.980696991457649],
                                [44.43765239133863, -1.0074534242441238],
                                [44.443344362596, -0.9191704541834174],
                                [44.418974549624615, -0.8452736279017063],
                                [44.446374662072536, -0.7307029568976181],
                                [44.443192240874566, -0.6287774027434528],
                                [44.39814566253359, -0.6276476111842939],
                                [44.36465404326284, -0.5281031072972922],
                                [44.33911112646834, -0.5176354697700617],
                                [44.32257705443087, -0.4318395413151788],
                                [44.286310667736586, -0.38338729038705555],
                                [44.20948462715674, -0.3896173620609178],
                                [44.193809246235574, -0.27211852903661166],
                                [44.205898263801814, -0.22344709828329445],
                                [44.26904045949535, -0.19411335198198051],
                                [44.226404747689884, -0.1406884798527587],
                                [44.246757992226044, -0.06662475964814332],
                                [44.2967257980246, -0.034811250980738874],
                                [44.33761004988665, -0.08575207965013022],
                                [44.38987879184508, 0.018233646559888256],
                                [44.418543403742476, -0.01055239618525492],
                                [44.50506278713605, -0.015453699893016915],
                                [44.55304661779892, 0.04056782018280631],
                                [44.61612295595807, 0.15360786253340622],
                                [44.661072124006985, 0.182677659153478],
                                [44.682444103785436, 0.13372640074632025],
                                [44.730481039785595, 0.15300384600841968],
                                [44.762284673952365, 0.2973255098237856],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "33", "NOM_DEPT": "GIRONDE"},
                },
                17: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            48.75222016383323,
                            -1.1395424010513058,
                            49.429861637283,
                            0.43675135320661196,
                        ),
                        "coordinates": [
                            [
                                [49.429861637283, 0.2972244202906149],
                                [49.42676180478786, 0.21994001130961904],
                                [49.39426193746853, 0.11038005889157709],
                                [49.321203481541424, -0.013368582587024589],
                                [49.29760052804955, -0.09959949005984037],
                                [49.28181693021673, -0.22569330389903117],
                                [49.33558104324267, -0.4148485981637238],
                                [49.34501616988367, -0.5153140242090215],
                                [49.34700416593967, -0.7222488013847806],
                                [49.36254475176417, -0.8511656303754815],
                                [49.39504220855989, -0.9393846923333837],
                                [49.38849350541247, -1.0782173743324184],
                                [49.3555679898469, -1.1196225402660513],
                                [49.309870859750724, -1.1395424010513058],
                                [49.26132689823427, -1.1134233752175775],
                                [49.20338541623966, -1.0226729579413136],
                                [49.20297333585717, -0.9008729068582105],
                                [49.14557431338926, -0.9314549410204019],
                                [49.12943404142506, -0.8865942987279166],
                                [49.06790310099278, -0.8690886128916935],
                                [48.96770698487004, -0.9427299538328557],
                                [48.87028515761763, -1.0711805139009567],
                                [48.848851642164846, -1.1326273918673393],
                                [48.781514884249376, -1.0894728333388966],
                                [48.786077720208596, -0.9670546190041182],
                                [48.75222016383323, -0.8409353560137922],
                                [48.79986774271756, -0.7146786118899515],
                                [48.87136647587905, -0.4637527288822026],
                                [48.87014004741071, -0.41151869249428463],
                                [48.821999140746335, -0.3462445710154047],
                                [48.858307152999124, -0.30592108673909135],
                                [48.83444909949477, -0.14634308820607572],
                                [48.85358688783118, -0.05880746358844414],
                                [48.90246403865731, 0.05639799250068904],
                                [48.95221907078784, 0.12760760912750208],
                                [48.924787583562484, 0.1564748700538276],
                                [48.96474519879868, 0.2756400197144897],
                                [48.942883562782185, 0.3337726147565274],
                                [48.95062636769437, 0.4128145328890876],
                                [49.008190235684026, 0.43675135320661196],
                                [49.04945033019972, 0.37767980975475124],
                                [49.130194368095964, 0.42487479285721214],
                                [49.15011747492428, 0.39468800874102034],
                                [49.264016474812756, 0.382786744119418],
                                [49.29699256482139, 0.32302317286212956],
                                [49.429861637283, 0.2972244202906149],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "14", "NOM_DEPT": "CALVADOS"},
                },
                18: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            47.81305372460471,
                            5.408721169498744,
                            48.51359226555661,
                            7.198281537029947,
                        ),
                        "coordinates": [
                            [
                                [47.92604714858532, 5.884726375202079],
                                [47.97971039136252, 5.94752101881473],
                                [47.956089699040746, 6.002262047573574],
                                [48.015666213333766, 6.072563808399439],
                                [48.00694405924028, 6.156057875261972],
                                [47.95235039238132, 6.167984818891344],
                                [47.93284210199926, 6.237987058178878],
                                [47.961944790786475, 6.366146412024702],
                                [47.94381595263879, 6.431707255957785],
                                [47.885521773703914, 6.4786018541765715],
                                [47.9026105653117, 6.5421528235861155],
                                [47.944398619135356, 6.601781921638085],
                                [47.904021106485565, 6.645533181556614],
                                [47.84962275518448, 6.784821909572193],
                                [47.81305372460471, 6.823538854548165],
                                [47.82294519701528, 6.846179818400714],
                                [47.850287916338935, 6.920034363859818],
                                [47.891191372726894, 6.900213335139268],
                                [47.9979579468772, 6.943356419805965],
                                [48.022399095831105, 7.001883743858899],
                                [48.13726637155602, 7.058912798901165],
                                [48.245940550021665, 7.133555808547299],
                                [48.31046786103526, 7.198281537029947],
                                [48.33329037920514, 7.121908440975998],
                                [48.40564467453035, 7.097427065168084],
                                [48.51359226555661, 7.123165369028565],
                                [48.47905957978557, 6.9829860045628855],
                                [48.4180943151424, 6.890810652427116],
                                [48.39884620056533, 6.815166528707747],
                                [48.41308754075586, 6.6994983396482075],
                                [48.46050916362014, 6.584971476704244],
                                [48.419031847017656, 6.56697422886565],
                                [48.397598877997915, 6.178419125638965],
                                [48.35403844099854, 6.116723785728533],
                                [48.34989070446764, 5.961559100039156],
                                [48.50684438558553, 5.856069666360071],
                                [48.49649260851312, 5.765154701602299],
                                [48.43974531395933, 5.615963788740979],
                                [48.42092912174115, 5.470048195176172],
                                [48.38310019043651, 5.408721169498744],
                                [48.35620132426793, 5.482149185087856],
                                [48.24235420494441, 5.640901189478503],
                                [48.21992832819691, 5.710843767915566],
                                [48.14504209498631, 5.68431870758825],
                                [48.08398621524326, 5.630534001339329],
                                [48.07722956641849, 5.696798789098754],
                                [48.03136192327879, 5.77774789858366],
                                [47.95259697311841, 5.787280985479235],
                                [47.96283504724515, 5.850003923490582],
                                [47.92604714858532, 5.884726375202079],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "88", "NOM_DEPT": "VOSGES"},
                },
                19: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            46.42040537318102,
                            1.7745813093652696,
                            47.6289623689043,
                            3.0793297925031697,
                        ),
                        "coordinates": [
                            [
                                [47.62097830787993, 2.2392136309887465],
                                [47.584697964594106, 2.1279686465889993],
                                [47.54857375641657, 2.1956362774138967],
                                [47.472342931945946, 2.2382190791314827],
                                [47.38678255688259, 2.101692730986123],
                                [47.285486220264254, 2.1389909561599825],
                                [47.26543934027617, 1.9970384773235634],
                                [47.29013078287711, 1.940816059215001],
                                [47.2156553664379, 1.9040800791132237],
                                [47.21930815773424, 1.8390792420529518],
                                [47.17802935443287, 1.8421086266284743],
                                [47.130846812692134, 1.7745813093652696],
                                [47.101949545642825, 1.882721849834433],
                                [47.125417513727896, 1.9664139793909294],
                                [47.10601550210712, 2.048374881247615],
                                [47.040016048649505, 2.051487760798448],
                                [47.01573583572996, 2.0933838995940373],
                                [46.93399643786305, 2.0706986163554206],
                                [46.87986509549618, 2.1262038890477335],
                                [46.82944826814362, 2.0488103323451234],
                                [46.774358601474674, 2.1153606164888155],
                                [46.74249480206491, 2.065751312591214],
                                [46.69555371540337, 2.1407244355816926],
                                [46.60286242584107, 2.18562886154938],
                                [46.55734628168219, 2.158700190947214],
                                [46.48439997524805, 2.2043972607989812],
                                [46.45796019235814, 2.1516716067091237],
                                [46.4240665008181, 2.167785718138384],
                                [46.42040537318102, 2.2810476101300576],
                                [46.45351915029326, 2.2857578150118907],
                                [46.512211347274814, 2.3520035556502914],
                                [46.53269744464404, 2.4829288047758253],
                                [46.51969984591659, 2.536652020779054],
                                [46.55328003970227, 2.614955459722656],
                                [46.6372195698165, 2.5966478252098466],
                                [46.7393873052656, 2.7049751251942706],
                                [46.71890739681203, 2.774488053228389],
                                [46.73528787880109, 2.8276163881602265],
                                [46.803876576773305, 2.9599146908207157],
                                [46.794911188525944, 3.0320681893946824],
                                [46.87767673133036, 3.0680947893123323],
                                [46.91063036589821, 3.0502941730720203],
                                [46.955118753700106, 3.0793297925031697],
                                [47.01914457943622, 3.0757376737966906],
                                [47.06261687352467, 3.0232152406674615],
                                [47.129067685143006, 3.0280852399597813],
                                [47.221996957251605, 2.9816846477683376],
                                [47.25976318039041, 2.9834041014118906],
                                [47.34839595883525, 2.8734906167112504],
                                [47.444566735803356, 2.928902314704163],
                                [47.520423112556664, 2.8746252064056805],
                                [47.49445932903693, 2.8064837781833747],
                                [47.523527275666915, 2.7680263231364863],
                                [47.49216663238491, 2.7193534234556664],
                                [47.48789924167961, 2.658459112358834],
                                [47.55368570340879, 2.599892421980175],
                                [47.568295437652175, 2.491358293796867],
                                [47.60977811486517, 2.4373472313231086],
                                [47.58552457239423, 2.3730210260695963],
                                [47.6289623689043, 2.286237981293774],
                                [47.62097830787993, 2.2392136309887465],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "18", "NOM_DEPT": "CHER"},
                },
                20: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            44.26478557642796,
                            3.862527190139651,
                            45.36567226076599,
                            4.886589299843449,
                        ),
                        "coordinates": [
                            [
                                [44.45979755586323, 3.998162987763964],
                                [44.40511357294199, 4.068441217053273],
                                [44.317323657117, 4.051451662788466],
                                [44.31335085540007, 4.142867700090412],
                                [44.26478557642796, 4.2588461979825505],
                                [44.314658687843355, 4.288416558058853],
                                [44.33952274370027, 4.336073225463424],
                                [44.34018845123076, 4.503536213064646],
                                [44.30244463260489, 4.55869985714841],
                                [44.27035986501095, 4.649223666100485],
                                [44.32980579151128, 4.650615013437554],
                                [44.43066448441976, 4.667367377491741],
                                [44.452309460126756, 4.69865229412497],
                                [44.542230674151796, 4.693639580520507],
                                [44.581549114708366, 4.7102664999416985],
                                [44.65469880413612, 4.779060115885166],
                                [44.77862679935857, 4.76621554467615],
                                [44.81708784467795, 4.822513080923934],
                                [44.93665163053356, 4.886589299843449],
                                [45.004791813947854, 4.837672652853049],
                                [45.16448183151871, 4.812473966213054],
                                [45.29836066114294, 4.800493926884063],
                                [45.36567226076599, 4.755996992712003],
                                [45.3461123269119, 4.679512199699749],
                                [45.30983662841339, 4.614497435388506],
                                [45.25170405771359, 4.602422910281467],
                                [45.23644648192783, 4.483134616383878],
                                [45.14083295591157, 4.443262789803058],
                                [45.1443595905019, 4.376558944791765],
                                [45.10483231156165, 4.375306064703463],
                                [44.99730682920296, 4.289827924670837],
                                [44.961336129386744, 4.221702631142119],
                                [44.87333360834132, 4.156154791813548],
                                [44.87316201331411, 4.039638866980704],
                                [44.83408100300616, 4.028374858328879],
                                [44.7954172172997, 3.937001123548729],
                                [44.743863434670935, 3.862527190139651],
                                [44.592708047769605, 3.9051719910706293],
                                [44.57379092180415, 3.9451489956301886],
                                [44.45979755586323, 3.998162987763964],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "07", "NOM_DEPT": "ARDECHE"},
                },
                21: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            48.85190849437287,
                            2.97439031593416,
                            50.069274635963545,
                            4.250088858677236,
                        ),
                        "coordinates": [
                            [
                                [49.405642294757534, 4.047972977986833],
                                [49.50853465720682, 4.040711745102368],
                                [49.57112749860687, 4.076570889635557],
                                [49.614289972299225, 4.031390794494156],
                                [49.628478163833556, 4.099316041330109],
                                [49.67792125134356, 4.127021546188527],
                                [49.75710160233298, 4.250088858677236],
                                [49.78178059627039, 4.20958854124873],
                                [49.856522649594936, 4.2485071443588325],
                                [49.95782375745278, 4.233068423333533],
                                [49.978759598994436, 4.140895251736092],
                                [49.969187585411916, 4.08712850474961],
                                [49.99537608693849, 3.9803763118726994],
                                [50.026430676607156, 3.923501465982155],
                                [50.05360423497288, 3.7463798889650586],
                                [50.069274635963545, 3.715184685025503],
                                [50.025418579177284, 3.6136399192005855],
                                [50.05379395526909, 3.54484649487849],
                                [50.01885605079539, 3.4913598357111555],
                                [50.035859344668864, 3.3529820366555496],
                                [50.0151825508069, 3.2801740988851327],
                                [50.03130959186552, 3.2305405050170397],
                                [50.01199494467939, 3.1727072271768164],
                                [49.977464696263276, 3.1926752854802194],
                                [49.91427637798353, 3.117968662907868],
                                [49.822415215784225, 3.078694114076548],
                                [49.705968560150744, 3.1184031553047866],
                                [49.656683091231635, 3.09777622468101],
                                [49.543377651791836, 3.1314803354793224],
                                [49.51340305901281, 3.0957783548212805],
                                [49.451589762665364, 3.1605832452848968],
                                [49.43374686813427, 3.0937834703774705],
                                [49.37711907478125, 3.0953874973379834],
                                [49.302338848225304, 2.97439031593416],
                                [49.27553205719088, 3.0268878942941857],
                                [49.19273857569733, 3.0640875194145396],
                                [49.152576953634764, 3.1396578896700365],
                                [49.117554218816146, 3.071884293834167],
                                [49.09965085798759, 3.16523032905892],
                                [49.014123184303735, 3.171683982224406],
                                [48.948764278944545, 3.3047494707754015],
                                [48.908706088642376, 3.3302994547269797],
                                [48.8646865193221, 3.4032194510047127],
                                [48.85190849437287, 3.4851874436586847],
                                [48.91214102895303, 3.528576443116953],
                                [48.94407204131733, 3.6015984944904185],
                                [49.04058839070318, 3.646307433571441],
                                [49.12069184512517, 3.600004656260229],
                                [49.151103693376655, 3.622246623748466],
                                [49.18137302346899, 3.7043920469634597],
                                [49.31515350351225, 3.646953205074641],
                                [49.36458662943729, 3.8474771401321166],
                                [49.406181771288736, 3.9244337055179424],
                                [49.359904159430094, 4.035496373111564],
                                [49.405642294757534, 4.047972977986833],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "02", "NOM_DEPT": "AISNE"},
                },
                22: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            42.79316107597115,
                            -1.762027538655403,
                            43.596404001570654,
                            0.009598314167784467,
                        ),
                        "coordinates": [
                            [
                                [43.52970134669009, -1.524866548422101],
                                [43.43749281443975, -1.5973846756448384],
                                [43.40836090393235, -1.6391097857903014],
                                [43.37589158909485, -1.762027538655403],
                                [43.29567717164443, -1.729746317485463],
                                [43.3140776879947, -1.6657616159233792],
                                [43.25212549943678, -1.6089349856953201],
                                [43.2879116835355, -1.564715648901561],
                                [43.29278486875202, -1.505324531987169],
                                [43.25329431428316, -1.382786289109042],
                                [43.19081965347401, -1.3838290836545226],
                                [43.129178211984154, -1.4139466293353435],
                                [43.0810930732876, -1.4717353538630287],
                                [43.045032714608894, -1.4351852539528482],
                                [43.02846729741783, -1.3547480564678602],
                                [43.09537933451567, -1.3432933078866276],
                                [43.04456744579185, -1.2642856059829328],
                                [43.05449581378487, -1.2311433515565404],
                                [42.98899399788973, -1.0064443208237919],
                                [42.95406127408886, -0.9464504061324431],
                                [42.95143307665447, -0.8100187374291923],
                                [42.96693889977146, -0.751639105301494],
                                [42.896559178660695, -0.7297615302313328],
                                [42.79316107597115, -0.5438135992737804],
                                [42.82539255578589, -0.5096457244615787],
                                [42.796462278452985, -0.4397499421861355],
                                [42.79955853388815, -0.3925972910093663],
                                [42.84937505970757, -0.31344286349808953],
                                [42.915781623764374, -0.3270821344018897],
                                [42.93356279018236, -0.28159092548449965],
                                [42.98776781593242, -0.29155187666703314],
                                [43.033687539643886, -0.22395152380116173],
                                [43.11120001485185, -0.19098404402245117],
                                [43.128235959977104, -0.14613235140227182],
                                [43.180326663081885, -0.11770146168361191],
                                [43.27045317593498, -0.017007531250724548],
                                [43.300855792903974, -0.046122416801734976],
                                [43.42210994370382, 0.009598314167784467],
                                [43.43734927067611, -0.06903100203309719],
                                [43.512605402100824, -0.04013178615004061],
                                [43.5824058976317, -0.0967829732087753],
                                [43.596404001570654, -0.17641328064610742],
                                [43.58497620901365, -0.2428365587430673],
                                [43.560276850255974, -0.3036904680467346],
                                [43.56822563862102, -0.4060419475368964],
                                [43.596089226471534, -0.4482922578476395],
                                [43.542797175106195, -0.557174431652949],
                                [43.566716972183386, -0.6708071861709698],
                                [43.54111406021403, -0.7153911507395111],
                                [43.56416715906682, -0.7817805196343687],
                                [43.55048921576566, -0.896690646890469],
                                [43.50538804684213, -0.9933935609538066],
                                [43.51412989565136, -1.1092478299389088],
                                [43.54560988391761, -1.1708199655376677],
                                [43.49820457476753, -1.2911822396099015],
                                [43.49776692584455, -1.4177740978934008],
                                [43.539184056404956, -1.47661986699547],
                                [43.52970134669009, -1.524866548422101],
                            ]
                        ],
                    },
                    "attributes": {
                        "CODE_DEPT": "64",
                        "NOM_DEPT": "PYRENEES-ATLANTIQUES",
                    },
                },
                23: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            47.18622542473178,
                            0.5805178732790713,
                            48.12749350968226,
                            2.2392136309887465,
                        ),
                        "coordinates": [
                            [
                                [47.62097830787993, 2.2392136309887465],
                                [47.67814460516368, 2.20255850774907],
                                [47.675630779123125, 1.9424229848119656],
                                [47.68635321601097, 1.8436947697611497],
                                [47.63843148089739, 1.7985957016041196],
                                [47.66153396919206, 1.739938252775079],
                                [47.738393484182936, 1.6973528002323046],
                                [47.76976159023591, 1.5478779921036048],
                                [47.820525929167275, 1.5337009096463892],
                                [47.87642659620686, 1.5881377383696464],
                                [47.92911358021597, 1.5254235639039049],
                                [47.98227847700271, 1.5201238283340488],
                                [47.95385379978459, 1.3086281518302278],
                                [47.968500516699756, 1.2096430686639734],
                                [48.03911591949663, 1.121233516589401],
                                [48.080729125955024, 1.112233332007327],
                                [48.08312677901136, 1.0085477409246664],
                                [48.12749350968226, 0.9973300079370282],
                                [48.10306240933593, 0.8412172317044129],
                                [48.03755441455243, 0.7974846748199685],
                                [47.94140146385974, 0.8458005593594105],
                                [47.89822684022154, 0.7598746908928177],
                                [47.839687295150355, 0.7745788175007324],
                                [47.790036219738816, 0.7126298064021259],
                                [47.71232800972911, 0.5805178732790713],
                                [47.69421364606961, 0.6144311990931551],
                                [47.69540180185664, 0.7353105618986349],
                                [47.66920726991006, 0.8595037193186874],
                                [47.632609060103235, 0.9190111731399363],
                                [47.60701157047614, 1.0333525357335167],
                                [47.56322155433421, 1.0763363652479008],
                                [47.53148801134601, 1.0452908534068046],
                                [47.44646665748557, 1.132364189106744],
                                [47.4113254251562, 1.1074833948523175],
                                [47.35401667090686, 1.1228353402815718],
                                [47.29839804393137, 1.1081270826014082],
                                [47.27219609172912, 1.1620645187006384],
                                [47.29408083062265, 1.2235368646048146],
                                [47.25470690394847, 1.2769082168277972],
                                [47.18622542473178, 1.3266655450453897],
                                [47.237967921224396, 1.448462247960517],
                                [47.27667661630457, 1.5924281213159723],
                                [47.26587806829791, 1.7058305011298698],
                                [47.21930815773424, 1.8390792420529518],
                                [47.2156553664379, 1.9040800791132237],
                                [47.29013078287711, 1.940816059215001],
                                [47.26543934027617, 1.9970384773235634],
                                [47.285486220264254, 2.1389909561599825],
                                [47.38678255688259, 2.101692730986123],
                                [47.472342931945946, 2.2382190791314827],
                                [47.54857375641657, 2.1956362774138967],
                                [47.584697964594106, 2.1279686465889993],
                                [47.62097830787993, 2.2392136309887465],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "41", "NOM_DEPT": "LOIR-ET-CHER"},
                },
                24: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            48.52759644354931,
                            5.893401083719673,
                            49.5100225584692,
                            7.635285449703197,
                        ),
                        "coordinates": [
                            [
                                [48.536417612700156, 7.079359770973246],
                                [48.52759644354931, 7.167909935894844],
                                [48.588675507652006, 7.256281654444217],
                                [48.63810720117092, 7.283044927480475],
                                [48.69154313190619, 7.242487615031407],
                                [48.76730084431057, 7.311900506296782],
                                [48.84470403837187, 7.149408408912651],
                                [48.801142358200266, 7.126799106595456],
                                [48.813704386223854, 7.054514540544794],
                                [48.87154914036644, 7.0453428905310576],
                                [48.90452526765522, 6.964601688658047],
                                [48.95992878867804, 6.98921640979739],
                                [49.03061918771655, 7.054911912536334],
                                [49.04411352331478, 7.107657105402387],
                                [49.006365681338195, 7.174240270723143],
                                [48.97341645090749, 7.293048848802893],
                                [48.94337274202096, 7.326851980608825],
                                [48.96577914855414, 7.446887904100119],
                                [48.932961584940934, 7.5382590392502085],
                                [48.95740241810784, 7.57839213753989],
                                [49.0541613551771, 7.635285449703197],
                                [49.09206519190207, 7.539004820203112],
                                [49.18079327995296, 7.4399513148130945],
                                [49.17183619631744, 7.365078240855518],
                                [49.11745711801211, 7.298652796709717],
                                [49.12798155802856, 7.247787410384875],
                                [49.11458391989877, 7.066094084474562],
                                [49.18812137477419, 7.010704448405599],
                                [49.22215638708473, 6.935411827637279],
                                [49.21132385245782, 6.835378369933188],
                                [49.15146671246839, 6.834537718950126],
                                [49.16366113912632, 6.738512367681465],
                                [49.22444557282531, 6.688137831919717],
                                [49.28060494669888, 6.669191900827955],
                                [49.3473501703592, 6.56583851528285],
                                [49.38493582882031, 6.587074296882196],
                                [49.42334910853593, 6.552234581612261],
                                [49.4763981473342, 6.43012234409301],
                                [49.46446473286874, 6.391962714585447],
                                [49.48010694491308, 6.296571041016305],
                                [49.5100225584692, 6.256413026994873],
                                [49.504389798567836, 6.156886905838471],
                                [49.47375617437316, 6.123493803074785],
                                [49.45333363561611, 5.988987531307048],
                                [49.49131664375855, 5.971769533719511],
                                [49.49690975011092, 5.893401083719673],
                                [49.45289553695899, 5.942619950432162],
                                [49.37550729349813, 5.928530586493157],
                                [49.23047199221416, 6.029385386695151],
                                [49.20961691713356, 5.987627297222747],
                                [49.165118935990016, 6.0261499402444025],
                                [49.10910433832356, 5.931603285178869],
                                [49.07185221973813, 5.935399690626695],
                                [49.01041872049325, 6.044996956010202],
                                [48.977477915970994, 6.043435324319259],
                                [48.967833205844386, 6.116898532084446],
                                [48.93472094774055, 6.132207146051102],
                                [48.9331355970772, 6.271977767337417],
                                [48.834058199828384, 6.338947107825573],
                                [48.78165892451309, 6.35503013356845],
                                [48.75409250995719, 6.554148775117042],
                                [48.71569079778236, 6.598965570952483],
                                [48.7080472862827, 6.658407329856351],
                                [48.672840395381456, 6.6922838813846575],
                                [48.66938665042789, 6.75467285145004],
                                [48.62597500455583, 6.844053536871702],
                                [48.61186293045215, 6.982882241286179],
                                [48.536417612700156, 7.079359770973246],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "57", "NOM_DEPT": "MOSELLE"},
                },
                25: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            46.06096626231274,
                            -0.10212095637964816,
                            47.16373008265527,
                            1.212690238083345,
                        ),
                        "coordinates": [
                            [
                                [46.0955500415297, 0.19735350521616218],
                                [46.06096626231274, 0.2798061440667491],
                                [46.06267560392233, 0.40265550901998215],
                                [46.131953549867, 0.5064169377082222],
                                [46.08555812252824, 0.5399728471342742],
                                [46.09725460634644, 0.6874528960648784],
                                [46.138574721782, 0.746904536639973],
                                [46.128581728488285, 0.8234337839605995],
                                [46.21096277430388, 0.7963255053030057],
                                [46.285257481169126, 0.9072715939898939],
                                [46.28097399864579, 1.0058867393780462],
                                [46.34303442800397, 1.026995442933731],
                                [46.360466281243085, 1.1297576486963083],
                                [46.383951622152935, 1.1772799568053667],
                                [46.43222161336161, 1.212690238083345],
                                [46.449236175812, 1.1516045347766355],
                                [46.50640188056708, 1.1459353661062848],
                                [46.567763998821995, 1.0147644249831798],
                                [46.580792108421264, 0.94202375883659],
                                [46.625736651822876, 0.8943018154002147],
                                [46.69279335231604, 0.9247556936578988],
                                [46.74821910504848, 0.8674688807081561],
                                [46.79450796471715, 0.8119017840639386],
                                [46.852391083185935, 0.7903284955617977],
                                [46.90329335315584, 0.704324392050786],
                                [46.97430706301783, 0.6925692823646332],
                                [47.00227037444165, 0.5669489614197056],
                                [46.95676414686082, 0.5983482495759433],
                                [46.95924736173615, 0.5061414593305557],
                                [46.92958207105905, 0.4387096602536596],
                                [46.973827658647814, 0.30073625724988373],
                                [47.0539187252087, 0.29823142261819696],
                                [47.07127519606643, 0.17422061595767882],
                                [47.12158055414751, 0.13613090268194533],
                                [47.123931948888234, 0.07637120084195193],
                                [47.16373008265527, 0.05382761471070587],
                                [47.15750952036683, -0.01073662557135027],
                                [47.09324258439809, -0.04416541443323783],
                                [47.064797190818, -0.10212095637964816],
                                [47.023133335712934, -0.08769647758767064],
                                [46.90747700605924, -0.009032410299882686],
                                [46.81265392500652, -0.020316336069380696],
                                [46.71623331657765, 0.0007042720140887955],
                                [46.66371702380725, -0.04042619019472192],
                                [46.5947435067776, 0.02598963802815841],
                                [46.52498101941567, -0.031351255287517144],
                                [46.411322394513704, -0.01709282434894281],
                                [46.373496799479916, 0.034219979012944574],
                                [46.32552885451101, 0.037602239808067595],
                                [46.304933538922825, 0.07821800902702593],
                                [46.34939518270097, 0.13759784994026172],
                                [46.32811314059693, 0.1773687959824542],
                                [46.267231548998694, 0.12883677213786546],
                                [46.210932609573995, 0.11283682536372644],
                                [46.157168244596924, 0.1551113740904494],
                                [46.13884556432993, 0.21492180826491442],
                                [46.0955500415297, 0.19735350521616218],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "86", "NOM_DEPT": "VIENNE"},
                },
                26: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            44.577324783565565,
                            -0.0402003397896402,
                            45.71456998977267,
                            1.4482615439322115,
                        ),
                        "coordinates": [
                            [
                                [45.71456998977267, 0.6297424639524395],
                                [45.67214440425978, 0.6006928771045711],
                                [45.61725930045946, 0.49964715509464347],
                                [45.5444880543905, 0.4962604525540846],
                                [45.46547909899255, 0.3565371468549886],
                                [45.46087036559336, 0.3078489404274546],
                                [45.3630432815919, 0.24932982871876253],
                                [45.297748756812105, 0.2666092126294511],
                                [45.209111965868274, 0.12772449711041312],
                                [45.226854975561835, 0.05343044144838209],
                                [45.191632555616025, 0.004330746876933936],
                                [45.10238433596342, -0.0402003397896402],
                                [45.11322788942682, 0.0460600817105796],
                                [45.07012096510983, 0.07329671773303688],
                                [44.947298811504744, 0.007378970051309284],
                                [44.91546925454322, 0.03436214413600625],
                                [44.857716516943654, -0.015447847302468334],
                                [44.831221061823996, 0.08302335597727034],
                                [44.82668350830169, 0.17043367429958434],
                                [44.85689385892574, 0.24175347207714187],
                                [44.762284673952365, 0.2973255098237856],
                                [44.73743575883074, 0.3354490861907089],
                                [44.66221103663619, 0.36557538473802004],
                                [44.64633711715288, 0.41470651574900513],
                                [44.70652766853691, 0.6304884773468264],
                                [44.67784707846914, 0.6574344166312163],
                                [44.69188957907682, 0.8270009642517763],
                                [44.627001476439105, 0.8170042739845019],
                                [44.59730727091491, 0.8699961633461994],
                                [44.64361045554161, 0.9791284687246183],
                                [44.577324783565565, 1.0751408247250978],
                                [44.6394062697152, 1.1537937079861709],
                                [44.67034606645627, 1.1466718447537776],
                                [44.684266348929604, 1.2245500554542499],
                                [44.71478109653049, 1.2877821394602265],
                                [44.81156818641523, 1.3641029713426986],
                                [44.84079526684298, 1.3614038259537622],
                                [44.87757922298133, 1.441920482742166],
                                [44.99938624261527, 1.413299030000565],
                                [45.019313158674045, 1.4482615439322115],
                                [45.10288137852398, 1.3864424774272137],
                                [45.140188825629004, 1.2965184989870575],
                                [45.24208241912198, 1.2774962889939248],
                                [45.27197997099894, 1.2271194403372108],
                                [45.382659361364226, 1.3227969726587205],
                                [45.39834890279047, 1.2596039598397968],
                                [45.44421907802482, 1.2531518386328937],
                                [45.487782926278754, 1.1197844789851372],
                                [45.60020929025313, 1.0358490435954522],
                                [45.611582010503184, 0.9345523684647926],
                                [45.575870643461926, 0.811500332264728],
                                [45.61832385402003, 0.7515297126109166],
                                [45.6675695723418, 0.775843134926025],
                                [45.71456998977267, 0.6297424639524395],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "24", "NOM_DEPT": "DORDOGNE"},
                },
                27: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            46.260729204793954,
                            5.255236339191406,
                            47.30418661946959,
                            6.203329933961532,
                        ),
                        "coordinates": [
                            [
                                [46.44676642071987, 5.310560613770375],
                                [46.41681731886722, 5.307691028342544],
                                [46.38135905559832, 5.377044586181938],
                                [46.35223630468514, 5.3734622886202095],
                                [46.31511297122548, 5.437795113853318],
                                [46.265063763323475, 5.473055311573813],
                                [46.270201908707435, 5.542037828826235],
                                [46.33949103303637, 5.649339135998931],
                                [46.3087688477459, 5.714717731644379],
                                [46.260729204793954, 5.725183003095843],
                                [46.26206360332614, 5.849846074176259],
                                [46.283951620059554, 5.908938421371526],
                                [46.364873088758074, 5.986841317727858],
                                [46.416226988931534, 6.06400848181829],
                                [46.463946006284665, 6.073927085793577],
                                [46.54546817311972, 6.156435507165684],
                                [46.557660399034056, 6.1381085470292716],
                                [46.60772285612785, 6.048566902902156],
                                [46.6498184099785, 6.1037670236188335],
                                [46.689524885344895, 6.06982847991084],
                                [46.74157523839264, 6.180271003478626],
                                [46.77268138485168, 6.203329933961532],
                                [46.82066736980736, 6.151793978046819],
                                [46.8730528372109, 6.0057784127798],
                                [46.94807945340021, 5.9640723607092],
                                [46.98044449059872, 5.968560305501438],
                                [47.02033909341784, 5.815050562004316],
                                [47.08943503996253, 5.768548742190094],
                                [47.134339348805675, 5.816084496368169],
                                [47.16905381606457, 5.811467446057154],
                                [47.21993674300857, 5.720409103677726],
                                [47.26499677497705, 5.698725742766406],
                                [47.26053058451154, 5.602110210787404],
                                [47.30418661946959, 5.518538729512594],
                                [47.289347470334135, 5.488282961724511],
                                [47.21602767128051, 5.47662851608292],
                                [47.144397191390595, 5.439973300314684],
                                [47.081977110214815, 5.386011880946295],
                                [47.07298220144243, 5.322186205925132],
                                [47.0180208967574, 5.310049747453535],
                                [46.9798880946405, 5.255236339191406],
                                [46.93591076096911, 5.263264616775811],
                                [46.90405615619232, 5.316959409128448],
                                [46.85524478563492, 5.459286424114922],
                                [46.82617125942893, 5.370244880835242],
                                [46.728695545924005, 5.391088772820641],
                                [46.63754001470946, 5.441107903009742],
                                [46.522560963527845, 5.359190879639876],
                                [46.47313865941285, 5.415741925117895],
                                [46.44676642071987, 5.310560613770375],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "39", "NOM_DEPT": "JURA"},
                },
                28: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            43.77077752425893,
                            0.7418847912050011,
                            44.378513265035394,
                            1.9901707126503436,
                        ),
                        "coordinates": [
                            [
                                [44.340065248844205, 1.882082857535903],
                                [44.31381428140451, 1.6995029158165782],
                                [44.28680580678515, 1.651620766314853],
                                [44.29839388706526, 1.5691379539986452],
                                [44.263269755581916, 1.5205387676670992],
                                [44.224857733084384, 1.3803681196871467],
                                [44.23578619286305, 1.2813793816235721],
                                [44.327402883405846, 1.1079385683846072],
                                [44.378513265035394, 1.0640838318649108],
                                [44.36263857861528, 1.049803151007228],
                                [44.36637485759438, 0.8873307771559802],
                                [44.32330810855775, 0.8734701152053458],
                                [44.27644247710553, 0.9499239562135766],
                                [44.23827002933658, 0.9190898187097757],
                                [44.12632969467469, 0.86877365550795],
                                [44.10226981270581, 0.7528835731451475],
                                [44.06519923501576, 0.7418847912050011],
                                [44.03591070642859, 0.7757831291372458],
                                [44.040785422701155, 0.8604173969632192],
                                [43.94224249346573, 0.7600848328151357],
                                [43.923289163046476, 0.8628924476067087],
                                [43.864698458132736, 0.8994393128667493],
                                [43.78433052070778, 0.906155770674725],
                                [43.78737246570886, 0.9539831166064945],
                                [43.82229820079683, 1.144597614414948],
                                [43.77077752425893, 1.2191934244058245],
                                [43.82107440669022, 1.360890148995833],
                                [43.884191550555926, 1.3568133196337082],
                                [43.87355299852184, 1.4478772809200224],
                                [43.91831715512138, 1.5556171726831818],
                                [43.96302664758977, 1.5522914897522986],
                                [43.974001636165994, 1.6185715580365614],
                                [44.02434074044873, 1.6913900365689167],
                                [44.11641211601675, 1.6589585652250582],
                                [44.116267124994856, 1.7455400915583978],
                                [44.09681615657593, 1.7775202074591068],
                                [44.14369109998093, 1.8417039588173185],
                                [44.16294029634056, 1.9196921618272453],
                                [44.14945256348434, 1.9901707126503436],
                                [44.17992355171284, 1.976683004728593],
                                [44.20432736443666, 1.9021988872029416],
                                [44.27643627943402, 1.9704438024330744],
                                [44.27911646341683, 1.901390505373501],
                                [44.340065248844205, 1.882082857535903],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "82", "NOM_DEPT": "TARN-ET-GARONNE"},
                },
                29: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            46.97581784960786,
                            -1.3051085022277937,
                            47.80999146298685,
                            0.23000172635318478,
                        ),
                        "coordinates": [
                            [
                                [46.97581784960786, -0.8919599503022404],
                                [47.004252209132005, -0.7738774456713039],
                                [46.98607221005182, -0.7130578012324359],
                                [46.993322065658454, -0.6199767888274355],
                                [47.01942614381194, -0.5654683969778384],
                                [47.06188673077479, -0.559531871926381],
                                [47.08238521770843, -0.4953402437613732],
                                [47.070771034609585, -0.40077950615793034],
                                [47.10572466544676, -0.24153794845204798],
                                [47.10833699690518, -0.18483982751841418],
                                [47.064797190818, -0.10212095637964816],
                                [47.09324258439809, -0.04416541443323783],
                                [47.15750952036683, -0.01073662557135027],
                                [47.16373008265527, 0.05382761471070587],
                                [47.28282475506665, 0.07897484723536188],
                                [47.424733449390715, 0.18528045906678237],
                                [47.50195329713312, 0.22010925240137172],
                                [47.54432775642862, 0.20150312551615113],
                                [47.608398291933675, 0.23000172635318478],
                                [47.58153476849178, 0.15160368312924158],
                                [47.60651520171703, 0.05165930848592362],
                                [47.6476884238069, -0.004507638464452976],
                                [47.65800746667541, -0.07183106759512606],
                                [47.632519977213676, -0.13503673265540417],
                                [47.647916580390344, -0.19315724780649807],
                                [47.707562003167396, -0.23306038777944318],
                                [47.72116575999532, -0.3340770241988634],
                                [47.76056283995014, -0.3817032700427246],
                                [47.765090867872736, -0.4604118623353693],
                                [47.73568882742972, -0.6108182423666904],
                                [47.738107486283226, -0.7417076584328766],
                                [47.752273303191295, -0.8392941203736615],
                                [47.79649707221334, -0.9520300471637984],
                                [47.76199058809525, -0.9786565126647941],
                                [47.7819668412532, -1.0999157158854143],
                                [47.77444246694106, -1.142627284404155],
                                [47.80999146298685, -1.2382517343256687],
                                [47.77671754769661, -1.2458823462890545],
                                [47.73364175152332, -1.2545772523262662],
                                [47.694565013846024, -1.1749295691501485],
                                [47.6194570478612, -1.1382017900650407],
                                [47.58905339489953, -1.0068639898836467],
                                [47.56335191106952, -1.045909504072581],
                                [47.57300754719196, -1.1724160661946539],
                                [47.51008306960625, -1.1572331855798599],
                                [47.49280029691793, -0.9674825559179046],
                                [47.38646685235786, -0.9464433335100018],
                                [47.365062263189614, -1.0178737847602033],
                                [47.36588723515685, -1.167609698077546],
                                [47.337623665323235, -1.2998771573086019],
                                [47.303169978196514, -1.3051085022277937],
                                [47.24985628237829, -1.2541747505718956],
                                [47.25058116645216, -1.1977216097650178],
                                [47.17778408754902, -1.1632160710080481],
                                [47.138781593624955, -1.2352482689031201],
                                [47.10995454752667, -1.2311457136088386],
                                [47.06256455498823, -1.1154625363954862],
                                [47.02954516258657, -1.1485704887534407],
                                [47.00568547430042, -1.0554031085144766],
                                [47.00890804339756, -0.9334603151811864],
                                [46.97581784960786, -0.8919599503022404],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "49", "NOM_DEPT": "MAINE-ET-LOIRE"},
                },
                30: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            45.45570734978023,
                            4.280409632428634,
                            46.30219481477719,
                            5.131048366350085,
                        ),
                        "coordinates": [
                            [
                                [45.81337808264366, 5.101067478338777],
                                [45.80399936996712, 4.923799133458053],
                                [45.90461654376232, 4.8645021533563355],
                                [45.949092212302176, 4.729096921230878],
                                [45.97362201497272, 4.7546312797683195],
                                [46.04720888365027, 4.739530214170903],
                                [46.0941499665971, 4.750325275584826],
                                [46.140701464361854, 4.797433206939167],
                                [46.17667702271938, 4.780213475718984],
                                [46.178372127719896, 4.730529789085251],
                                [46.30219481477719, 4.693107175516046],
                                [46.26479308755153, 4.618551541036954],
                                [46.26712984788543, 4.503987529872384],
                                [46.29606050757101, 4.405813600867753],
                                [46.21978851671502, 4.388079599211451],
                                [46.16787882969538, 4.438590902796802],
                                [46.12922273900979, 4.321566636697419],
                                [46.05294444469335, 4.280409632428634],
                                [46.02122907041072, 4.30609575897843],
                                [45.95339953385286, 4.2939122642052165],
                                [45.9005013366276, 4.3239261660748465],
                                [45.86399385908122, 4.383032288498641],
                                [45.754934723712715, 4.391252031699621],
                                [45.69851909472673, 4.365516200673114],
                                [45.63205080632734, 4.410284239143386],
                                [45.57325450372858, 4.5197664589356545],
                                [45.575468343903715, 4.614858045826019],
                                [45.48675363928719, 4.661741865018664],
                                [45.49429755062865, 4.722336796597095],
                                [45.45570734978023, 4.756935570818616],
                                [45.5234402120416, 4.868481734036511],
                                [45.5723005698916, 4.808696981728118],
                                [45.60626780465844, 4.901457719834113],
                                [45.63720294798378, 5.035148740524161],
                                [45.70770885564475, 5.131048366350085],
                                [45.73945335950924, 5.094526879742294],
                                [45.81337808264366, 5.101067478338777],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "69", "NOM_DEPT": "RHONE"},
                },
                31: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            48.67016796018795,
                            0.2972244202906149,
                            49.47786858986832,
                            1.775628840636083,
                        ),
                        "coordinates": [
                            [
                                [49.409224988863485, 1.7139375433100608],
                                [49.39898608539559, 1.6593030583878112],
                                [49.440143979724375, 1.5754225666575],
                                [49.45649644272496, 1.4121220377546604],
                                [49.44805852414146, 1.3452333638981178],
                                [49.346289233389804, 1.2721366387570638],
                                [49.3419941567295, 1.1602558424773857],
                                [49.30984205819146, 1.133993537971445],
                                [49.2978832323054, 1.0481488434094983],
                                [49.252262976528414, 1.0133166256832071],
                                [49.33855254623689, 0.9214023473164947],
                                [49.38546058453573, 0.9181193706199334],
                                [49.41958304773064, 0.7648660757667747],
                                [49.402002347911484, 0.6652914150341133],
                                [49.43363577759451, 0.5818886055232164],
                                [49.47786858986832, 0.5249403531988144],
                                [49.44093130606127, 0.33898282435946203],
                                [49.429861637283, 0.2972244202906149],
                                [49.29699256482139, 0.32302317286212956],
                                [49.264016474812756, 0.382786744119418],
                                [49.15011747492428, 0.39468800874102034],
                                [49.130194368095964, 0.42487479285721214],
                                [49.04945033019972, 0.37767980975475124],
                                [49.008190235684026, 0.43675135320661196],
                                [48.95062636769437, 0.4128145328890876],
                                [48.91041450585283, 0.3861893489650419],
                                [48.87976248181588, 0.4573579962478969],
                                [48.875537831571705, 0.5525030083730612],
                                [48.83131414903287, 0.6102938086141846],
                                [48.78336423502616, 0.7335062460350473],
                                [48.73752726458569, 0.7749590431141294],
                                [48.7052077986587, 0.7305886446296774],
                                [48.67016796018795, 0.8148191028635925],
                                [48.7154924458169, 0.8767072376479725],
                                [48.7305834560073, 1.0316566693561058],
                                [48.77263016325768, 1.184730602501536],
                                [48.760965095552265, 1.319548414059536],
                                [48.79176905228099, 1.376964009060968],
                                [48.83417900337295, 1.3621810029001882],
                                [48.89221734449297, 1.4683503712150041],
                                [48.94105360615515, 1.5015238197988665],
                                [49.026291046220386, 1.4577625828067997],
                                [49.06854572684407, 1.5217661561843225],
                                [49.07789415353795, 1.6087960706299216],
                                [49.13016217033745, 1.655777439712795],
                                [49.211867057756656, 1.6757368125175731],
                                [49.232201775163404, 1.7043642065965865],
                                [49.26446416218004, 1.7104793339744566],
                                [49.2996937213467, 1.775628840636083],
                                [49.368149815393046, 1.759411755988114],
                                [49.409224988863485, 1.7139375433100608],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "27", "NOM_DEPT": "EURE"},
                },
                32: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            43.693077287037454,
                            1.8395995416341195,
                            44.94122218473673,
                            3.4507554815828207,
                        ),
                        "coordinates": [
                            [
                                [44.14945256348434, 1.9901707126503436],
                                [44.194394561916845, 2.106128564722785],
                                [44.19771468052574, 2.152470897558622],
                                [44.09349085014796, 2.389213772232005],
                                [44.055848637246484, 2.4102102719432614],
                                [44.05139799957896, 2.459937005782879],
                                [43.98128240119407, 2.522933752458295],
                                [43.95058625773123, 2.4993471763625212],
                                [43.921379933748845, 2.554997490001796],
                                [43.841331088723116, 2.564162540693876],
                                [43.7439636033151, 2.6813058930169467],
                                [43.72904476801738, 2.742838073038075],
                                [43.76171872931413, 2.813673557986314],
                                [43.73611367807565, 2.9211070453325663],
                                [43.694667785188855, 2.9354629666803715],
                                [43.708516252330526, 2.98535037366361],
                                [43.693077287037454, 3.060740509271366],
                                [43.83164737994541, 3.0598559764719786],
                                [43.81387268634425, 3.203111724562128],
                                [43.89835231151905, 3.275074750407491],
                                [43.913832893255, 3.3583594413044624],
                                [44.02078728434533, 3.4507554815828207],
                                [44.0790299038748, 3.3289104186209886],
                                [44.158672362655494, 3.3360602348274],
                                [44.17075587210565, 3.3736480448306843],
                                [44.197910434234956, 3.3577995033411128],
                                [44.22625501460891, 3.2298475773263053],
                                [44.2844635736958, 3.1252288254578002],
                                [44.30837023621564, 3.1542516260589815],
                                [44.38337811871574, 3.119711177226503],
                                [44.454870231099065, 3.13573609856136],
                                [44.50348970314472, 3.068542786200033],
                                [44.559014394432964, 3.083593896775788],
                                [44.6446766126243, 2.981676986530433],
                                [44.72863892315705, 2.9232644794453155],
                                [44.779198272865976, 2.9345215070232764],
                                [44.8030106101463, 2.8795722036394493],
                                [44.87148933996955, 2.8496583078406252],
                                [44.87362935290199, 2.8019551055054883],
                                [44.94122218473673, 2.738254293313791],
                                [44.9072261221646, 2.70643491497566],
                                [44.843167608376426, 2.6026810523917403],
                                [44.79280887269849, 2.5993575445949],
                                [44.77575324565893, 2.562709168390778],
                                [44.721284895454446, 2.556123813120712],
                                [44.63887764359621, 2.4350033478315978],
                                [44.66969245597248, 2.326785795750648],
                                [44.643844101683406, 2.208413991565611],
                                [44.61553167652982, 2.2074752855308404],
                                [44.5719014562647, 2.1538165441705135],
                                [44.58290555966192, 2.0573690252842414],
                                [44.50639427715403, 1.9314678023099068],
                                [44.475900168970036, 1.8395995416341195],
                                [44.340065248844205, 1.882082857535903],
                                [44.27911646341683, 1.901390505373501],
                                [44.27643627943402, 1.9704438024330744],
                                [44.20432736443666, 1.9021988872029416],
                                [44.17992355171284, 1.976683004728593],
                                [44.14945256348434, 1.9901707126503436],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "12", "NOM_DEPT": "AVEYRON"},
                },
                33: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            45.68060482956175,
                            1.3749003074212889,
                            46.43091738935583,
                            2.5944189201416936,
                        ),
                        "coordinates": [
                            [
                                [46.4240665008181, 2.167785718138384],
                                [46.40890318674807, 2.088941803334241],
                                [46.43091738935583, 1.9930823669027022],
                                [46.4300383389509, 1.819500417665562],
                                [46.38895871366094, 1.7277108990817451],
                                [46.386815849085174, 1.6448464161558107],
                                [46.42652499450048, 1.5223068332769552],
                                [46.34721849587296, 1.4151905101137503],
                                [46.305894207375275, 1.4437697350516507],
                                [46.21545110095231, 1.3749003074212889],
                                [46.17975461207027, 1.4527947858284072],
                                [46.03541014153877, 1.5491757848158922],
                                [45.95280423814569, 1.5325001755915217],
                                [45.9334124264404, 1.6087196458716777],
                                [45.85746515857901, 1.6023984681707657],
                                [45.835114020235736, 1.6766374034760068],
                                [45.84282757445294, 1.7727491731275804],
                                [45.797714818456456, 1.8808988285366512],
                                [45.7327797889896, 1.875140102478583],
                                [45.6982775512041, 1.898730779182943],
                                [45.755490360800245, 2.01760876898307],
                                [45.724775065025135, 2.113545472759344],
                                [45.73221596168252, 2.17435335428623],
                                [45.699047103880844, 2.1939584682323856],
                                [45.68060482956175, 2.3377545093277403],
                                [45.70947892430507, 2.3491828014700613],
                                [45.699275061444226, 2.4358558482207813],
                                [45.73767009540705, 2.4921255582417543],
                                [45.76985735244724, 2.434118730275934],
                                [45.82737590512424, 2.3880204308712214],
                                [45.86301255580736, 2.4425852582122802],
                                [45.86402992467917, 2.4922254101808226],
                                [45.98944187163357, 2.5944189201416936],
                                [46.11407139955365, 2.5490476236021444],
                                [46.143032182829025, 2.5653790586982073],
                                [46.23943958277255, 2.51631108338946],
                                [46.281147774598125, 2.478940668864652],
                                [46.329982476677515, 2.3918607677139923],
                                [46.32927925675374, 2.3230243720211274],
                                [46.42040537318102, 2.2810476101300576],
                                [46.4240665008181, 2.167785718138384],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "23", "NOM_DEPT": "CREUSE"},
                },
                34: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            47.48789924167961,
                            1.512975755811939,
                            48.320719459436056,
                            3.1284501214452565,
                        ),
                        "coordinates": [
                            [
                                [48.16339174416305, 2.936314411640624],
                                [48.16827665011798, 2.7989445730680167],
                                [48.124819245820404, 2.7065470696044738],
                                [48.140648103275275, 2.5381092459271755],
                                [48.23853573046793, 2.506191747348858],
                                [48.26029732659769, 2.4237635277023717],
                                [48.320719459436056, 2.402664267131608],
                                [48.308672482875515, 2.369810541415244],
                                [48.313745436024625, 2.1813499926674265],
                                [48.28658587795804, 1.9940847180593788],
                                [48.2554662453119, 1.9654790051841269],
                                [48.08385719873065, 1.8656712589157682],
                                [48.066144349606105, 1.7448338583126362],
                                [48.06722274292945, 1.6245928719693987],
                                [48.03069992075931, 1.5941156652809596],
                                [48.02872178085822, 1.512975755811939],
                                [47.98227847700271, 1.5201238283340488],
                                [47.92911358021597, 1.5254235639039049],
                                [47.87642659620686, 1.5881377383696464],
                                [47.820525929167275, 1.5337009096463892],
                                [47.76976159023591, 1.5478779921036048],
                                [47.738393484182936, 1.6973528002323046],
                                [47.66153396919206, 1.739938252775079],
                                [47.63843148089739, 1.7985957016041196],
                                [47.68635321601097, 1.8436947697611497],
                                [47.675630779123125, 1.9424229848119656],
                                [47.67814460516368, 2.20255850774907],
                                [47.62097830787993, 2.2392136309887465],
                                [47.6289623689043, 2.286237981293774],
                                [47.58552457239423, 2.3730210260695963],
                                [47.60977811486517, 2.4373472313231086],
                                [47.568295437652175, 2.491358293796867],
                                [47.55368570340879, 2.599892421980175],
                                [47.48789924167961, 2.658459112358834],
                                [47.49216663238491, 2.7193534234556664],
                                [47.523527275666915, 2.7680263231364863],
                                [47.49445932903693, 2.8064837781833747],
                                [47.520423112556664, 2.8746252064056805],
                                [47.565970182735235, 2.914297452553034],
                                [47.56942879711256, 2.9765380120036067],
                                [47.598884707750464, 2.937999037836789],
                                [47.68055969848399, 2.9231098081748264],
                                [47.71199289202637, 2.8585180302225814],
                                [47.7609264707902, 2.8566660682192713],
                                [47.7632462761762, 2.9350577707343026],
                                [47.786554679015424, 3.023798094359226],
                                [47.90471697202148, 3.0102926272319244],
                                [47.911447449150096, 3.0501042789379826],
                                [47.97097324036121, 3.1284501214452565],
                                [48.05393639482612, 3.0883177986514796],
                                [48.07233413114024, 3.0504714242752176],
                                [48.13320717201307, 3.0294654865478936],
                                [48.16339174416305, 2.936314411640624],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "45", "NOM_DEPT": "LOIRET"},
                },
                35: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            47.26053058451154,
                            5.374078595885573,
                            48.015666213333766,
                            6.823538854548165,
                        ),
                        "coordinates": [
                            [
                                [47.81305372460471, 6.823538854548165],
                                [47.84962275518448, 6.784821909572193],
                                [47.904021106485565, 6.645533181556614],
                                [47.944398619135356, 6.601781921638085],
                                [47.9026105653117, 6.5421528235861155],
                                [47.885521773703914, 6.4786018541765715],
                                [47.94381595263879, 6.431707255957785],
                                [47.961944790786475, 6.366146412024702],
                                [47.93284210199926, 6.237987058178878],
                                [47.95235039238132, 6.167984818891344],
                                [48.00694405924028, 6.156057875261972],
                                [48.015666213333766, 6.072563808399439],
                                [47.956089699040746, 6.002262047573574],
                                [47.97971039136252, 5.94752101881473],
                                [47.92604714858532, 5.884726375202079],
                                [47.86817605973291, 5.821435400588568],
                                [47.85933449218556, 5.7611912388659805],
                                [47.81860389080509, 5.690283323540387],
                                [47.77915825542385, 5.676611542335574],
                                [47.74481735499545, 5.709213007321317],
                                [47.68483888152057, 5.690066479915616],
                                [47.67168603173905, 5.596682241448044],
                                [47.68460287491279, 5.482567919490752],
                                [47.67340074449039, 5.406342872021028],
                                [47.60454165280248, 5.374078595885573],
                                [47.63211377458532, 5.425863186006296],
                                [47.60872207291229, 5.477547427463133],
                                [47.54414450478295, 5.496859255517604],
                                [47.496253655362196, 5.447063511552309],
                                [47.49901446301563, 5.3992024955272315],
                                [47.384062513467185, 5.451397515008267],
                                [47.30418661946959, 5.518538729512594],
                                [47.26053058451154, 5.602110210787404],
                                [47.26499677497705, 5.698725742766406],
                                [47.34425359386964, 5.94137455282545],
                                [47.327623386353956, 5.989355047833264],
                                [47.35403647499406, 6.080045800270596],
                                [47.430569873278635, 6.262328582663191],
                                [47.50596607054917, 6.334353737417102],
                                [47.52029975346226, 6.401377017027886],
                                [47.492797262167244, 6.55356252302069],
                                [47.53987013332597, 6.5817761531248],
                                [47.535260638072835, 6.646719240296149],
                                [47.562955627817956, 6.685554362876694],
                                [47.53641528724466, 6.780972040773947],
                                [47.56280181879927, 6.806992048333126],
                                [47.62526070546134, 6.780404771904787],
                                [47.747877966491, 6.757638483670513],
                                [47.81305372460471, 6.823538854548165],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "70", "NOM_DEPT": "HAUTE-SAONE"},
                },
                36: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            45.28712067830808,
                            2.3880204308712214,
                            46.255486129901755,
                            3.9751057509236487,
                        ),
                        "coordinates": [
                            [
                                [45.93073235641238, 3.6940178008729885],
                                [46.02413780633835, 3.5884696050346547],
                                [46.017936870152774, 3.4635034430082112],
                                [46.074292455804986, 3.419029561174583],
                                [46.05506094849443, 3.371595622264062],
                                [46.06567797651341, 3.166531859715606],
                                [46.12178012989871, 2.971756635840471],
                                [46.20349381071083, 2.9095928618303133],
                                [46.242917468274975, 2.9371457775851466],
                                [46.255486129901755, 2.8557252864968374],
                                [46.19621262362186, 2.810275114252155],
                                [46.223324326165475, 2.733052145656418],
                                [46.11847766171901, 2.6406912317167386],
                                [46.143032182829025, 2.5653790586982073],
                                [46.11407139955365, 2.5490476236021444],
                                [45.98944187163357, 2.5944189201416936],
                                [45.86402992467917, 2.4922254101808226],
                                [45.86301255580736, 2.4425852582122802],
                                [45.82737590512424, 2.3880204308712214],
                                [45.76985735244724, 2.434118730275934],
                                [45.73767009540705, 2.4921255582417543],
                                [45.681924336473706, 2.5283647797478266],
                                [45.639532080177666, 2.514296706686258],
                                [45.60082287582866, 2.46534961788347],
                                [45.553426613923115, 2.516332317304299],
                                [45.47849879874484, 2.508408697113082],
                                [45.44265505156296, 2.651429936294738],
                                [45.38155782083131, 2.714857227145231],
                                [45.3923406923832, 2.852378684057164],
                                [45.3657751174624, 2.9215557561638335],
                                [45.309125835256815, 2.9486247512965202],
                                [45.28712067830808, 3.016710134630249],
                                [45.35437310008832, 3.1034981328800555],
                                [45.352259807508005, 3.1680632240379363],
                                [45.40182189242603, 3.290691872112179],
                                [45.40028672539169, 3.4567465988864985],
                                [45.42757868705258, 3.501320580432494],
                                [45.3383456593203, 3.625846869344361],
                                [45.37619709113048, 3.667209012708465],
                                [45.349191883525556, 3.7722554467335283],
                                [45.39161196684209, 3.8083099578489272],
                                [45.357083781715595, 3.897408424881887],
                                [45.410307649293415, 3.899187761612733],
                                [45.44826954913943, 3.9751057509236487],
                                [45.555962683335494, 3.954348408158434],
                                [45.5990224663249, 3.903596234209209],
                                [45.63241694241681, 3.823453198078696],
                                [45.72434927186397, 3.7808499481107716],
                                [45.783181674804744, 3.699758022143211],
                                [45.88603083611283, 3.7543707578917007],
                                [45.93073235641238, 3.6940178008729885],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "63", "NOM_DEPT": "PUY-DE-DOME"},
                },
                37: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            43.395686947410056,
                            1.5522914897522986,
                            44.19771468052574,
                            2.9354629666803715,
                        ),
                        "coordinates": [
                            [
                                [43.91831715512138, 1.5556171726831818],
                                [43.868315400129546, 1.5554632454868464],
                                [43.815488439336, 1.5910292905659653],
                                [43.800257495357435, 1.644787627039312],
                                [43.74183402488211, 1.6604214137506872],
                                [43.71621951436253, 1.7064455963184253],
                                [43.65775037692843, 1.730869381606712],
                                [43.63070037401987, 1.687771093611741],
                                [43.5808317662611, 1.824800921390715],
                                [43.520928759682434, 1.882609451533412],
                                [43.47035021960434, 2.018141282533191],
                                [43.43689796484212, 2.02913283879736],
                                [43.395686947410056, 2.0728007398118375],
                                [43.43176717254867, 2.2241677335019907],
                                [43.4599295251568, 2.2591004793801175],
                                [43.418670700931195, 2.4036304838758644],
                                [43.43517605493273, 2.4331017858919792],
                                [43.422959744104, 2.5657873980365586],
                                [43.431093773006396, 2.606081177961043],
                                [43.48016355800575, 2.6595399785833935],
                                [43.525794099032574, 2.658651329156613],
                                [43.56663335506618, 2.615607192520078],
                                [43.650146162495055, 2.6432637215975134],
                                [43.64559678398747, 2.711169474843746],
                                [43.6141387864358, 2.7545235571938624],
                                [43.66002074537221, 2.9159815194674086],
                                [43.694667785188855, 2.9354629666803715],
                                [43.73611367807565, 2.9211070453325663],
                                [43.76171872931413, 2.813673557986314],
                                [43.72904476801738, 2.742838073038075],
                                [43.7439636033151, 2.6813058930169467],
                                [43.841331088723116, 2.564162540693876],
                                [43.921379933748845, 2.554997490001796],
                                [43.95058625773123, 2.4993471763625212],
                                [43.98128240119407, 2.522933752458295],
                                [44.05139799957896, 2.459937005782879],
                                [44.055848637246484, 2.4102102719432614],
                                [44.09349085014796, 2.389213772232005],
                                [44.19771468052574, 2.152470897558622],
                                [44.194394561916845, 2.106128564722785],
                                [44.14945256348434, 1.9901707126503436],
                                [44.16294029634056, 1.9196921618272453],
                                [44.14369109998093, 1.8417039588173185],
                                [44.09681615657593, 1.7775202074591068],
                                [44.116267124994856, 1.7455400915583978],
                                [44.11641211601675, 1.6589585652250582],
                                [44.02434074044873, 1.6913900365689167],
                                [43.974001636165994, 1.6185715580365614],
                                [43.96302664758977, 1.5522914897522986],
                                [43.91831715512138, 1.5556171726831818],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "81", "NOM_DEPT": "TARN"},
                },
                38: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            49.252262976528414,
                            0.06560687754986201,
                            50.06501467638129,
                            1.7838370588623413,
                        ),
                        "coordinates": [
                            [
                                [49.75830750106765, 1.7838370588623413],
                                [49.828884105223665, 1.7270555289768348],
                                [49.91813416149145, 1.6784506742272387],
                                [50.037833342652824, 1.4564621593341673],
                                [50.06501467638129, 1.379705037415187],
                                [49.96803785451211, 1.1943823852499285],
                                [49.92561385766795, 1.0659015382478343],
                                [49.919857551513566, 0.9631874837108026],
                                [49.872095613532025, 0.7697293792067499],
                                [49.84972067059468, 0.5729399803584807],
                                [49.74154748097868, 0.32055875091141733],
                                [49.71446864261743, 0.2116632434482712],
                                [49.648642302677665, 0.1545347165457159],
                                [49.51257112097312, 0.06560687754986201],
                                [49.46319090812617, 0.12124538314126901],
                                [49.44093130606127, 0.33898282435946203],
                                [49.47786858986832, 0.5249403531988144],
                                [49.43363577759451, 0.5818886055232164],
                                [49.402002347911484, 0.6652914150341133],
                                [49.41958304773064, 0.7648660757667747],
                                [49.38546058453573, 0.9181193706199334],
                                [49.33855254623689, 0.9214023473164947],
                                [49.252262976528414, 1.0133166256832071],
                                [49.2978832323054, 1.0481488434094983],
                                [49.30984205819146, 1.133993537971445],
                                [49.3419941567295, 1.1602558424773857],
                                [49.346289233389804, 1.2721366387570638],
                                [49.44805852414146, 1.3452333638981178],
                                [49.45649644272496, 1.4121220377546604],
                                [49.440143979724375, 1.5754225666575],
                                [49.39898608539559, 1.6593030583878112],
                                [49.409224988863485, 1.7139375433100608],
                                [49.466150363724154, 1.7663450271414043],
                                [49.50822302010687, 1.7192326604453183],
                                [49.531737693641695, 1.7451334451250167],
                                [49.60539892585883, 1.7045819685135704],
                                [49.67263435960493, 1.7252046142437356],
                                [49.69478564626097, 1.689575882111812],
                                [49.75830750106765, 1.7838370588623413],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "76", "NOM_DEPT": "SEINE-MARITIME"},
                },
                39: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            47.60454165280248,
                            4.653455248176321,
                            48.68871245199127,
                            5.884726375202079,
                        ),
                        "coordinates": [
                            [
                                [48.53188730232318, 4.670183207291811],
                                [48.47054866778951, 4.653455248176321],
                                [48.39485512882371, 4.716095686333967],
                                [48.347359803339394, 4.809737759938721],
                                [48.26363849150269, 4.858919933219106],
                                [48.141758855401065, 4.850099917169891],
                                [48.10319242347872, 4.8193072949588815],
                                [48.11820899819213, 4.730610406781701],
                                [48.07312791926578, 4.688818526238874],
                                [48.0202323762219, 4.704238250439468],
                                [48.00782938257308, 4.789083695644797],
                                [47.9642022255857, 4.78651260287447],
                                [47.956238623224316, 4.852043179350452],
                                [47.866768148099496, 4.9540942495981195],
                                [47.80034738345194, 4.982400768988487],
                                [47.76500253040028, 4.949610301299183],
                                [47.68776283651174, 4.979107142832904],
                                [47.64968494441666, 5.108878229414663],
                                [47.65256871238262, 5.173597037303847],
                                [47.61613009899267, 5.239232274239111],
                                [47.60454165280248, 5.374078595885573],
                                [47.67340074449039, 5.406342872021028],
                                [47.68460287491279, 5.482567919490752],
                                [47.67168603173905, 5.596682241448044],
                                [47.68483888152057, 5.690066479915616],
                                [47.74481735499545, 5.709213007321317],
                                [47.77915825542385, 5.676611542335574],
                                [47.81860389080509, 5.690283323540387],
                                [47.85933449218556, 5.7611912388659805],
                                [47.86817605973291, 5.821435400588568],
                                [47.92604714858532, 5.884726375202079],
                                [47.96283504724515, 5.850003923490582],
                                [47.95259697311841, 5.787280985479235],
                                [48.03136192327879, 5.77774789858366],
                                [48.07722956641849, 5.696798789098754],
                                [48.08398621524326, 5.630534001339329],
                                [48.14504209498631, 5.68431870758825],
                                [48.21992832819691, 5.710843767915566],
                                [48.24235420494441, 5.640901189478503],
                                [48.35620132426793, 5.482149185087856],
                                [48.38310019043651, 5.408721169498744],
                                [48.42092912174115, 5.470048195176172],
                                [48.48198867902053, 5.349469998299744],
                                [48.53861075457746, 5.208425883036941],
                                [48.59551086053376, 5.118346103266606],
                                [48.59572522098937, 5.070888258264775],
                                [48.634035501163716, 5.005925627052495],
                                [48.684418562233176, 4.988427677798425],
                                [48.68871245199127, 4.911268319875394],
                                [48.64966704551767, 4.84196138973274],
                                [48.62363257092489, 4.84925614314003],
                                [48.588688310630296, 4.769195892207036],
                                [48.52977987624909, 4.799180099828292],
                                [48.53188730232318, 4.670183207291811],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "52", "NOM_DEPT": "HAUTE-MARNE"},
                },
                40: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            43.460185432726384,
                            3.3289104186209886,
                            44.45979755586323,
                            4.842093969959472,
                        ),
                        "coordinates": [
                            [
                                [44.27035986501095, 4.649223666100485],
                                [44.30244463260489, 4.55869985714841],
                                [44.34018845123076, 4.503536213064646],
                                [44.33952274370027, 4.336073225463424],
                                [44.314658687843355, 4.288416558058853],
                                [44.26478557642796, 4.2588461979825505],
                                [44.31335085540007, 4.142867700090412],
                                [44.317323657117, 4.051451662788466],
                                [44.40511357294199, 4.068441217053273],
                                [44.45979755586323, 3.998162987763964],
                                [44.399567503492314, 3.944362317344653],
                                [44.387999052346906, 3.8859181039452233],
                                [44.32838999677705, 3.952331315351652],
                                [44.305217941025674, 3.922858913740669],
                                [44.247795429889, 3.9513171396124562],
                                [44.1707937260686, 3.9526044819739092],
                                [44.130073752440985, 3.862104986455048],
                                [44.12738907948688, 3.7969951126604835],
                                [44.18275878035751, 3.678640671819198],
                                [44.175488044182295, 3.637769161351025],
                                [44.122695330490544, 3.633491144032294],
                                [44.12909826593223, 3.4397298934659637],
                                [44.17075587210565, 3.3736480448306843],
                                [44.158672362655494, 3.3360602348274],
                                [44.0790299038748, 3.3289104186209886],
                                [44.02078728434533, 3.4507554815828207],
                                [43.913832893255, 3.3583594413044624],
                                [43.91159816844731, 3.424448067668623],
                                [43.855624713961625, 3.5307009207380955],
                                [43.86552224087741, 3.5754482408134063],
                                [43.916978566757564, 3.623588615095356],
                                [43.96901626259538, 3.726990344828379],
                                [43.96687037520115, 3.787325021892116],
                                [43.91929773950883, 3.824905456819552],
                                [43.8664240348707, 3.830797043559706],
                                [43.88559322066372, 3.917385092127717],
                                [43.81146444231582, 4.002046166191344],
                                [43.73388653553411, 4.144780927023586],
                                [43.654303826233026, 4.194441206758988],
                                [43.585562468156866, 4.150215691493674],
                                [43.554370946408625, 4.1010416754063925],
                                [43.53189642273346, 4.13912342859037],
                                [43.481945925465276, 4.13766421830876],
                                [43.460185432726384, 4.230283393392478],
                                [43.49762691783989, 4.238105541141803],
                                [43.5611278006361, 4.409349673740098],
                                [43.62067757183952, 4.4270280421178025],
                                [43.69923776661919, 4.487236861293796],
                                [43.68746240297296, 4.593032248301324],
                                [43.80640869163021, 4.654821446467849],
                                [43.86747754714164, 4.641909591242105],
                                [43.924059473490566, 4.739060856654237],
                                [43.98647454846487, 4.842093969959472],
                                [44.06505409747017, 4.787978024928094],
                                [44.10367246401243, 4.707458356688192],
                                [44.18742154948268, 4.722074664233517],
                                [44.27035986501095, 4.649223666100485],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "30", "NOM_DEPT": "GARD"},
                },
                41: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            48.12036852181815,
                            6.964601688658047,
                            49.06411681072389,
                            8.214337990422155,
                        ),
                        "coordinates": [
                            [
                                [48.31046786103526, 7.198281537029947],
                                [48.30523478706437, 7.275183721811301],
                                [48.24719461957464, 7.348562541549848],
                                [48.20353668429841, 7.476943375699941],
                                [48.161014524040404, 7.470560946722399],
                                [48.12611186664672, 7.519368638022094],
                                [48.12036852181815, 7.577312855212316],
                                [48.223910814477854, 7.667802806274936],
                                [48.30881209287648, 7.7031402606000405],
                                [48.32174822909557, 7.7398807675883825],
                                [48.40415792790444, 7.7359757519993035],
                                [48.489658145871125, 7.768185493209044],
                                [48.513571471609616, 7.805195566047566],
                                [48.59233465434716, 7.804169862129347],
                                [48.641373985105616, 7.83981724689541],
                                [48.7213530972908, 7.9631400450945655],
                                [48.757628209852165, 7.971745157755574],
                                [48.81038371014785, 8.096320563319823],
                                [48.9038081988035, 8.14793847273242],
                                [48.97509304800346, 8.214337990422155],
                                [48.98925821691501, 8.091376040143569],
                                [49.057809150306376, 7.934626827531663],
                                [49.03415707326485, 7.868785609773862],
                                [49.06411681072389, 7.800436670933281],
                                [49.04436019362859, 7.732229514556395],
                                [49.0541613551771, 7.635285449703197],
                                [48.95740241810784, 7.57839213753989],
                                [48.932961584940934, 7.5382590392502085],
                                [48.96577914855414, 7.446887904100119],
                                [48.94337274202096, 7.326851980608825],
                                [48.97341645090749, 7.293048848802893],
                                [49.006365681338195, 7.174240270723143],
                                [49.04411352331478, 7.107657105402387],
                                [49.03061918771655, 7.054911912536334],
                                [48.95992878867804, 6.98921640979739],
                                [48.90452526765522, 6.964601688658047],
                                [48.87154914036644, 7.0453428905310576],
                                [48.813704386223854, 7.054514540544794],
                                [48.801142358200266, 7.126799106595456],
                                [48.84470403837187, 7.149408408912651],
                                [48.76730084431057, 7.311900506296782],
                                [48.69154313190619, 7.242487615031407],
                                [48.63810720117092, 7.283044927480475],
                                [48.588675507652006, 7.256281654444217],
                                [48.52759644354931, 7.167909935894844],
                                [48.536417612700156, 7.079359770973246],
                                [48.51359226555661, 7.123165369028565],
                                [48.40564467453035, 7.097427065168084],
                                [48.33329037920514, 7.121908440975998],
                                [48.31046786103526, 7.198281537029947],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "67", "NOM_DEPT": "BAS-RHIN"},
                },
                42: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            42.66391836976527,
                            1.688419720914751,
                            43.4599295251568,
                            3.24056113717041,
                        ),
                        "coordinates": [
                            [
                                [43.21280863308409, 3.24056113717041],
                                [43.24916714805367, 3.2010265503923754],
                                [43.24700506844496, 3.1472079664155532],
                                [43.28853825294427, 3.004740938100306],
                                [43.32013114159761, 3.004349268167806],
                                [43.322412805617326, 2.8327620472635995],
                                [43.25778564580618, 2.772248225673249],
                                [43.298706986396866, 2.6016030790296316],
                                [43.34622186231968, 2.5399619094859687],
                                [43.422959744104, 2.5657873980365586],
                                [43.43517605493273, 2.4331017858919792],
                                [43.418670700931195, 2.4036304838758644],
                                [43.4599295251568, 2.2591004793801175],
                                [43.43176717254867, 2.2241677335019907],
                                [43.395686947410056, 2.0728007398118375],
                                [43.43689796484212, 2.02913283879736],
                                [43.40405939980915, 1.9101007956285103],
                                [43.44382089121736, 1.8587429714302222],
                                [43.391684804856155, 1.8040846789340412],
                                [43.341403596986645, 1.81342406452215],
                                [43.3437401011229, 1.747732597304773],
                                [43.27355372810048, 1.688419720914751],
                                [43.224524250769015, 1.723844068753025],
                                [43.18969803410896, 1.710056447799201],
                                [43.14581388915534, 1.824772198868932],
                                [43.119494438163784, 1.9494758652019246],
                                [43.052715472626694, 1.941132873290632],
                                [43.02627232234234, 1.9851004481943353],
                                [42.87101168756058, 1.986920914223352],
                                [42.852669269026464, 1.8804739886198156],
                                [42.767667043480046, 1.9081798281291227],
                                [42.73670079860314, 1.9553956635295406],
                                [42.7562228612599, 2.057204243184995],
                                [42.6827952243106, 2.1758741195218594],
                                [42.66391836976527, 2.166053682054993],
                                [42.70779157620242, 2.322006120391769],
                                [42.73412195489036, 2.357535079462851],
                                [42.837442775831846, 2.327116045977923],
                                [42.83693276356474, 2.452474760710876],
                                [42.8498316897035, 2.5090117260388043],
                                [42.830431065988684, 2.697577646248594],
                                [42.837574151816995, 2.7400003158100112],
                                [42.89598872881156, 2.789053819259419],
                                [42.918341437261006, 2.8652738803519484],
                                [42.88486022074883, 2.917114990593263],
                                [42.83815011921807, 3.0434985865888815],
                                [42.917059904945106, 3.060589297455898],
                                [42.96015378799919, 3.0428431893335772],
                                [43.10183913719124, 3.1172205062222833],
                                [43.21280863308409, 3.24056113717041],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "11", "NOM_DEPT": "AUDE"},
                },
                43: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            48.124819245820404,
                            2.402664267131608,
                            49.117554218816146,
                            3.5556137492385345,
                        ),
                        "coordinates": [
                            [
                                [48.16339174416305, 2.936314411640624],
                                [48.20767000036061, 3.0051556578134635],
                                [48.27202235762727, 3.043627253848888],
                                [48.36012035556558, 3.0495188960927044],
                                [48.371860839526576, 3.167737573570585],
                                [48.37228068710627, 3.3651592673815314],
                                [48.39027303882033, 3.4147915595010967],
                                [48.424322153455364, 3.3919598867876517],
                                [48.533562692399734, 3.4234423807070566],
                                [48.604809134470905, 3.5038535314822115],
                                [48.62028467657408, 3.5556137492385345],
                                [48.65300999879329, 3.460426313142606],
                                [48.69935806711918, 3.476963643099447],
                                [48.75357171634101, 3.435808986802742],
                                [48.85190849437287, 3.4851874436586847],
                                [48.8646865193221, 3.4032194510047127],
                                [48.908706088642376, 3.3302994547269797],
                                [48.948764278944545, 3.3047494707754015],
                                [49.014123184303735, 3.171683982224406],
                                [49.09965085798759, 3.16523032905892],
                                [49.117554218816146, 3.071884293834167],
                                [49.09151015780461, 3.0085155429257675],
                                [49.06044982525112, 2.7350126834936956],
                                [49.10837621896304, 2.633272965218076],
                                [49.07965484673244, 2.5905242793946224],
                                [49.00981711743891, 2.55306064485419],
                                [48.92935660278061, 2.6025984314319826],
                                [48.888884130524836, 2.5626221662429587],
                                [48.8074366758147, 2.5922804883088015],
                                [48.761027192292545, 2.6136476481340414],
                                [48.69201409164603, 2.571660318442073],
                                [48.65733138882678, 2.53361600680745],
                                [48.603849771145576, 2.5437765144069613],
                                [48.525239048001154, 2.49952467433224],
                                [48.439446016118225, 2.504749755053753],
                                [48.41125114633111, 2.533731834361712],
                                [48.362015783117755, 2.429832228504419],
                                [48.320719459436056, 2.402664267131608],
                                [48.26029732659769, 2.4237635277023717],
                                [48.23853573046793, 2.506191747348858],
                                [48.140648103275275, 2.5381092459271755],
                                [48.124819245820404, 2.7065470696044738],
                                [48.16827665011798, 2.7989445730680167],
                                [48.16339174416305, 2.936314411640624],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "77", "NOM_DEPT": "SEINE-ET-MARNE"},
                },
                44: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            49.58141197178742,
                            1.379705037415187,
                            50.36186618072208,
                            3.1926752854802194,
                        ),
                        "coordinates": [
                            [
                                [50.05374055513492, 3.090253620620082],
                                [50.04217932424791, 2.87653264314694],
                                [50.07739311900277, 2.857843650412817],
                                [50.11341281005765, 2.576019813733672],
                                [50.141605436861035, 2.551329915710551],
                                [50.136999469996475, 2.4766865519087604],
                                [50.10064240686793, 2.4145079258525888],
                                [50.1554848214444, 2.3897770566865675],
                                [50.194562024118035, 2.4956903275727766],
                                [50.23030237700429, 2.4517852065078483],
                                [50.20977035832257, 2.370204907638782],
                                [50.226839899619605, 2.2738282654200974],
                                [50.20554490563295, 2.0957483707167426],
                                [50.24882125974279, 2.0778202954555876],
                                [50.287428042736344, 1.9461316429136999],
                                [50.31177877534883, 1.9180007470953697],
                                [50.36186618072208, 1.7787842601942672],
                                [50.33101039989745, 1.670715509846568],
                                [50.35215320244089, 1.641543920995599],
                                [50.35032330173502, 1.5509358115042569],
                                [50.28266847458906, 1.537947734772934],
                                [50.255951023550146, 1.5902673346965241],
                                [50.16491841311899, 1.4787143993875134],
                                [50.110329098934855, 1.453881224461017],
                                [50.06501467638129, 1.379705037415187],
                                [50.037833342652824, 1.4564621593341673],
                                [49.91813416149145, 1.6784506742272387],
                                [49.828884105223665, 1.7270555289768348],
                                [49.75830750106765, 1.7838370588623413],
                                [49.69898823076107, 1.8938643249004958],
                                [49.71962996348948, 1.9332098221662726],
                                [49.68807409174484, 2.1214097069260887],
                                [49.70164087681329, 2.247168590692668],
                                [49.65626624025836, 2.373145663229162],
                                [49.639467268909165, 2.5047488992503943],
                                [49.59708062701417, 2.571493337841171],
                                [49.58141197178742, 2.670723151725744],
                                [49.625601863474394, 2.6891419821315017],
                                [49.6205860518149, 2.7994949073615056],
                                [49.65595422263167, 2.7936124229581845],
                                [49.702672388966874, 2.915712813038834],
                                [49.705968560150744, 3.1184031553047866],
                                [49.822415215784225, 3.078694114076548],
                                [49.91427637798353, 3.117968662907868],
                                [49.977464696263276, 3.1926752854802194],
                                [50.01199494467939, 3.1727072271768164],
                                [50.05374055513492, 3.090253620620082],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "80", "NOM_DEPT": "SOMME"},
                },
                45: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            44.743863434670935,
                            3.1034981328800555,
                            45.42757868705258,
                            4.483134616383878,
                        ),
                        "coordinates": [
                            [
                                [45.35437310008832, 3.1034981328800555],
                                [45.28418729762223, 3.1179979977042014],
                                [45.27197144658481, 3.222465248668949],
                                [45.12042440957931, 3.2880332175079103],
                                [45.09513611769881, 3.3257851579159827],
                                [45.03607778789878, 3.2972503187682016],
                                [45.014233878924166, 3.3471986847617567],
                                [44.971411709678975, 3.3613425807398936],
                                [44.94484250197586, 3.412834742275399],
                                [44.90076835769558, 3.4179705141646854],
                                [44.81537151910512, 3.475773707159976],
                                [44.83219404802294, 3.589348917106291],
                                [44.87542977006507, 3.5943359966689923],
                                [44.869938644505325, 3.6595223843815874],
                                [44.82877808873478, 3.666364914643008],
                                [44.83869734813899, 3.7406507355868404],
                                [44.743863434670935, 3.862527190139651],
                                [44.7954172172997, 3.937001123548729],
                                [44.83408100300616, 4.028374858328879],
                                [44.87316201331411, 4.039638866980704],
                                [44.87333360834132, 4.156154791813548],
                                [44.961336129386744, 4.221702631142119],
                                [44.99730682920296, 4.289827924670837],
                                [45.10483231156165, 4.375306064703463],
                                [45.1443595905019, 4.376558944791765],
                                [45.14083295591157, 4.443262789803058],
                                [45.23644648192783, 4.483134616383878],
                                [45.27542410166107, 4.418571110077436],
                                [45.264395356817886, 4.3625488691169565],
                                [45.33699593440974, 4.366534405291163],
                                [45.37098690693708, 4.308199323181692],
                                [45.39260487868634, 4.177926371804465],
                                [45.3428877136373, 4.02482405154612],
                                [45.37513435596747, 3.97965057221058],
                                [45.357083781715595, 3.897408424881887],
                                [45.39161196684209, 3.8083099578489272],
                                [45.349191883525556, 3.7722554467335283],
                                [45.37619709113048, 3.667209012708465],
                                [45.3383456593203, 3.625846869344361],
                                [45.42757868705258, 3.501320580432494],
                                [45.40028672539169, 3.4567465988864985],
                                [45.40182189242603, 3.290691872112179],
                                [45.352259807508005, 3.1680632240379363],
                                [45.35437310008832, 3.1034981328800555],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "43", "NOM_DEPT": "HAUTE-LOIRE"},
                },
                46: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            48.516104417807576,
                            3.435808986802742,
                            49.406181771288736,
                            5.036321445219878,
                        ),
                        "coordinates": [
                            [
                                [49.405642294757534, 4.047972977986833],
                                [49.359904159430094, 4.035496373111564],
                                [49.406181771288736, 3.9244337055179424],
                                [49.36458662943729, 3.8474771401321166],
                                [49.31515350351225, 3.646953205074641],
                                [49.18137302346899, 3.7043920469634597],
                                [49.151103693376655, 3.622246623748466],
                                [49.12069184512517, 3.600004656260229],
                                [49.04058839070318, 3.646307433571441],
                                [48.94407204131733, 3.6015984944904185],
                                [48.91214102895303, 3.528576443116953],
                                [48.85190849437287, 3.4851874436586847],
                                [48.75357171634101, 3.435808986802742],
                                [48.69935806711918, 3.476963643099447],
                                [48.65300999879329, 3.460426313142606],
                                [48.62028467657408, 3.5556137492385345],
                                [48.541298263185546, 3.634028277746641],
                                [48.53746785521082, 3.730879401425958],
                                [48.516104417807576, 3.822742058660399],
                                [48.60343162808371, 3.9492266572894206],
                                [48.66387541820995, 4.001695483416846],
                                [48.70106898077084, 4.080262439820496],
                                [48.70745423752744, 4.166386793257749],
                                [48.700277029531, 4.3255940122986445],
                                [48.615578923326495, 4.315905486866125],
                                [48.56126039348743, 4.40306312166006],
                                [48.525252271641655, 4.545406992928758],
                                [48.553807130712464, 4.614026636401957],
                                [48.53188730232318, 4.670183207291811],
                                [48.52977987624909, 4.799180099828292],
                                [48.588688310630296, 4.769195892207036],
                                [48.62363257092489, 4.84925614314003],
                                [48.64966704551767, 4.84196138973274],
                                [48.68871245199127, 4.911268319875394],
                                [48.684418562233176, 4.988427677798425],
                                [48.74183736486811, 4.990124563499124],
                                [48.81720971453768, 4.888760929797642],
                                [48.92214239512387, 4.9362093920054075],
                                [48.95690245547182, 5.030128675561755],
                                [49.024332549540816, 5.036321445219878],
                                [49.03495195077164, 5.0076814026818575],
                                [49.11490008827158, 4.992117611940037],
                                [49.18506820457861, 4.9397619983736725],
                                [49.23686584630137, 4.950989232683009],
                                [49.25907433894352, 4.8942062202820455],
                                [49.23576093816036, 4.826941205469512],
                                [49.256759043801544, 4.686074799511886],
                                [49.235656063432884, 4.625104107270341],
                                [49.296651189312385, 4.575868215345435],
                                [49.28064492915537, 4.422583188651028],
                                [49.32779732810991, 4.306756525620349],
                                [49.38225617648581, 4.24830818454738],
                                [49.40418703243856, 4.143169752612987],
                                [49.405642294757534, 4.047972977986833],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "51", "NOM_DEPT": "MARNE"},
                },
                47: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            42.674924581800944,
                            -0.3270821344018897,
                            43.60465738319822,
                            0.6274179241908857,
                        ),
                        "coordinates": [
                            [
                                [42.84937505970757, -0.31344286349808953],
                                [42.76846693245407, -0.14599159174135215],
                                [42.72082372641455, -0.10610940781291865],
                                [42.68438508509316, -0.010637584646292208],
                                [42.73648479569684, 0.1757204586573466],
                                [42.71581111366541, 0.259882956272081],
                                [42.674924581800944, 0.2928222485813244],
                                [42.72339183232152, 0.35962879548357923],
                                [42.69074972940033, 0.42927573387270157],
                                [42.69999034279792, 0.4777495403273698],
                                [42.728060641999555, 0.4550942250736491],
                                [42.828145214268325, 0.4588995164240373],
                                [42.87810749616207, 0.47730134412302644],
                                [42.870825923039746, 0.575935146951876],
                                [43.000102873234276, 0.6274179241908857],
                                [43.01746794817708, 0.5630044583601441],
                                [43.093864488407256, 0.5322696523895425],
                                [43.13127313187027, 0.4419985587106278],
                                [43.20914713009289, 0.5518748957180638],
                                [43.236102503746785, 0.5515684940570376],
                                [43.28903679046807, 0.6162800547565972],
                                [43.31088599158549, 0.6068109749570955],
                                [43.32618057240136, 0.4980338187920962],
                                [43.385790922905464, 0.2772545000281133],
                                [43.37118267445077, 0.1820312140000635],
                                [43.43291627195161, 0.13798238183895667],
                                [43.517369919818584, 0.11212423457670333],
                                [43.5188072498529, 0.056081443916197675],
                                [43.56554046143868, -0.0019248187812953763],
                                [43.60465738319822, -0.015780894995831136],
                                [43.5824058976317, -0.0967829732087753],
                                [43.512605402100824, -0.04013178615004061],
                                [43.43734927067611, -0.06903100203309719],
                                [43.42210994370382, 0.009598314167784467],
                                [43.300855792903974, -0.046122416801734976],
                                [43.27045317593498, -0.017007531250724548],
                                [43.180326663081885, -0.11770146168361191],
                                [43.128235959977104, -0.14613235140227182],
                                [43.11120001485185, -0.19098404402245117],
                                [43.033687539643886, -0.22395152380116173],
                                [42.98776781593242, -0.29155187666703314],
                                [42.93356279018236, -0.28159092548449965],
                                [42.915781623764374, -0.3270821344018897],
                                [42.84937505970757, -0.31344286349808953],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "65", "NOM_DEPT": "HAUTES-PYRENEES"},
                },
                48: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            44.224857733084384,
                            1.0090253989657332,
                            45.04628038727667,
                            2.2074752855308404,
                        ),
                        "coordinates": [
                            [
                                [44.577324783565565, 1.0751408247250978],
                                [44.53612714227498, 1.0131666459229496],
                                [44.480041109061666, 1.0090253989657332],
                                [44.378513265035394, 1.0640838318649108],
                                [44.327402883405846, 1.1079385683846072],
                                [44.23578619286305, 1.2813793816235721],
                                [44.224857733084384, 1.3803681196871467],
                                [44.263269755581916, 1.5205387676670992],
                                [44.29839388706526, 1.5691379539986452],
                                [44.28680580678515, 1.651620766314853],
                                [44.31381428140451, 1.6995029158165782],
                                [44.340065248844205, 1.882082857535903],
                                [44.475900168970036, 1.8395995416341195],
                                [44.50639427715403, 1.9314678023099068],
                                [44.58290555966192, 2.0573690252842414],
                                [44.5719014562647, 2.1538165441705135],
                                [44.61553167652982, 2.2074752855308404],
                                [44.63806619142596, 2.1694177928364122],
                                [44.75310757902523, 2.1534919160094748],
                                [44.790024398712326, 2.1716362748643747],
                                [44.87201148950672, 2.094212310672087],
                                [44.97650640551561, 2.062914291973062],
                                [44.978426771844674, 1.908156162007897],
                                [44.927682448456935, 1.8239145263410463],
                                [44.95495947953578, 1.7506251087427582],
                                [45.02501608647879, 1.650983768334641],
                                [45.04628038727667, 1.5357253751118864],
                                [45.019313158674045, 1.4482615439322115],
                                [44.99938624261527, 1.413299030000565],
                                [44.87757922298133, 1.441920482742166],
                                [44.84079526684298, 1.3614038259537622],
                                [44.81156818641523, 1.3641029713426986],
                                [44.71478109653049, 1.2877821394602265],
                                [44.684266348929604, 1.2245500554542499],
                                [44.67034606645627, 1.1466718447537776],
                                [44.6394062697152, 1.1537937079861709],
                                [44.577324783565565, 1.0751408247250978],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "46", "NOM_DEPT": "LOT"},
                },
                49: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            43.69416334085517,
                            5.498787806458752,
                            44.65949945810214,
                            6.948335091404862,
                        ),
                        "coordinates": [
                            [
                                [43.788950567095455, 6.636395800176685],
                                [43.87365480225297, 6.697323345466609],
                                [43.87210825687496, 6.745556290785885],
                                [43.91836301148648, 6.830709312232407],
                                [43.88912075689406, 6.884610185550848],
                                [43.92796536503885, 6.913088787529998],
                                [43.95479401195955, 6.8518918622455915],
                                [43.99060185096185, 6.836004210977612],
                                [44.043235362043184, 6.745713950501123],
                                [44.078606586955765, 6.755280297628582],
                                [44.169253930861004, 6.686536427072905],
                                [44.24984330468263, 6.723993885002385],
                                [44.31610570751232, 6.796090992510113],
                                [44.36104783803612, 6.887429900902961],
                                [44.477252952765674, 6.881957404401121],
                                [44.529129653944196, 6.854013487274842],
                                [44.57595174677901, 6.933506639572194],
                                [44.654816299146766, 6.948335091404862],
                                [44.65949945810214, 6.914488202179288],
                                [44.60858882906438, 6.83980166742822],
                                [44.58890871380474, 6.772207133133651],
                                [44.54130010645836, 6.684305299896708],
                                [44.44712877640474, 6.63237632755871],
                                [44.44549275371157, 6.562444503095604],
                                [44.46928995962832, 6.413884950226283],
                                [44.522072579043936, 6.362000081358196],
                                [44.46383091832782, 6.233718236049833],
                                [44.41225003856591, 6.262481962582939],
                                [44.381700391997015, 6.228221718294849],
                                [44.461959822985584, 6.15561504901071],
                                [44.45053588827667, 6.071139333430848],
                                [44.39505926669922, 5.953670382950493],
                                [44.27153166809449, 5.912323479912074],
                                [44.27890195531251, 5.823911889045942],
                                [44.210998662542806, 5.881793583616447],
                                [44.21020776523787, 5.75549419659688],
                                [44.191433131858965, 5.676037325543462],
                                [44.167586051913645, 5.639593544372252],
                                [44.188041650949074, 5.576187167563139],
                                [44.13639078272547, 5.543986124993946],
                                [44.11571934778836, 5.498787806458752],
                                [44.06343920865494, 5.5026367853279545],
                                [44.02870768768523, 5.543656674317526],
                                [43.946002285646465, 5.512089542555731],
                                [43.913772843753264, 5.607126670731598],
                                [43.82992112219788, 5.5781897912212175],
                                [43.82511098585936, 5.654445137414141],
                                [43.729409113755324, 5.7573329775827045],
                                [43.75565738832376, 5.781343238677484],
                                [43.732584595184825, 5.90120740256815],
                                [43.69416334085517, 6.036131813943927],
                                [43.76217559136371, 6.1828860082819075],
                                [43.799511976998794, 6.216709972579084],
                                [43.73636766488724, 6.356960735074889],
                                [43.76036041847219, 6.413483066219064],
                                [43.791594458434176, 6.414428052603499],
                                [43.806365977888035, 6.52476198332243],
                                [43.788950567095455, 6.636395800176685],
                            ]
                        ],
                    },
                    "attributes": {
                        "CODE_DEPT": "04",
                        "NOM_DEPT": "ALPES-DE-HAUTE-PROVENCE",
                    },
                },
                50: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            47.56910405527042,
                            -0.4478589178811479,
                            48.480174054010746,
                            0.8824911871126105,
                        ),
                        "coordinates": [
                            [
                                [47.69421364606961, 0.6144311990931551],
                                [47.71232800972911, 0.5805178732790713],
                                [47.790036219738816, 0.7126298064021259],
                                [47.839687295150355, 0.7745788175007324],
                                [47.89822684022154, 0.7598746908928177],
                                [47.94140146385974, 0.8458005593594105],
                                [48.03755441455243, 0.7974846748199685],
                                [48.10306240933593, 0.8412172317044129],
                                [48.161763238455514, 0.8824911871126105],
                                [48.194452217564375, 0.797655838494225],
                                [48.18907227443456, 0.7378268325294965],
                                [48.24858560387064, 0.6832238274745237],
                                [48.24984731425012, 0.5359730618565082],
                                [48.30780026964518, 0.48757228180388706],
                                [48.3338273937567, 0.3826045470591664],
                                [48.45163268082664, 0.36395898803578564],
                                [48.480174054010746, 0.29585999149911124],
                                [48.43555379652284, 0.11624508246972709],
                                [48.3822165318321, 0.06248837191072311],
                                [48.397313886217454, -0.0025588318946282674],
                                [48.38200345781552, -0.05453120471342586],
                                [48.36135559567944, -0.1379780943180353],
                                [48.25554245624927, -0.16309583433799862],
                                [48.20500891985258, -0.1468370673865568],
                                [48.157106805256795, -0.24992127138834272],
                                [48.10695966457705, -0.21717400338852627],
                                [48.05898535750186, -0.23094244360355798],
                                [48.04309552281351, -0.3416648270919381],
                                [47.95819180740854, -0.2826331784456301],
                                [47.930844658498074, -0.3848402809484052],
                                [47.88002461791636, -0.37067332986759677],
                                [47.83221637946878, -0.4478589178811479],
                                [47.80531865640705, -0.38820058256862927],
                                [47.76056283995014, -0.3817032700427246],
                                [47.72116575999532, -0.3340770241988634],
                                [47.707562003167396, -0.23306038777944318],
                                [47.647916580390344, -0.19315724780649807],
                                [47.632519977213676, -0.13503673265540417],
                                [47.65800746667541, -0.07183106759512606],
                                [47.6476884238069, -0.004507638464452976],
                                [47.60651520171703, 0.05165930848592362],
                                [47.58153476849178, 0.15160368312924158],
                                [47.608398291933675, 0.23000172635318478],
                                [47.56910405527042, 0.3789609617763961],
                                [47.638826411584255, 0.4566307036183553],
                                [47.656207138108634, 0.5428919700970383],
                                [47.69421364606961, 0.6144311990931551],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "72", "NOM_DEPT": "SARTHE"},
                },
                51: {
                    "geometry": {
                        "type": "MultiPolygon",
                        "bbox": (
                            47.283073725555035,
                            -3.69583851492298,
                            48.206363809489616,
                            -2.0495260703928677,
                        ),
                        "coordinates": [
                            [
                                [
                                    [47.32381750417184, -3.235445313568332],
                                    [47.283073725555035, -3.0865563158660554],
                                    [47.315134709442134, -3.093118374110733],
                                    [47.361084420864834, -3.1558608908337984],
                                    [47.37957604821457, -3.248774831164668],
                                    [47.32381750417184, -3.235445313568332],
                                ]
                            ],
                            [
                                [
                                    [47.84914685715854, -3.523004293499609],
                                    [47.78246448850765, -3.5299269866083183],
                                    [47.69534163730077, -3.452760568692728],
                                    [47.708362699566045, -3.344217792341288],
                                    [47.663420828536175, -3.208127827120786],
                                    [47.64069004036754, -3.209753080991345],
                                    [47.569508156886435, -3.1232589863704034],
                                    [47.57607169774949, -2.9751778282815953],
                                    [47.61902226485754, -2.851150732135118],
                                    [47.6191585697231, -2.7785737528565213],
                                    [47.589919045820096, -2.70195079899252],
                                    [47.542488706697725, -2.7305385199391004],
                                    [47.55297298270365, -2.8136159976601793],
                                    [47.53218358478734, -2.871566103275051],
                                    [47.487274625090585, -2.8002084412292936],
                                    [47.51863653795228, -2.664337299385736],
                                    [47.525679091444125, -2.537129650340703],
                                    [47.49623958284168, -2.441223914821732],
                                    [47.44812172073533, -2.45848916517333],
                                    [47.46446874949347, -2.31286829291468],
                                    [47.53105690026964, -2.107333643913478],
                                    [47.63135984403087, -2.097035597340287],
                                    [47.7222402621733, -2.131472084919136],
                                    [47.738560505874425, -2.0897121808782715],
                                    [47.81691739794516, -2.0495260703928677],
                                    [47.8809562899002, -2.1162985684590656],
                                    [47.91952249841039, -2.079088544973964],
                                    [47.9791168009217, -2.1368653813504155],
                                    [47.99946162799206, -2.239593524217945],
                                    [48.02636073133584, -2.2795950136703547],
                                    [48.0756278763605, -2.2332446439270166],
                                    [48.133745563473816, -2.2872784304005114],
                                    [48.122103008406654, -2.371364753161675],
                                    [48.168611326672774, -2.408904872170661],
                                    [48.157844785512516, -2.4948185697824816],
                                    [48.07041003849149, -2.5747859613043027],
                                    [48.03547931277979, -2.6311897590265936],
                                    [48.04788395292574, -2.6700509484423693],
                                    [48.11932466386193, -2.652301006956973],
                                    [48.1205797308541, -2.781951132488677],
                                    [48.199360646242376, -3.033540216127106],
                                    [48.206363809489616, -3.116373512585393],
                                    [48.15849094354359, -3.1552540693335716],
                                    [48.14001476485905, -3.27224433962783],
                                    [48.17112526547107, -3.336754735635011],
                                    [48.185746943072566, -3.564838973733329],
                                    [48.152211751235065, -3.69583851492298],
                                    [48.09349465948051, -3.695020686823406],
                                    [47.98524271313105, -3.640231533075075],
                                    [47.993098470477676, -3.5552758457516087],
                                    [47.96688978460307, -3.484812467813042],
                                    [47.954451158273805, -3.392624522513053],
                                    [47.87011455487803, -3.4034429894056735],
                                    [47.84914685715854, -3.523004293499609],
                                ]
                            ],
                        ],
                    },
                    "attributes": {"CODE_DEPT": "56", "NOM_DEPT": "MORBIHAN"},
                },
                52: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            47.95385379978459,
                            0.7621929543543107,
                            48.94105360615515,
                            1.9940847180593788,
                        ),
                        "coordinates": [
                            [
                                [48.67016796018795, 0.8148191028635925],
                                [48.582626730806226, 0.850642103767011],
                                [48.52274528507802, 0.9665513231299332],
                                [48.39900115345221, 0.9422407728065403],
                                [48.35667269476583, 0.8833710269390439],
                                [48.340427240284555, 0.7854319060188925],
                                [48.306876614025086, 0.7621929543543107],
                                [48.21071322673851, 0.8304834708324242],
                                [48.194452217564375, 0.797655838494225],
                                [48.161763238455514, 0.8824911871126105],
                                [48.10306240933593, 0.8412172317044129],
                                [48.12749350968226, 0.9973300079370282],
                                [48.08312677901136, 1.0085477409246664],
                                [48.080729125955024, 1.112233332007327],
                                [48.03911591949663, 1.121233516589401],
                                [47.968500516699756, 1.2096430686639734],
                                [47.95385379978459, 1.3086281518302278],
                                [47.98227847700271, 1.5201238283340488],
                                [48.02872178085822, 1.512975755811939],
                                [48.03069992075931, 1.5941156652809596],
                                [48.06722274292945, 1.6245928719693987],
                                [48.066144349606105, 1.7448338583126362],
                                [48.08385719873065, 1.8656712589157682],
                                [48.2554662453119, 1.9654790051841269],
                                [48.28658587795804, 1.9940847180593788],
                                [48.39938447447992, 1.9765777946992387],
                                [48.40412484182912, 1.9305557503485924],
                                [48.45760028606413, 1.9221489648373704],
                                [48.46608795961456, 1.8014458379190346],
                                [48.56937104099975, 1.7653297161980415],
                                [48.57802434626237, 1.70925278746701],
                                [48.663769109280636, 1.6024984234215411],
                                [48.70181187348942, 1.5795458299182847],
                                [48.814869639400584, 1.5912030850964909],
                                [48.89157660948184, 1.5572502545823868],
                                [48.94105360615515, 1.5015238197988665],
                                [48.89221734449297, 1.4683503712150041],
                                [48.83417900337295, 1.3621810029001882],
                                [48.79176905228099, 1.376964009060968],
                                [48.760965095552265, 1.319548414059536],
                                [48.77263016325768, 1.184730602501536],
                                [48.7305834560073, 1.0316566693561058],
                                [48.7154924458169, 0.8767072376479725],
                                [48.67016796018795, 0.8148191028635925],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "28", "NOM_DEPT": "EURE-ET-LOIR"},
                },
                53: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            41.368214489339856,
                            8.570335354249014,
                            42.38140571205032,
                            9.407323413987857,
                        ),
                        "coordinates": [
                            [
                                [41.85869824227228, 9.40226832441199],
                                [41.83681486608311, 9.329200877550077],
                                [41.85558903234784, 9.227497390904743],
                                [42.027596960539064, 9.22108402465599],
                                [42.026017143380564, 9.160818391906192],
                                [42.10777443178612, 9.119729450195367],
                                [42.13021371520013, 9.072186891776042],
                                [42.20692343140828, 9.04565931380628],
                                [42.253859280700944, 8.904766989145308],
                                [42.31755804188288, 8.819561377056068],
                                [42.37343635383299, 8.640801666424288],
                                [42.38140571205032, 8.573411068108614],
                                [42.2635239717512, 8.689105710448827],
                                [42.25545987316995, 8.616716018939046],
                                [42.230300263764974, 8.570335354249014],
                                [42.16388769237883, 8.590170524060467],
                                [42.10358657526462, 8.6605051108979],
                                [42.09582422568564, 8.710256944399482],
                                [42.04090929509705, 8.741332481964944],
                                [42.00934596433832, 8.65641983419225],
                                [41.982430657214024, 8.668873449917276],
                                [41.95324306386643, 8.59769539752256],
                                [41.909889114859915, 8.64145251301252],
                                [41.90925797590218, 8.72143021896541],
                                [41.93256867906004, 8.754903133430055],
                                [41.89138353772895, 8.803137234079097],
                                [41.811239551074216, 8.771293565923227],
                                [41.74700226740522, 8.684518163125169],
                                [41.722771268016935, 8.717235397872976],
                                [41.68972719719775, 8.914509146058743],
                                [41.652450901524396, 8.877266064638949],
                                [41.6295527238139, 8.79307422195644],
                                [41.55773356360863, 8.788528375117988],
                                [41.54654924536304, 8.841680682750065],
                                [41.48966696643905, 8.938397598811326],
                                [41.44197767283875, 9.08219781219703],
                                [41.41243171053319, 9.095532004302171],
                                [41.368214489339856, 9.219681605069646],
                                [41.42530280266712, 9.228899383902926],
                                [41.46599484844721, 9.265877253287044],
                                [41.530225532118976, 9.287551136639264],
                                [41.55924531057785, 9.340900099192767],
                                [41.616359707091576, 9.327204087148893],
                                [41.657362352253315, 9.387496558130868],
                                [41.76763912659151, 9.407323413987857],
                                [41.85869824227228, 9.40226832441199],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "2A", "NOM_DEPT": "CORSE-DU-SUD"},
                },
                54: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            48.34989070446764,
                            5.461779526865533,
                            49.55287086489331,
                            7.123165369028565,
                        ),
                        "coordinates": [
                            [
                                [49.49720502129503, 5.470910130592771],
                                [49.45269148819386, 5.461779526865533],
                                [49.40737462726647, 5.529099312496953],
                                [49.43743606551584, 5.634565984546508],
                                [49.41510555457393, 5.688147604064061],
                                [49.311343191085655, 5.731786006583375],
                                [49.21598694642171, 5.719044394768754],
                                [49.198088628043735, 5.765544232834612],
                                [49.15659587123615, 5.744467916779598],
                                [49.10787996559759, 5.763360758388861],
                                [49.08617366650139, 5.818638375145698],
                                [49.02310661815185, 5.823066740236896],
                                [48.9467460575909, 5.800245290300757],
                                [48.915257872637035, 5.747161790828688],
                                [48.826749431285386, 5.780971762726475],
                                [48.744533308856504, 5.714036349479591],
                                [48.695698334229284, 5.7577093395619],
                                [48.60939047859851, 5.7617670452603855],
                                [48.56142416981741, 5.71608982178375],
                                [48.54035925156704, 5.7762118887724645],
                                [48.49649260851312, 5.765154701602299],
                                [48.50684438558553, 5.856069666360071],
                                [48.34989070446764, 5.961559100039156],
                                [48.35403844099854, 6.116723785728533],
                                [48.397598877997915, 6.178419125638965],
                                [48.419031847017656, 6.56697422886565],
                                [48.46050916362014, 6.584971476704244],
                                [48.41308754075586, 6.6994983396482075],
                                [48.39884620056533, 6.815166528707747],
                                [48.4180943151424, 6.890810652427116],
                                [48.47905957978557, 6.9829860045628855],
                                [48.51359226555661, 7.123165369028565],
                                [48.536417612700156, 7.079359770973246],
                                [48.61186293045215, 6.982882241286179],
                                [48.62597500455583, 6.844053536871702],
                                [48.66938665042789, 6.75467285145004],
                                [48.672840395381456, 6.6922838813846575],
                                [48.7080472862827, 6.658407329856351],
                                [48.71569079778236, 6.598965570952483],
                                [48.75409250995719, 6.554148775117042],
                                [48.78165892451309, 6.35503013356845],
                                [48.834058199828384, 6.338947107825573],
                                [48.9331355970772, 6.271977767337417],
                                [48.93472094774055, 6.132207146051102],
                                [48.967833205844386, 6.116898532084446],
                                [48.977477915970994, 6.043435324319259],
                                [49.01041872049325, 6.044996956010202],
                                [49.07185221973813, 5.935399690626695],
                                [49.10910433832356, 5.931603285178869],
                                [49.165118935990016, 6.0261499402444025],
                                [49.20961691713356, 5.987627297222747],
                                [49.23047199221416, 6.029385386695151],
                                [49.37550729349813, 5.928530586493157],
                                [49.45289553695899, 5.942619950432162],
                                [49.49690975011092, 5.893401083719673],
                                [49.55124020373497, 5.793930405166045],
                                [49.53933978552671, 5.715278934594514],
                                [49.55287086489331, 5.659768488051475],
                                [49.49720502129503, 5.470910130592771],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "54", "NOM_DEPT": "MEURTHE-ET-MOSELLE"},
                },
                55: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            48.18907227443456,
                            -0.8603629154348689,
                            48.96474519879868,
                            0.9665513231299332,
                        ),
                        "coordinates": [
                            [
                                [48.95062636769437, 0.4128145328890876],
                                [48.942883562782185, 0.3337726147565274],
                                [48.96474519879868, 0.2756400197144897],
                                [48.924787583562484, 0.1564748700538276],
                                [48.95221907078784, 0.12760760912750208],
                                [48.90246403865731, 0.05639799250068904],
                                [48.85358688783118, -0.05880746358844414],
                                [48.83444909949477, -0.14634308820607572],
                                [48.858307152999124, -0.30592108673909135],
                                [48.821999140746335, -0.3462445710154047],
                                [48.87014004741071, -0.41151869249428463],
                                [48.87136647587905, -0.4637527288822026],
                                [48.79986774271756, -0.7146786118899515],
                                [48.75222016383323, -0.8409353560137922],
                                [48.710188837806285, -0.7989559815697868],
                                [48.617618520532695, -0.7526143435139804],
                                [48.56267832832824, -0.7741715461672727],
                                [48.501458496522545, -0.8603629154348689],
                                [48.43655146991278, -0.7572811397545346],
                                [48.44428211569599, -0.6539938321279792],
                                [48.473117087352556, -0.5517177835994801],
                                [48.50579601256293, -0.5050654278707298],
                                [48.51181992419309, -0.43075405116636184],
                                [48.492944315128234, -0.3676233888648996],
                                [48.506988913211536, -0.2782279440483014],
                                [48.56294475916397, -0.20693829348513745],
                                [48.53697035216617, -0.16938268000563395],
                                [48.45806753461724, -0.14871347253945932],
                                [48.4532597698412, -0.051896256193192866],
                                [48.38200345781552, -0.05453120471342586],
                                [48.397313886217454, -0.0025588318946282674],
                                [48.3822165318321, 0.06248837191072311],
                                [48.43555379652284, 0.11624508246972709],
                                [48.480174054010746, 0.29585999149911124],
                                [48.45163268082664, 0.36395898803578564],
                                [48.3338273937567, 0.3826045470591664],
                                [48.30780026964518, 0.48757228180388706],
                                [48.24984731425012, 0.5359730618565082],
                                [48.24858560387064, 0.6832238274745237],
                                [48.18907227443456, 0.7378268325294965],
                                [48.194452217564375, 0.797655838494225],
                                [48.21071322673851, 0.8304834708324242],
                                [48.306876614025086, 0.7621929543543107],
                                [48.340427240284555, 0.7854319060188925],
                                [48.35667269476583, 0.8833710269390439],
                                [48.39900115345221, 0.9422407728065403],
                                [48.52274528507802, 0.9665513231299332],
                                [48.582626730806226, 0.850642103767011],
                                [48.67016796018795, 0.8148191028635925],
                                [48.7052077986587, 0.7305886446296774],
                                [48.73752726458569, 0.7749590431141294],
                                [48.78336423502616, 0.7335062460350473],
                                [48.83131414903287, 0.6102938086141846],
                                [48.875537831571705, 0.5525030083730612],
                                [48.87976248181588, 0.4573579962478969],
                                [48.91041450585283, 0.3861893489650419],
                                [48.95062636769437, 0.4128145328890876],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "61", "NOM_DEPT": "ORNE"},
                },
                56: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            45.613268326764185,
                            4.729096921230878,
                            46.51719845218087,
                            6.169741660312735,
                        ),
                        "coordinates": [
                            [
                                [46.44676642071987, 5.310560613770375],
                                [46.468359273121585, 5.215064143095116],
                                [46.508209505159336, 5.201145108499204],
                                [46.484872844561906, 5.052374107055715],
                                [46.51719845218087, 4.940023082647429],
                                [46.43991436571944, 4.891817622919295],
                                [46.40298160185767, 4.8882077017045455],
                                [46.25992151697564, 4.810994882268941],
                                [46.17667702271938, 4.780213475718984],
                                [46.140701464361854, 4.797433206939167],
                                [46.0941499665971, 4.750325275584826],
                                [46.04720888365027, 4.739530214170903],
                                [45.97362201497272, 4.7546312797683195],
                                [45.949092212302176, 4.729096921230878],
                                [45.90461654376232, 4.8645021533563355],
                                [45.80399936996712, 4.923799133458053],
                                [45.81337808264366, 5.101067478338777],
                                [45.77168800093879, 5.191532760208243],
                                [45.78936901099018, 5.266894883868229],
                                [45.85493340191009, 5.309169396437734],
                                [45.88327273564142, 5.3538271958050325],
                                [45.8310937764943, 5.434944676804955],
                                [45.80712379566377, 5.42264142008713],
                                [45.71359345746489, 5.5455415978088505],
                                [45.613268326764185, 5.623748035268078],
                                [45.64850161239944, 5.689187102194641],
                                [45.71092632945919, 5.704119379498135],
                                [45.7292223955843, 5.7761608991802635],
                                [45.82295599649881, 5.7868562241797115],
                                [45.93845957829322, 5.831226413621036],
                                [45.98979960381867, 5.809643351753076],
                                [46.063934978382775, 5.807622444833504],
                                [46.10599585856306, 5.832300912634432],
                                [46.13208943594268, 5.956063159932634],
                                [46.23799614420533, 6.033127717153324],
                                [46.251012016472174, 6.124247271884755],
                                [46.28506396607944, 6.102638404712806],
                                [46.36793686221589, 6.169741660312735],
                                [46.416226988931534, 6.06400848181829],
                                [46.364873088758074, 5.986841317727858],
                                [46.283951620059554, 5.908938421371526],
                                [46.26206360332614, 5.849846074176259],
                                [46.260729204793954, 5.725183003095843],
                                [46.3087688477459, 5.714717731644379],
                                [46.33949103303637, 5.649339135998931],
                                [46.270201908707435, 5.542037828826235],
                                [46.265063763323475, 5.473055311573813],
                                [46.31511297122548, 5.437795113853318],
                                [46.35223630468514, 5.3734622886202095],
                                [46.38135905559832, 5.377044586181938],
                                [46.41681731886722, 5.307691028342544],
                                [46.44676642071987, 5.310560613770375],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "01", "NOM_DEPT": "AIN"},
                },
                57: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            42.57362343207788,
                            0.8324133769327755,
                            43.31560605476546,
                            2.1758741195218594,
                        ),
                        "coordinates": [
                            [
                                [42.825719089084465, 0.8583056667230169],
                                [42.78926022063215, 0.9273318147672919],
                                [42.78535096062724, 1.0751084975718934],
                                [42.71104632984594, 1.161848153380758],
                                [42.72758608076071, 1.2302117813358218],
                                [42.72390397060217, 1.32502612790918],
                                [42.68508287715745, 1.3895996264494757],
                                [42.60607634725255, 1.4350544962266247],
                                [42.65577628584985, 1.5492483438086206],
                                [42.62803932707508, 1.601470136798133],
                                [42.623904127991494, 1.6873586751619762],
                                [42.57362343207788, 1.7861250110638964],
                                [42.58140598425563, 1.8744850028357225],
                                [42.61692049379412, 1.9717596461471245],
                                [42.66156483553937, 2.0005149149001973],
                                [42.66391836976527, 2.166053682054993],
                                [42.6827952243106, 2.1758741195218594],
                                [42.7562228612599, 2.057204243184995],
                                [42.73670079860314, 1.9553956635295406],
                                [42.767667043480046, 1.9081798281291227],
                                [42.852669269026464, 1.8804739886198156],
                                [42.87101168756058, 1.986920914223352],
                                [43.02627232234234, 1.9851004481943353],
                                [43.052715472626694, 1.941132873290632],
                                [43.119494438163784, 1.9494758652019246],
                                [43.14581388915534, 1.824772198868932],
                                [43.18969803410896, 1.710056447799201],
                                [43.224524250769015, 1.723844068753025],
                                [43.27355372810048, 1.688419720914751],
                                [43.25511535449163, 1.6372035311274424],
                                [43.27567426925569, 1.54752004958837],
                                [43.21060079806052, 1.4637105789844813],
                                [43.25657153586671, 1.4253606535844832],
                                [43.31560605476546, 1.3436519696346765],
                                [43.28533747712757, 1.2933102990704717],
                                [43.21374576570539, 1.3743734334754005],
                                [43.18999472443669, 1.3146078107375299],
                                [43.18389310581045, 1.2274806300813899],
                                [43.117951050809886, 1.2087344680123449],
                                [43.156907404761775, 1.1240820844542168],
                                [43.14182620134684, 1.058912548014145],
                                [43.100552820032235, 1.038835682734409],
                                [43.06705628157321, 0.9851687313481592],
                                [43.007591006439135, 1.0070461604480825],
                                [42.97443096191435, 0.9791013887263268],
                                [42.95777574631528, 0.8749113719387418],
                                [42.91998800205083, 0.8324133769327755],
                                [42.825719089084465, 0.8583056667230169],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "09", "NOM_DEPT": "ARIEGE"},
                },
                58: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            44.927682448456935,
                            1.2271194403372108,
                            45.755490360800245,
                            2.5283647797478266,
                        ),
                        "coordinates": [
                            [
                                [45.44421907802482, 1.2531518386328937],
                                [45.39834890279047, 1.2596039598397968],
                                [45.382659361364226, 1.3227969726587205],
                                [45.27197997099894, 1.2271194403372108],
                                [45.24208241912198, 1.2774962889939248],
                                [45.140188825629004, 1.2965184989870575],
                                [45.10288137852398, 1.3864424774272137],
                                [45.019313158674045, 1.4482615439322115],
                                [45.04628038727667, 1.5357253751118864],
                                [45.02501608647879, 1.650983768334641],
                                [44.95495947953578, 1.7506251087427582],
                                [44.927682448456935, 1.8239145263410463],
                                [44.978426771844674, 1.908156162007897],
                                [44.97650640551561, 2.062914291973062],
                                [44.98552052019745, 2.1329789677394575],
                                [45.05602988503954, 2.09515947189117],
                                [45.081495873975626, 2.171755685373443],
                                [45.160192640152275, 2.2136969761815397],
                                [45.22085230029835, 2.195361138057307],
                                [45.29015191925762, 2.2714136874802593],
                                [45.32755821486306, 2.350479440865637],
                                [45.41430579076644, 2.378246243484016],
                                [45.384258469857066, 2.4418608930121475],
                                [45.41883841080893, 2.4874679068775096],
                                [45.47849879874484, 2.508408697113082],
                                [45.553426613923115, 2.516332317304299],
                                [45.60082287582866, 2.46534961788347],
                                [45.639532080177666, 2.514296706686258],
                                [45.681924336473706, 2.5283647797478266],
                                [45.73767009540705, 2.4921255582417543],
                                [45.699275061444226, 2.4358558482207813],
                                [45.70947892430507, 2.3491828014700613],
                                [45.68060482956175, 2.3377545093277403],
                                [45.699047103880844, 2.1939584682323856],
                                [45.73221596168252, 2.17435335428623],
                                [45.724775065025135, 2.113545472759344],
                                [45.755490360800245, 2.01760876898307],
                                [45.6982775512041, 1.898730779182943],
                                [45.664658270083336, 1.8713480467629338],
                                [45.68036337807322, 1.7838678002323438],
                                [45.58035190912391, 1.6376634511377184],
                                [45.54936632471628, 1.5571958047036873],
                                [45.56594313830816, 1.4803697950912302],
                                [45.528081031575745, 1.412058914052018],
                                [45.46688830500579, 1.350077879284767],
                                [45.48993789201231, 1.2870567570435631],
                                [45.44421907802482, 1.2531518386328937],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "19", "NOM_DEPT": "CORREZE"},
                },
                59: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            47.42220209989122,
                            6.846179818400714,
                            48.31046786103526,
                            7.622090012011826,
                        ),
                        "coordinates": [
                            [
                                [47.82294519701528, 6.846179818400714],
                                [47.785160874502324, 6.86347551612767],
                                [47.74323273949904, 7.015960767929836],
                                [47.671501710494844, 7.046314752908177],
                                [47.61938273175802, 7.00498323142151],
                                [47.59256219967389, 7.086270201422721],
                                [47.50302658240899, 7.130345969302944],
                                [47.44718259366279, 7.173076933987583],
                                [47.42220209989122, 7.2462970616937685],
                                [47.43781547828914, 7.301734408679477],
                                [47.43552354218881, 7.403411294214607],
                                [47.49563386054373, 7.506753671499357],
                                [47.54198029495234, 7.503407577023025],
                                [47.57726432342955, 7.5847059048213925],
                                [47.60177705410426, 7.592798217753343],
                                [47.66232148986579, 7.522345790100707],
                                [47.70281805791817, 7.513752001020273],
                                [47.739586644859074, 7.548078387714247],
                                [47.786758092756166, 7.531259755609871],
                                [47.87994110575861, 7.556704620769358],
                                [47.97227315829841, 7.622090012011826],
                                [48.030379632553434, 7.571623278915895],
                                [48.12036852181815, 7.577312855212316],
                                [48.12611186664672, 7.519368638022094],
                                [48.161014524040404, 7.470560946722399],
                                [48.20353668429841, 7.476943375699941],
                                [48.24719461957464, 7.348562541549848],
                                [48.30523478706437, 7.275183721811301],
                                [48.31046786103526, 7.198281537029947],
                                [48.245940550021665, 7.133555808547299],
                                [48.13726637155602, 7.058912798901165],
                                [48.022399095831105, 7.001883743858899],
                                [47.9979579468772, 6.943356419805965],
                                [47.891191372726894, 6.900213335139268],
                                [47.850287916338935, 6.920034363859818],
                                [47.82294519701528, 6.846179818400714],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "68", "NOM_DEPT": "HAUT-RHIN"},
                },
                60: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            46.74821910504848,
                            0.05382761471070587,
                            47.69540180185664,
                            1.3653609997076237,
                        ),
                        "coordinates": [
                            [
                                [47.18622542473178, 1.3266655450453897],
                                [47.25470690394847, 1.2769082168277972],
                                [47.29408083062265, 1.2235368646048146],
                                [47.27219609172912, 1.1620645187006384],
                                [47.29839804393137, 1.1081270826014082],
                                [47.35401667090686, 1.1228353402815718],
                                [47.4113254251562, 1.1074833948523175],
                                [47.44646665748557, 1.132364189106744],
                                [47.53148801134601, 1.0452908534068046],
                                [47.56322155433421, 1.0763363652479008],
                                [47.60701157047614, 1.0333525357335167],
                                [47.632609060103235, 0.9190111731399363],
                                [47.66920726991006, 0.8595037193186874],
                                [47.69540180185664, 0.7353105618986349],
                                [47.69421364606961, 0.6144311990931551],
                                [47.656207138108634, 0.5428919700970383],
                                [47.638826411584255, 0.4566307036183553],
                                [47.56910405527042, 0.3789609617763961],
                                [47.608398291933675, 0.23000172635318478],
                                [47.54432775642862, 0.20150312551615113],
                                [47.50195329713312, 0.22010925240137172],
                                [47.424733449390715, 0.18528045906678237],
                                [47.28282475506665, 0.07897484723536188],
                                [47.16373008265527, 0.05382761471070587],
                                [47.123931948888234, 0.07637120084195193],
                                [47.12158055414751, 0.13613090268194533],
                                [47.07127519606643, 0.17422061595767882],
                                [47.0539187252087, 0.29823142261819696],
                                [46.973827658647814, 0.30073625724988373],
                                [46.92958207105905, 0.4387096602536596],
                                [46.95924736173615, 0.5061414593305557],
                                [46.95676414686082, 0.5983482495759433],
                                [47.00227037444165, 0.5669489614197056],
                                [46.97430706301783, 0.6925692823646332],
                                [46.90329335315584, 0.704324392050786],
                                [46.852391083185935, 0.7903284955617977],
                                [46.79450796471715, 0.8119017840639386],
                                [46.74821910504848, 0.8674688807081561],
                                [46.76154066839267, 0.9888132945329691],
                                [46.98064041873546, 1.0498776400419187],
                                [47.015842398188234, 1.0776154683629737],
                                [47.039622972819544, 1.1614221724181901],
                                [47.03783413818556, 1.2730568495660919],
                                [47.096975273440314, 1.311672909460613],
                                [47.12205127770917, 1.3653609997076237],
                                [47.18622542473178, 1.3266655450453897],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "37", "NOM_DEPT": "INDRE-ET-LOIRE"},
                },
                61: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            49.969187585411916,
                            2.067712027611001,
                            51.08854281218866,
                            4.227998848506977,
                        ),
                        "coordinates": [
                            [
                                [51.006505154665284, 2.067712027611001],
                                [50.998427200370195, 2.097600537080802],
                                [50.883452469254024, 2.18390456104644],
                                [50.81054861626229, 2.2134304216785434],
                                [50.74090632543495, 2.34089102647672],
                                [50.672765602799466, 2.40779242678447],
                                [50.631244941936494, 2.495948921017839],
                                [50.617951505356416, 2.630516060197486],
                                [50.63129225354633, 2.713850503520111],
                                [50.663678139297865, 2.7690409100193936],
                                [50.65656635139436, 2.8404494526472543],
                                [50.6032712281948, 2.8051660601438893],
                                [50.52538845142136, 2.8259824668620874],
                                [50.501557815660604, 2.8989518584324676],
                                [50.512778020799246, 2.9647097377674005],
                                [50.48176905740127, 3.0207925423124586],
                                [50.4416400980408, 3.037672306035308],
                                [50.379846956513916, 2.993078464231492],
                                [50.24110767125754, 3.173376482382538],
                                [50.183715151473976, 3.1561320895920617],
                                [50.12420173433414, 3.0957569207512843],
                                [50.05374055513492, 3.090253620620082],
                                [50.01199494467939, 3.1727072271768164],
                                [50.03130959186552, 3.2305405050170397],
                                [50.0151825508069, 3.2801740988851327],
                                [50.035859344668864, 3.3529820366555496],
                                [50.01885605079539, 3.4913598357111555],
                                [50.05379395526909, 3.54484649487849],
                                [50.025418579177284, 3.6136399192005855],
                                [50.069274635963545, 3.715184685025503],
                                [50.05360423497288, 3.7463798889650586],
                                [50.026430676607156, 3.923501465982155],
                                [49.99537608693849, 3.9803763118726994],
                                [49.969187585411916, 4.08712850474961],
                                [49.978759598994436, 4.140895251736092],
                                [50.04898484693675, 4.162223866832849],
                                [50.066371644106745, 4.227998848506977],
                                [50.13107752152201, 4.199886857285581],
                                [50.13501086614893, 4.126926892460069],
                                [50.202535967141905, 4.160120194753328],
                                [50.256952603046614, 4.221850100147642],
                                [50.27430028766336, 4.136656244682008],
                                [50.34294913095138, 4.037614330208127],
                                [50.35036640688852, 3.967898522087576],
                                [50.32998024472696, 3.889799951126813],
                                [50.35159288086556, 3.8527555820958135],
                                [50.350929148402, 3.747403815562772],
                                [50.31582758312017, 3.694426981658982],
                                [50.371341179601195, 3.658270970690328],
                                [50.45317465879257, 3.664218477773235],
                                [50.49246946526615, 3.613009891798258],
                                [50.53356175114644, 3.4739635628750074],
                                [50.49182493572303, 3.3738916027191275],
                                [50.527575838126204, 3.2865173191905384],
                                [50.63804120853444, 3.248509229627794],
                                [50.70064952130496, 3.2583710099316026],
                                [50.72440644616072, 3.1912194219619847],
                                [50.78234329668403, 3.1519976780893755],
                                [50.78050085123832, 3.0613770323899683],
                                [50.744341238034195, 2.938073313612885],
                                [50.69423611297018, 2.8983800599236966],
                                [50.716947630173586, 2.813275390169948],
                                [50.81360773516545, 2.7174810677545755],
                                [50.81275641876223, 2.634982733121708],
                                [50.85333434260148, 2.599594701801672],
                                [50.94600519935865, 2.6326872836805335],
                                [51.01375274755887, 2.575982419777286],
                                [51.08854281218866, 2.5430346143752027],
                                [51.05562611741315, 2.4247542826080695],
                                [51.0598323621204, 2.347839655429636],
                                [51.00382398080942, 2.1097003640363865],
                                [51.006505154665284, 2.067712027611001],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "59", "NOM_DEPT": "NORD"},
                },
                62: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            47.433373721422306,
                            6.757638483670513,
                            47.82294519701528,
                            7.130345969302944,
                        ),
                        "coordinates": [
                            [
                                [47.50302658240899, 7.130345969302944],
                                [47.59256219967389, 7.086270201422721],
                                [47.61938273175802, 7.00498323142151],
                                [47.671501710494844, 7.046314752908177],
                                [47.74323273949904, 7.015960767929836],
                                [47.785160874502324, 6.86347551612767],
                                [47.82294519701528, 6.846179818400714],
                                [47.81305372460471, 6.823538854548165],
                                [47.747877966491, 6.757638483670513],
                                [47.62526070546134, 6.780404771904787],
                                [47.56280181879927, 6.806992048333126],
                                [47.54736152102862, 6.90566962763424],
                                [47.49454608019349, 6.90760985982366],
                                [47.433373721422306, 6.940536510867674],
                                [47.452299031235334, 6.998962818675517],
                                [47.493302817356266, 6.983118836626175],
                                [47.488863995885616, 7.079276690803703],
                                [47.50302658240899, 7.130345969302944],
                            ]
                        ],
                    },
                    "attributes": {
                        "CODE_DEPT": "90",
                        "NOM_DEPT": "TERRITOIRE DE BELFORT",
                    },
                },
                63: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            46.86007983436468,
                            -2.5341025675524835,
                            47.82828080116927,
                            -0.9464433335100018,
                        ),
                        "coordinates": [
                            [
                                [47.77671754769661, -1.2458823462890545],
                                [47.797692640089586, -1.3528642478531794],
                                [47.82828080116927, -1.3904279688415837],
                                [47.77605009179812, -1.5934074072820492],
                                [47.71259280237026, -1.6548203169539613],
                                [47.69845339610199, -1.772416302356319],
                                [47.70698467056549, -1.864013339310425],
                                [47.688369032584774, -1.96905397590764],
                                [47.63135984403087, -2.097035597340287],
                                [47.53105690026964, -2.107333643913478],
                                [47.46446874949347, -2.31286829291468],
                                [47.44812172073533, -2.45848916517333],
                                [47.38296506335942, -2.5341025675524835],
                                [47.298372267525686, -2.51380537508331],
                                [47.261755657502384, -2.447540278501034],
                                [47.28144600128057, -2.398380900159916],
                                [47.236404402309375, -2.301643363345214],
                                [47.280619489541195, -2.1873645299124624],
                                [47.20905347869715, -2.1583713304619327],
                                [47.166180499018125, -2.1670644777818096],
                                [47.13094036238745, -2.226823218085358],
                                [47.09412159709028, -2.0534725301465038],
                                [47.028906494075635, -1.980414486742876],
                                [46.99471092059495, -1.9432276192598656],
                                [46.9320337241545, -1.8309821821134158],
                                [46.92959568215277, -1.7510623002403711],
                                [46.89049286319805, -1.6897612739864445],
                                [46.86007983436468, -1.5485110748777025],
                                [46.88389115282978, -1.5007668577856463],
                                [46.98150474523172, -1.5535636972370026],
                                [47.01834875737957, -1.5523222833408654],
                                [47.03786198958929, -1.4821311833973994],
                                [46.926272854355254, -1.4561316296061424],
                                [46.95218446660972, -1.3729857700949506],
                                [47.03085386698655, -1.3786124689367822],
                                [47.03948346966516, -1.2946349782361042],
                                [47.08389319899775, -1.2712067087150385],
                                [47.02954516258657, -1.1485704887534407],
                                [47.06256455498823, -1.1154625363954862],
                                [47.10995454752667, -1.2311457136088386],
                                [47.138781593624955, -1.2352482689031201],
                                [47.17778408754902, -1.1632160710080481],
                                [47.25058116645216, -1.1977216097650178],
                                [47.24985628237829, -1.2541747505718956],
                                [47.303169978196514, -1.3051085022277937],
                                [47.337623665323235, -1.2998771573086019],
                                [47.36588723515685, -1.167609698077546],
                                [47.365062263189614, -1.0178737847602033],
                                [47.38646685235786, -0.9464433335100018],
                                [47.49280029691793, -0.9674825559179046],
                                [47.51008306960625, -1.1572331855798599],
                                [47.57300754719196, -1.1724160661946539],
                                [47.56335191106952, -1.045909504072581],
                                [47.58905339489953, -1.0068639898836467],
                                [47.6194570478612, -1.1382017900650407],
                                [47.694565013846024, -1.1749295691501485],
                                [47.73364175152332, -1.2545772523262662],
                                [47.77671754769661, -1.2458823462890545],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "44", "NOM_DEPT": "LOIRE-ATLANTIQUE"},
                },
                64: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            47.33271278537438,
                            2.8566660682192713,
                            48.39027303882033,
                            4.332471702607339,
                        ),
                        "coordinates": [
                            [
                                [47.56942879711256, 2.9765380120036067],
                                [47.558752776952176, 3.0256381393798466],
                                [47.58795617120515, 3.10199661377424],
                                [47.54104902333151, 3.122046633548593],
                                [47.522966343586994, 3.2046491761957805],
                                [47.48917911094721, 3.2354769572493565],
                                [47.49471952596052, 3.307051239784071],
                                [47.472438113851204, 3.3463147218972584],
                                [47.50886749595519, 3.3972880002653882],
                                [47.49392259510354, 3.487879079980051],
                                [47.52766801375831, 3.5135049928892266],
                                [47.497863236330566, 3.5806168100615214],
                                [47.46490071650613, 3.580113356556516],
                                [47.44553367789057, 3.6789914842274665],
                                [47.40683466664035, 3.7147823454353084],
                                [47.39054233152028, 3.7856341851420217],
                                [47.37831443829053, 3.9706779602609212],
                                [47.33271278537438, 3.9730845789314024],
                                [47.339255985508245, 4.106085850126875],
                                [47.40725128721285, 4.066060118363545],
                                [47.443553393328095, 4.119426533664949],
                                [47.515008579609535, 4.11550026231875],
                                [47.55325916322948, 4.17512808182493],
                                [47.62796570433963, 4.212381292101606],
                                [47.6814099239688, 4.268422869492534],
                                [47.72740297086132, 4.258164266526501],
                                [47.756511310408264, 4.332471702607339],
                                [47.84715746363821, 4.324394417243652],
                                [47.84385063868304, 4.2610008241447535],
                                [47.9256762348538, 4.2934241069450065],
                                [47.9699414025263, 4.199158053352666],
                                [47.92699565753336, 4.1117857473984065],
                                [47.93917007405483, 3.9020865465480417],
                                [47.98379240722837, 3.850029315571996],
                                [48.10254956016531, 3.8049683849961107],
                                [48.169707832950834, 3.740291245795231],
                                [48.13921190362741, 3.667869602845747],
                                [48.225740470572546, 3.6216038851697063],
                                [48.27133989892487, 3.6168043332338455],
                                [48.36909719472573, 3.4981527640993844],
                                [48.39027303882033, 3.4147915595010967],
                                [48.37228068710627, 3.3651592673815314],
                                [48.371860839526576, 3.167737573570585],
                                [48.36012035556558, 3.0495188960927044],
                                [48.27202235762727, 3.043627253848888],
                                [48.20767000036061, 3.0051556578134635],
                                [48.16339174416305, 2.936314411640624],
                                [48.13320717201307, 3.0294654865478936],
                                [48.07233413114024, 3.0504714242752176],
                                [48.05393639482612, 3.0883177986514796],
                                [47.97097324036121, 3.1284501214452565],
                                [47.911447449150096, 3.0501042789379826],
                                [47.90471697202148, 3.0102926272319244],
                                [47.786554679015424, 3.023798094359226],
                                [47.7632462761762, 2.9350577707343026],
                                [47.7609264707902, 2.8566660682192713],
                                [47.71199289202637, 2.8585180302225814],
                                [47.68055969848399, 2.9231098081748264],
                                [47.598884707750464, 2.937999037836789],
                                [47.56942879711256, 2.9765380120036067],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "89", "NOM_DEPT": "YONNE"},
                },
                65: {
                    "geometry": {
                        "type": "MultiPolygon",
                        "bbox": (
                            47.63135984403087,
                            -2.2872784304005114,
                            48.70485450481566,
                            -1.021261028476561,
                        ),
                        "coordinates": [
                            [
                                [
                                    [48.56611290198357, -2.006894935706843],
                                    [48.63697592731957, -2.0486879074738535],
                                    [48.6044100285603, -2.1237080247752895],
                                    [48.56767919673737, -2.075983866873217],
                                    [48.56611290198357, -2.006894935706843],
                                ]
                            ],
                            [
                                [
                                    [48.50849381419033, -1.0701645143702043],
                                    [48.54220594454137, -1.206555726308375],
                                    [48.533924823055, -1.2722484935647256],
                                    [48.45828455072381, -1.3772458850979696],
                                    [48.4893748476061, -1.4899474351423645],
                                    [48.56659421958315, -1.5189153941473403],
                                    [48.62644574305228, -1.571087121326364],
                                    [48.603560368601826, -1.7641518008716617],
                                    [48.61636825056999, -1.8450734275301934],
                                    [48.64741056211108, -1.8716564802791003],
                                    [48.70485450481566, -1.8561321209072572],
                                    [48.686323125327455, -1.9698282134951834],
                                    [48.64691471298053, -2.028959676879305],
                                    [48.53880790488251, -1.9480369010443905],
                                    [48.51884141988655, -1.9124900704350776],
                                    [48.31710984530666, -1.9548327221541837],
                                    [48.27953190981902, -2.0141005291993967],
                                    [48.29832786131649, -2.0532925486538494],
                                    [48.252903482093345, -2.110118931164647],
                                    [48.2463785700459, -2.186961247227295],
                                    [48.1705970187894, -2.2247373292770836],
                                    [48.133745563473816, -2.2872784304005114],
                                    [48.0756278763605, -2.2332446439270166],
                                    [48.02636073133584, -2.2795950136703547],
                                    [47.99946162799206, -2.239593524217945],
                                    [47.9791168009217, -2.1368653813504155],
                                    [47.91952249841039, -2.079088544973964],
                                    [47.8809562899002, -2.1162985684590656],
                                    [47.81691739794516, -2.0495260703928677],
                                    [47.738560505874425, -2.0897121808782715],
                                    [47.7222402621733, -2.131472084919136],
                                    [47.63135984403087, -2.097035597340287],
                                    [47.688369032584774, -1.96905397590764],
                                    [47.70698467056549, -1.864013339310425],
                                    [47.69845339610199, -1.772416302356319],
                                    [47.71259280237026, -1.6548203169539613],
                                    [47.77605009179812, -1.5934074072820492],
                                    [47.82828080116927, -1.3904279688415837],
                                    [47.797692640089586, -1.3528642478531794],
                                    [47.77671754769661, -1.2458823462890545],
                                    [47.80999146298685, -1.2382517343256687],
                                    [47.86797794678783, -1.189183999002136],
                                    [47.96582099565697, -1.1539940378788582],
                                    [47.9890627829139, -1.1026711686637327],
                                    [47.99494016249537, -1.021261028476561],
                                    [48.06891120316757, -1.0232833455698922],
                                    [48.08980493061708, -1.0496060893987509],
                                    [48.25928012122702, -1.1000610480389654],
                                    [48.327727830000974, -1.0450195299623035],
                                    [48.433058231677805, -1.0827940655347785],
                                    [48.50849381419033, -1.0701645143702043],
                                ]
                            ],
                        ],
                    },
                    "attributes": {"CODE_DEPT": "35", "NOM_DEPT": "ILLE-ET-VILAINE"},
                },
                66: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            43.49776692584455,
                            -1.524866548422101,
                            44.53219457167761,
                            0.13510828700872374,
                        ),
                        "coordinates": [
                            [
                                [43.52970134669009, -1.524866548422101],
                                [43.539184056404956, -1.47661986699547],
                                [43.49776692584455, -1.4177740978934008],
                                [43.49820457476753, -1.2911822396099015],
                                [43.54560988391761, -1.1708199655376677],
                                [43.51412989565136, -1.1092478299389088],
                                [43.50538804684213, -0.9933935609538066],
                                [43.55048921576566, -0.896690646890469],
                                [43.56416715906682, -0.7817805196343687],
                                [43.54111406021403, -0.7153911507395111],
                                [43.566716972183386, -0.6708071861709698],
                                [43.542797175106195, -0.557174431652949],
                                [43.596089226471534, -0.4482922578476395],
                                [43.56822563862102, -0.4060419475368964],
                                [43.560276850255974, -0.3036904680467346],
                                [43.58497620901365, -0.2428365587430673],
                                [43.71408748429112, -0.23258236946731775],
                                [43.73701668569468, -0.19414330237234037],
                                [43.875183336159544, -0.19099217321599574],
                                [43.891067750109656, -0.23393876198190033],
                                [43.93791976442837, -0.1791090595179048],
                                [43.94504687607565, -0.07359844651969412],
                                [43.90018804605384, 0.032556764180923806],
                                [43.916471143129584, 0.07664688901341983],
                                [43.98314313658292, 0.07604560969926086],
                                [44.00084249917964, 0.06269801329290979],
                                [44.08677044166998, 0.10082062971801448],
                                [44.12422070347952, 0.13510828700872374],
                                [44.13065240342956, 0.03459384382220977],
                                [44.14999595086847, -0.004232390832892187],
                                [44.15240992875157, -0.12915451548994528],
                                [44.226404747689884, -0.1406884798527587],
                                [44.26904045949535, -0.19411335198198051],
                                [44.205898263801814, -0.22344709828329445],
                                [44.193809246235574, -0.27211852903661166],
                                [44.20948462715674, -0.3896173620609178],
                                [44.286310667736586, -0.38338729038705555],
                                [44.32257705443087, -0.4318395413151788],
                                [44.33911112646834, -0.5176354697700617],
                                [44.36465404326284, -0.5281031072972922],
                                [44.39814566253359, -0.6276476111842939],
                                [44.443192240874566, -0.6287774027434528],
                                [44.446374662072536, -0.7307029568976181],
                                [44.418974549624615, -0.8452736279017063],
                                [44.443344362596, -0.9191704541834174],
                                [44.43765239133863, -1.0074534242441238],
                                [44.48287893553745, -0.980696991457649],
                                [44.53219457167761, -1.0851664955491256],
                                [44.502772891337074, -1.1064909647292627],
                                [44.46760421234612, -1.2538901028077152],
                                [44.144802425789706, -1.3123241886692387],
                                [43.91378891976494, -1.374986662948486],
                                [43.710565130021784, -1.4365038283323692],
                                [43.64227785427402, -1.4482041246762156],
                                [43.52970134669009, -1.524866548422101],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "40", "NOM_DEPT": "LANDES"},
                },
                67: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            47.76827885611337,
                            -4.793344007924674,
                            48.71193803703632,
                            -3.392624522513053,
                        ),
                        "coordinates": [
                            [
                                [48.65920978066925, -3.6591438196705757],
                                [48.69406986741948, -3.6609362536487686],
                                [48.71193803703632, -3.8323800958932215],
                                [48.67033253738436, -3.8644177127525783],
                                [48.65285953016301, -3.9494602787296587],
                                [48.69903337142497, -3.9757489429755535],
                                [48.6864612279009, -4.1869356904234065],
                                [48.64958226192499, -4.2727675202883395],
                                [48.676117521154396, -4.35140810886426],
                                [48.62710227835847, -4.462762668788339],
                                [48.62380353944807, -4.561475551373931],
                                [48.57769163687087, -4.630604970514318],
                                [48.556349210517865, -4.730582004767843],
                                [48.49100463761581, -4.775473394851904],
                                [48.41623318232073, -4.793344007924674],
                                [48.37274934621913, -4.760909970272357],
                                [48.337887485223526, -4.608723907528043],
                                [48.397597431903016, -4.424948261340765],
                                [48.35361514079129, -4.441760780702188],
                                [48.34377660538751, -4.302158218411381],
                                [48.297168113923405, -4.308030328849242],
                                [48.275155727113315, -4.384499553201254],
                                [48.29166824316697, -4.423777088962566],
                                [48.28634356728925, -4.566613794720503],
                                [48.23223061158217, -4.564023813101924],
                                [48.23563035676817, -4.44836228902972],
                                [48.19144690509731, -4.301125453787076],
                                [48.1330557098113, -4.271734463109185],
                                [48.089182615732675, -4.306988535338469],
                                [48.11016030592398, -4.374400199477134],
                                [48.086471142269275, -4.48860072225349],
                                [48.07020031865326, -4.66822216968598],
                                [48.0335962657083, -4.723030433108444],
                                [47.98177439190436, -4.453570861423831],
                                [47.889262907304456, -4.362572451765147],
                                [47.795743686186675, -4.362418521201161],
                                [47.79738016645033, -4.192310067833886],
                                [47.8491851080577, -4.163559448578029],
                                [47.86652658516891, -4.077726475728436],
                                [47.845999453357926, -4.041588845349637],
                                [47.87028016364018, -3.9115007019573915],
                                [47.83593985815636, -3.9024761254088056],
                                [47.78763239458594, -3.8006004190720057],
                                [47.802926739002665, -3.7325436278241773],
                                [47.77678956846733, -3.6808401232958063],
                                [47.76827885611337, -3.5323088913488188],
                                [47.84914685715854, -3.523004293499609],
                                [47.87011455487803, -3.4034429894056735],
                                [47.954451158273805, -3.392624522513053],
                                [47.96688978460307, -3.484812467813042],
                                [47.993098470477676, -3.5552758457516087],
                                [47.98524271313105, -3.640231533075075],
                                [48.09349465948051, -3.695020686823406],
                                [48.152211751235065, -3.69583851492298],
                                [48.185746943072566, -3.564838973733329],
                                [48.2822731470352, -3.518440717872892],
                                [48.33551998786712, -3.5567868257426127],
                                [48.37776678483146, -3.5545842830629764],
                                [48.42892323446267, -3.590415422993112],
                                [48.49643946876788, -3.604061396321586],
                                [48.54092077173928, -3.5538598863227393],
                                [48.610153346220144, -3.6493779946144103],
                                [48.65920978066925, -3.6591438196705757],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "29", "NOM_DEPT": "FINISTERE"},
                },
                68: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            45.685404763162595,
                            5.807622444833504,
                            46.40755389780494,
                            7.043893795018055,
                        ),
                        "coordinates": [
                            [
                                [45.77837197402194, 6.802516663522653],
                                [45.83497696816749, 6.818078636732782],
                                [45.84673210642239, 6.9396049391538215],
                                [45.86819987209144, 6.991719912014907],
                                [45.92208520277858, 7.043893795018055],
                                [45.98418643361579, 7.018245614212891],
                                [46.04995609942394, 6.951511564566568],
                                [46.08449157208839, 6.891454223590301],
                                [46.12256207039407, 6.898381393099359],
                                [46.1296964613652, 6.814732162900611],
                                [46.20434524954355, 6.80366083421475],
                                [46.282990769883504, 6.864509851829648],
                                [46.33688407311203, 6.78263705608952],
                                [46.39309255862677, 6.7956649275692085],
                                [46.40755389780494, 6.722868985320351],
                                [46.39472735936455, 6.545175304790927],
                                [46.340165634060874, 6.390036156687233],
                                [46.37112568338626, 6.3269978517135375],
                                [46.3510944327135, 6.279911924662279],
                                [46.27733425851669, 6.237797813525851],
                                [46.22605896768258, 6.295655645057158],
                                [46.20547030935733, 6.232071540724357],
                                [46.158149899601675, 6.175072377878082],
                                [46.13208943594268, 5.956063159932634],
                                [46.10599585856306, 5.832300912634432],
                                [46.063934978382775, 5.807622444833504],
                                [45.98979960381867, 5.809643351753076],
                                [45.93845957829322, 5.831226413621036],
                                [45.93240229486182, 5.862101395990038],
                                [45.838095558126746, 5.873426502484641],
                                [45.804140838702274, 5.913209603821917],
                                [45.739095951312514, 6.042939005987318],
                                [45.75571563232778, 6.166233910329839],
                                [45.704161749692204, 6.18971416977487],
                                [45.685404763162595, 6.239679907775353],
                                [45.69553113948381, 6.330635270345084],
                                [45.778055295582206, 6.383851558657904],
                                [45.80244240743692, 6.423672125473556],
                                [45.884692297393386, 6.470559679970141],
                                [45.90863287329888, 6.509087472467454],
                                [45.82687986970036, 6.552237633503553],
                                [45.795419923318136, 6.60173297249558],
                                [45.79890547186772, 6.661192099251397],
                                [45.72291967208872, 6.711938518958689],
                                [45.77837197402194, 6.802516663522653],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "74", "NOM_DEPT": "HAUTE-SAVOIE"},
                },
                69: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            49.06044982525112,
                            1.689575882111812,
                            49.75830750106765,
                            3.1605832452848968,
                        ),
                        "coordinates": [
                            [
                                [49.232201775163404, 1.7043642065965865],
                                [49.180155278024564, 1.742137397998168],
                                [49.18525912523885, 1.7954686863275515],
                                [49.16263786454188, 1.8852389528169067],
                                [49.17644980799869, 1.9968226136719944],
                                [49.20977574824026, 2.0808878042448358],
                                [49.15288152246086, 2.252488213818398],
                                [49.18640655833579, 2.3109290446865427],
                                [49.16181582456364, 2.3462570508145517],
                                [49.14580320714456, 2.4409026178736455],
                                [49.07965484673244, 2.5905242793946224],
                                [49.10837621896304, 2.633272965218076],
                                [49.06044982525112, 2.7350126834936956],
                                [49.09151015780461, 3.0085155429257675],
                                [49.117554218816146, 3.071884293834167],
                                [49.152576953634764, 3.1396578896700365],
                                [49.19273857569733, 3.0640875194145396],
                                [49.27553205719088, 3.0268878942941857],
                                [49.302338848225304, 2.97439031593416],
                                [49.37711907478125, 3.0953874973379834],
                                [49.43374686813427, 3.0937834703774705],
                                [49.451589762665364, 3.1605832452848968],
                                [49.51340305901281, 3.0957783548212805],
                                [49.543377651791836, 3.1314803354793224],
                                [49.656683091231635, 3.09777622468101],
                                [49.705968560150744, 3.1184031553047866],
                                [49.702672388966874, 2.915712813038834],
                                [49.65595422263167, 2.7936124229581845],
                                [49.6205860518149, 2.7994949073615056],
                                [49.625601863474394, 2.6891419821315017],
                                [49.58141197178742, 2.670723151725744],
                                [49.59708062701417, 2.571493337841171],
                                [49.639467268909165, 2.5047488992503943],
                                [49.65626624025836, 2.373145663229162],
                                [49.70164087681329, 2.247168590692668],
                                [49.68807409174484, 2.1214097069260887],
                                [49.71962996348948, 1.9332098221662726],
                                [49.69898823076107, 1.8938643249004958],
                                [49.75830750106765, 1.7838370588623413],
                                [49.69478564626097, 1.689575882111812],
                                [49.67263435960493, 1.7252046142437356],
                                [49.60539892585883, 1.7045819685135704],
                                [49.531737693641695, 1.7451334451250167],
                                [49.50822302010687, 1.7192326604453183],
                                [49.466150363724154, 1.7663450271414043],
                                [49.409224988863485, 1.7139375433100608],
                                [49.368149815393046, 1.759411755988114],
                                [49.2996937213467, 1.775628840636083],
                                [49.26446416218004, 1.7104793339744566],
                                [49.232201775163404, 1.7043642065965865],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "60", "NOM_DEPT": "OISE"},
                },
                70: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            48.90867932989047,
                            1.6087960706299216,
                            49.232201775163404,
                            2.5905242793946224,
                        ),
                        "coordinates": [
                            [
                                [49.07789415353795, 1.6087960706299216],
                                [49.0781511731843, 1.6736891270071166],
                                [49.04497657550693, 1.7234571618642331],
                                [49.07636122204013, 1.8239503630063805],
                                [49.021776326372276, 1.9378021652564323],
                                [48.998755806188655, 2.0247730444607903],
                                [49.01467871491032, 2.084914920835882],
                                [48.94974074221645, 2.20585834678071],
                                [48.90867932989047, 2.2005910092695036],
                                [48.95096678807721, 2.2909735732251613],
                                [48.97417666856734, 2.3664436276371537],
                                [48.95504632683333, 2.4594899596115933],
                                [49.00981711743891, 2.55306064485419],
                                [49.07965484673244, 2.5905242793946224],
                                [49.14580320714456, 2.4409026178736455],
                                [49.16181582456364, 2.3462570508145517],
                                [49.18640655833579, 2.3109290446865427],
                                [49.15288152246086, 2.252488213818398],
                                [49.20977574824026, 2.0808878042448358],
                                [49.17644980799869, 1.9968226136719944],
                                [49.16263786454188, 1.8852389528169067],
                                [49.18525912523885, 1.7954686863275515],
                                [49.180155278024564, 1.742137397998168],
                                [49.232201775163404, 1.7043642065965865],
                                [49.211867057756656, 1.6757368125175731],
                                [49.13016217033745, 1.655777439712795],
                                [49.07789415353795, 1.6087960706299216],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "95", "NOM_DEPT": "VAL-D'OISE"},
                },
                71: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            46.658252554713975,
                            2.8734906167112504,
                            47.58795617120515,
                            4.230655226496764,
                        ),
                        "coordinates": [
                            [
                                [47.339255985508245, 4.106085850126875],
                                [47.33271278537438, 3.9730845789314024],
                                [47.37831443829053, 3.9706779602609212],
                                [47.39054233152028, 3.7856341851420217],
                                [47.40683466664035, 3.7147823454353084],
                                [47.44553367789057, 3.6789914842274665],
                                [47.46490071650613, 3.580113356556516],
                                [47.497863236330566, 3.5806168100615214],
                                [47.52766801375831, 3.5135049928892266],
                                [47.49392259510354, 3.487879079980051],
                                [47.50886749595519, 3.3972880002653882],
                                [47.472438113851204, 3.3463147218972584],
                                [47.49471952596052, 3.307051239784071],
                                [47.48917911094721, 3.2354769572493565],
                                [47.522966343586994, 3.2046491761957805],
                                [47.54104902333151, 3.122046633548593],
                                [47.58795617120515, 3.10199661377424],
                                [47.558752776952176, 3.0256381393798466],
                                [47.56942879711256, 2.9765380120036067],
                                [47.565970182735235, 2.914297452553034],
                                [47.520423112556664, 2.8746252064056805],
                                [47.444566735803356, 2.928902314704163],
                                [47.34839595883525, 2.8734906167112504],
                                [47.25976318039041, 2.9834041014118906],
                                [47.221996957251605, 2.9816846477683376],
                                [47.129067685143006, 3.0280852399597813],
                                [47.06261687352467, 3.0232152406674615],
                                [47.01914457943622, 3.0757376737966906],
                                [46.955118753700106, 3.0793297925031697],
                                [46.91063036589821, 3.0502941730720203],
                                [46.87767673133036, 3.0680947893123323],
                                [46.794911188525944, 3.0320681893946824],
                                [46.75807894189367, 3.049065356287102],
                                [46.68289184476867, 3.2155498733945853],
                                [46.71674092868996, 3.2697920192933188],
                                [46.684416345410895, 3.3467088070518343],
                                [46.711906067614386, 3.4341330414396496],
                                [46.658252554713975, 3.487153284024355],
                                [46.7158646720816, 3.550392218815862],
                                [46.74945902193753, 3.629423683496518],
                                [46.75247120098577, 3.73619002089105],
                                [46.701502637145154, 3.797329518692337],
                                [46.73887265980929, 3.9233937335663813],
                                [46.7767510975447, 3.9919591863262944],
                                [46.789364691282145, 4.062709832615211],
                                [46.84327237673586, 4.056234450174584],
                                [46.87473433322919, 4.093851364443379],
                                [46.918155606841836, 4.037221978317054],
                                [46.98511001230654, 4.039401951235417],
                                [47.05449482938563, 4.072015136934213],
                                [47.080010034285166, 4.038726355028209],
                                [47.12104166410018, 4.06142733788571],
                                [47.12333757652633, 4.1159670699158095],
                                [47.15050513981915, 4.181888404407953],
                                [47.15541168354447, 4.209834279044644],
                                [47.19895127921225, 4.230655226496764],
                                [47.25028786310221, 4.1780522851486825],
                                [47.237396324140384, 4.135479914723283],
                                [47.339255985508245, 4.106085850126875],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "58", "NOM_DEPT": "NIEVRE"},
                },
                72: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            46.919374625937934,
                            4.066060118363545,
                            48.02946360188034,
                            5.518538729512594,
                        ),
                        "coordinates": [
                            [
                                [46.9798880946405, 5.255236339191406],
                                [47.0180208967574, 5.310049747453535],
                                [47.07298220144243, 5.322186205925132],
                                [47.081977110214815, 5.386011880946295],
                                [47.144397191390595, 5.439973300314684],
                                [47.21602767128051, 5.47662851608292],
                                [47.289347470334135, 5.488282961724511],
                                [47.30418661946959, 5.518538729512594],
                                [47.384062513467185, 5.451397515008267],
                                [47.49901446301563, 5.3992024955272315],
                                [47.496253655362196, 5.447063511552309],
                                [47.54414450478295, 5.496859255517604],
                                [47.60872207291229, 5.477547427463133],
                                [47.63211377458532, 5.425863186006296],
                                [47.60454165280248, 5.374078595885573],
                                [47.61613009899267, 5.239232274239111],
                                [47.65256871238262, 5.173597037303847],
                                [47.64968494441666, 5.108878229414663],
                                [47.68776283651174, 4.979107142832904],
                                [47.76500253040028, 4.949610301299183],
                                [47.80034738345194, 4.982400768988487],
                                [47.866768148099496, 4.9540942495981195],
                                [47.956238623224316, 4.852043179350452],
                                [47.9642022255857, 4.78651260287447],
                                [48.00782938257308, 4.789083695644797],
                                [48.0202323762219, 4.704238250439468],
                                [48.02946360188034, 4.582678644289108],
                                [47.97142319627392, 4.5599688756782095],
                                [47.95715474758692, 4.448998378066956],
                                [47.961173282793276, 4.309003616780037],
                                [47.9256762348538, 4.2934241069450065],
                                [47.84385063868304, 4.2610008241447535],
                                [47.84715746363821, 4.324394417243652],
                                [47.756511310408264, 4.332471702607339],
                                [47.72740297086132, 4.258164266526501],
                                [47.6814099239688, 4.268422869492534],
                                [47.62796570433963, 4.212381292101606],
                                [47.55325916322948, 4.17512808182493],
                                [47.515008579609535, 4.11550026231875],
                                [47.443553393328095, 4.119426533664949],
                                [47.40725128721285, 4.066060118363545],
                                [47.339255985508245, 4.106085850126875],
                                [47.237396324140384, 4.135479914723283],
                                [47.25028786310221, 4.1780522851486825],
                                [47.19895127921225, 4.230655226496764],
                                [47.15541168354447, 4.209834279044644],
                                [47.11432625058055, 4.259600310936345],
                                [47.08164281958383, 4.405487083945717],
                                [47.049999892555, 4.406283415170733],
                                [47.028371557104066, 4.493691403385164],
                                [46.94082023678555, 4.623230215613321],
                                [46.919374625937934, 4.728129651701318],
                                [46.98158693341567, 5.049303736126251],
                                [46.95576520247547, 5.106281375832608],
                                [46.9798880946405, 5.255236339191406],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "21", "NOM_DEPT": "COTE-D'OR"},
                },
                73: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            48.28658587795804,
                            1.9221489648373704,
                            48.77610203162177,
                            2.571660318442073,
                        ),
                        "coordinates": [
                            [
                                [48.77610203162177, 2.2265593271545225],
                                [48.73956019802753, 2.111889242882012],
                                [48.68585180710444, 2.082221274606409],
                                [48.64208882251873, 2.020005696381871],
                                [48.557597387423435, 2.0175740602972896],
                                [48.53307136184394, 1.9674261909808515],
                                [48.45760028606413, 1.9221489648373704],
                                [48.40412484182912, 1.9305557503485924],
                                [48.39938447447992, 1.9765777946992387],
                                [48.28658587795804, 1.9940847180593788],
                                [48.313745436024625, 2.1813499926674265],
                                [48.308672482875515, 2.369810541415244],
                                [48.320719459436056, 2.402664267131608],
                                [48.362015783117755, 2.429832228504419],
                                [48.41125114633111, 2.533731834361712],
                                [48.439446016118225, 2.504749755053753],
                                [48.525239048001154, 2.49952467433224],
                                [48.603849771145576, 2.5437765144069613],
                                [48.65733138882678, 2.53361600680745],
                                [48.69201409164603, 2.571660318442073],
                                [48.735211482171685, 2.5035365695581286],
                                [48.72017592253298, 2.370706732277135],
                                [48.748756235080634, 2.3207180175230313],
                                [48.77610203162177, 2.2265593271545225],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "91", "NOM_DEPT": "ESSONNE"},
                },
                74: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            45.96965998523795,
                            -0.8919599503022404,
                            47.10833699690518,
                            0.21492180826491442,
                        ),
                        "coordinates": [
                            [
                                [46.0955500415297, 0.19735350521616218],
                                [46.13884556432993, 0.21492180826491442],
                                [46.157168244596924, 0.1551113740904494],
                                [46.210932609573995, 0.11283682536372644],
                                [46.267231548998694, 0.12883677213786546],
                                [46.32811314059693, 0.1773687959824542],
                                [46.34939518270097, 0.13759784994026172],
                                [46.304933538922825, 0.07821800902702593],
                                [46.32552885451101, 0.037602239808067595],
                                [46.373496799479916, 0.034219979012944574],
                                [46.411322394513704, -0.01709282434894281],
                                [46.52498101941567, -0.031351255287517144],
                                [46.5947435067776, 0.02598963802815841],
                                [46.66371702380725, -0.04042619019472192],
                                [46.71623331657765, 0.0007042720140887955],
                                [46.81265392500652, -0.020316336069380696],
                                [46.90747700605924, -0.009032410299882686],
                                [47.023133335712934, -0.08769647758767064],
                                [47.064797190818, -0.10212095637964816],
                                [47.10833699690518, -0.18483982751841418],
                                [47.10572466544676, -0.24153794845204798],
                                [47.070771034609585, -0.40077950615793034],
                                [47.08238521770843, -0.4953402437613732],
                                [47.06188673077479, -0.559531871926381],
                                [47.01942614381194, -0.5654683969778384],
                                [46.993322065658454, -0.6199767888274355],
                                [46.98607221005182, -0.7130578012324359],
                                [47.004252209132005, -0.7738774456713039],
                                [46.97581784960786, -0.8919599503022404],
                                [46.93336473376701, -0.8291443983745113],
                                [46.84282850114093, -0.7816473761536221],
                                [46.8086267548513, -0.7008564794263525],
                                [46.767632454457974, -0.7273121698337293],
                                [46.700774642460914, -0.6561893352875904],
                                [46.638027907323625, -0.644063907848707],
                                [46.62039039102902, -0.6141139330666174],
                                [46.53328054778874, -0.6021285989587053],
                                [46.45873492951776, -0.6124259071699322],
                                [46.416229245155975, -0.6406445679433732],
                                [46.386465465455686, -0.5378004980121102],
                                [46.36344857378176, -0.5576498721967054],
                                [46.304258794361935, -0.7504755422947282],
                                [46.24507022173625, -0.7514619974841967],
                                [46.219202505698206, -0.690715475013079],
                                [46.13775275457054, -0.6199574101252718],
                                [46.14422952781576, -0.5469968076890206],
                                [46.10670520800869, -0.5060833286611991],
                                [46.084717640247526, -0.40050831263592807],
                                [46.079753777667634, -0.28173430941987676],
                                [45.96965998523795, -0.10293687953014748],
                                [45.99347998149095, -0.04143104082306168],
                                [46.05592180291526, -0.03199529342544053],
                                [46.052847829356985, 0.019272784617024384],
                                [46.09389590958498, 0.07297225926176226],
                                [46.0955500415297, 0.19735350521616218],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "79", "NOM_DEPT": "DEUX-SEVRES"},
                },
                75: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            48.03547931277979,
                            -3.6591438196705757,
                            48.867416308253006,
                            -1.9124900704350776,
                        ),
                        "coordinates": [
                            [
                                [48.133745563473816, -2.2872784304005114],
                                [48.1705970187894, -2.2247373292770836],
                                [48.2463785700459, -2.186961247227295],
                                [48.252903482093345, -2.110118931164647],
                                [48.29832786131649, -2.0532925486538494],
                                [48.27953190981902, -2.0141005291993967],
                                [48.31710984530666, -1.9548327221541837],
                                [48.51884141988655, -1.9124900704350776],
                                [48.53880790488251, -1.9480369010443905],
                                [48.56611290198357, -2.006894935706843],
                                [48.56767919673737, -2.075983866873217],
                                [48.6044100285603, -2.1237080247752895],
                                [48.57889313289854, -2.1642613521091087],
                                [48.595386986537584, -2.223947576787102],
                                [48.68092282170517, -2.3128652882169667],
                                [48.62251656640193, -2.473428281486323],
                                [48.538129672654826, -2.631267666969782],
                                [48.53113342751236, -2.681558937117988],
                                [48.5935282745742, -2.819598830141578],
                                [48.65056933154874, -2.826935021352181],
                                [48.727215066784595, -2.9479038576324985],
                                [48.75833756841586, -2.9436531177995517],
                                [48.77591418615603, -3.0293966218671415],
                                [48.86673762495404, -3.113976113733975],
                                [48.867416308253006, -3.231756943127049],
                                [48.79722346331915, -3.4307245025981694],
                                [48.83499877620536, -3.5131996274964488],
                                [48.775499964695776, -3.585008235573639],
                                [48.670017885042235, -3.5812485466634145],
                                [48.65920978066925, -3.6591438196705757],
                                [48.610153346220144, -3.6493779946144103],
                                [48.54092077173928, -3.5538598863227393],
                                [48.49643946876788, -3.604061396321586],
                                [48.42892323446267, -3.590415422993112],
                                [48.37776678483146, -3.5545842830629764],
                                [48.33551998786712, -3.5567868257426127],
                                [48.2822731470352, -3.518440717872892],
                                [48.185746943072566, -3.564838973733329],
                                [48.17112526547107, -3.336754735635011],
                                [48.14001476485905, -3.27224433962783],
                                [48.15849094354359, -3.1552540693335716],
                                [48.206363809489616, -3.116373512585393],
                                [48.199360646242376, -3.033540216127106],
                                [48.1205797308541, -2.781951132488677],
                                [48.11932466386193, -2.652301006956973],
                                [48.04788395292574, -2.6700509484423693],
                                [48.03547931277979, -2.6311897590265936],
                                [48.07041003849149, -2.5747859613043027],
                                [48.157844785512516, -2.4948185697824816],
                                [48.168611326672774, -2.408904872170661],
                                [48.122103008406654, -2.371364753161675],
                                [48.133745563473816, -2.2872784304005114],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "22", "NOM_DEPT": "COTES-D'ARMOR"},
                },
                76: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            45.93073235641238,
                            2.2810476101300576,
                            46.803876576773305,
                            3.9980416518372484,
                        ),
                        "coordinates": [
                            [
                                [46.794911188525944, 3.0320681893946824],
                                [46.803876576773305, 2.9599146908207157],
                                [46.73528787880109, 2.8276163881602265],
                                [46.71890739681203, 2.774488053228389],
                                [46.7393873052656, 2.7049751251942706],
                                [46.6372195698165, 2.5966478252098466],
                                [46.55328003970227, 2.614955459722656],
                                [46.51969984591659, 2.536652020779054],
                                [46.53269744464404, 2.4829288047758253],
                                [46.512211347274814, 2.3520035556502914],
                                [46.45351915029326, 2.2857578150118907],
                                [46.42040537318102, 2.2810476101300576],
                                [46.32927925675374, 2.3230243720211274],
                                [46.329982476677515, 2.3918607677139923],
                                [46.281147774598125, 2.478940668864652],
                                [46.23943958277255, 2.51631108338946],
                                [46.143032182829025, 2.5653790586982073],
                                [46.11847766171901, 2.6406912317167386],
                                [46.223324326165475, 2.733052145656418],
                                [46.19621262362186, 2.810275114252155],
                                [46.255486129901755, 2.8557252864968374],
                                [46.242917468274975, 2.9371457775851466],
                                [46.20349381071083, 2.9095928618303133],
                                [46.12178012989871, 2.971756635840471],
                                [46.06567797651341, 3.166531859715606],
                                [46.05506094849443, 3.371595622264062],
                                [46.074292455804986, 3.419029561174583],
                                [46.017936870152774, 3.4635034430082112],
                                [46.02413780633835, 3.5884696050346547],
                                [45.93073235641238, 3.6940178008729885],
                                [45.97378454864044, 3.708883724363124],
                                [45.97385869263016, 3.788909241913359],
                                [45.995967743331704, 3.8254431917706775],
                                [46.04562293029197, 3.80676406021388],
                                [46.08798388977018, 3.8218687105012146],
                                [46.154851332057156, 3.7897619940586127],
                                [46.25485708711847, 3.8048868330812957],
                                [46.27590543921817, 3.8995333931893303],
                                [46.31919378739559, 3.9866257932147806],
                                [46.39922459383981, 3.9772154801510964],
                                [46.46546757106011, 3.9980416518372484],
                                [46.489755621859324, 3.957937642803863],
                                [46.48125092995185, 3.8904705648097107],
                                [46.53113227681356, 3.8340059039329697],
                                [46.519899554588264, 3.8017563441985818],
                                [46.56756978217593, 3.7432867634118923],
                                [46.660582165836225, 3.6969523102437005],
                                [46.70720877171206, 3.6379005417614154],
                                [46.74945902193753, 3.629423683496518],
                                [46.7158646720816, 3.550392218815862],
                                [46.658252554713975, 3.487153284024355],
                                [46.711906067614386, 3.4341330414396496],
                                [46.684416345410895, 3.3467088070518343],
                                [46.71674092868996, 3.2697920192933188],
                                [46.68289184476867, 3.2155498733945853],
                                [46.75807894189367, 3.049065356287102],
                                [46.794911188525944, 3.0320681893946824],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "03", "NOM_DEPT": "ALLIER"},
                },
                77: {
                    "geometry": {
                        "type": "MultiPolygon",
                        "bbox": (
                            45.08880721589074,
                            -1.5353220120922217,
                            46.355624759961664,
                            0.004330746876933936,
                        ),
                        "coordinates": [
                            [
                                [
                                    [46.20012841110215, -1.3421247126758935],
                                    [46.204880769084305, -1.4221002716213327],
                                    [46.25771384564713, -1.5143725982265899],
                                    [46.204394676268265, -1.5353220120922217],
                                    [46.20211883930829, -1.461598406633688],
                                    [46.15588808122243, -1.3549590855946727],
                                    [46.20012841110215, -1.3421247126758935],
                                ]
                            ],
                            [
                                [
                                    [45.90668049019489, -1.215499860497111],
                                    [45.99041558337048, -1.2479234576289204],
                                    [45.992977450421975, -1.312761781453581],
                                    [46.02726602149255, -1.3659335056314696],
                                    [45.95144459142133, -1.3839143994579735],
                                    [45.87816722390549, -1.2661507817954076],
                                    [45.804536905465575, -1.2364229444496377],
                                    [45.82969725881442, -1.1956193786522464],
                                    [45.88674805159812, -1.188433122652762],
                                    [45.90668049019489, -1.215499860497111],
                                ]
                            ],
                            [
                                [
                                    [45.191632555616025, 0.004330746876933936],
                                    [45.24789117263397, -0.04416800947411795],
                                    [45.24807269185132, -0.11538526357329361],
                                    [45.28895157818027, -0.10878607028506979],
                                    [45.32143289837574, -0.22670231706753935],
                                    [45.359870837250256, -0.28089591660714885],
                                    [45.40874172938641, -0.2497593835924437],
                                    [45.455677709323595, -0.2674239730736361],
                                    [45.49164146613392, -0.2461560346224077],
                                    [45.5644938737933, -0.2967152234141246],
                                    [45.608919202664524, -0.37591965312829384],
                                    [45.65617988507809, -0.4089294944559108],
                                    [45.741668657543315, -0.41583863552489936],
                                    [45.80655862747694, -0.2731191101089069],
                                    [45.775745644085404, -0.2217452863431165],
                                    [45.79573700033925, -0.15309474428582864],
                                    [45.87066390237826, -0.11540038254695688],
                                    [45.91102062998216, -0.13166445066648028],
                                    [45.96965998523795, -0.10293687953014748],
                                    [46.079753777667634, -0.28173430941987676],
                                    [46.084717640247526, -0.40050831263592807],
                                    [46.10670520800869, -0.5060833286611991],
                                    [46.14422952781576, -0.5469968076890206],
                                    [46.13775275457054, -0.6199574101252718],
                                    [46.219202505698206, -0.690715475013079],
                                    [46.24507022173625, -0.7514619974841967],
                                    [46.304258794361935, -0.7504755422947282],
                                    [46.340369117324386, -0.839878203866059],
                                    [46.312856004616734, -0.9348886609093259],
                                    [46.355624759961664, -1.0138072401150018],
                                    [46.310276919155996, -1.129404177492153],
                                    [46.26134367831711, -1.1111638836886621],
                                    [46.21324548926303, -1.1989980101944613],
                                    [46.16594526939377, -1.2238754783330195],
                                    [46.1242629149501, -1.1264112813835243],
                                    [46.01118088641006, -1.0526867952056995],
                                    [45.990507551332094, -1.0989490769387051],
                                    [45.94990908084705, -1.0643196475545222],
                                    [45.819898614850615, -1.1371605532141837],
                                    [45.781571555535336, -1.242573859956351],
                                    [45.70589632544041, -1.2372284214926084],
                                    [45.6469813279075, -1.115849451052298],
                                    [45.61143397047429, -1.0096306936697144],
                                    [45.574693032813535, -1.0257418763479118],
                                    [45.43508336826085, -0.8410572249719415],
                                    [45.3692088136439, -0.7740181405098189],
                                    [45.32176994097864, -0.7526821734869675],
                                    [45.32114282458838, -0.5944806728104985],
                                    [45.29770833934139, -0.5595072006432503],
                                    [45.2794739946481, -0.4291954727294871],
                                    [45.16477966588985, -0.3940718179854259],
                                    [45.16755837660476, -0.34233753875966755],
                                    [45.11408527738146, -0.2550869802991912],
                                    [45.08880721589074, -0.15295329411286412],
                                    [45.1213888362867, -0.08770283087044228],
                                    [45.10238433596342, -0.0402003397896402],
                                    [45.191632555616025, 0.004330746876933936],
                                ]
                            ],
                        ],
                    },
                    "attributes": {"CODE_DEPT": "17", "NOM_DEPT": "CHARENTE-MARITIME"},
                },
                78: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            44.61553167652982,
                            2.062914291973062,
                            45.47849879874484,
                            3.3613425807398936,
                        ),
                        "coordinates": [
                            [
                                [44.971411709678975, 3.3613425807398936],
                                [45.014233878924166, 3.3471986847617567],
                                [45.03607778789878, 3.2972503187682016],
                                [45.09513611769881, 3.3257851579159827],
                                [45.12042440957931, 3.2880332175079103],
                                [45.27197144658481, 3.222465248668949],
                                [45.28418729762223, 3.1179979977042014],
                                [45.35437310008832, 3.1034981328800555],
                                [45.28712067830808, 3.016710134630249],
                                [45.309125835256815, 2.9486247512965202],
                                [45.3657751174624, 2.9215557561638335],
                                [45.3923406923832, 2.852378684057164],
                                [45.38155782083131, 2.714857227145231],
                                [45.44265505156296, 2.651429936294738],
                                [45.47849879874484, 2.508408697113082],
                                [45.41883841080893, 2.4874679068775096],
                                [45.384258469857066, 2.4418608930121475],
                                [45.41430579076644, 2.378246243484016],
                                [45.32755821486306, 2.350479440865637],
                                [45.29015191925762, 2.2714136874802593],
                                [45.22085230029835, 2.195361138057307],
                                [45.160192640152275, 2.2136969761815397],
                                [45.081495873975626, 2.171755685373443],
                                [45.05602988503954, 2.09515947189117],
                                [44.98552052019745, 2.1329789677394575],
                                [44.97650640551561, 2.062914291973062],
                                [44.87201148950672, 2.094212310672087],
                                [44.790024398712326, 2.1716362748643747],
                                [44.75310757902523, 2.1534919160094748],
                                [44.63806619142596, 2.1694177928364122],
                                [44.61553167652982, 2.2074752855308404],
                                [44.643844101683406, 2.208413991565611],
                                [44.66969245597248, 2.326785795750648],
                                [44.63887764359621, 2.4350033478315978],
                                [44.721284895454446, 2.556123813120712],
                                [44.77575324565893, 2.562709168390778],
                                [44.79280887269849, 2.5993575445949],
                                [44.843167608376426, 2.6026810523917403],
                                [44.9072261221646, 2.70643491497566],
                                [44.94122218473673, 2.738254293313791],
                                [44.87362935290199, 2.8019551055054883],
                                [44.87148933996955, 2.8496583078406252],
                                [44.8030106101463, 2.8795722036394493],
                                [44.779198272865976, 2.9345215070232764],
                                [44.72863892315705, 2.9232644794453155],
                                [44.6446766126243, 2.981676986530433],
                                [44.81717597962275, 3.0615255979734926],
                                [44.83358841808968, 3.0994768968798603],
                                [44.88677480310235, 3.1054983095640436],
                                [44.863734531317185, 3.182311971252496],
                                [44.91623789304496, 3.2496925236752454],
                                [44.971411709678975, 3.3613425807398936],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "15", "NOM_DEPT": "CANTAL"},
                },
                79: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            43.21280863308409,
                            2.5399619094859687,
                            43.96901626259538,
                            4.194441206758988,
                        ),
                        "coordinates": [
                            [
                                [43.422959744104, 2.5657873980365586],
                                [43.34622186231968, 2.5399619094859687],
                                [43.298706986396866, 2.6016030790296316],
                                [43.25778564580618, 2.772248225673249],
                                [43.322412805617326, 2.8327620472635995],
                                [43.32013114159761, 3.004349268167806],
                                [43.28853825294427, 3.004740938100306],
                                [43.24700506844496, 3.1472079664155532],
                                [43.24916714805367, 3.2010265503923754],
                                [43.21280863308409, 3.24056113717041],
                                [43.27039600610153, 3.343863387032852],
                                [43.290209536435995, 3.4303316940306616],
                                [43.27333336221085, 3.510954322025528],
                                [43.35542655651463, 3.6026190412473764],
                                [43.392279064377114, 3.66215922818193],
                                [43.441035909910426, 3.796663802013001],
                                [43.51684377775199, 3.9071342421308484],
                                [43.552446652511314, 4.011185334395634],
                                [43.554370946408625, 4.1010416754063925],
                                [43.585562468156866, 4.150215691493674],
                                [43.654303826233026, 4.194441206758988],
                                [43.73388653553411, 4.144780927023586],
                                [43.81146444231582, 4.002046166191344],
                                [43.88559322066372, 3.917385092127717],
                                [43.8664240348707, 3.830797043559706],
                                [43.91929773950883, 3.824905456819552],
                                [43.96687037520115, 3.787325021892116],
                                [43.96901626259538, 3.726990344828379],
                                [43.916978566757564, 3.623588615095356],
                                [43.86552224087741, 3.5754482408134063],
                                [43.855624713961625, 3.5307009207380955],
                                [43.91159816844731, 3.424448067668623],
                                [43.913832893255, 3.3583594413044624],
                                [43.89835231151905, 3.275074750407491],
                                [43.81387268634425, 3.203111724562128],
                                [43.83164737994541, 3.0598559764719786],
                                [43.693077287037454, 3.060740509271366],
                                [43.708516252330526, 2.98535037366361],
                                [43.694667785188855, 2.9354629666803715],
                                [43.66002074537221, 2.9159815194674086],
                                [43.6141387864358, 2.7545235571938624],
                                [43.64559678398747, 2.711169474843746],
                                [43.650146162495055, 2.6432637215975134],
                                [43.56663335506618, 2.615607192520078],
                                [43.525794099032574, 2.658651329156613],
                                [43.48016355800575, 2.6595399785833935],
                                [43.431093773006396, 2.606081177961043],
                                [43.422959744104, 2.5657873980365586],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "34", "NOM_DEPT": "HERAULT"},
                },
                80: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            44.11571934778836,
                            4.650615013437554,
                            45.344046640836105,
                            5.801469996094522,
                        ),
                        "coordinates": [
                            [
                                [44.70677851287, 5.801469996094522],
                                [44.6960702841541, 5.759044078047863],
                                [44.75246442874924, 5.62708487257189],
                                [44.79242749679306, 5.4641587549688655],
                                [44.922290598248225, 5.483647138020397],
                                [45.02278614732907, 5.483609211781887],
                                [45.07078365917332, 5.449788835244157],
                                [45.03613916354606, 5.388382939418146],
                                [45.08331022009428, 5.1793846576859695],
                                [45.17126853879258, 5.188573507748233],
                                [45.2484020449113, 5.176540876984406],
                                [45.248335918090646, 5.121425532367966],
                                [45.31905467974735, 5.05431872757624],
                                [45.344046640836105, 4.989191483458711],
                                [45.297454009351384, 4.880237763487565],
                                [45.29836066114294, 4.800493926884063],
                                [45.16448183151871, 4.812473966213054],
                                [45.004791813947854, 4.837672652853049],
                                [44.93665163053356, 4.886589299843449],
                                [44.81708784467795, 4.822513080923934],
                                [44.77862679935857, 4.76621554467615],
                                [44.65469880413612, 4.779060115885166],
                                [44.581549114708366, 4.7102664999416985],
                                [44.542230674151796, 4.693639580520507],
                                [44.452309460126756, 4.69865229412497],
                                [44.43066448441976, 4.667367377491741],
                                [44.32980579151128, 4.650615013437554],
                                [44.32538168266027, 4.762251228111599],
                                [44.29659556592805, 4.802876705944989],
                                [44.23231488509351, 4.814083573320775],
                                [44.30813976056078, 5.060564583015947],
                                [44.28208386834488, 5.14972713298067],
                                [44.230944996200954, 5.154903556803357],
                                [44.20104672066314, 5.384523055943826],
                                [44.15528473021912, 5.383240887752098],
                                [44.15224864024982, 5.435755865794636],
                                [44.11571934778836, 5.498787806458752],
                                [44.13639078272547, 5.543986124993946],
                                [44.188041650949074, 5.576187167563139],
                                [44.167586051913645, 5.639593544372252],
                                [44.191433131858965, 5.676037325543462],
                                [44.26691847226595, 5.686555113440127],
                                [44.26709147544853, 5.646781325357401],
                                [44.32830301747026, 5.631598076087924],
                                [44.337177520811714, 5.4930715607447445],
                                [44.42494737031899, 5.418530667075709],
                                [44.49113051875815, 5.513340558551903],
                                [44.465545293621936, 5.603638674628631],
                                [44.53159832212814, 5.630798606104504],
                                [44.54327372797923, 5.5972487980667855],
                                [44.6178810074043, 5.6496309488227565],
                                [44.65329030204329, 5.790619766631355],
                                [44.70677851287, 5.801469996094522],
                            ],
                            [
                                [44.36481842003465, 4.892909784975503],
                                [44.40778504385655, 4.918515009368784],
                                [44.43136994934865, 4.970436397484981],
                                [44.392766145968594, 5.015759498726315],
                                [44.32614028646893, 5.013377111169766],
                                [44.297463038388315, 4.978583367650993],
                                [44.30415309780472, 4.8895301353902365],
                                [44.36481842003465, 4.892909784975503],
                            ],
                        ],
                    },
                    "attributes": {"CODE_DEPT": "26", "NOM_DEPT": "DROME"},
                },
                81: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            42.33375178289351,
                            1.7298881048979535,
                            42.918341437261006,
                            3.1732198139368313,
                        ),
                        "coordinates": [
                            [
                                [42.57362343207788, 1.7861250110638964],
                                [42.56358508914754, 1.7498821218907066],
                                [42.49532568149937, 1.7298881048979535],
                                [42.48178622958981, 1.8346228986722801],
                                [42.42404869009333, 1.9582842085598802],
                                [42.362048166797734, 1.9859066164117019],
                                [42.36270013981574, 2.083598101455443],
                                [42.42342744508062, 2.156341756737746],
                                [42.43835800634602, 2.2578002255424416],
                                [42.38887656698712, 2.435482130866189],
                                [42.33964655377135, 2.4829628754848416],
                                [42.33375178289351, 2.5400343955805043],
                                [42.357933234601845, 2.5778245531567956],
                                [42.34117820769782, 2.6717654689105332],
                                [42.404968311039255, 2.675046174210866],
                                [42.42535725427018, 2.7532002138160783],
                                [42.41856867596309, 2.799242281304166],
                                [42.45852270899326, 2.8414109625242325],
                                [42.47314100863664, 3.0407621096853417],
                                [42.425509881233154, 3.085437328583658],
                                [42.434877393314636, 3.1732198139368313],
                                [42.51294127329124, 3.1335847928885587],
                                [42.55014015956973, 3.049606421697757],
                                [42.678248196502366, 3.0354222951214984],
                                [42.83815011921807, 3.0434985865888815],
                                [42.88486022074883, 2.917114990593263],
                                [42.918341437261006, 2.8652738803519484],
                                [42.89598872881156, 2.789053819259419],
                                [42.837574151816995, 2.7400003158100112],
                                [42.830431065988684, 2.697577646248594],
                                [42.8498316897035, 2.5090117260388043],
                                [42.83693276356474, 2.452474760710876],
                                [42.837442775831846, 2.327116045977923],
                                [42.73412195489036, 2.357535079462851],
                                [42.70779157620242, 2.322006120391769],
                                [42.66391836976527, 2.166053682054993],
                                [42.66156483553937, 2.0005149149001973],
                                [42.61692049379412, 1.9717596461471245],
                                [42.58140598425563, 1.8744850028357225],
                                [42.57362343207788, 1.7861250110638964],
                            ]
                        ],
                    },
                    "attributes": {
                        "CODE_DEPT": "66",
                        "NOM_DEPT": "PYRENEES-ORIENTALES",
                    },
                },
                82: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            45.05607309559144,
                            5.623748035268078,
                            45.93845957829322,
                            7.184274774893671,
                        ),
                        "coordinates": [
                            [
                                [45.126847913866314, 6.260566197557926],
                                [45.10449394991729, 6.36292281324225],
                                [45.06181851097422, 6.393914586674507],
                                [45.05607309559144, 6.486234598441579],
                                [45.09413629464072, 6.4812541096424034],
                                [45.109326928199906, 6.629987338137473],
                                [45.140124971361885, 6.68006735247428],
                                [45.15974375221742, 6.767935179515762],
                                [45.12716081574408, 6.84985884318955],
                                [45.208060557766785, 6.968757184292427],
                                [45.25569487340002, 7.13759030527828],
                                [45.326512299604914, 7.110695394012847],
                                [45.40748063151992, 7.184274774893671],
                                [45.4341946873311, 7.113516455211972],
                                [45.46943936219542, 7.0997891354009095],
                                [45.50441719658229, 7.000331708478396],
                                [45.63990159437462, 7.000690534148291],
                                [45.64709230917701, 6.934608837460737],
                                [45.70283279544943, 6.829114564865921],
                                [45.77837197402194, 6.802516663522653],
                                [45.72291967208872, 6.711938518958689],
                                [45.79890547186772, 6.661192099251397],
                                [45.795419923318136, 6.60173297249558],
                                [45.82687986970036, 6.552237633503553],
                                [45.90863287329888, 6.509087472467454],
                                [45.884692297393386, 6.470559679970141],
                                [45.80244240743692, 6.423672125473556],
                                [45.778055295582206, 6.383851558657904],
                                [45.69553113948381, 6.330635270345084],
                                [45.685404763162595, 6.239679907775353],
                                [45.704161749692204, 6.18971416977487],
                                [45.75571563232778, 6.166233910329839],
                                [45.739095951312514, 6.042939005987318],
                                [45.804140838702274, 5.913209603821917],
                                [45.838095558126746, 5.873426502484641],
                                [45.93240229486182, 5.862101395990038],
                                [45.93845957829322, 5.831226413621036],
                                [45.82295599649881, 5.7868562241797115],
                                [45.7292223955843, 5.7761608991802635],
                                [45.71092632945919, 5.704119379498135],
                                [45.64850161239944, 5.689187102194641],
                                [45.613268326764185, 5.623748035268078],
                                [45.47254042424705, 5.736372335642621],
                                [45.44065533936712, 5.782081150720109],
                                [45.406796712103805, 5.879738401559338],
                                [45.4923087213814, 5.966169653050879],
                                [45.43791952965108, 6.049753851710852],
                                [45.438897845399275, 6.121272339213556],
                                [45.39316148783123, 6.177450938299202],
                                [45.317948507606715, 6.184450320779225],
                                [45.288287215984546, 6.131944929909638],
                                [45.244270268835876, 6.125696481423487],
                                [45.163732283278, 6.189207693158914],
                                [45.126847913866314, 6.260566197557926],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "73", "NOM_DEPT": "SAVOIE"},
                },
                83: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            44.191433131858965,
                            5.418530667075709,
                            45.126847913866314,
                            7.077108800206923,
                        ),
                        "coordinates": [
                            [
                                [44.70677851287, 5.801469996094522],
                                [44.65329030204329, 5.790619766631355],
                                [44.6178810074043, 5.6496309488227565],
                                [44.54327372797923, 5.5972487980667855],
                                [44.53159832212814, 5.630798606104504],
                                [44.465545293621936, 5.603638674628631],
                                [44.49113051875815, 5.513340558551903],
                                [44.42494737031899, 5.418530667075709],
                                [44.337177520811714, 5.4930715607447445],
                                [44.32830301747026, 5.631598076087924],
                                [44.26709147544853, 5.646781325357401],
                                [44.26691847226595, 5.686555113440127],
                                [44.191433131858965, 5.676037325543462],
                                [44.21020776523787, 5.75549419659688],
                                [44.210998662542806, 5.881793583616447],
                                [44.27890195531251, 5.823911889045942],
                                [44.27153166809449, 5.912323479912074],
                                [44.39505926669922, 5.953670382950493],
                                [44.45053588827667, 6.071139333430848],
                                [44.461959822985584, 6.15561504901071],
                                [44.381700391997015, 6.228221718294849],
                                [44.41225003856591, 6.262481962582939],
                                [44.46383091832782, 6.233718236049833],
                                [44.522072579043936, 6.362000081358196],
                                [44.46928995962832, 6.413884950226283],
                                [44.44549275371157, 6.562444503095604],
                                [44.44712877640474, 6.63237632755871],
                                [44.54130010645836, 6.684305299896708],
                                [44.58890871380474, 6.772207133133651],
                                [44.60858882906438, 6.83980166742822],
                                [44.65949945810214, 6.914488202179288],
                                [44.654816299146766, 6.948335091404862],
                                [44.69014148867834, 6.987055135805779],
                                [44.680917509173426, 7.077108800206923],
                                [44.78944471324737, 6.999571239749256],
                                [44.83931596763314, 7.006773778890771],
                                [44.86202607200865, 6.933687243037528],
                                [44.852900819527065, 6.859863090422122],
                                [44.90736131510599, 6.749745773276749],
                                [44.971220086046884, 6.763455936171166],
                                [45.01672934689641, 6.7408068424989125],
                                [45.019617540780494, 6.673884165477502],
                                [45.109326928199906, 6.629987338137473],
                                [45.09413629464072, 6.4812541096424034],
                                [45.05607309559144, 6.486234598441579],
                                [45.06181851097422, 6.393914586674507],
                                [45.10449394991729, 6.36292281324225],
                                [45.126847913866314, 6.260566197557926],
                                [45.108750055807405, 6.229388123209472],
                                [45.01246916508484, 6.203927022398643],
                                [45.003856776770675, 6.3181981975765975],
                                [44.94128447146301, 6.3588400606704845],
                                [44.854778989917435, 6.355361452664249],
                                [44.87325988167463, 6.302846745398276],
                                [44.85265497741959, 6.25054409332542],
                                [44.86407279122649, 6.136224190737252],
                                [44.815908261733654, 6.056342958572753],
                                [44.83809609775419, 6.030210546238998],
                                [44.80453012289716, 5.94951924784745],
                                [44.754705804536066, 5.915233300411789],
                                [44.75074454418582, 5.850398663313628],
                                [44.70677851287, 5.801469996094522],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "05", "NOM_DEPT": "HAUTES-ALPES"},
                },
                84: {
                    "geometry": {
                        "type": "MultiPolygon",
                        "bbox": (
                            43.658685905164766,
                            4.649223666100485,
                            44.43136994934865,
                            5.7573329775827045,
                        ),
                        "coordinates": [
                            [
                                [
                                    [44.36481842003465, 4.892909784975503],
                                    [44.30415309780472, 4.8895301353902365],
                                    [44.297463038388315, 4.978583367650993],
                                    [44.32614028646893, 5.013377111169766],
                                    [44.392766145968594, 5.015759498726315],
                                    [44.43136994934865, 4.970436397484981],
                                    [44.40778504385655, 4.918515009368784],
                                    [44.36481842003465, 4.892909784975503],
                                ]
                            ],
                            [
                                [
                                    [43.924059473490566, 4.739060856654237],
                                    [43.91138205123055, 4.853093547765335],
                                    [43.87164726913833, 4.966309299927298],
                                    [43.827792913138744, 5.02953344530474],
                                    [43.78788168846555, 5.051490035086313],
                                    [43.73510332278255, 5.187972296540633],
                                    [43.74767288112557, 5.229990308924739],
                                    [43.735021431958224, 5.31850282672],
                                    [43.68110432174805, 5.439245661034277],
                                    [43.65901134759575, 5.531453034372501],
                                    [43.658685905164766, 5.6069435191164425],
                                    [43.72462253878876, 5.753638490630264],
                                    [43.729409113755324, 5.7573329775827045],
                                    [43.82511098585936, 5.654445137414141],
                                    [43.82992112219788, 5.5781897912212175],
                                    [43.913772843753264, 5.607126670731598],
                                    [43.946002285646465, 5.512089542555731],
                                    [44.02870768768523, 5.543656674317526],
                                    [44.06343920865494, 5.5026367853279545],
                                    [44.11571934778836, 5.498787806458752],
                                    [44.15224864024982, 5.435755865794636],
                                    [44.15528473021912, 5.383240887752098],
                                    [44.20104672066314, 5.384523055943826],
                                    [44.230944996200954, 5.154903556803357],
                                    [44.28208386834488, 5.14972713298067],
                                    [44.30813976056078, 5.060564583015947],
                                    [44.23231488509351, 4.814083573320775],
                                    [44.29659556592805, 4.802876705944989],
                                    [44.32538168266027, 4.762251228111599],
                                    [44.32980579151128, 4.650615013437554],
                                    [44.27035986501095, 4.649223666100485],
                                    [44.18742154948268, 4.722074664233517],
                                    [44.10367246401243, 4.707458356688192],
                                    [44.06505409747017, 4.787978024928094],
                                    [43.98647454846487, 4.842093969959472],
                                    [43.924059473490566, 4.739060856654237],
                                ]
                            ],
                        ],
                    },
                    "attributes": {"CODE_DEPT": "84", "NOM_DEPT": "VAUCLUSE"},
                },
                85: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            46.34721849587296,
                            0.8674688807081561,
                            47.27667661630457,
                            2.2043972607989812,
                        ),
                        "coordinates": [
                            [
                                [46.4240665008181, 2.167785718138384],
                                [46.45796019235814, 2.1516716067091237],
                                [46.48439997524805, 2.2043972607989812],
                                [46.55734628168219, 2.158700190947214],
                                [46.60286242584107, 2.18562886154938],
                                [46.69555371540337, 2.1407244355816926],
                                [46.74249480206491, 2.065751312591214],
                                [46.774358601474674, 2.1153606164888155],
                                [46.82944826814362, 2.0488103323451234],
                                [46.87986509549618, 2.1262038890477335],
                                [46.93399643786305, 2.0706986163554206],
                                [47.01573583572996, 2.0933838995940373],
                                [47.040016048649505, 2.051487760798448],
                                [47.10601550210712, 2.048374881247615],
                                [47.125417513727896, 1.9664139793909294],
                                [47.101949545642825, 1.882721849834433],
                                [47.130846812692134, 1.7745813093652696],
                                [47.17802935443287, 1.8421086266284743],
                                [47.21930815773424, 1.8390792420529518],
                                [47.26587806829791, 1.7058305011298698],
                                [47.27667661630457, 1.5924281213159723],
                                [47.237967921224396, 1.448462247960517],
                                [47.18622542473178, 1.3266655450453897],
                                [47.12205127770917, 1.3653609997076237],
                                [47.096975273440314, 1.311672909460613],
                                [47.03783413818556, 1.2730568495660919],
                                [47.039622972819544, 1.1614221724181901],
                                [47.015842398188234, 1.0776154683629737],
                                [46.98064041873546, 1.0498776400419187],
                                [46.76154066839267, 0.9888132945329691],
                                [46.74821910504848, 0.8674688807081561],
                                [46.69279335231604, 0.9247556936578988],
                                [46.625736651822876, 0.8943018154002147],
                                [46.580792108421264, 0.94202375883659],
                                [46.567763998821995, 1.0147644249831798],
                                [46.50640188056708, 1.1459353661062848],
                                [46.449236175812, 1.1516045347766355],
                                [46.43222161336161, 1.212690238083345],
                                [46.383951622152935, 1.1772799568053667],
                                [46.37099465262579, 1.303056786055347],
                                [46.40012317441315, 1.356022895309223],
                                [46.34721849587296, 1.4151905101137503],
                                [46.42652499450048, 1.5223068332769552],
                                [46.386815849085174, 1.6448464161558107],
                                [46.38895871366094, 1.7277108990817451],
                                [46.4300383389509, 1.819500417665562],
                                [46.43091738935583, 1.9930823669027022],
                                [46.40890318674807, 2.088941803334241],
                                [46.4240665008181, 2.167785718138384],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "36", "NOM_DEPT": "INDRE"},
                },
                86: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            41.83681486608311,
                            8.573411068108614,
                            43.0117229260943,
                            9.558834031337039,
                        ),
                        "coordinates": [
                            [
                                [41.85869824227228, 9.40226832441199],
                                [41.95247536073487, 9.412573752377247],
                                [42.10416397232962, 9.549983013016071],
                                [42.285263441361955, 9.558834031337039],
                                [42.37996722190875, 9.532670166153812],
                                [42.428489580925785, 9.543397471188387],
                                [42.545944023399095, 9.533193015205356],
                                [42.662236031630215, 9.449196243675715],
                                [42.68612187004434, 9.446380758225057],
                                [42.80510332631401, 9.49237931225356],
                                [42.87413170694094, 9.473063477929271],
                                [42.98640316480421, 9.463553614767086],
                                [43.0117229260943, 9.421761206671862],
                                [42.99446130565274, 9.340869996691138],
                                [42.916238918113834, 9.353823296916074],
                                [42.83467992024285, 9.311020338565653],
                                [42.794801298609066, 9.34256025591115],
                                [42.737812432908356, 9.344474787466684],
                                [42.67431591000078, 9.293321757624451],
                                [42.71851210134236, 9.254452272413712],
                                [42.73656106751822, 9.16688288642443],
                                [42.71460676752977, 9.085757984829682],
                                [42.644271176255096, 9.020690214855307],
                                [42.62897074250373, 8.886523760118468],
                                [42.599055946968434, 8.808932860020777],
                                [42.5698603416326, 8.804094980454657],
                                [42.51522405863273, 8.666504962154614],
                                [42.41573555548147, 8.655224073914713],
                                [42.416825413431944, 8.608422093704316],
                                [42.38140571205032, 8.573411068108614],
                                [42.37343635383299, 8.640801666424288],
                                [42.31755804188288, 8.819561377056068],
                                [42.253859280700944, 8.904766989145308],
                                [42.20692343140828, 9.04565931380628],
                                [42.13021371520013, 9.072186891776042],
                                [42.10777443178612, 9.119729450195367],
                                [42.026017143380564, 9.160818391906192],
                                [42.027596960539064, 9.22108402465599],
                                [41.85558903234784, 9.227497390904743],
                                [41.83681486608311, 9.329200877550077],
                                [41.85869824227228, 9.40226832441199],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "2B", "NOM_DEPT": "HAUTE-CORSE"},
                },
                87: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            45.44421907802482,
                            0.6297424639524395,
                            46.40012317441315,
                            1.898730779182943,
                        ),
                        "coordinates": [
                            [
                                [45.44421907802482, 1.2531518386328937],
                                [45.48993789201231, 1.2870567570435631],
                                [45.46688830500579, 1.350077879284767],
                                [45.528081031575745, 1.412058914052018],
                                [45.56594313830816, 1.4803697950912302],
                                [45.54936632471628, 1.5571958047036873],
                                [45.58035190912391, 1.6376634511377184],
                                [45.68036337807322, 1.7838678002323438],
                                [45.664658270083336, 1.8713480467629338],
                                [45.6982775512041, 1.898730779182943],
                                [45.7327797889896, 1.875140102478583],
                                [45.797714818456456, 1.8808988285366512],
                                [45.84282757445294, 1.7727491731275804],
                                [45.835114020235736, 1.6766374034760068],
                                [45.85746515857901, 1.6023984681707657],
                                [45.9334124264404, 1.6087196458716777],
                                [45.95280423814569, 1.5325001755915217],
                                [46.03541014153877, 1.5491757848158922],
                                [46.17975461207027, 1.4527947858284072],
                                [46.21545110095231, 1.3749003074212889],
                                [46.305894207375275, 1.4437697350516507],
                                [46.34721849587296, 1.4151905101137503],
                                [46.40012317441315, 1.356022895309223],
                                [46.37099465262579, 1.303056786055347],
                                [46.383951622152935, 1.1772799568053667],
                                [46.360466281243085, 1.1297576486963083],
                                [46.34303442800397, 1.026995442933731],
                                [46.28097399864579, 1.0058867393780462],
                                [46.285257481169126, 0.9072715939898939],
                                [46.21096277430388, 0.7963255053030057],
                                [46.128581728488285, 0.8234337839605995],
                                [46.04787811648369, 0.8179096763959524],
                                [46.010453963771624, 0.9256254984735032],
                                [45.95743607843123, 0.942591996012476],
                                [45.91975549444778, 0.8629055339639634],
                                [45.82108209588079, 0.7822321483214054],
                                [45.80561793866405, 0.7164398059782177],
                                [45.76311968057405, 0.714888400126834],
                                [45.71456998977267, 0.6297424639524395],
                                [45.6675695723418, 0.775843134926025],
                                [45.61832385402003, 0.7515297126109166],
                                [45.575870643461926, 0.811500332264728],
                                [45.611582010503184, 0.9345523684647926],
                                [45.60020929025313, 1.0358490435954522],
                                [45.487782926278754, 1.1197844789851372],
                                [45.44421907802482, 1.2531518386328937],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "87", "NOM_DEPT": "HAUTE-VIENNE"},
                },
                88: {
                    "geometry": {
                        "type": "MultiPolygon",
                        "bbox": (
                            46.266571614816904,
                            -2.301813103356834,
                            47.08389319899775,
                            -0.5378004980121102,
                        ),
                        "coordinates": [
                            [
                                [
                                    [46.989742762366824, -2.301813103356834],
                                    [46.96087838866197, -2.264380088499401],
                                    [47.00781894429174, -2.2183340290348834],
                                    [47.02462125927166, -2.2872305163820257],
                                    [46.989742762366824, -2.301813103356834],
                                ]
                            ],
                            [
                                [
                                    [47.028906494075635, -1.980414486742876],
                                    [47.00991814012838, -2.0273554296334564],
                                    [46.948066582804636, -2.0627409343597365],
                                    [46.89015018115229, -2.1538266883941843],
                                    [46.826396356812694, -2.144508393520906],
                                    [46.692704991393796, -1.9428810018395475],
                                    [46.60857792818521, -1.856017609992669],
                                    [46.493418144353235, -1.8123496382428275],
                                    [46.492758463623176, -1.777141798763278],
                                    [46.414221541074, -1.6270608317160031],
                                    [46.39734952406837, -1.502145422584782],
                                    [46.34235901019938, -1.465941563501806],
                                    [46.34861328663727, -1.3667425638808843],
                                    [46.266571614816904, -1.2073944924206372],
                                    [46.31634695785251, -1.201087723676226],
                                    [46.310276919155996, -1.129404177492153],
                                    [46.355624759961664, -1.0138072401150018],
                                    [46.312856004616734, -0.9348886609093259],
                                    [46.340369117324386, -0.839878203866059],
                                    [46.304258794361935, -0.7504755422947282],
                                    [46.36344857378176, -0.5576498721967054],
                                    [46.386465465455686, -0.5378004980121102],
                                    [46.416229245155975, -0.6406445679433732],
                                    [46.45873492951776, -0.6124259071699322],
                                    [46.53328054778874, -0.6021285989587053],
                                    [46.62039039102902, -0.6141139330666174],
                                    [46.638027907323625, -0.644063907848707],
                                    [46.700774642460914, -0.6561893352875904],
                                    [46.767632454457974, -0.7273121698337293],
                                    [46.8086267548513, -0.7008564794263525],
                                    [46.84282850114093, -0.7816473761536221],
                                    [46.93336473376701, -0.8291443983745113],
                                    [46.97581784960786, -0.8919599503022404],
                                    [47.00890804339756, -0.9334603151811864],
                                    [47.00568547430042, -1.0554031085144766],
                                    [47.02954516258657, -1.1485704887534407],
                                    [47.08389319899775, -1.2712067087150385],
                                    [47.03948346966516, -1.2946349782361042],
                                    [47.03085386698655, -1.3786124689367822],
                                    [46.95218446660972, -1.3729857700949506],
                                    [46.926272854355254, -1.4561316296061424],
                                    [47.03786198958929, -1.4821311833973994],
                                    [47.01834875737957, -1.5523222833408654],
                                    [46.98150474523172, -1.5535636972370026],
                                    [46.88389115282978, -1.5007668577856463],
                                    [46.86007983436468, -1.5485110748777025],
                                    [46.89049286319805, -1.6897612739864445],
                                    [46.92959568215277, -1.7510623002403711],
                                    [46.9320337241545, -1.8309821821134158],
                                    [46.99471092059495, -1.9432276192598656],
                                    [47.028906494075635, -1.980414486742876],
                                ]
                            ],
                        ],
                    },
                    "attributes": {"CODE_DEPT": "85", "NOM_DEPT": "VENDEE"},
                },
                89: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            43.046619004635104,
                            5.6718750056992775,
                            43.806365977888035,
                            6.933726236453418,
                        ),
                        "coordinates": [
                            [
                                [43.17926878690493, 5.6718750056992775],
                                [43.1435877868191, 5.694880043308294],
                                [43.10936452456005, 5.812729626801352],
                                [43.07828493675108, 5.804564531287972],
                                [43.046619004635104, 5.857450411938569],
                                [43.10766029019478, 5.941245658009144],
                                [43.077473324630404, 6.031440047836646],
                                [43.07930848251309, 6.124045766317685],
                                [43.10853535096938, 6.183993790284117],
                                [43.12104461810048, 6.26529674054148],
                                [43.0899129219639, 6.368261479285514],
                                [43.14489830267707, 6.387572821703614],
                                [43.15022275222098, 6.493498246377528],
                                [43.18862998328654, 6.559636361254335],
                                [43.17251047188624, 6.635531400239646],
                                [43.19592734658188, 6.659331915728428],
                                [43.27879196431358, 6.6773116237656085],
                                [43.31821636550589, 6.665952517510405],
                                [43.41288050528172, 6.739811023717541],
                                [43.41816384523436, 6.859478029180435],
                                [43.48006801088501, 6.933726236453418],
                                [43.502535727819236, 6.884230099335205],
                                [43.59907918794692, 6.908012993627824],
                                [43.62818033606128, 6.798740654262],
                                [43.66648795918856, 6.760801398395701],
                                [43.738166980478354, 6.753535969205429],
                                [43.788950567095455, 6.636395800176685],
                                [43.806365977888035, 6.52476198332243],
                                [43.791594458434176, 6.414428052603499],
                                [43.76036041847219, 6.413483066219064],
                                [43.73636766488724, 6.356960735074889],
                                [43.799511976998794, 6.216709972579084],
                                [43.76217559136371, 6.1828860082819075],
                                [43.69416334085517, 6.036131813943927],
                                [43.732584595184825, 5.90120740256815],
                                [43.75565738832376, 5.781343238677484],
                                [43.729409113755324, 5.7573329775827045],
                                [43.72462253878876, 5.753638490630264],
                                [43.68896399525111, 5.813243983394541],
                                [43.66051789095841, 5.799061112603832],
                                [43.641716113697846, 5.700215221457389],
                                [43.61373206007321, 5.682144833819898],
                                [43.55089752725021, 5.724610447116372],
                                [43.48217012690397, 5.698802592390259],
                                [43.434295125206056, 5.751846953791003],
                                [43.39915686931637, 5.682787396731936],
                                [43.26733799967126, 5.760928945485899],
                                [43.23605829449105, 5.683909137465822],
                                [43.17926878690493, 5.6718750056992775],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "83", "NOM_DEPT": "VAR"},
                },
                90: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            48.69201409164603,
                            2.3207180175230313,
                            48.860849617648306,
                            2.6136476481340414,
                        ),
                        "coordinates": [
                            [
                                [48.8074366758147, 2.5922804883088015],
                                [48.860849617648306, 2.4956469644616233],
                                [48.849238273407416, 2.416339717281352],
                                [48.817012713055696, 2.3318953139887446],
                                [48.748756235080634, 2.3207180175230313],
                                [48.72017592253298, 2.370706732277135],
                                [48.735211482171685, 2.5035365695581286],
                                [48.69201409164603, 2.571660318442073],
                                [48.761027192292545, 2.6136476481340414],
                                [48.8074366758147, 2.5922804883088015],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "94", "NOM_DEPT": "VAL-DE-MARNE"},
                },
                91: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            48.748756235080634,
                            2.1515778037276103,
                            48.95096678807721,
                            2.3318953139887446,
                        ),
                        "coordinates": [
                            [
                                [48.817012713055696, 2.3318953139887446],
                                [48.834807742280645, 2.255142901863683],
                                [48.869069480870024, 2.2317363464837308],
                                [48.90045886733916, 2.319884458526643],
                                [48.95096678807721, 2.2909735732251613],
                                [48.90867932989047, 2.2005910092695036],
                                [48.87333985214219, 2.1528691414227357],
                                [48.81702039834037, 2.1515778037276103],
                                [48.77610203162177, 2.2265593271545225],
                                [48.748756235080634, 2.3207180175230313],
                                [48.817012713055696, 2.3318953139887446],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "92", "NOM_DEPT": "HAUTS-DE-SEINE"},
                },
                92: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            44.122695330490544,
                            2.981676986530433,
                            44.971411709678975,
                            3.998162987763964,
                        ),
                        "coordinates": [
                            [
                                [44.6446766126243, 2.981676986530433],
                                [44.559014394432964, 3.083593896775788],
                                [44.50348970314472, 3.068542786200033],
                                [44.454870231099065, 3.13573609856136],
                                [44.38337811871574, 3.119711177226503],
                                [44.30837023621564, 3.1542516260589815],
                                [44.2844635736958, 3.1252288254578002],
                                [44.22625501460891, 3.2298475773263053],
                                [44.197910434234956, 3.3577995033411128],
                                [44.17075587210565, 3.3736480448306843],
                                [44.12909826593223, 3.4397298934659637],
                                [44.122695330490544, 3.633491144032294],
                                [44.175488044182295, 3.637769161351025],
                                [44.18275878035751, 3.678640671819198],
                                [44.12738907948688, 3.7969951126604835],
                                [44.130073752440985, 3.862104986455048],
                                [44.1707937260686, 3.9526044819739092],
                                [44.247795429889, 3.9513171396124562],
                                [44.305217941025674, 3.922858913740669],
                                [44.32838999677705, 3.952331315351652],
                                [44.387999052346906, 3.8859181039452233],
                                [44.399567503492314, 3.944362317344653],
                                [44.45979755586323, 3.998162987763964],
                                [44.57379092180415, 3.9451489956301886],
                                [44.592708047769605, 3.9051719910706293],
                                [44.743863434670935, 3.862527190139651],
                                [44.83869734813899, 3.7406507355868404],
                                [44.82877808873478, 3.666364914643008],
                                [44.869938644505325, 3.6595223843815874],
                                [44.87542977006507, 3.5943359966689923],
                                [44.83219404802294, 3.589348917106291],
                                [44.81537151910512, 3.475773707159976],
                                [44.90076835769558, 3.4179705141646854],
                                [44.94484250197586, 3.412834742275399],
                                [44.971411709678975, 3.3613425807398936],
                                [44.91623789304496, 3.2496925236752454],
                                [44.863734531317185, 3.182311971252496],
                                [44.88677480310235, 3.1054983095640436],
                                [44.83358841808968, 3.0994768968798603],
                                [44.81717597962275, 3.0615255979734926],
                                [44.6446766126243, 2.981676986530433],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "48", "NOM_DEPT": "LOZERE"},
                },
                93: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            43.16254563167401,
                            4.230283393392478,
                            43.924059473490566,
                            5.813243983394541,
                        ),
                        "coordinates": [
                            [
                                [43.460185432726384, 4.230283393392478],
                                [43.44621502092873, 4.554920338571666],
                                [43.422706954965456, 4.5880988691773705],
                                [43.372136705961424, 4.562800334318894],
                                [43.34641234548359, 4.6617830951472214],
                                [43.34994067645596, 4.759588900377178],
                                [43.33261665440881, 4.855048529182454],
                                [43.40468173427723, 4.8668500280141265],
                                [43.42610491918483, 4.967705599857735],
                                [43.32728665294986, 5.041038908355625],
                                [43.33171447327496, 5.240586909552984],
                                [43.36087640052119, 5.311030077911203],
                                [43.32195654694643, 5.3620550042845565],
                                [43.28236341769543, 5.345688435376646],
                                [43.207124911642964, 5.363644360087066],
                                [43.21449364341566, 5.536931681001044],
                                [43.16254563167401, 5.600889900320151],
                                [43.17926878690493, 5.6718750056992775],
                                [43.23605829449105, 5.683909137465822],
                                [43.26733799967126, 5.760928945485899],
                                [43.39915686931637, 5.682787396731936],
                                [43.434295125206056, 5.751846953791003],
                                [43.48217012690397, 5.698802592390259],
                                [43.55089752725021, 5.724610447116372],
                                [43.61373206007321, 5.682144833819898],
                                [43.641716113697846, 5.700215221457389],
                                [43.66051789095841, 5.799061112603832],
                                [43.68896399525111, 5.813243983394541],
                                [43.72462253878876, 5.753638490630264],
                                [43.658685905164766, 5.6069435191164425],
                                [43.65901134759575, 5.531453034372501],
                                [43.68110432174805, 5.439245661034277],
                                [43.735021431958224, 5.31850282672],
                                [43.74767288112557, 5.229990308924739],
                                [43.73510332278255, 5.187972296540633],
                                [43.78788168846555, 5.051490035086313],
                                [43.827792913138744, 5.02953344530474],
                                [43.87164726913833, 4.966309299927298],
                                [43.91138205123055, 4.853093547765335],
                                [43.924059473490566, 4.739060856654237],
                                [43.86747754714164, 4.641909591242105],
                                [43.80640869163021, 4.654821446467849],
                                [43.68746240297296, 4.593032248301324],
                                [43.69923776661919, 4.487236861293796],
                                [43.62067757183952, 4.4270280421178025],
                                [43.5611278006361, 4.409349673740098],
                                [43.49762691783989, 4.238105541141803],
                                [43.460185432726384, 4.230283393392478],
                            ],
                            [
                                [43.401407831650545, 5.096382025203831],
                                [43.40397723018537, 5.05956976393125],
                                [43.463556640011085, 5.051880922172624],
                                [43.46966221650609, 5.006007239562997],
                                [43.529723334348155, 5.015464900192831],
                                [43.52549492153407, 5.108666384243251],
                                [43.40958412270749, 5.157538221661901],
                                [43.401407831650545, 5.096382025203831],
                            ],
                        ],
                    },
                    "attributes": {"CODE_DEPT": "13", "NOM_DEPT": "BOUCHES-DU-RHONE"},
                },
                94: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            48.817012713055696,
                            2.2317363464837308,
                            48.902007792208785,
                            2.416339717281352,
                        ),
                        "coordinates": [
                            [
                                [48.817012713055696, 2.3318953139887446],
                                [48.849238273407416, 2.416339717281352],
                                [48.902007792208785, 2.385151006972503],
                                [48.90045886733916, 2.319884458526643],
                                [48.869069480870024, 2.2317363464837308],
                                [48.834807742280645, 2.255142901863683],
                                [48.817012713055696, 2.3318953139887446],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "75", "NOM_DEPT": "PARIS"},
                },
                95: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (
                            48.8074366758147,
                            2.2909735732251613,
                            49.00981711743891,
                            2.6025984314319826,
                        ),
                        "coordinates": [
                            [
                                [48.8074366758147, 2.5922804883088015],
                                [48.888884130524836, 2.5626221662429587],
                                [48.92935660278061, 2.6025984314319826],
                                [49.00981711743891, 2.55306064485419],
                                [48.95504632683333, 2.4594899596115933],
                                [48.97417666856734, 2.3664436276371537],
                                [48.95096678807721, 2.2909735732251613],
                                [48.90045886733916, 2.319884458526643],
                                [48.902007792208785, 2.385151006972503],
                                [48.849238273407416, 2.416339717281352],
                                [48.860849617648306, 2.4956469644616233],
                                [48.8074366758147, 2.5922804883088015],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": "93", "NOM_DEPT": "SEINE-SAINT-DENIS"},
                },
            },
        },
    },
}


def test_all():
    # create_geolayer_from_i_feat_list
    print(
        test_function(
            create_geolayer_from_i_feat_list,
            create_geolayer_from_i_feat_list_parameters,
        )
    )

    if test_dependencies()['osr']:
        # reproject_geolayer
        print(test_function(reproject_geolayer, reproject_geolayer_parameters))


if __name__ == "__main__":
    test_all()
